/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;

public class SetServiceAccountAndPorts
implements PanelAction {
    @Override
    public void executeAction(InstallData idata, AbstractUIHandler ah) {
        try {
            String serviceAccount = idata.getVariable("serviceAccount");
            if (serviceAccount != null && serviceAccount.indexOf("\\") > -1) {
                String[] serviceAccountParts = serviceAccount.trim().split("\\\\");
                String serviceDomain = "";
                String serviceUser = "";
                if (serviceAccountParts.length == 2) {
                    serviceDomain = serviceAccountParts[0].trim();
                    serviceUser = serviceAccountParts[1].trim();
                }
                idata.setVariable("serviceDomain", serviceDomain);
                idata.setVariable("serviceUser", serviceUser);
                if (serviceAccount.trim().equals("\\")) {
                    idata.setVariable("serviceAccount", "");
                }
            } else {
                idata.setVariable("serviceDomain", "");
                idata.setVariable("serviceUser", "");
                idata.setVariable("serviceAccount", "");
            }
        }
        catch (Exception serviceAccount) {
            // empty catch block
        }
        if (idata.getVariable("installMode") != null) {
            String httpPort;
            if (idata.getVariable("installMode").contains("controller")) {
                try {
                    httpPort = (idata.getVariable("controllerHost") + ":" + idata.getVariable("controllerPort")).replaceFirst("^:", "");
                    idata.setVariable("controllerHttpPort", httpPort);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (idata.getVariable("installMode").contains("agent")) {
                try {
                    httpPort = (idata.getVariable("agentHost") + ":" + idata.getVariable("agentPort")).replaceFirst("^:", "");
                    idata.setVariable("agentHttpPort", httpPort);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void initialize(PanelActionConfiguration pac) {
    }
}

