/*
 * Decompiled with CFR 0.152.
 */
package js7.base.eventbus;

import cats.effect.IO;
import cats.effect.IO$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.eventbus.ClassEventBus$;
import js7.base.eventbus.EventPublisher;
import js7.base.utils.ScalaUtils$;
import js7.base.utils.SuperclassCache;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public interface ClassEventBus<E>
extends EventPublisher<E>,
AutoCloseable {
    public static void $init$(ClassEventBus $this) {
        $this.js7$base$eventbus$ClassEventBus$_setter_$js7$base$eventbus$ClassEventBus$$register_$eq(new ConcurrentHashMap());
        $this.js7$base$eventbus$ClassEventBus$_setter_$js7$base$eventbus$ClassEventBus$$superclassCache_$eq(new SuperclassCache<Object>($this.classifierSuperclass()));
    }

    public Class<Object> classifierSuperclass();

    public Class<? extends Object> classify(E var1);

    public ConcurrentHashMap<Class<? extends Object>, Vector<EventSubscription>> js7$base$eventbus$ClassEventBus$$register();

    public void js7$base$eventbus$ClassEventBus$_setter_$js7$base$eventbus$ClassEventBus$$register_$eq(ConcurrentHashMap var1);

    public SuperclassCache<Object> js7$base$eventbus$ClassEventBus$$superclassCache();

    public void js7$base$eventbus$ClassEventBus$_setter_$js7$base$eventbus$ClassEventBus$$superclassCache_$eq(SuperclassCache var1);

    public static boolean isEmpty$(ClassEventBus $this) {
        return $this.isEmpty();
    }

    default public boolean isEmpty() {
        return this.js7$base$eventbus$ClassEventBus$$register().isEmpty();
    }

    public static void close$(ClassEventBus $this) {
        $this.close();
    }

    @Override
    default public void close() {
        this.removeAllSubscriptions();
    }

    public static void publish$(ClassEventBus $this, Object event) {
        $this.publish(event);
    }

    @Override
    default public void publish(E event) {
        this.js7$base$eventbus$ClassEventBus$$superclassCache().assignableClasses(this.classify(event)).foreach((Function1)(JProcedure1 & Serializable)cls -> {
            Vector<EventSubscription> vector = this.js7$base$eventbus$ClassEventBus$$register().get(cls);
            if (vector == null) {
                return;
            }
            Vector<EventSubscription> subscriptions = vector;
            subscriptions.foreach((Function1)(JProcedure1 & Serializable)subscription -> {
                try {
                    subscription.call().apply(event);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable t = throwable3 = (Throwable)option.get();
                        Logger LoggerImpl_this = ClassEventBus$.js7$base$eventbus$ClassEventBus$$$logger;
                        if (LoggerImpl_this.underlying().isErrorEnabled()) {
                            LoggerImpl_this.underlying().error("Error in event handler ignored: " + t, t);
                        }
                    }
                    throw throwable;
                }
            });
        });
    }

    public static void addSubscription$(ClassEventBus $this, EventSubscription subscription) {
        $this.addSubscription(subscription);
    }

    default public void addSubscription(EventSubscription subscription) {
        ConcurrentHashMap<Class<Object>, Vector<EventSubscription>> concurrentHashMap = this.js7$base$eventbus$ClassEventBus$$register();
        synchronized (concurrentHashMap) {
            subscription.classes().foreach((Function1 & Serializable)cls -> this.js7$base$eventbus$ClassEventBus$$register().put((Class<Object>)cls, (Vector<EventSubscription>)((SeqOps)this.js7$base$eventbus$ClassEventBus$$register().getOrDefault(cls, (Vector<EventSubscription>)package$.MODULE$.Vector().empty())).$colon$plus((Object)subscription)));
        }
    }

    public static void removeSubscription$(ClassEventBus $this, EventSubscription subscription) {
        $this.removeSubscription(subscription);
    }

    default public void removeSubscription(EventSubscription subscription) {
        ConcurrentHashMap<Class<Object>, Vector<EventSubscription>> concurrentHashMap = this.js7$base$eventbus$ClassEventBus$$register();
        synchronized (concurrentHashMap) {
            subscription.classes().foreach((Function1 & Serializable)cls -> {
                Vector<EventSubscription> vector = this.js7$base$eventbus$ClassEventBus$$register().get(cls);
                if (vector == null) {
                    return BoxedUnit.UNIT;
                }
                Vector<EventSubscription> list = vector;
                Vector removed = (Vector)list.filterNot((Function1 & Serializable)_$1 -> _$1 == subscription);
                if (removed.nonEmpty()) {
                    return this.js7$base$eventbus$ClassEventBus$$register().put((Class<Object>)cls, (Vector<EventSubscription>)removed);
                }
                return this.js7$base$eventbus$ClassEventBus$$register().remove(cls);
            });
        }
    }

    public static void removeAllSubscriptions$(ClassEventBus $this) {
        $this.removeAllSubscriptions();
    }

    default public void removeAllSubscriptions() {
        ClassEventBus classEventBus = this;
        synchronized (classEventBus) {
            this.js7$base$eventbus$ClassEventBus$$register().clear();
        }
    }

    public static Future when$(ClassEventBus $this, ClassTag evidence$1) {
        return $this.when(evidence$1);
    }

    default public <C> Future<Object> when(ClassTag<C> evidence$1) {
        return this.when_((Function1<Object, Object>)(Function1 & Serializable)_$2 -> true, evidence$1);
    }

    public static Future when_$(ClassEventBus $this, Function1 predicate, ClassTag evidence$1) {
        return $this.when_((Function1<Object, Object>)predicate, evidence$1);
    }

    default public <C> Future<Object> when_(Function1<Object, Object> predicate, ClassTag<C> evidence$1) {
        Promise promise = Promise$.MODULE$.apply();
        this.oneShot(predicate, (Function1<Object, BoxedUnit>)(JProcedure1 & Serializable)value -> promise.success(value), evidence$1);
        return promise.future();
    }

    public static IO whenPF$(ClassEventBus $this, PartialFunction pf, ClassTag evidence$1) {
        return $this.whenPF(pf, evidence$1);
    }

    default public <C, D> IO<D> whenPF(PartialFunction<Object, D> pf, ClassTag<C> evidence$1) {
        return this.whenFilterMap(pf.lift(), evidence$1);
    }

    public static IO whenFilterMap$(ClassEventBus $this, Function1 f, ClassTag evidence$1) {
        return $this.whenFilterMap(f, evidence$1);
    }

    default public <C, D> IO<D> whenFilterMap(Function1<Object, Option<D>> f, ClassTag<C> evidence$1) {
        return IO$.MODULE$.fromFuture(IO$.MODULE$.apply(() -> this.whenFilterMap$$anonfun$1(f, evidence$1)));
    }

    public static Future whenFuture$(ClassEventBus $this, ClassTag evidence$1) {
        return $this.whenFuture(evidence$1);
    }

    default public <C> Future<Object> whenFuture(ClassTag<C> evidence$1) {
        return this.whenFuture_((Function1<Object, Object>)(Function1 & Serializable)_$3 -> true, evidence$1);
    }

    public static Future whenFuture_$(ClassEventBus $this, Function1 predicate, ClassTag evidence$1) {
        return $this.whenFuture_((Function1<Object, Object>)predicate, evidence$1);
    }

    default public <C> Future<Object> whenFuture_(Function1<Object, Object> predicate, ClassTag<C> evidence$1) {
        return this.when_(predicate, evidence$1);
    }

    public static Future whenPFFuture$(ClassEventBus $this, PartialFunction pf, ClassTag evidence$1) {
        return $this.whenPFFuture(pf, evidence$1);
    }

    default public <C, D> Future<D> whenPFFuture(PartialFunction<Object, D> pf, ClassTag<C> evidence$1) {
        return this.whenFilterMapFuture(pf.lift(), evidence$1);
    }

    public static Future whenFilterMapFuture$(ClassEventBus $this, Function1 f, ClassTag evidence$1) {
        return $this.whenFilterMapFuture(f, evidence$1);
    }

    default public <C, D> Future<D> whenFilterMapFuture(Function1<Object, Option<D>> f, ClassTag<C> evidence$1) {
        Promise promise = Promise$.MODULE$.apply();
        this.oneShotFilterMap((Function1)f, (Function1)(JProcedure1 & Serializable)value -> promise.success(value), evidence$1);
        return promise.future();
    }

    public static void oneShot$(ClassEventBus $this, Function1 predicate, Function1 handle, ClassTag evidence$1) {
        $this.oneShot((Function1<Object, Object>)predicate, (Function1<Object, BoxedUnit>)handle, evidence$1);
    }

    default public <C> void oneShot(Function1<Object, Object> predicate, Function1<Object, BoxedUnit> handle, ClassTag<C> evidence$1) {
        LazyRef lazyRef = new LazyRef();
        AtomicBoolean used = new AtomicBoolean(false);
        this.addSubscription(this.subscription$4(lazyRef, predicate, used, handle, evidence$1));
    }

    public static Function1 oneShot$default$1$(ClassEventBus $this) {
        return $this.oneShot$default$1();
    }

    default public <C> Function1<Object, Object> oneShot$default$1() {
        return (Function1 & Serializable)_$4 -> true;
    }

    private <C, A> void oneShotPF(PartialFunction<Object, A> pf, Function1<A, BoxedUnit> handle, ClassTag<C> evidence$1) {
        this.oneShotFilterMap(pf.lift(), handle, evidence$1);
    }

    public static void oneShotFilterMap$(ClassEventBus $this, Function1 f, Function1 handle, ClassTag evidence$1) {
        $this.oneShotFilterMap(f, handle, evidence$1);
    }

    default public <C, A> void oneShotFilterMap(Function1<Object, Option<A>> f, Function1<A, BoxedUnit> handle, ClassTag<C> evidence$1) {
        LazyRef lazyRef = new LazyRef();
        AtomicBoolean used = new AtomicBoolean(false);
        this.addSubscription(this.subscription$5(lazyRef, f, used, handle, evidence$1));
    }

    public static EventSubscription subscribe$(ClassEventBus $this, Function1 handle, ClassTag evidence$1) {
        return $this.subscribe((Function1<Object, BoxedUnit>)handle, evidence$1);
    }

    default public <C> EventSubscription subscribe(Function1<Object, BoxedUnit> handle, ClassTag<C> evidence$1) {
        return this.subscribeToClass(ScalaUtils$.MODULE$.implicitClass(evidence$1), handle);
    }

    public static EventSubscription subscribeToClass$(ClassEventBus $this, Class eventClass, Function1 handle) {
        return $this.subscribeToClass(eventClass, (Function1<Object, BoxedUnit>)handle);
    }

    default public <C> EventSubscription subscribeToClass(Class<C> eventClass, Function1<Object, BoxedUnit> handle) {
        EventSubscription subscription = this.classToSubscription(eventClass, handle);
        this.addSubscription(subscription);
        return subscription;
    }

    public static EventSubscription toSubscription$(ClassEventBus $this, Function1 handle, ClassTag evidence$1) {
        return $this.toSubscription(handle, evidence$1);
    }

    default public <C> EventSubscription toSubscription(Function1<E, BoxedUnit> handle, ClassTag<C> evidence$1) {
        return this.classToSubscription(ScalaUtils$.MODULE$.implicitClass(evidence$1), handle);
    }

    private <C> EventSubscription classToSubscription(Class<C> eventClass, Function1<Object, BoxedUnit> handle) {
        return new EventSubscription(this, (Set<Class<? extends Object>>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{eventClass}))), handle);
    }

    private Future whenFilterMap$$anonfun$1(Function1 f$1, ClassTag evidence$1$1) {
        Promise promise = Promise$.MODULE$.apply();
        this.oneShotFilterMap((Function1)f$1, (Function1)(JProcedure1 & Serializable)value -> promise.success(value), (ClassTag)evidence$1$1);
        return promise.future();
    }

    private EventSubscription subscription$lzyINIT1$1(LazyRef subscription$lzy1$1, Function1 predicate$1, AtomicBoolean used$1, Function1 handle$1, ClassTag evidence$1$2) {
        EventSubscription eventSubscription;
        LazyRef lazyRef = subscription$lzy1$1;
        synchronized (lazyRef) {
            eventSubscription = (EventSubscription)(subscription$lzy1$1.initialized() ? subscription$lzy1$1.value() : subscription$lzy1$1.initialize((Object)this.toSubscription((Function1<E, BoxedUnit>)(JProcedure1 & Serializable)event_ -> {
                Object event = event_;
                if (BoxesRunTime.unboxToBoolean((Object)predicate$1.apply(event)) && !used$1.getAndSet(true)) {
                    this.subscription$4(subscription$lzy1$1, predicate$1, used$1, handle$1, evidence$1$2).close();
                    handle$1.apply(event);
                    return;
                }
            }, (ClassTag)evidence$1$2)));
        }
        return eventSubscription;
    }

    private EventSubscription subscription$4(LazyRef subscription$lzy1$3, Function1 predicate$3, AtomicBoolean used$3, Function1 handle$3, ClassTag evidence$1$4) {
        return (EventSubscription)(subscription$lzy1$3.initialized() ? subscription$lzy1$3.value() : this.subscription$lzyINIT1$1(subscription$lzy1$3, predicate$3, used$3, handle$3, evidence$1$4));
    }

    private EventSubscription subscription$lzyINIT2$1(LazyRef subscription$lzy2$1, Function1 f$2, AtomicBoolean used$4, Function1 handle$4, ClassTag evidence$1$5) {
        EventSubscription eventSubscription;
        LazyRef lazyRef = subscription$lzy2$1;
        synchronized (lazyRef) {
            eventSubscription = (EventSubscription)(subscription$lzy2$1.initialized() ? subscription$lzy2$1.value() : subscription$lzy2$1.initialize((Object)this.toSubscription((Function1<E, BoxedUnit>)(JProcedure1 & Serializable)event_ -> {
                Object event = event_;
                ((Option)f$2.apply(event)).foreach((Function1)(JProcedure1 & Serializable)a -> {
                    if (!used$4.getAndSet(true)) {
                        this.subscription$5(subscription$lzy2$1, f$2, used$4, handle$4, evidence$1$5).close();
                        handle$4.apply(a);
                        return;
                    }
                });
            }, (ClassTag)evidence$1$5)));
        }
        return eventSubscription;
    }

    private EventSubscription subscription$5(LazyRef subscription$lzy2$4, Function1 f$5, AtomicBoolean used$7, Function1 handle$7, ClassTag evidence$1$8) {
        return (EventSubscription)(subscription$lzy2$4.initialized() ? subscription$lzy2$4.value() : this.subscription$lzyINIT2$1(subscription$lzy2$4, f$5, used$7, handle$7, evidence$1$8));
    }

    public final class EventSubscription
    implements AutoCloseable {
        private final Set classes;
        private final Function1 call;
        private final /* synthetic */ ClassEventBus $outer;

        public EventSubscription(ClassEventBus $outer, Set<Class<? extends Object>> classes, Function1<E, BoxedUnit> call) {
            this.classes = classes;
            this.call = call;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public Set<Class<? extends Object>> classes() {
            return this.classes;
        }

        public Function1<E, BoxedUnit> call() {
            return this.call;
        }

        @Override
        public void close() {
            this.$outer.removeSubscription(this);
        }

        public final /* synthetic */ ClassEventBus js7$base$eventbus$ClassEventBus$EventSubscription$$$outer() {
            return this.$outer;
        }
    }
}

