/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Resource;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import js7.base.auth.Admission;
import js7.base.auth.UserAndPassword;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.UnsafeMemoizable$;
import js7.base.log.Logger$syntax$;
import js7.base.problem.Problem;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.Assertions$;
import js7.base.utils.MVar;
import js7.base.utils.MVar$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.cluster.ActivationInhibitor$;
import js7.cluster.ActivationInhibitor$Active$;
import js7.cluster.ActivationInhibitor$Inhibited$;
import js7.cluster.ActivationInhibitor$Initial$;
import js7.cluster.ActivationInhibitor$Passive$;
import js7.data.cluster.ClusterNodeApi;
import js7.data.cluster.ClusterSetting;
import js7.data.cluster.ClusterState;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Name$;
import sourcecode.Text;
import sourcecode.Text$;

public final class ActivationInhibitor {
    private final IO<MVar<IO, State>> stateMvarIO = (IO)UnsafeMemoizable$.MODULE$.unsafeMemoize(MVar$.MODULE$.apply().of(ActivationInhibitor$Initial$.MODULE$, IO$.MODULE$.asyncForIO()), IO$.MODULE$.asyncForIO());

    public static IO<Option<ClusterState.FailedOver>> inhibitActivationOfPassiveNode(ClusterSetting clusterSetting, Option<UserAndPassword> option, Function2<Admission, String, Resource<IO, ClusterNodeApi>> function2) {
        return ActivationInhibitor$.MODULE$.inhibitActivationOfPassiveNode(clusterSetting, option, function2);
    }

    public IO<BoxedUnit> startActive() {
        return this.startAs(ActivationInhibitor$Active$.MODULE$);
    }

    public IO<BoxedUnit> startPassive() {
        return this.startAs(ActivationInhibitor$Passive$.MODULE$);
    }

    private IO<BoxedUnit> startAs(State state) {
        return IO$.MODULE$.defer(() -> this.startAs$$anonfun$1(state));
    }

    public IO<Either<Problem, Object>> tryToActivate(IO<Either<Problem, Object>> ifInhibited, IO<Either<Problem, Object>> activate) {
        return Logger$syntax$.MODULE$.debugIO(ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger, IO$.MODULE$.defer(() -> this.tryToActivate$$anonfun$1(activate, ifInhibited)), Name$.MODULE$.apply("tryToActivate"));
    }

    public IO<Either<Problem, Object>> inhibitActivation(FiniteDuration duration) {
        return Logger$syntax$.MODULE$.debugIOWithResult(ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger, this.stateMvarIO.flatMap((Function1 & Serializable)mvar -> ((IO)mvar.take()).flatMap((Function1 & Serializable)x$1 -> {
            State state = x$1;
            if (ActivationInhibitor$Initial$.MODULE$.equals(state) || ActivationInhibitor$Passive$.MODULE$.equals(state) || state instanceof Inhibited) {
                int n;
                State state2 = state;
                State state3 = state2;
                if (state3 instanceof Inhibited) {
                    int n2;
                    Inhibited inhibited = ActivationInhibitor$Inhibited$.MODULE$.unapply((Inhibited)state3);
                    int n3 = n2 = inhibited._1();
                    n = n3 + 1;
                } else {
                    n = 1;
                }
                int depth = n;
                return ((IO)mvar.put(ActivationInhibitor$Inhibited$.MODULE$.apply(depth))).flatMap((Function1 & Serializable)_$1 -> this.setInhibitionTimer(duration)).map((Function1 & Serializable)_$2 -> package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            }
            if (ActivationInhibitor$Active$.MODULE$.equals(state)) {
                return ((IO)mvar.put(ActivationInhibitor$Active$.MODULE$)).map((Function1 & Serializable)_$3 -> package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)false)));
            }
            throw new MatchError((Object)state);
        })), Name$.MODULE$.apply("inhibitActivation"));
    }

    private IO<BoxedUnit> setInhibitionTimer(FiniteDuration duration) {
        return CatsEffectExtensions$.MODULE$.startAndForget(this.stateMvarIO.flatMap((Function1 & Serializable)mvar -> ((IO)mvar.take()).flatMap((Function1 & Serializable)x$1 -> {
            State state = x$1;
            if (state instanceof Inhibited) {
                Inhibited inhibited = ActivationInhibitor$Inhibited$.MODULE$.unapply((Inhibited)state);
                int n = inhibited._1();
                if (1 == n) {
                    return (IO)mvar.put(ActivationInhibitor$Passive$.MODULE$);
                }
                int n2 = n;
                return (IO)mvar.put(ActivationInhibitor$Inhibited$.MODULE$.apply(n2 - 1));
            }
            State state2 = state;
            return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                ActivationInhibitor.setInhibitionTimer$$anonfun$1$$anonfun$1$$anonfun$1(duration, state2);
                return BoxedUnit.UNIT;
            });
        })).attempt().map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Throwable throwable = (Throwable)((Left)either).value();
                Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                    Throwable throwable3 = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                    LoggerImpl_this.underlying().error("setInhibitionTimer: " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable2), ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable3));
                    return;
                }
                return;
            }
            if (either instanceof Right) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = ((Right)either).value();
                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                    return;
                }
            }
            throw new MatchError((Object)either);
        }).delayBy((Duration)duration));
    }

    public IO<Option<State>> state() {
        return this.stateMvarIO.flatMap((Function1 & Serializable)_$4 -> (IO)_$4.tryRead());
    }

    private static final IO startAs$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private static final IO startAs$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3(State state$4, Option s$1) {
        return IO$.MODULE$.raiseError((Throwable)new IllegalStateException("ActivationInhibitor startAs(" + state$4 + "): Already '" + s$1 + "''"));
    }

    private final IO startAs$$anonfun$1(State state$1) {
        block0: {
            Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("startAs {}", (Object)state$1);
        }
        return this.stateMvarIO.flatMap((Function1 & Serializable)mvar -> ((IO)mvar.tryTake()).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some && ActivationInhibitor$Initial$.MODULE$.equals(((Some)option).value())) {
                return (IO)mvar.put(state$1);
            }
            Option s = option;
            return ((IO)s.fold(ActivationInhibitor::startAs$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1, (Function1 & Serializable)a -> (IO)mvar.put(a))).$greater$greater(() -> ActivationInhibitor.startAs$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3(state$1, s));
        }));
    }

    private static final IO tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Outcome outcome$1, MVar mvar$4) {
        block0: {
            Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("tryToActivate: Passive \u2014 due to {}", (Object)outcome$1);
        }
        return (IO)mvar$4.put(ActivationInhibitor$Passive$.MODULE$);
    }

    private static final IO tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(Either o$1, MVar mvar$6) {
        block0: {
            Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("tryToActivate: Passive \u2014 due to {}", (Object)o$1);
        }
        return (IO)mvar$6.put(ActivationInhibitor$Passive$.MODULE$);
    }

    private static final void tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1() {
        Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info("Activation inhibited");
            return;
        }
    }

    private static final IO tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3(Inhibited o$2, MVar mvar$8, IO ifInhibited$4) {
        block0: {
            Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("tryToActivate: {}", (Object)o$2);
        }
        return ((IO)mvar$8.put(o$2)).$times$greater(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            ActivationInhibitor.tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1();
            return BoxedUnit.UNIT;
        })).$times$greater(ifInhibited$4);
    }

    private final IO tryToActivate$$anonfun$1(IO activate$1, IO ifInhibited$1) {
        return this.stateMvarIO.flatMap((Function1 & Serializable)mvar -> ((IO)mvar.take()).flatMap((Function1 & Serializable)x$12 -> {
            State state = x$12;
            if (ActivationInhibitor$Initial$.MODULE$.equals(state) || ActivationInhibitor$Passive$.MODULE$.equals(state) || ActivationInhibitor$Active$.MODULE$.equals(state)) {
                return activate$1.guaranteeCase((Function1 & Serializable)x$1 -> {
                    Outcome outcome = x$1;
                    if (outcome instanceof Outcome.Succeeded) {
                        cats.effect.package$.MODULE$.Outcome();
                        Outcome.Succeeded succeeded = Outcome.Succeeded$.MODULE$.unapply((Outcome.Succeeded)outcome);
                        IO iO = (IO)succeeded._1();
                        return IO$.MODULE$.unit();
                    }
                    Outcome outcome2 = outcome;
                    return IO$.MODULE$.defer(() -> ActivationInhibitor.tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(outcome2, mvar));
                }).flatTap((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left || either instanceof Right && !BoxesRunTime.unboxToBoolean((Object)((Right)either).value())) {
                        Either o = either;
                        return IO$.MODULE$.defer(() -> ActivationInhibitor.tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(o, mvar));
                    }
                    if (either instanceof Right && BoxesRunTime.unboxToBoolean((Object)((Right)either).value())) {
                        Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
                        if (LoggerImpl_this.underlying().isDebugEnabled()) {
                            LoggerImpl_this.underlying().debug("tryToActivate: Active \u2014 due to Right(true)");
                        }
                        return (IO)mvar.put(ActivationInhibitor$Active$.MODULE$);
                    }
                    throw new MatchError((Object)either);
                });
            }
            if (state instanceof Inhibited) {
                Inhibited o = (Inhibited)state;
                return IO$.MODULE$.defer(() -> ActivationInhibitor.tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3(o, mvar, ifInhibited$1));
            }
            throw new MatchError((Object)state);
        }));
    }

    private static final void setInhibitionTimer$$anonfun$1$$anonfun$1$$anonfun$1(FiniteDuration duration$6, State state$5) {
        Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
        if (LoggerImpl_this.underlying().isErrorEnabled()) {
            LoggerImpl_this.underlying().error("inhibitActivation timeout after {}: expected Inhibited but got '{}'", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration$6)), state$5}), Object.class));
            return;
        }
    }

    public static class Inhibited
    implements State,
    Product,
    Serializable {
        private final int depth;

        public static Inhibited apply(int n) {
            return ActivationInhibitor$Inhibited$.MODULE$.apply(n);
        }

        public static Inhibited fromProduct(Product product) {
            return ActivationInhibitor$Inhibited$.MODULE$.fromProduct(product);
        }

        public static Inhibited unapply(Inhibited inhibited) {
            return ActivationInhibitor$Inhibited$.MODULE$.unapply(inhibited);
        }

        public Inhibited(int depth) {
            this.depth = depth;
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1(depth)), "depth >= 1"), FullName$.MODULE$.apply("js7.cluster.ActivationInhibitor.Inhibited"), FileName$.MODULE$.apply("ActivationInhibitor.scala"), Line$.MODULE$.apply(149));
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.depth());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Inhibited)) return false;
            Inhibited inhibited = (Inhibited)object;
            if (this.depth() != inhibited.depth()) return false;
            if (!inhibited.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Inhibited;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Inhibited";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "depth";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int depth() {
            return this.depth;
        }

        public Inhibited copy(int depth) {
            return new Inhibited(depth);
        }

        public int copy$default$1() {
            return this.depth();
        }

        public int _1() {
            return this.depth();
        }

        private final boolean v$proxy1$1(int depth$1) {
            return depth$1 >= 1;
        }
    }

    public static interface State {
    }
}

