/*
 * Decompiled with CFR 0.152.
 */
package js7.common.http;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.unsafe.IORuntime;
import io.circe.Decoder$;
import io.circe.Encoder$;
import io.circe.Json;
import js7.base.auth.SessionToken;
import js7.base.circeutils.CirceUtils$;
import js7.base.circeutils.CirceUtils$RichCirceString$;
import js7.base.circeutils.CirceUtils$RichJson$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.utils.StackTraces$;
import js7.base.utils.StackTraces$StackTraceThrowable$;
import js7.base.web.HttpClient;
import js7.base.web.Uri;
import js7.common.http.TextApi$ConnectionLost$;
import js7.common.http.TextApi$printer$;
import scala.Function1;
import scala.Option;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;

public interface TextApi {
    public static void $init$(TextApi $this) {
    }

    public Function1<String, BoxedUnit> print();

    public String serverName();

    public Uri sessionUri();

    public Uri commandUri();

    public Uri apiUri(String var1);

    public HttpClient httpClient();

    public Option<SessionToken> sessionToken();

    private IO<Option<SessionToken>> implicitSessionToken() {
        return IO$.MODULE$.apply(this::implicitSessionToken$$anonfun$1);
    }

    public static void executeCommand$(TextApi $this, String command, IORuntime x$2) {
        $this.executeCommand(command, x$2);
    }

    default public void executeCommand(String command, IORuntime x$2) {
        Json response = (Json)this.awaitResult(this.httpClient().post(this.commandUri(), CirceUtils$RichCirceString$.MODULE$.parseJsonOrThrow$extension(CirceUtils$.MODULE$.RichCirceString(command)), Encoder$.MODULE$.encodeJson(), Decoder$.MODULE$.decodeJson(), this.implicitSessionToken()), x$2);
        this.printer().doPrint(CirceUtils$RichJson$.MODULE$.toPrettyString$extension(CirceUtils$.MODULE$.RichJson(response)));
    }

    public static void getApi$(TextApi $this, String uri, IORuntime x$2) {
        $this.getApi(uri, x$2);
    }

    default public void getApi(String uri, IORuntime x$2) {
        String string = uri;
        String string2 = "?";
        String u = !(string != null ? !string.equals(string2) : string2 != null) ? "" : uri;
        IO whenResponded = this.httpClient().get(this.apiUri(u), Decoder$.MODULE$.decodeJson(), this.implicitSessionToken());
        Json response = (Json)this.awaitResult(whenResponded, x$2);
        this.printer().doPrint(response);
    }

    public static void requireIsResponding$(TextApi $this, IORuntime x$1) {
        $this.requireIsResponding(x$1);
    }

    default public void requireIsResponding(IORuntime x$1) {
        try {
            IO whenResponded = this.httpClient().get(this.apiUri(""), Decoder$.MODULE$.decodeJson(), this.implicitSessionToken());
            this.awaitResult(whenResponded, x$1);
            this.print().apply((Object)(this.serverName() + " is responding"));
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = this.ConnectionLost().unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                Throwable throwable4 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                this.print().apply((Object)(this.serverName() + " is not responding: " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable4)));
                throw t;
            }
            throw throwable;
        }
    }

    public static boolean checkIsResponding$(TextApi $this, IORuntime x$1) {
        return $this.checkIsResponding(x$1);
    }

    default public boolean checkIsResponding(IORuntime x$1) {
        boolean bl;
        try {
            this.requireIsResponding(x$1);
            bl = true;
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = this.ConnectionLost().unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    private <A> A awaitResult(IO<A> io, IORuntime x$2) {
        Object object;
        try {
            object = Await$.MODULE$.result((Awaitable)io.unsafeToFuture(x$2), (Duration)ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(65)));
        }
        catch (Throwable t) {
            Throwable throwable = StackTraces$.MODULE$.StackTraceThrowable(t);
            StackTraces$StackTraceThrowable$.MODULE$.appendCurrentStackTrace$extension(throwable);
            throw t;
        }
        return (A)object;
    }

    public static TextApi$printer$ printer$(TextApi $this) {
        return $this.printer();
    }

    default public TextApi$printer$ printer() {
        return new TextApi$printer$(this);
    }

    public static TextApi$ConnectionLost$ ConnectionLost$(TextApi $this) {
        return $this.ConnectionLost();
    }

    default public TextApi$ConnectionLost$ ConnectionLost() {
        return new TextApi$ConnectionLost$(this);
    }

    private Option implicitSessionToken$$anonfun$1() {
        return this.sessionToken();
    }

    public static Throwable js7$common$http$TextApi$ConnectionLost$$$_$unapply$$anonfun$1(Throwable t$1) {
        return t$1;
    }
}

