/*
 * Decompiled with CFR 0.152.
 */
package js7.common.jsonseq;

import cats.Foldable;
import cats.effect.IO;
import cats.effect.kernel.Resource;
import cats.instances.package;
import cats.kernel.Monoid;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import io.circe.Json;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.data.ByteSequence$ops$;
import js7.base.problem.Problem;
import js7.base.problem.ProblemCode;
import js7.base.problem.ProblemException;
import js7.base.utils.Ascii$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.common.jsonseq.InputStreamJsonSeqReader$;
import js7.common.jsonseq.InputStreamJsonSeqReader$JsonSeqFileClosedProblem$;
import js7.common.jsonseq.PositionAnd;
import js7.common.jsonseq.PositionAnd$;
import js7.common.jsonseq.SeekableInputStream;
import js7.common.utils.UntilNoneIterator$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class InputStreamJsonSeqReader
implements AutoCloseable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(InputStreamJsonSeqReader.class.getDeclaredField("iterator$lzy1"));
    private final String name;
    private final boolean withRS;
    private final AtomicReference<SeekableInputStream> inAtomic;
    private final byte[] block;
    private long blockPos;
    private int blockLength;
    private int blockRead;
    private final Buffer<ByteArray> byteArrays;
    private long lineNumber;
    private volatile Object iterator$lzy1;

    public static int BlockSize() {
        return InputStreamJsonSeqReader$.MODULE$.BlockSize();
    }

    public static InputStreamJsonSeqReader open(Path path, int n) {
        return InputStreamJsonSeqReader$.MODULE$.open(path, n);
    }

    public static Resource<IO, InputStreamJsonSeqReader> resource(Path path) {
        return InputStreamJsonSeqReader$.MODULE$.resource(path);
    }

    public static int open$default$2() {
        return InputStreamJsonSeqReader$.MODULE$.open$default$2();
    }

    public static int $lessinit$greater$default$3() {
        return InputStreamJsonSeqReader$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$4() {
        return InputStreamJsonSeqReader$.MODULE$.$lessinit$greater$default$4();
    }

    public InputStreamJsonSeqReader(SeekableInputStream inputStream_, String name, int blockSize, boolean withRS) {
        this.name = name;
        this.withRS = withRS;
        this.inAtomic = new AtomicReference<SeekableInputStream>(inputStream_);
        this.block = new byte[blockSize];
        this.blockPos = 0L;
        this.blockLength = 0;
        this.blockRead = 0;
        this.byteArrays = (Buffer)Buffer$.MODULE$.empty();
        this.lineNumber = 1L;
    }

    public Iterator<PositionAnd<Json>> iterator() {
        Object object = this.iterator$lzy1;
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Iterator)this.iterator$lzyINIT1();
    }

    private Object iterator$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.iterator$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Iterator iterator = null;
                    Iterator iterator2 = null;
                    try {
                        iterator2 = UntilNoneIterator$.MODULE$.apply(this::iterator$lzyINIT1$$anonfun$1);
                        iterator = iterator2 == null ? LazyVals.NullValue$.MODULE$ : iterator2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, iterator)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.iterator$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, iterator);
                            waiting.countDown();
                        }
                    }
                    return iterator2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private SeekableInputStream in() {
        SeekableInputStream seekableInputStream = this.inAtomic.get();
        if (seekableInputStream == null) {
            throw new ClosedException(this.name);
        }
        SeekableInputStream o = seekableInputStream;
        return o;
    }

    @Override
    public void close() {
        InputStreamJsonSeqReader inputStreamJsonSeqReader = this;
        synchronized (inputStreamJsonSeqReader) {
            Option$.MODULE$.apply(this.inAtomic.getAndSet(null)).foreach((Function1)(JProcedure1 & Serializable)in -> ((InputStream)((Object)in)).close());
        }
    }

    private boolean isClosed() {
        return this.inAtomic.get() == null;
    }

    public Option<PositionAnd<Json>> read() {
        return this.readRaw().map((Function1 & Serializable)positionAndRaw -> this.toJson((PositionAnd<ByteArray>)positionAndRaw));
    }

    public PositionAnd<Json> toJson(PositionAnd<ByteArray> positionAndRaw) {
        PositionAnd<ByteArray> positionAnd = positionAndRaw;
        if (positionAnd == null) {
            throw new MatchError(positionAnd);
        }
        PositionAnd<ByteArray> positionAnd2 = PositionAnd$.MODULE$.unapply(positionAnd);
        long l = positionAnd2._1();
        ByteArray byteArray = positionAnd2._2();
        long pos = l;
        ByteArray bytes = byteArray;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)pos), (Object)bytes);
        long pos2 = BoxesRunTime.unboxToLong((Object)tuple2._1());
        ByteArray bytes2 = (ByteArray)tuple2._2();
        Either<Problem, Json> either = bytes2.parseJson();
        if (either instanceof Left) {
            Problem problem = (Problem)((Left)either).value();
            long lineNr = this.lineNumber - 1L;
            String extra = problem.toString().startsWith("JSON ParsingFailure: ") ? StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(problem.toString()), "JSON ParsingFailure: ").replace(" (line 1, ", " (") : problem.toString();
            Logger LoggerImpl_this = InputStreamJsonSeqReader$.js7$common$jsonseq$InputStreamJsonSeqReader$$$logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("JSON sequence read from '" + this.name + "' is corrupt at " + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(lineNr >= 0L), (Function0<String>)((Function0 & Serializable)() -> InputStreamJsonSeqReader.toJson$$anonfun$1(lineNr))) + ("file position " + pos2 + ": ") + (extra + ": " + ByteSequence$ops$.MODULE$.toAllByteSequenceOps(bytes2, ByteArray$.MODULE$.implicitByteSequence()).utf8StringTruncateAt(200)));
            }
            throw InputStreamJsonSeqReader$.MODULE$.js7$common$jsonseq$InputStreamJsonSeqReader$$$throwCorrupt2(lineNr, pos2, extra);
        }
        if (either instanceof Right) {
            Json json = (Json)((Right)either).value();
            return PositionAnd$.MODULE$.apply(pos2, json);
        }
        throw new MatchError(either);
    }

    public Option<PositionAnd<ByteArray>> readRaw() {
        Option option;
        InputStreamJsonSeqReader inputStreamJsonSeqReader = this;
        synchronized (inputStreamJsonSeqReader) {
            long startPosition = this.position();
            boolean rsReached = false;
            boolean lfReached = false;
            boolean eof = false;
            while (!(lfReached || eof && this.blockRead >= this.blockLength)) {
                ByteArray chunk;
                if (this.blockRead == this.blockLength) {
                    boolean bl = eof = !this.fillByteBuffer();
                }
                if (!rsReached && this.blockRead < this.blockLength) {
                    byte by = this.block[this.blockRead];
                    if (this.withRS) {
                        if (by != Ascii$.MODULE$.RS()) {
                            throw this.throwCorrupt(StringOps$.MODULE$.format$extension("Missing ASCII RS at start of JSON sequence record (instead read: %02x)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)by)})));
                        }
                        rsReached = true;
                    }
                }
                int start = ++this.blockRead;
                while (this.blockRead < this.blockLength) {
                    if (this.block[this.blockRead] == Ascii$.MODULE$.LF()) {
                        lfReached = true;
                        if (!false) break;
                    }
                    ++this.blockRead;
                }
                if (ByteSequence$ops$.MODULE$.toAllByteSequenceOps(chunk = ByteArray$.MODULE$.unsafeWrap(Arrays.copyOfRange(this.block, start, this.blockRead + (lfReached ? 1 : 0))), ByteArray$.MODULE$.implicitByteSequence()).nonEmpty()) {
                    this.byteArrays.$plus$eq((Object)chunk);
                }
                if (!lfReached) continue;
                ++this.blockRead;
            }
            if ((!this.withRS && this.byteArrays.nonEmpty() || rsReached) && !lfReached) {
                Logger LoggerImpl_this = InputStreamJsonSeqReader$.js7$common$jsonseq$InputStreamJsonSeqReader$$$logger;
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn("Discarding truncated last record in '{}': {} (terminating LF is missing)", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.name, ((ByteArray)package.foldable$.MODULE$.toFoldableOps((Object)this.byteArrays.toVector(), (Foldable)package.vector$.MODULE$.catsStdInstancesForVector()).combineAll((Monoid)ByteArray$.MODULE$.implicitByteSequence())).utf8String()}), Object.class));
                }
                this.byteArrays.clear();
                this.seek(startPosition);
            }
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(lfReached);
            option = ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> this.readRaw$$anonfun$1(startPosition));
        }
        return option;
    }

    private boolean fillByteBuffer() {
        this.blockPos = this.position();
        this.blockRead = 0;
        int length = BoxesRunTime.unboxToInt(this.check(this::$anonfun$1));
        if (length == -1) {
            this.blockLength = 0;
            return false;
        }
        this.blockLength = length;
        return true;
    }

    public void seek(long pos) {
        InputStreamJsonSeqReader inputStreamJsonSeqReader = this;
        synchronized (inputStreamJsonSeqReader) {
            if (pos != this.position()) {
                if (pos >= this.blockPos && pos <= this.blockPos + (long)this.blockLength) {
                    this.blockRead = (int)(pos - this.blockPos);
                } else {
                    this.check((Function0 & Serializable)() -> {
                        this.seek$$anonfun$1(pos);
                        return BoxedUnit.UNIT;
                    });
                    this.blockPos = pos;
                    this.blockLength = 0;
                    this.blockRead = 0;
                }
                this.lineNumber = -1L;
                Logger LoggerImpl_this = InputStreamJsonSeqReader$.js7$common$jsonseq$InputStreamJsonSeqReader$$$logger;
                if (LoggerImpl_this.underlying().isTraceEnabled()) {
                    LoggerImpl_this.underlying().trace("seek {} => blockPos={} blockRead={} blockLength={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToLong((long)pos), BoxesRunTime.boxToLong((long)pos), BoxesRunTime.boxToInteger((int)this.blockRead), BoxesRunTime.boxToInteger((int)this.blockLength)}), Object.class));
                }
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = BoxedUnit.UNIT;
            }
        }
    }

    public long position() {
        return this.blockPos + (long)this.blockRead;
    }

    private <A> A check(Function0<A> body) {
        Object object;
        try {
            object = body.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException && this.isClosed()) {
                throw new ClosedException(this.name);
            }
            throw throwable;
        }
        return (A)object;
    }

    private Nothing$ throwCorrupt(String extra) {
        return InputStreamJsonSeqReader$.MODULE$.js7$common$jsonseq$InputStreamJsonSeqReader$$$throwCorrupt2(this.lineNumber, this.position(), extra);
    }

    private final Option iterator$lzyINIT1$$anonfun$1() {
        return this.read();
    }

    private static final String toJson$$anonfun$1(long lineNr$1) {
        return "line " + lineNr$1 + ", ";
    }

    private final PositionAnd a$proxy1$1(long startPosition$1) {
        if (this.lineNumber != -1L) {
            ++this.lineNumber;
        }
        Object result = ByteArray$.MODULE$.combineAll((IterableOnce)this.byteArrays);
        this.byteArrays.clear();
        return PositionAnd$.MODULE$.apply(startPosition$1, result);
    }

    private final PositionAnd readRaw$$anonfun$1(long startPosition$2) {
        return this.a$proxy1$1(startPosition$2);
    }

    private final int $anonfun$1() {
        return ((InputStream)((Object)this.in())).read(this.block);
    }

    private final void seek$$anonfun$1(long pos$1) {
        this.in().seek(pos$1);
    }

    public static final class ClosedException
    extends ProblemException {
        public ClosedException(String file) {
            super(InputStreamJsonSeqReader$JsonSeqFileClosedProblem$.MODULE$.apply(file));
        }
    }

    public static final class JsonSeqFileClosedProblem
    implements Problem,
    Problem.Simple,
    Problem.HasCode,
    Problem.Coded,
    Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JsonSeqFileClosedProblem.class.getDeclaredField("message$lzy1"));
        private volatile Object message$lzy1;
        private ProblemCode code;
        private final String file;

        public static JsonSeqFileClosedProblem apply(String string) {
            return InputStreamJsonSeqReader$JsonSeqFileClosedProblem$.MODULE$.apply(string);
        }

        public static JsonSeqFileClosedProblem fromProduct(Product product) {
            return InputStreamJsonSeqReader$JsonSeqFileClosedProblem$.MODULE$.fromProduct(product);
        }

        public static JsonSeqFileClosedProblem unapply(JsonSeqFileClosedProblem jsonSeqFileClosedProblem) {
            return InputStreamJsonSeqReader$JsonSeqFileClosedProblem$.MODULE$.unapply(jsonSeqFileClosedProblem);
        }

        public JsonSeqFileClosedProblem(String file) {
            this.file = file;
            Problem.Coded.$init$(this);
            Statics.releaseFence();
        }

        @Override
        public final String message() {
            Object object = this.message$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.message$lzyINIT1();
        }

        private Object message$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.message$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = Problem.Simple.message$(this);
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.message$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public ProblemCode code() {
            return this.code;
        }

        @Override
        public void js7$base$problem$Problem$Coded$_setter_$code_$eq(ProblemCode x$0) {
            this.code = x$0;
        }

        public boolean canEqual(Object that) {
            return that instanceof JsonSeqFileClosedProblem;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "JsonSeqFileClosedProblem";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "file";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String file() {
            return this.file;
        }

        @Override
        public Map<String, String> arguments() {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"file");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.file());
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }

        public JsonSeqFileClosedProblem copy(String file) {
            return new JsonSeqFileClosedProblem(file);
        }

        public String copy$default$1() {
            return this.file();
        }

        public String _1() {
            return this.file();
        }
    }
}

