/*
 * Decompiled with CFR 0.152.
 */
package js7.common.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import js7.base.log.Logger$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.Failure$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class Exceptions$
implements Serializable {
    private static final Logger logger;
    public static final Exceptions$ MODULE$;

    private Exceptions$() {
    }

    static {
        MODULE$ = new Exceptions$();
        logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(Exceptions$.class));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Exceptions$.class);
    }

    public <A> A repeatUntilNoException(FiniteDuration timeout, FiniteDuration delayNext, Function0<A> body) {
        return this.repeatUntilNoException(Deadline$.MODULE$.now().$plus(timeout), delayNext, body);
    }

    public <A> A repeatUntilNoException(Deadline deadline, FiniteDuration delayNext, Function0<A> body) {
        Try tried = Try$.MODULE$.apply(() -> Exceptions$.$anonfun$1(body));
        while (tried.isFailure() && deadline.hasTimeLeft()) {
            ScalaTime$.MODULE$.sleep((Duration)delayNext.min(ScalaTime$RichDeadline$.MODULE$.timeLeftOrZero$extension(ScalaTime$.MODULE$.RichDeadline(deadline))));
            tried = Try$.MODULE$.apply(() -> Exceptions$.repeatUntilNoException$$anonfun$1(body));
        }
        return (A)tried.get();
    }

    public <A> Try<A> ignoreException(Function2<String, Throwable, BoxedUnit> log, Function0<A> body) {
        return Try$.MODULE$.apply(() -> Exceptions$.ignoreException$$anonfun$1(body)).recoverWith((PartialFunction)new Serializable(log){
            private final Function2 log$1;
            {
                this.log$1 = log$2;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Option option;
                Throwable throwable = x2;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable t = throwable2 = (Throwable)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x2, Function1 function1) {
                Option option;
                Throwable throwable = x2;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable t = throwable2 = (Throwable)option.get();
                    this.log$1.apply(() -> Exceptions$.js7$common$utils$Exceptions$$anon$1$$_$applyOrElse$$anonfun$1(t), (Object)t);
                    return Failure$.MODULE$.apply(t);
                }
                return function1.apply((Object)x2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{js7$common$utils$Exceptions$$anon$1$$_$applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    public <A> A logException(Function2<String, Throwable, BoxedUnit> log, Function0<A> body) {
        Object object;
        try {
            object = body.apply();
        }
        catch (Throwable t) {
            log.apply(() -> Exceptions$.logException$$anonfun$1(t), (Object)t);
            throw t;
        }
        return (A)object;
    }

    public PartialFunction<Throwable, Nothing$> andRethrow(Function0<BoxedUnit> body) {
        return new Serializable(body){
            private final Function0 body$4;
            {
                this.body$4 = body$5;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Option option;
                Throwable throwable = x2;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable t = throwable2 = (Throwable)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x2, Function1 function1) {
                Option option;
                Throwable throwable = x2;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable t = throwable2 = (Throwable)option.get();
                    Exceptions$.MODULE$.onExceptionAddSuppressed(t, (Function0<BoxedUnit>)this.body$4);
                    throw t;
                }
                return function1.apply((Object)x2);
            }
        };
    }

    public void onExceptionAddSuppressed(Throwable t, Function0<BoxedUnit> body) {
        try {
            body.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable suppressed;
            Throwable throwable2 = throwable;
            if (throwable2 != null && (suppressed = throwable2) != t) {
                Logger LoggerImpl_this;
                Object object;
                t.addSuppressed(suppressed);
                Object[] suppresseds = t.getSuppressed();
                Object object2 = Predef$.MODULE$.refArrayOps(suppresseds);
                if ((ArrayOps$.MODULE$.isEmpty$extension(object2) || (Throwable)ArrayOps$.MODULE$.last$extension(object = Predef$.MODULE$.refArrayOps(suppresseds)) != suppressed) && (LoggerImpl_this = logger).underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn("While handling an exception, this second exception is ignored: " + suppressed + "\n" + ("Original exception is: " + t), suppressed);
                }
            }
            throw throwable;
        }
    }

    public <A> A wrapException(Function0<String> message, Function0<A> body) {
        Object object;
        try {
            object = body.apply();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                Throwable throwable4 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                throw new RuntimeException(message.apply() + ": " + ScalaUtils$syntax$RichThrowable$.MODULE$.toSimplifiedString$extension(throwable4), t);
            }
            throw throwable;
        }
        return (A)object;
    }

    private static final Object $anonfun$1(Function0 body$1) {
        return body$1.apply();
    }

    private static final Object repeatUntilNoException$$anonfun$1(Function0 body$2) {
        return body$2.apply();
    }

    private static final Object ignoreException$$anonfun$1(Function0 body$3) {
        return body$3.apply();
    }

    public static final String js7$common$utils$Exceptions$$anon$1$$_$applyOrElse$$anonfun$1(Throwable t$1) {
        return "Ignoring exception " + t$1;
    }

    private static final String logException$$anonfun$1(Throwable t$2) {
        return t$2.toString();
    }
}

