/*
 * Decompiled with CFR 0.152.
 */
package js7.data.board;

import cats.effect.IO;
import fs2.Stream;
import fs2.Stream$;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import js7.base.circeutils.typed.Subtype;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichOption$;
import js7.base.utils.ScalaUtils$syntax$RichScalaUtilsMap$;
import js7.data.board.Board;
import js7.data.board.BoardEvent;
import js7.data.board.BoardEvent$NoticeDeleted$;
import js7.data.board.BoardPath;
import js7.data.board.BoardSnapshot;
import js7.data.board.BoardState$;
import js7.data.board.BoardState$NoticeConsumptionSnapshot$;
import js7.data.board.Notice;
import js7.data.board.NoticeId;
import js7.data.board.NoticePlace;
import js7.data.board.NoticePlace$;
import js7.data.board.NoticeV2_3;
import js7.data.event.KeyedEvent;
import js7.data.item.UnsignedSimpleItemState;
import js7.data.order.Order;
import js7.data.order.OrderEvent;
import js7.data.order.OrderId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.View;
import scala.collection.View$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;

public final class BoardState
implements UnsignedSimpleItemState,
Product,
Serializable {
    private final Board board;
    private final Map idToNotice;
    private final Map orderToConsumptionStack;
    private final BoardState$ companion;
    private final Board item;

    public static BoardState apply(Board board, Map<NoticeId, NoticePlace> map, Map<OrderId, List<NoticeId>> map2) {
        return BoardState$.MODULE$.apply(board, map, map2);
    }

    public static BoardState fromProduct(Product product) {
        return BoardState$.MODULE$.fromProduct(product);
    }

    public static BoardState unapply(BoardState boardState) {
        return BoardState$.MODULE$.unapply(boardState);
    }

    public static Map<NoticeId, NoticePlace> $lessinit$greater$default$2() {
        return BoardState$.MODULE$.$lessinit$greater$default$2();
    }

    public static Map<OrderId, List<NoticeId>> $lessinit$greater$default$3() {
        return BoardState$.MODULE$.$lessinit$greater$default$3();
    }

    public BoardState(Board board, Map<NoticeId, NoticePlace> idToNotice, Map<OrderId, List<NoticeId>> orderToConsumptionStack) {
        this.board = board;
        this.idToNotice = idToNotice;
        this.orderToConsumptionStack = orderToConsumptionStack;
        this.companion = BoardState$.MODULE$;
        this.item = board;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BoardState)) return false;
        BoardState boardState = (BoardState)object;
        Board board = this.board();
        Board board2 = boardState.board();
        if (board == null) {
            if (board2 != null) {
                return false;
            }
        } else if (!((Object)board).equals(board2)) return false;
        Map<NoticeId, NoticePlace> map = this.idToNotice();
        Map<NoticeId, NoticePlace> map2 = boardState.idToNotice();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Map<OrderId, List<NoticeId>> map3 = this.orderToConsumptionStack();
        Map<OrderId, List<NoticeId>> map4 = boardState.orderToConsumptionStack();
        if (map3 == null) {
            if (map4 == null) return true;
            return false;
        } else {
            if (!map3.equals(map4)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof BoardState;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "BoardState";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "board";
            }
            case 1: {
                return "idToNotice";
            }
            case 2: {
                return "orderToConsumptionStack";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Board board() {
        return this.board;
    }

    public Map<NoticeId, NoticePlace> idToNotice() {
        return this.idToNotice;
    }

    public Map<OrderId, List<NoticeId>> orderToConsumptionStack() {
        return this.orderToConsumptionStack;
    }

    public BoardState$ companion() {
        return this.companion;
    }

    @Override
    public Board item() {
        return this.item;
    }

    @Override
    public BoardPath path() {
        return this.item().path();
    }

    public Either<Problem, BoardState> updateItem(Board item) {
        return package$.MODULE$.Right().apply((Object)this.copy(item, this.copy$default$2(), this.copy$default$3()));
    }

    public String toString() {
        return "BoardState(" + this.board().pathRev() + " " + this.idToNotice() + ")";
    }

    @Override
    public Stream<IO, Object> toSnapshotStream() {
        return Stream$.MODULE$.iterable((Iterable)((IterableOps)((IterableOps)View$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Board[]{this.board()})).$plus$plus(this.notices())).$plus$plus((IterableOnce)this.idToNotice().values().view().flatMap((Function1 & Serializable)_$1 -> _$1.toSnapshot(this.path())))).$plus$plus((IterableOnce)this.orderToConsumptionStack().view().map((Function1 & Serializable)x$1 -> {
            OrderId orderId = (OrderId)x$1._1();
            List list = (List)x$1._2();
            return BoardState$NoticeConsumptionSnapshot$.MODULE$.apply(this.path(), orderId, (List<NoticeId>)list);
        })));
    }

    public Either<Problem, BoardState> recover(BoardSnapshot snapshot) {
        BoardSnapshot boardSnapshot = snapshot;
        if (boardSnapshot instanceof Notice) {
            Notice notice = (Notice)boardSnapshot;
            return this.addNotice(notice);
        }
        if (boardSnapshot instanceof NoticeConsumptionSnapshot) {
            NoticeConsumptionSnapshot snapshot2 = (NoticeConsumptionSnapshot)boardSnapshot;
            Map map = (Map)this.orderToConsumptionStack().updated((Object)snapshot2.orderId(), snapshot2.noticeIdStack());
            Board board = this.copy$default$1();
            Map<NoticeId, NoticePlace> map2 = this.copy$default$2();
            return package$.MODULE$.Right().apply((Object)this.copy(board, map2, (Map<OrderId, List<NoticeId>>)map));
        }
        if (boardSnapshot instanceof NoticePlace.Snapshot) {
            NoticePlace.Snapshot snapshot3 = (NoticePlace.Snapshot)boardSnapshot;
            Map map = (Map)this.idToNotice().updated((Object)snapshot3.noticeId(), (Object)((NoticePlace)this.idToNotice().getOrElse((Object)snapshot3.noticeId(), () -> BoardState.$anonfun$1(snapshot3))).withSnapshot(snapshot3));
            Board board = this.copy$default$1();
            Map<OrderId, List<NoticeId>> map3 = this.copy$default$3();
            return package$.MODULE$.Right().apply((Object)this.copy(board, (Map<NoticeId, NoticePlace>)map, map3));
        }
        throw new MatchError((Object)boardSnapshot);
    }

    public Either<Problem, BoardState> addNoticeV2_3(NoticeV2_3 notice) {
        return this.addNotice(notice.toNotice(this.board().path()));
    }

    public Either<Problem, BoardState> addNotice(Notice notice) {
        Option option = this.idToNotice().get((Object)notice.id());
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)this.updateNoticePlace(NoticePlace$.MODULE$.apply(notice.id(), (Option<Notice>)Some$.MODULE$.apply((Object)notice), NoticePlace$.MODULE$.$lessinit$greater$default$3(), NoticePlace$.MODULE$.$lessinit$greater$default$4(), NoticePlace$.MODULE$.$lessinit$greater$default$5())));
        }
        if (option instanceof Some) {
            NoticePlace noticePlace = (NoticePlace)((Some)option).value();
            return package$.MODULE$.Right().apply((Object)this.updateNoticePlace(noticePlace.post(notice)));
        }
        throw new MatchError((Object)option);
    }

    public Either<Problem, BoardState> addExpectation(NoticeId noticeId, OrderId orderId) {
        NoticePlace noticePlace = (NoticePlace)this.idToNotice().getOrElse((Object)noticeId, () -> BoardState.$anonfun$2(noticeId));
        Set set = (Set)noticePlace.expectingOrderIds().$plus((Object)orderId);
        NoticeId noticeId2 = noticePlace.copy$default$1();
        Option<Notice> option = noticePlace.copy$default$2();
        boolean bl = noticePlace.copy$default$4();
        int n = noticePlace.copy$default$5();
        return package$.MODULE$.Right().apply((Object)this.updateNoticePlace(noticePlace.copy(noticeId2, option, (Set<OrderId>)set, bl, n)));
    }

    public Either<Problem, BoardState> removeExpectation(NoticeId noticeId, OrderId orderId) {
        return package$.MODULE$.Right().apply(this.idToNotice().get((Object)noticeId).fold(this::removeExpectation$$anonfun$1, (Function1 & Serializable)noticePlace -> {
            Set set = (Set)noticePlace.expectingOrderIds().$minus((Object)orderId);
            NoticeId noticeId = noticePlace.copy$default$1();
            Option<Notice> option = noticePlace.copy$default$2();
            boolean bl = noticePlace.copy$default$4();
            int n = noticePlace.copy$default$5();
            return this.updateNoticePlace(noticePlace.copy(noticeId, option, (Set<OrderId>)set, bl, n));
        }));
    }

    public Either<Problem, BoardState> addConsumption(NoticeId noticeId, Order<Order.State> order, OrderEvent.OrderNoticesExpected.Expected consumption) {
        NoticePlace noticePlace = (NoticePlace)this.idToNotice().getOrElse((Object)noticeId, () -> BoardState.$anonfun$3(noticeId));
        List consumptionStack = (List)this.orderToConsumptionStack().getOrElse((Object)order.id(), BoardState::$anonfun$4);
        Map map = (Map)this.idToNotice().updated((Object)noticeId, (Object)noticePlace.startConsumption(order.id()));
        Map map2 = (Map)this.orderToConsumptionStack().updated((Object)order.id(), (Object)consumptionStack.$colon$colon((Object)consumption.noticeId()));
        Board board = this.copy$default$1();
        return package$.MODULE$.Right().apply((Object)this.copy(board, (Map<NoticeId, NoticePlace>)map, (Map<OrderId, List<NoticeId>>)map2));
    }

    public Either<Problem, BoardState> removeConsumption(OrderId orderId, boolean succeeded) {
        Map map = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.orderToConsumptionStack());
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(map, orderId, Tag$.MODULE$.apply(OrderId.class, LightTypeTag$.MODULE$.parse(-414890029, "\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))).flatMap((Function1 & Serializable)consumptions -> {
            List list = consumptions;
            if (!(list instanceof .colon.colon)) {
                throw new MatchError((Object)list);
            }
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            NoticeId noticeId = (NoticeId)colon2.head();
            List remainingConsumptions = list2;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)noticeId, (Object)remainingConsumptions);
            NoticeId noticeId2 = (NoticeId)tuple2._1();
            List remainingConsumptions2 = (List)tuple2._2();
            Map map = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.idToNotice());
            return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(map, noticeId2, Tag$.MODULE$.apply(NoticeId.class, LightTypeTag$.MODULE$.parse(296927199, "\u0004\u0000\u0001\u0017js7.data.board.NoticeId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\u0017js7.data.board.NoticeId\u0001\u0001\u0004\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))).map((Function1 & Serializable)noticePlace -> {
                BoardState boardState = this.updateNoticePlace(noticePlace.finishConsumption(succeeded));
                Map map = remainingConsumptions2.isEmpty() ? (Map)this.orderToConsumptionStack().$minus((Object)orderId) : (Map)this.orderToConsumptionStack().updated((Object)orderId, (Object)remainingConsumptions2);
                Board board = boardState.copy$default$1();
                Map<NoticeId, NoticePlace> map2 = boardState.copy$default$2();
                return boardState.copy(board, map2, (Map<OrderId, List<NoticeId>>)map);
            });
        });
    }

    public boolean containsNotice(NoticeId noticeId) {
        return this.idToNotice().get((Object)noticeId).exists((Function1 & Serializable)_$2 -> _$2.notice().isDefined());
    }

    public Set<OrderId> expectingOrders(NoticeId noticeId) {
        Option option = ScalaUtils$syntax$.MODULE$.RichOption(this.idToNotice().get((Object)noticeId));
        return (Set)ScalaUtils$syntax$RichOption$.MODULE$.fold_$extension(option, BoardState::expectingOrders$$anonfun$1, (Function1 & Serializable)_$3 -> _$3.expectingOrderIds());
    }

    public View<Notice> notices() {
        return (View)this.idToNotice().values().view().flatMap((Function1 & Serializable)_$4 -> _$4.notice());
    }

    public int noticeCount() {
        return this.idToNotice().values().count((Function1 & Serializable)_$5 -> _$5.notice().isDefined());
    }

    public Either<Problem, KeyedEvent<BoardEvent.NoticeDeleted>> deleteNoticeEvent(NoticeId noticeId) {
        return this.checkDelete(noticeId).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return BoardEvent$NoticeDeleted$.MODULE$.apply(noticeId).toKeyedEvent(this.board().path());
        });
    }

    public Either<Problem, BoardState> removeNotice(NoticeId noticeId) {
        return this.checkDelete(noticeId).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return (BoardState)this.idToNotice().get((Object)noticeId).fold(this::removeNotice$$anonfun$1$$anonfun$1, (Function1 & Serializable)noticePlace -> this.updateNoticePlace(noticePlace.removeNotice()));
        });
    }

    private BoardState updateNoticePlace(NoticePlace noticePlace) {
        Map map = noticePlace.isEmpty() ? (Map)this.idToNotice().$minus((Object)noticePlace.noticeId()) : (Map)this.idToNotice().updated((Object)noticePlace.noticeId(), (Object)noticePlace);
        Board board = this.copy$default$1();
        Map<OrderId, List<NoticeId>> map2 = this.copy$default$3();
        return this.copy(board, (Map<NoticeId, NoticePlace>)map, map2);
    }

    private Either<Problem, BoxedUnit> checkDelete(NoticeId noticeId) {
        return this.notice(noticeId).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Notice notice = x$1;
        });
    }

    public Either<Problem, Notice> notice(NoticeId noticeId) {
        Map map = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.idToNotice());
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(map, noticeId, Tag$.MODULE$.apply(NoticeId.class, LightTypeTag$.MODULE$.parse(296927199, "\u0004\u0000\u0001\u0017js7.data.board.NoticeId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\u0017js7.data.board.NoticeId\u0001\u0001\u0004\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))).flatMap((Function1 & Serializable)noticePlace -> {
            Left left;
            Option<Notice> option = noticePlace.notice();
            if (None$.MODULE$.equals(option)) {
                left = package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> BoardState.notice$$anonfun$1$$anonfun$1(noticeId)), Problem$.MODULE$.apply$default$2()));
            } else if (option instanceof Some) {
                Notice notice2 = (Notice)((Some)option).value();
                left = package$.MODULE$.Right().apply((Object)notice2);
            } else {
                throw new MatchError(option);
            }
            return left.map((Function1 & Serializable)notice -> notice);
        });
    }

    public BoardState copy(Board board, Map<NoticeId, NoticePlace> idToNotice, Map<OrderId, List<NoticeId>> orderToConsumptionStack) {
        return new BoardState(board, idToNotice, orderToConsumptionStack);
    }

    public Board copy$default$1() {
        return this.board();
    }

    public Map<NoticeId, NoticePlace> copy$default$2() {
        return this.idToNotice();
    }

    public Map<OrderId, List<NoticeId>> copy$default$3() {
        return this.orderToConsumptionStack();
    }

    public Board _1() {
        return this.board();
    }

    public Map<NoticeId, NoticePlace> _2() {
        return this.idToNotice();
    }

    public Map<OrderId, List<NoticeId>> _3() {
        return this.orderToConsumptionStack();
    }

    private static final NoticePlace $anonfun$1(NoticePlace.Snapshot snapshot$1) {
        return NoticePlace$.MODULE$.apply(snapshot$1.noticeId(), NoticePlace$.MODULE$.$lessinit$greater$default$2(), NoticePlace$.MODULE$.$lessinit$greater$default$3(), NoticePlace$.MODULE$.$lessinit$greater$default$4(), NoticePlace$.MODULE$.$lessinit$greater$default$5());
    }

    private static final NoticePlace $anonfun$2(NoticeId noticeId$3) {
        return NoticePlace$.MODULE$.apply(noticeId$3, NoticePlace$.MODULE$.$lessinit$greater$default$2(), NoticePlace$.MODULE$.$lessinit$greater$default$3(), NoticePlace$.MODULE$.$lessinit$greater$default$4(), NoticePlace$.MODULE$.$lessinit$greater$default$5());
    }

    private final BoardState removeExpectation$$anonfun$1() {
        return this;
    }

    private static final NoticePlace $anonfun$3(NoticeId noticeId$4) {
        return NoticePlace$.MODULE$.apply(noticeId$4, NoticePlace$.MODULE$.$lessinit$greater$default$2(), NoticePlace$.MODULE$.$lessinit$greater$default$3(), NoticePlace$.MODULE$.$lessinit$greater$default$4(), NoticePlace$.MODULE$.$lessinit$greater$default$5());
    }

    private static final List $anonfun$4() {
        return package$.MODULE$.Nil();
    }

    private static final Set expectingOrders$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private final BoardState removeNotice$$anonfun$1$$anonfun$1() {
        return this;
    }

    private static final String notice$$anonfun$1$$anonfun$1(NoticeId noticeId$8) {
        return noticeId$8 + " does not denote a Notice (but a Notice expectation)";
    }

    public static final class NoticeConsumptionSnapshot
    implements BoardSnapshot,
    Product,
    Serializable {
        private final BoardPath boardPath;
        private final OrderId orderId;
        private final List noticeIdStack;

        public static NoticeConsumptionSnapshot apply(BoardPath boardPath, OrderId orderId, List<NoticeId> list) {
            return BoardState$NoticeConsumptionSnapshot$.MODULE$.apply(boardPath, orderId, list);
        }

        public static NoticeConsumptionSnapshot fromProduct(Product product) {
            return BoardState$NoticeConsumptionSnapshot$.MODULE$.fromProduct(product);
        }

        public static Subtype<NoticeConsumptionSnapshot> subtype() {
            return BoardState$NoticeConsumptionSnapshot$.MODULE$.subtype();
        }

        public static NoticeConsumptionSnapshot unapply(NoticeConsumptionSnapshot noticeConsumptionSnapshot) {
            return BoardState$NoticeConsumptionSnapshot$.MODULE$.unapply(noticeConsumptionSnapshot);
        }

        public NoticeConsumptionSnapshot(BoardPath boardPath, OrderId orderId, List<NoticeId> noticeIdStack) {
            this.boardPath = boardPath;
            this.orderId = orderId;
            this.noticeIdStack = noticeIdStack;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NoticeConsumptionSnapshot)) return false;
            NoticeConsumptionSnapshot noticeConsumptionSnapshot = (NoticeConsumptionSnapshot)object;
            BoardPath boardPath = this.boardPath();
            BoardPath boardPath2 = noticeConsumptionSnapshot.boardPath();
            if (boardPath == null) {
                if (boardPath2 != null) {
                    return false;
                }
            } else if (!((Object)boardPath).equals(boardPath2)) return false;
            OrderId orderId = this.orderId();
            OrderId orderId2 = noticeConsumptionSnapshot.orderId();
            if (orderId == null) {
                if (orderId2 != null) {
                    return false;
                }
            } else if (!((Object)orderId).equals(orderId2)) return false;
            List<NoticeId> list = this.noticeIdStack();
            List<NoticeId> list2 = noticeConsumptionSnapshot.noticeIdStack();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NoticeConsumptionSnapshot;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "NoticeConsumptionSnapshot";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "boardPath";
                }
                case 1: {
                    return "orderId";
                }
                case 2: {
                    return "noticeIdStack";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public BoardPath boardPath() {
            return this.boardPath;
        }

        public OrderId orderId() {
            return this.orderId;
        }

        public List<NoticeId> noticeIdStack() {
            return this.noticeIdStack;
        }

        public NoticeConsumptionSnapshot copy(BoardPath boardPath, OrderId orderId, List<NoticeId> noticeIdStack) {
            return new NoticeConsumptionSnapshot(boardPath, orderId, noticeIdStack);
        }

        public BoardPath copy$default$1() {
            return this.boardPath();
        }

        public OrderId copy$default$2() {
            return this.orderId();
        }

        public List<NoticeId> copy$default$3() {
            return this.noticeIdStack();
        }

        public BoardPath _1() {
            return this.boardPath();
        }

        public OrderId _2() {
            return this.orderId();
        }

        public List<NoticeId> _3() {
            return this.noticeIdStack();
        }
    }
}

