/*
 * Decompiled with CFR 0.152.
 */
package js7.data.execution.workflow.instructions;

import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import js7.base.problem.Problem;
import js7.base.time.AdmissionTimeSchemeForJavaTime$;
import js7.base.time.AdmissionTimeSchemeForJavaTime$RichAdmissionTimeScheme$;
import js7.base.time.JavaTimestamp;
import js7.base.time.JavaTimestamp$;
import js7.base.time.JavaTimestamp$specific$;
import js7.base.time.JavaTimestamp$specific$RichJavaTimestamp$;
import js7.base.time.TimeInterval;
import js7.base.time.Timestamp;
import js7.base.time.Timestamp$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichPartialFunction$;
import js7.data.execution.workflow.instructions.ScheduleCalculator$;
import js7.data.execution.workflow.instructions.ScheduleSimulator;
import js7.data.order.CycleState;
import js7.data.workflow.instructions.Schedule;
import js7.data.workflow.instructions.Schedule$Continuous$;
import js7.data.workflow.instructions.Schedule$Ticking$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqView;
import scala.collection.View;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

public final class ScheduleCalculator
implements ScheduleSimulator {
    private final Schedule schedule;
    private final ZoneId zone;
    private final FiniteDuration dateOffset;
    private final boolean onlyOnePeriod;

    public static ScheduleCalculator apply(Schedule schedule, ZoneId zoneId, FiniteDuration finiteDuration, boolean bl) {
        return ScheduleCalculator$.MODULE$.apply(schedule, zoneId, finiteDuration, bl);
    }

    public static Either<Problem, ScheduleCalculator> checked(Schedule schedule, ZoneId zoneId, FiniteDuration finiteDuration, boolean bl) {
        return ScheduleCalculator$.MODULE$.checked(schedule, zoneId, finiteDuration, bl);
    }

    public static boolean apply$default$4() {
        return ScheduleCalculator$.MODULE$.apply$default$4();
    }

    public ScheduleCalculator(Schedule schedule, ZoneId zone, FiniteDuration dateOffset, boolean onlyOnePeriod) {
        this.schedule = schedule;
        this.zone = zone;
        this.dateOffset = dateOffset;
        this.onlyOnePeriod = onlyOnePeriod;
    }

    public Option<CycleState> nextCycleState(Timestamp now, CycleState cycleState) {
        return this.nextCycle(now, cycleState).flatMap((Function1 & Serializable)x$1 -> {
            int n = BoxesRunTime.unboxToInt((Object)x$1._1());
            int n2 = BoxesRunTime.unboxToInt((Object)x$1._2());
            Timestamp timestamp = (Timestamp)x$1._3();
            boolean periodChanges = cycleState.index() != 0 && (n != cycleState.schemeIndex() || n2 != cycleState.periodIndex());
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(!this.onlyOnePeriod || !periodChanges);
            return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> ScheduleCalculator.nextCycleState$$anonfun$1$$anonfun$1(periodChanges, cycleState, n, n2, timestamp));
        });
    }

    public Either<Problem, Option<Option<CycleState>>> maybeRecalcCycleState(Timestamp now, CycleState cycleState) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.schedule.schemes());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, BoxesRunTime.boxToInteger((int)cycleState.schemeIndex()), Tag$.MODULE$.apply(Integer.TYPE, LightTypeTag$.MODULE$.parse(1454689320, "\u0004\u0000\u0001\tscala.Int\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\tscala.Int\u0001\u0001\u0001\u0004\u0000\u0001\fscala.AnyVal\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30))).map((Function1 & Serializable)scheme -> {
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(!AdmissionTimeSchemeForJavaTime$RichAdmissionTimeScheme$.MODULE$.isPermitted$extension(AdmissionTimeSchemeForJavaTime$.MODULE$.RichAdmissionTimeScheme(scheme.admissionTimeScheme()), now.max(cycleState.next()), this.zone, this.dateOffset));
            return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> this.maybeRecalcCycleState$$anonfun$1$$anonfun$1(now, cycleState));
        });
    }

    private Option<Tuple3<Object, Object, Timestamp>> nextCycle(Timestamp now, CycleState cycleState) {
        return ((IterableOnceOps)((IterableOps)this.schedule.schemes().view().zipWithIndex()).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Schedule.Scheme scheme = (Schedule.Scheme)tuple2._1();
                int schemeIndex = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return (View)AdmissionTimeSchemeForJavaTime$RichAdmissionTimeScheme$.MODULE$.findTimeIntervals$extension(AdmissionTimeSchemeForJavaTime$.MODULE$.RichAdmissionTimeScheme(scheme.admissionTimeScheme()), now, cycleState.end(), this.zone, this.dateOffset).flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Option option;
                        int periodIndex = BoxesRunTime.unboxToInt((Object)tuple2._1());
                        TimeInterval interval = (TimeInterval)tuple2._2();
                        Timestamp lastScheduledCycleStart = cycleState.next().max(interval.start());
                        Timestamp end = cycleState.end().min(interval.end());
                        boolean first = schemeIndex != cycleState.schemeIndex() || periodIndex != cycleState.periodIndex();
                        Schedule.Repeat repeat = scheme.repeat();
                        if (repeat instanceof Schedule.Periodic) {
                            Schedule.Periodic periodic = (Schedule.Periodic)repeat;
                            option = this.nextPeriod(periodic, lastScheduledCycleStart, now, first, end);
                        } else if (repeat instanceof Schedule.Ticking) {
                            FiniteDuration finiteDuration;
                            Schedule.Ticking ticking = Schedule$Ticking$.MODULE$.unapply((Schedule.Ticking)repeat);
                            FiniteDuration tickDuration = finiteDuration = ticking._1();
                            long n = now.$minus(lastScheduledCycleStart).toMillis() / tickDuration.toMillis();
                            option = Some$.MODULE$.apply((Object)(n > 0L ? lastScheduledCycleStart.$plus(package.LongMult$.MODULE$.$times$extension(scala.concurrent.duration.package$.MODULE$.LongMult(n), tickDuration)) : lastScheduledCycleStart.$plus(tickDuration.$times(Int$.MODULE$.int2long(ScalaUtils$syntax$RichBoolean$.MODULE$.toInt$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(!first)))))));
                        } else if (repeat instanceof Schedule.Continuous) {
                            Schedule.Continuous continuous = Schedule$Continuous$.MODULE$.unapply((Schedule.Continuous)repeat);
                            FiniteDuration finiteDuration = continuous._1();
                            Option<Object> option2 = continuous._2();
                            FiniteDuration pause = finiteDuration;
                            Option<Object> limit = option2;
                            int index = first ? 0 : cycleState.index();
                            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(limit.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$1 -> index < _$1));
                            option = ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> ScheduleCalculator.nextCycle$$anonfun$1$$anonfun$1$$anonfun$1(now, interval, pause, first));
                        } else {
                            throw new MatchError((Object)repeat);
                        }
                        return option.filter((Function1 & Serializable)_$2 -> _$2.$less(end)).map((Function1 & Serializable)_$3 -> Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)schemeIndex), (Object)BoxesRunTime.boxToInteger((int)periodIndex), _$3));
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        })).minByOption((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                Timestamp next = (Timestamp)tuple3._3();
                return next;
            }
            throw new MatchError((Object)tuple3);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    private Option<Timestamp> nextPeriod(Schedule.Periodic periodic, Timestamp last, Timestamp now, boolean first, Timestamp end) {
        SeqView scheduleMillis = periodic.offsets().view().map((Function1 & Serializable)_$4 -> _$4.toMillis());
        long p = periodic.period().toMillis();
        long localMilli = JavaTimestamp$specific$RichJavaTimestamp$.MODULE$.toZonedDateTime$extension(JavaTimestamp$specific$.MODULE$.RichJavaTimestamp(last), this.zone).toLocalDateTime().toInstant(ZoneOffset.UTC).toEpochMilli();
        long localPeriodStart = localMilli / p * p;
        long localMilliOfPeriod = localMilli % p;
        Vector nextTimestamps = package$.MODULE$.Iterator().from(0).flatMap((Function1 & Serializable)i -> scheduleMillis.map((Function1)(JFunction1.mcJJ.sp & Serializable)_$5 -> _$5 + (long)i * p$1)).filter((Function1)(JFunction1.mcZJ.sp & Serializable)t -> {
            if (first) {
                return t >= localMilliOfPeriod;
            }
            return t > localMilliOfPeriod;
        }).map((Function1 & Serializable)nextMilli -> this.$anonfun$5(localPeriodStart, BoxesRunTime.unboxToLong((Object)nextMilli))).takeWhile((Function1 & Serializable)_$6 -> _$6.$less(end)).toVector();
        return ((IterableOnceOps)nextTimestamps.view().filter((Function1 & Serializable)_$7 -> _$7.$less$eq(now))).maxOption(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).orElse(() -> ScheduleCalculator.nextPeriod$$anonfun$2(nextTimestamps));
    }

    private static final CycleState a$proxy1$1(boolean periodChanges$1, CycleState cycleState$2, int schemeIndex$1, int periodIndex$1, Timestamp next$1) {
        int n = periodChanges$1 ? 1 : cycleState$2.index() + 1;
        Timestamp timestamp = cycleState$2.copy$default$1();
        return cycleState$2.copy(timestamp, schemeIndex$1, periodIndex$1, n, next$1);
    }

    private static final CycleState nextCycleState$$anonfun$1$$anonfun$1(boolean periodChanges$2, CycleState cycleState$7, int schemeIndex$4, int periodIndex$3, Timestamp next$2) {
        return ScheduleCalculator.a$proxy1$1(periodChanges$2, cycleState$7, schemeIndex$4, periodIndex$3, next$2);
    }

    private final Option a$proxy2$1(Timestamp now$2, CycleState cycleState$4) {
        return this.nextCycleState(now$2, cycleState$4);
    }

    private final Option maybeRecalcCycleState$$anonfun$1$$anonfun$1(Timestamp now$7, CycleState cycleState$8) {
        return this.a$proxy2$1(now$7, cycleState$8);
    }

    private static final Timestamp a$proxy3$1(Timestamp now$5, TimeInterval interval$1, FiniteDuration pause$1, boolean first$1) {
        Timestamp next = now$5.max(interval$1.start()).$plus(pause$1.$times(Int$.MODULE$.int2long(ScalaUtils$syntax$RichBoolean$.MODULE$.toInt$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(!first$1)))));
        if (next.$less$eq(now$5)) {
            return Timestamp$.MODULE$.Epoch();
        }
        return next;
    }

    private static final Timestamp nextCycle$$anonfun$1$$anonfun$1$$anonfun$1(Timestamp now$8, TimeInterval interval$2, FiniteDuration pause$2, boolean first$3) {
        return ScheduleCalculator.a$proxy3$1(now$8, interval$2, pause$2, first$3);
    }

    private final /* synthetic */ JavaTimestamp $anonfun$5(long localPeriodStart$1, long nextMilli) {
        long localEpochMilli = localPeriodStart$1 + nextMilli;
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(localEpochMilli / 1000L, (int)(localEpochMilli % 1000L), ZoneOffset.UTC);
        return JavaTimestamp$.MODULE$.ofInstant(localDateTime.atZone(this.zone).toInstant());
    }

    private static final Option nextPeriod$$anonfun$2(Vector nextTimestamps$1) {
        return nextTimestamps$1.minOption(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }
}

