/*
 * Decompiled with CFR 0.152.
 */
package js7.data.workflow;

import io.circe.Decoder;
import io.circe.Encoder;
import java.io.Serializable;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.Tests$;
import js7.data.agent.AgentPath;
import js7.data.source.SourcePos;
import js7.data.workflow.Instruction$;
import js7.data.workflow.Instruction$Labeled$;
import js7.data.workflow.Workflow;
import js7.data.workflow.position.BranchId;
import js7.data.workflow.position.BranchPath;
import js7.data.workflow.position.Label;
import js7.data.workflow.position.Label$;
import js7.data.workflow.position.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.View;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public interface Instruction {
    public static Labeled toLabeled(Instruction instruction) {
        return Instruction$.MODULE$.toLabeled(instruction);
    }

    public static String instructionName$(Instruction $this) {
        return $this.instructionName();
    }

    default public String instructionName() {
        return ScalaUtils$syntax$.MODULE$.RichJavaClass(this.getClass()).simpleScalaName();
    }

    public Option<SourcePos> sourcePos();

    public Instruction withoutSourcePos();

    public static Instruction withPositions$(Instruction $this, Position position) {
        return $this.withPositions(position);
    }

    default public Instruction withPositions(Position position) {
        if (this.branchWorkflows().nonEmpty()) {
            throw new AssertionError((Object)(this.instructionName() + ".withPositions is not implemented"));
        }
        return this;
    }

    public static Instruction adopt$(Instruction $this, Workflow workflow) {
        return $this.adopt(workflow);
    }

    default public Instruction adopt(Workflow workflow) {
        return this;
    }

    public static Instruction reduceForAgent$(Instruction $this, AgentPath agentPath, Workflow workflow) {
        return $this.reduceForAgent(agentPath, workflow);
    }

    default public Instruction reduceForAgent(AgentPath agentPath, Workflow workflow) {
        return this;
    }

    public static boolean isVisibleForAgent$(Instruction $this, AgentPath agentPath, Workflow workflow) {
        return $this.isVisibleForAgent(agentPath, workflow);
    }

    default public boolean isVisibleForAgent(AgentPath agentPath, Workflow workflow) {
        return this.workflows().exists((Function1 & Serializable)_$1 -> _$1.isVisibleForAgent(agentPath));
    }

    public Instruction withoutBlocks();

    public Seq<Tuple2<BranchId, Workflow>> branchWorkflows();

    public static Seq workflows$(Instruction $this) {
        return $this.workflows();
    }

    default public Seq<Workflow> workflows() {
        return (Seq)this.branchWorkflows().map((Function1 & Serializable)_$2 -> (Workflow)_$2._2());
    }

    public static View flattenedWorkflows$(Instruction $this, Position parent) {
        return $this.flattenedWorkflows(parent);
    }

    default public View<Tuple2<List<BranchPath.package.BranchPath.Segment>, Workflow>> flattenedWorkflows(Position parent) {
        return (View)this.branchWorkflows().view().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                BranchId branchId = (BranchId)tuple2._1();
                Workflow workflow = (Workflow)tuple2._2();
                return workflow.flattenedWorkflowsOf(parent.$div(branchId));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static View flattenedInstructions$(Instruction $this, Position parent) {
        return $this.flattenedInstructions(parent);
    }

    default public View<Tuple2<Position, Labeled>> flattenedInstructions(Position parent) {
        return (View)this.branchWorkflows().view().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                BranchId branchId = (BranchId)tuple2._1();
                Workflow workflow = (Workflow)tuple2._2();
                return workflow.flattenedInstructions(parent.$div(branchId));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static Either workflow$(Instruction $this, BranchId branchId) {
        return $this.workflow(branchId);
    }

    default public Either<Problem, Workflow> workflow(BranchId branchId) {
        return Problem$.MODULE$.toInvalid(Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> this.workflow$$anonfun$1(branchId)), Problem$.MODULE$.apply$default$2()));
    }

    public static Option toCatchBranchId$(Instruction $this, BranchId branchId) {
        return $this.toCatchBranchId(branchId);
    }

    default public Option<BranchId> toCatchBranchId(BranchId branchId) {
        return None$.MODULE$;
    }

    public static boolean isSameCore$(Instruction $this, Instruction other) {
        return $this.isSameCore(other);
    }

    default public boolean isSameCore(Instruction other) {
        Instruction instruction = this.withoutSourcePos().withoutBlocks();
        Instruction instruction2 = other.withoutSourcePos().withoutBlocks();
        return !(instruction != null ? !instruction.equals(instruction2) : instruction2 != null);
    }

    public static Labeled $at$colon$(Instruction $this, Option maybeLabel) {
        return $this.$at$colon((Option<Label>)maybeLabel);
    }

    default public Labeled $at$colon(Option<Label> maybeLabel) {
        return Instruction$Labeled$.MODULE$.apply(maybeLabel, this, Instruction$Labeled$.MODULE$.$lessinit$greater$default$3());
    }

    public static Labeled $at$colon$(Instruction $this, Label label) {
        return $this.$at$colon(label);
    }

    default public Labeled $at$colon(Label label) {
        return Instruction$Labeled$.MODULE$.apply((Option<Label>)Some$.MODULE$.apply((Object)label), this, Instruction$Labeled$.MODULE$.$lessinit$greater$default$3());
    }

    public static Labeled $at$colon$(Instruction $this, String label) {
        return $this.$at$colon(label);
    }

    default public Labeled $at$colon(String label) {
        return Instruction$Labeled$.MODULE$.apply((Option<Label>)Some$.MODULE$.apply((Object)Label$.MODULE$.apply(label)), this, Instruction$Labeled$.MODULE$.$lessinit$greater$default$3());
    }

    public static Labeled $at$colon$(Instruction $this, BoxedUnit unit) {
        return $this.$at$colon(unit);
    }

    default public Labeled $at$colon(BoxedUnit unit) {
        return Instruction$Labeled$.MODULE$.apply((Option<Label>)None$.MODULE$, this, Instruction$Labeled$.MODULE$.$lessinit$greater$default$3());
    }

    public static String sourcePosToString$(Instruction $this) {
        return $this.sourcePosToString();
    }

    default public String sourcePosToString() {
        return ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(Tests$.MODULE$.isTest()), (Function0<String>)((Function0 & Serializable)this::sourcePosToString$$anonfun$1));
    }

    private String workflow$$anonfun$1(BranchId branchId$1) {
        return "Instruction '" + this.instructionName() + "' does not have a nested workflow for branch '" + branchId$1 + "'";
    }

    private String sourcePosToString$$anonfun$1() {
        return " /*" + this.sourcePos() + "*/";
    }

    public static interface IsOrderBoundary
    extends Instruction {
    }

    public static final class Labeled
    implements Product,
    Serializable {
        private final Option maybeLabel;
        private final Instruction instruction;
        private final Option maybePosition;

        public static Labeled apply(Option<Label> option, Instruction instruction, Option<Position> option2) {
            return Instruction$Labeled$.MODULE$.apply(option, instruction, option2);
        }

        public static Labeled fromProduct(Product product) {
            return Instruction$Labeled$.MODULE$.fromProduct(product);
        }

        public static Decoder<Labeled> jsonDecoder(Decoder<Instruction> decoder) {
            return Instruction$Labeled$.MODULE$.jsonDecoder(decoder);
        }

        public static Encoder.AsObject<Labeled> jsonEncoder(Encoder.AsObject<Instruction> asObject) {
            return Instruction$Labeled$.MODULE$.jsonEncoder(asObject);
        }

        public static Labeled unapply(Labeled labeled) {
            return Instruction$Labeled$.MODULE$.unapply(labeled);
        }

        public static Option<Position> $lessinit$greater$default$3() {
            return Instruction$Labeled$.MODULE$.$lessinit$greater$default$3();
        }

        public Labeled(Option<Label> maybeLabel, Instruction instruction, Option<Position> maybePosition) {
            this.maybeLabel = maybeLabel;
            this.instruction = instruction;
            this.maybePosition = maybePosition;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Labeled)) return false;
            Labeled labeled = (Labeled)object;
            Option<Label> option = this.maybeLabel();
            Option<Label> option2 = labeled.maybeLabel();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Instruction instruction = this.instruction();
            Instruction instruction2 = labeled.instruction();
            if (instruction == null) {
                if (instruction2 != null) {
                    return false;
                }
            } else if (!instruction.equals(instruction2)) return false;
            Option<Position> option3 = this.maybePosition();
            Option<Position> option4 = labeled.maybePosition();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Labeled;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Labeled";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "maybeLabel";
                }
                case 1: {
                    return "instruction";
                }
                case 2: {
                    return "maybePosition";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<Label> maybeLabel() {
            return this.maybeLabel;
        }

        public Instruction instruction() {
            return this.instruction;
        }

        public Option<Position> maybePosition() {
            return this.maybePosition;
        }

        public String toString() {
            return this.labelString() + this.instruction();
        }

        public String labelString() {
            return Option$.MODULE$.option2Iterable(this.maybeLabel().map(Instruction$::js7$data$workflow$Instruction$Labeled$$_$labelString$$anonfun$1)).mkString();
        }

        public Labeled withPositions(Position position) {
            Some some = Some$.MODULE$.apply((Object)position);
            Instruction instruction = this.instruction().withPositions(position);
            Option<Label> option = this.copy$default$1();
            return this.copy(option, instruction, (Option<Position>)some);
        }

        public Labeled copy(Option<Label> maybeLabel, Instruction instruction, Option<Position> maybePosition) {
            return new Labeled(maybeLabel, instruction, maybePosition);
        }

        public Option<Label> copy$default$1() {
            return this.maybeLabel();
        }

        public Instruction copy$default$2() {
            return this.instruction();
        }

        public Option<Position> copy$default$3() {
            return this.maybePosition();
        }

        public Option<Label> _1() {
            return this.maybeLabel();
        }

        public Instruction _2() {
            return this.instruction();
        }

        public Option<Position> _3() {
            return this.maybePosition();
        }
    }

    public static interface NoInstructionBlock
    extends Instruction {
        public static NoInstructionBlock withoutBlocks$(NoInstructionBlock $this) {
            return $this.withoutBlocks();
        }

        @Override
        default public NoInstructionBlock withoutBlocks() {
            return this;
        }

        public static Seq branchWorkflows$(NoInstructionBlock $this) {
            return $this.branchWorkflows();
        }

        @Override
        default public Seq<Tuple2<BranchId, Workflow>> branchWorkflows() {
            return package$.MODULE$.Nil();
        }
    }
}

