/*
 * Decompiled with CFR 0.152.
 */
package js7.data.workflow.instructions;

import cats.kernel.CommutativeSemigroup;
import cats.kernel.Eq$;
import cats.kernel.Order;
import cats.kernel.Semigroup$;
import io.circe.CursorOp;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.HCursor;
import io.circe.JsonObject$;
import io.circe.syntax.package;
import java.io.Serializable;
import js7.base.circeutils.CirceUtils$;
import js7.base.circeutils.CirceUtils$CirceUtilsChecked$;
import js7.base.circeutils.ScalaJsonCodecs$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.ScalaTime$;
import js7.base.utils.typeclasses.IsEmpty;
import js7.base.utils.typeclasses.IsEmpty$;
import js7.base.utils.typeclasses.IsEmpty$syntax$;
import js7.data.source.SourcePos;
import js7.data.source.SourcePos$;
import js7.data.workflow.Instruction;
import js7.data.workflow.Workflow;
import js7.data.workflow.Workflow$;
import js7.data.workflow.instructions.If;
import js7.data.workflow.instructions.Retry;
import js7.data.workflow.instructions.TryInstruction;
import js7.data.workflow.position.BranchId;
import js7.data.workflow.position.TryCatchBranchId$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class TryInstruction$
implements Mirror.Product,
Serializable {
    public static final FiniteDuration js7$data$workflow$instructions$TryInstruction$$$NoRetryDelay;
    public static final Problem js7$data$workflow$instructions$TryInstruction$$$InvalidMaxTriesProblem;
    private static final Problem MissingRetryProblem;
    private static final Encoder.AsObject jsonEncoder;
    private static final Decoder jsonDecoder;
    public static final TryInstruction$ MODULE$;

    private TryInstruction$() {
    }

    static {
        MODULE$ = new TryInstruction$();
        js7$data$workflow$instructions$TryInstruction$$$NoRetryDelay = ScalaTime$.MODULE$.ZeroDuration();
        js7$data$workflow$instructions$TryInstruction$$$InvalidMaxTriesProblem = Problem$.MODULE$.pure("maxTries argument must be a positive number");
        MissingRetryProblem = Problem$.MODULE$.pure("Missing a retry instruction in the catch block to make sense of retryDelays or maxTries");
        jsonEncoder = (Encoder.AsObject & Serializable)o -> {
            Object[] objectArray = new Tuple2[5];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"try");
            Workflow workflow = (Workflow)io.circe.syntax.package$.MODULE$.EncoderOps((Object)o.tryWorkflow());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)workflow, Workflow$.MODULE$.jsonCodec()));
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"catch");
            Workflow workflow2 = (Workflow)io.circe.syntax.package$.MODULE$.EncoderOps((Object)o.catchWorkflow());
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)workflow2, Workflow$.MODULE$.jsonCodec()));
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"retryDelays");
            Option option = (Option)io.circe.syntax.package$.MODULE$.EncoderOps(o.retryDelays());
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)option, Encoder$.MODULE$.encodeOption((Encoder)Encoder$.MODULE$.encodeIterable(ScalaJsonCodecs$.MODULE$.FiniteDurationJsonEncoder(), Predef$.MODULE$.$conforms()))));
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"maxTries");
            IsEmpty IsEmpty$proxy1 = IsEmpty$.MODULE$.given_IsEmpty_A(Semigroup$.MODULE$.catsKernelCommutativeMonoidForOption((CommutativeSemigroup)Semigroup$.MODULE$.catsKernelCommutativeGroupForInt()), Eq$.MODULE$.catsKernelOrderForOption((Order)Eq$.MODULE$.catsKernelInstancesForInt()));
            Option option2 = (Option)io.circe.syntax.package$.MODULE$.EncoderOps(IsEmpty$syntax$.MODULE$.ifNonEmpty(o.maxTries(), IsEmpty$proxy1));
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)option2, Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeInt()))));
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"sourcePos");
            Option option3 = (Option)io.circe.syntax.package$.MODULE$.EncoderOps(o.sourcePos());
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)option3, Encoder$.MODULE$.encodeOption(SourcePos$.MODULE$.jsonEncoder())));
            return JsonObject$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        };
        jsonDecoder = (Decoder & Serializable)c -> c.get("try", Workflow$.MODULE$.jsonCodec()).flatMap((Function1 & Serializable)try_ -> c.get("catch", Workflow$.MODULE$.jsonCodec()).flatMap((Function1 & Serializable)catch_ -> c.get("retryDelays", Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeSeq(ScalaJsonCodecs$.MODULE$.FiniteDurationJsonDecoder()))).flatMap((Function1 & Serializable)delays -> c.get("maxTries", Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeInt())).flatMap((Function1 & Serializable)maxTries -> c.get("sourcePos", Decoder$.MODULE$.decodeOption(SourcePos$.MODULE$.jsonDecoder())).flatMap((Function1 & Serializable)sourcePos -> {
            Either either = CirceUtils$.MODULE$.CirceUtilsChecked(this.checked((Workflow)try_, (Workflow)catch_, (Option<Seq<FiniteDuration>>)delays, (Option<Object>)maxTries, (Option<SourcePos>)sourcePos));
            return CirceUtils$CirceUtilsChecked$.MODULE$.toDecoderResult$extension(either, (Function0<List<CursorOp>>)((Function0 & Serializable)() -> this.$init$$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(c))).map((Function1 & Serializable)tryInstr -> tryInstr);
        })))));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TryInstruction$.class);
    }

    public TryInstruction apply(Workflow tryWorkflow, Workflow catchWorkflow, Option<IndexedSeq<FiniteDuration>> retryDelays, Option<Object> maxTries, Option<SourcePos> sourcePos) {
        return new TryInstruction(tryWorkflow, catchWorkflow, retryDelays, maxTries, sourcePos);
    }

    public TryInstruction unapply(TryInstruction x$1) {
        return x$1;
    }

    public Option<IndexedSeq<FiniteDuration>> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Option<SourcePos> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public Problem MissingRetryProblem() {
        return MissingRetryProblem;
    }

    public Either<Problem, TryInstruction> checked(Workflow tryWorkflow, Workflow catchWorkflow, Option<Seq<FiniteDuration>> retryDelays, Option<Object> maxTries, Option<SourcePos> sourcePos) {
        return new TryInstruction(tryWorkflow, catchWorkflow, (Option<IndexedSeq<FiniteDuration>>)retryDelays.map((Function1 & Serializable)_$2 -> _$2.toVector()), maxTries, sourcePos).checked();
    }

    public Option<Seq<FiniteDuration>> checked$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> checked$default$4() {
        return None$.MODULE$;
    }

    public Option<SourcePos> checked$default$5() {
        return None$.MODULE$;
    }

    public Either<Problem, Object> toRetryIndex(BranchId branchId) {
        Option<Object> option;
        BranchId branchId2 = branchId;
        if (branchId2 != null && !(option = TryCatchBranchId$.MODULE$.unapply(branchId2)).isEmpty()) {
            int n;
            int i = n = BoxesRunTime.unboxToInt((Object)option.get());
            return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)i));
        }
        return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> TryInstruction$.toRetryIndex$$anonfun$1(branchId)), Problem$.MODULE$.apply$default$2()));
    }

    public boolean js7$data$workflow$instructions$TryInstruction$$$containsRetry(Workflow workflow) {
        return workflow.instructions().exists((Function1 & Serializable)x$1 -> {
            Instruction instruction = x$1;
            if (instruction instanceof Retry) {
                return true;
            }
            if (instruction instanceof If) {
                If o = (If)instruction;
                return o.workflows().exists((Function1 & Serializable)workflow -> MODULE$.js7$data$workflow$instructions$TryInstruction$$$containsRetry((Workflow)workflow));
            }
            if (instruction instanceof TryInstruction) {
                TryInstruction o = (TryInstruction)instruction;
                return MODULE$.js7$data$workflow$instructions$TryInstruction$$$containsRetry(o.tryWorkflow());
            }
            return false;
        });
    }

    public Encoder.AsObject<TryInstruction> jsonEncoder() {
        return jsonEncoder;
    }

    public Decoder<TryInstruction> jsonDecoder() {
        return jsonDecoder;
    }

    public TryInstruction fromProduct(Product x$0) {
        return new TryInstruction((Workflow)x$0.productElement(0), (Workflow)x$0.productElement(1), (Option<IndexedSeq<FiniteDuration>>)((Option)x$0.productElement(2)), (Option<Object>)((Option)x$0.productElement(3)), (Option<SourcePos>)((Option)x$0.productElement(4)));
    }

    private final List $init$$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(HCursor c$6) {
        return c$6.history();
    }

    private static final String toRetryIndex$$anonfun$1(BranchId branchId$1) {
        return "Invalid BranchId for Try instruction: " + branchId$1;
    }
}

