/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.recover;

import cats.effect.unsafe.IORuntime;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.typesafe.config.Config;
import java.io.Serializable;
import js7.data.cluster.ClusterState;
import js7.data.event.EventId$;
import js7.data.event.JournalId;
import js7.data.event.SnapshotableState;
import js7.data.node.NodeId;
import js7.journal.data.JournalLocation;
import js7.journal.recover.Recovered$;
import js7.journal.recover.Recovered$Extract$;
import js7.journal.recover.RecoveredJournalFile;
import js7.journal.watch.JournalEventWatch;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.concurrent.duration.Deadline;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class Recovered<S extends SnapshotableState<S>>
implements AutoCloseable {
    private final JournalLocation journalLocation;
    private final Option recoveredJournalFile;
    private final Deadline totalRunningSince;
    private final Config config;
    private final JournalEventWatch eventWatch;
    private final SnapshotableState.Companion<S> S;

    public static <S extends SnapshotableState<S>> Recovered<S> fromJournalFile(JournalLocation journalLocation, RecoveredJournalFile<S> recoveredJournalFile, Deadline deadline, Config config, SnapshotableState.Companion<S> companion, IORuntime iORuntime) {
        return Recovered$.MODULE$.fromJournalFile(journalLocation, recoveredJournalFile, deadline, config, companion, iORuntime);
    }

    public static <S extends SnapshotableState<S>> Recovered<S> noJournalFile(JournalLocation journalLocation, Deadline deadline, Config config, SnapshotableState.Companion<S> companion, IORuntime iORuntime) {
        return Recovered$.MODULE$.noJournalFile(journalLocation, deadline, config, companion, iORuntime);
    }

    public Recovered(JournalLocation journalLocation, Option<RecoveredJournalFile<S>> recoveredJournalFile, Deadline totalRunningSince, Config config, JournalEventWatch eventWatch, SnapshotableState.Companion<S> S) {
        this.journalLocation = journalLocation;
        this.recoveredJournalFile = recoveredJournalFile;
        this.totalRunningSince = totalRunningSince;
        this.config = config;
        this.eventWatch = eventWatch;
        this.S = S;
    }

    public JournalLocation journalLocation() {
        return this.journalLocation;
    }

    public Option<RecoveredJournalFile<S>> recoveredJournalFile() {
        return this.recoveredJournalFile;
    }

    public Deadline totalRunningSince() {
        return this.totalRunningSince;
    }

    public JournalEventWatch eventWatch() {
        return this.eventWatch;
    }

    @Override
    public void close() {
        this.eventWatch().close();
    }

    public Recovered<S> changeRecoveredJournalFile(Option<RecoveredJournalFile<S>> recoveredJournalFile) {
        return new Recovered<S>(this.journalLocation(), recoveredJournalFile, this.totalRunningSince(), this.config, this.eventWatch(), this.S);
    }

    public long eventId() {
        return BoxesRunTime.unboxToLong((Object)this.recoveredJournalFile().fold(Recovered::eventId$$anonfun$1, (Function1 & Serializable)_$1 -> _$1.eventId()));
    }

    public ClusterState clusterState() {
        return this.state().clusterState();
    }

    public Option<NodeId> failedNodeId() {
        ClusterState clusterState = (ClusterState)package.option$.MODULE$.catsSyntaxOptionId((Object)this.clusterState());
        return OptionIdOps$.MODULE$.some$extension((Object)clusterState).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(ClusterState x2) {
                ClusterState clusterState = x2;
                if (clusterState instanceof ClusterState.FailedOver) {
                    ClusterState.FailedOver o = (ClusterState.FailedOver)clusterState;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(ClusterState x2, Function1 function1) {
                ClusterState clusterState = x2;
                if (clusterState instanceof ClusterState.FailedOver) {
                    ClusterState.FailedOver o = (ClusterState.FailedOver)clusterState;
                    return o.passiveId();
                }
                return function1.apply((Object)x2);
            }
        });
    }

    public S state() {
        return (S)((SnapshotableState)this.recoveredJournalFile().fold(this::state$$anonfun$1, (Function1 & Serializable)_$2 -> _$2.state()));
    }

    public Option<S> recoveredState() {
        return this.recoveredJournalFile().map((Function1 & Serializable)_$3 -> _$3.state());
    }

    public Option<JournalId> journalId() {
        return this.recoveredJournalFile().map((Function1 & Serializable)_$4 -> _$4.journalId());
    }

    public Extract extract() {
        return Recovered$Extract$.MODULE$.apply(this.eventId(), this.eventWatch(), this.totalRunningSince());
    }

    public String toString() {
        return "Recovered(" + this.journalLocation() + "," + this.recoveredJournalFile() + "," + this.eventWatch() + ")";
    }

    private static final long eventId$$anonfun$1() {
        return EventId$.MODULE$.BeforeFirst();
    }

    private final SnapshotableState state$$anonfun$1() {
        return this.S.empty();
    }

    public static final class Extract
    implements Product,
    Serializable {
        private final long eventId;
        private final JournalEventWatch eventWatch;
        private final Deadline totalRunningSince;

        public static Extract apply(long l, JournalEventWatch journalEventWatch, Deadline deadline) {
            return Recovered$Extract$.MODULE$.apply(l, journalEventWatch, deadline);
        }

        public static Extract fromProduct(Product product) {
            return Recovered$Extract$.MODULE$.fromProduct(product);
        }

        public static Extract unapply(Extract extract) {
            return Recovered$Extract$.MODULE$.unapply(extract);
        }

        public Extract(long eventId, JournalEventWatch eventWatch, Deadline totalRunningSince) {
            this.eventId = eventId;
            this.eventWatch = eventWatch;
            this.totalRunningSince = totalRunningSince;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.eventId()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.eventWatch()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.totalRunningSince()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Extract)) return false;
            Extract extract = (Extract)object;
            if (this.eventId() != extract.eventId()) return false;
            JournalEventWatch journalEventWatch = this.eventWatch();
            JournalEventWatch journalEventWatch2 = extract.eventWatch();
            if (journalEventWatch == null) {
                if (journalEventWatch2 != null) {
                    return false;
                }
            } else if (!journalEventWatch.equals(journalEventWatch2)) return false;
            Deadline deadline = this.totalRunningSince();
            Deadline deadline2 = extract.totalRunningSince();
            if (deadline == null) {
                if (deadline2 == null) return true;
                return false;
            } else {
                if (!deadline.equals(deadline2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Extract;
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "eventId";
                }
                case 1: {
                    return "eventWatch";
                }
                case 2: {
                    return "totalRunningSince";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long eventId() {
            return this.eventId;
        }

        public JournalEventWatch eventWatch() {
            return this.eventWatch;
        }

        public Deadline totalRunningSince() {
            return this.totalRunningSince;
        }

        public String productPrefix() {
            return "Recovered.Extract";
        }

        public Extract copy(long eventId, JournalEventWatch eventWatch, Deadline totalRunningSince) {
            return new Extract(eventId, eventWatch, totalRunningSince);
        }

        public long copy$default$1() {
            return this.eventId();
        }

        public JournalEventWatch copy$default$2() {
            return this.eventWatch();
        }

        public Deadline copy$default$3() {
            return this.totalRunningSince();
        }

        public long _1() {
            return this.eventId();
        }

        public JournalEventWatch _2() {
            return this.eventWatch();
        }

        public Deadline _3() {
            return this.totalRunningSince();
        }
    }
}

