/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.write;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.data.ByteArray;
import js7.common.jsonseq.OutputStreamJsonSeqWriter;
import js7.common.jsonseq.OutputStreamJsonSeqWriter$;
import js7.journal.write.FileJsonWriter$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class FileJsonWriter
implements AutoCloseable {
    private final Path file;
    private final boolean append;
    private final Option<FiniteDuration> simulateSync;
    private final FileOutputStream out;
    private final BufferedOutputStream bufferedOut;
    private final OutputStreamJsonSeqWriter writer;
    private final AtomicBoolean closed;
    private boolean flushed;
    private boolean synced;
    private final long initialPosition;

    public static boolean $lessinit$greater$default$2() {
        return FileJsonWriter$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<FiniteDuration> $lessinit$greater$default$3() {
        return FileJsonWriter$.MODULE$.$lessinit$greater$default$3();
    }

    public FileJsonWriter(Path file, boolean append, Option<FiniteDuration> simulateSync) {
        this.file = file;
        this.append = append;
        this.simulateSync = simulateSync;
        this.out = (FileOutputStream)this.wrapException(() -> FileJsonWriter.$init$$$anonfun$1(file, append));
        this.bufferedOut = new BufferedOutputStream(this.out);
        this.writer = new OutputStreamJsonSeqWriter(this.bufferedOut, OutputStreamJsonSeqWriter$.MODULE$.$lessinit$greater$default$2());
        this.closed = new AtomicBoolean();
        this.flushed = false;
        this.synced = false;
        this.initialPosition = Files.size(file);
    }

    public Path file() {
        return this.file;
    }

    @Override
    public void close() {
        this.wrapException((Function0 & Serializable)() -> {
            this.close$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public void write(ByteArray byteArray) {
        this.wrapException((Function0 & Serializable)() -> {
            this.write$$anonfun$1(byteArray);
            return BoxedUnit.UNIT;
        });
    }

    public void sync() {
        this.wrapException((Function0 & Serializable)() -> {
            this.sync$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public void flush() {
        this.wrapException((Function0 & Serializable)() -> {
            this.flush$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public boolean isFlushed() {
        return this.flushed;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public long fileLength() {
        return this.initialPosition + this.bytesWritten();
    }

    public long bytesWritten() {
        return this.writer.bytesWritten();
    }

    public <A> A wrapException(Function0<A> body) {
        Object object;
        try {
            object = body.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable t;
            Option option;
            Throwable throwable3 = throwable;
            if (!(throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty() || (t = (throwable2 = (Throwable)option.get())) != null && t.getMessage() != null && t.getMessage().contains(this.file().toAbsolutePath().toString()))) {
                throw new RuntimeException("Error while writing file '" + this.file() + "': " + t, t);
            }
            throw throwable;
        }
        return (A)object;
    }

    private static final FileOutputStream $init$$$anonfun$1(Path file$1, boolean append$1) {
        return new FileOutputStream(file$1.toFile(), append$1);
    }

    private final void close$$anonfun$1() {
        if (!this.closed.getAndSet(true)) {
            this.flush();
            this.writer.close();
            this.bufferedOut.close();
            this.out.close();
            return;
        }
    }

    private final void write$$anonfun$1(ByteArray byteArray$1) {
        this.flushed = false;
        this.synced = false;
        this.writer.writeJson(byteArray$1);
    }

    private final void sync$$anonfun$1() {
        if (!this.synced) {
            this.flush();
            Option<FiniteDuration> option = this.simulateSync;
            if (option instanceof Some) {
                FiniteDuration duration = (FiniteDuration)((Some)option).value();
                Thread.sleep(duration.toMillis());
            } else if (None$.MODULE$.equals(option)) {
                this.out.getFD().sync();
            } else {
                throw new MatchError(option);
            }
            this.synced = true;
            return;
        }
    }

    private final void flush$$anonfun$1() {
        if (!this.flushed) {
            this.writer.flush();
            this.bufferedOut.flush();
            this.flushed = true;
            this.synced = false;
            return;
        }
    }
}

