/*
 * Decompiled with CFR 0.152.
 */
package js7.launcher;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.MonadCancel;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import js7.base.problem.Problem;
import js7.base.utils.NonFatalInterruptedException;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.utils.SetOnce;
import js7.base.utils.SetOnce$;
import js7.data.job.JobKey;
import js7.data.order.OrderId;
import js7.data.order.OrderOutcome;
import js7.data.order.OrderOutcome$Failed$;
import js7.data.value.Value;
import js7.launcher.OrderProcess$;
import js7.launcher.OrderProcess$Failed$;
import scala.Function0;
import scala.Function1;
import scala.Product;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

public interface OrderProcess {
    public static OrderProcess apply(IO<OrderOutcome.Completed> iO) {
        return OrderProcess$.MODULE$.apply(iO);
    }

    public static FiberCancelable cancelable(IO<OrderOutcome.Completed> iO) {
        return OrderProcess$.MODULE$.cancelable(iO);
    }

    public static OrderProcess checkedOutcome(Either<Problem, OrderOutcome.Completed> either) {
        return OrderProcess$.MODULE$.checkedOutcome(either);
    }

    public static OrderProcess outcome(OrderOutcome.Completed completed) {
        return OrderProcess$.MODULE$.outcome(completed);
    }

    public static OrderProcess problem(Problem problem) {
        return OrderProcess$.MODULE$.problem(problem);
    }

    public static OrderProcess succeeded(Map<String, Value> map) {
        return OrderProcess$.MODULE$.succeeded(map);
    }

    public static Map<String, Value> succeeded$default$1() {
        return OrderProcess$.MODULE$.succeeded$default$1();
    }

    public IO<OrderOutcome.Completed> run();

    public static IO onStarted$(OrderProcess $this, Fiber fiber) {
        return $this.onStarted((Fiber<IO, Throwable, OrderOutcome.Completed>)fiber);
    }

    default public IO<BoxedUnit> onStarted(Fiber<IO, Throwable, OrderOutcome.Completed> fiber) {
        return IO$.MODULE$.unit();
    }

    public IO<BoxedUnit> cancel(boolean var1);

    public static IO start$(OrderProcess $this, OrderId orderId, JobKey jobKey) {
        return $this.start(orderId, jobKey);
    }

    default public IO<Fiber<IO, Throwable, OrderOutcome.Completed>> start(OrderId orderId, JobKey jobKey) {
        return this.run().start().flatMap((Function1 & Serializable)fiber -> this.onStarted((Fiber<IO, Throwable, OrderOutcome.Completed>)fiber).productR((IO)fiber.joinWith((Object)IO$.MODULE$.pure((Object)OrderProcess$.js7$launcher$OrderProcess$$$CanceledOutcome), (MonadCancel)IO$.MODULE$.asyncForIO())).handleError((Function1 & Serializable)t -> {
            Throwable u;
            block2: {
                Throwable throwable;
                Throwable throwable2 = t;
                if (throwable2 instanceof NonFatalInterruptedException) {
                    NonFatalInterruptedException t2 = (NonFatalInterruptedException)throwable2;
                    throwable = t2.getCause();
                } else {
                    throwable = t;
                }
                u = throwable;
                Logger LoggerImpl_this = OrderProcess$.js7$launcher$OrderProcess$$$logger;
                if (!LoggerImpl_this.underlying().isWarnEnabled()) break block2;
                Throwable throwable3 = ScalaUtils$syntax$.MODULE$.RichThrowable(u);
                LoggerImpl_this.underlying().warn(orderId + " in " + jobKey + ": " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable3), u);
            }
            return OrderOutcome$Failed$.MODULE$.fromThrowable(u);
        }).start());
    }

    public static final class Cancelable
    implements OrderProcess,
    FiberCancelable {
        private SetOnce js7$launcher$OrderProcess$FiberCancelable$$fiberOnce;
        private final IO run;

        public Cancelable(IO<OrderOutcome.Completed> run) {
            this.run = run;
            FiberCancelable.$init$(this);
            Statics.releaseFence();
        }

        public SetOnce js7$launcher$OrderProcess$FiberCancelable$$fiberOnce() {
            return this.js7$launcher$OrderProcess$FiberCancelable$$fiberOnce;
        }

        @Override
        public void js7$launcher$OrderProcess$FiberCancelable$_setter_$js7$launcher$OrderProcess$FiberCancelable$$fiberOnce_$eq(SetOnce x$0) {
            this.js7$launcher$OrderProcess$FiberCancelable$$fiberOnce = x$0;
        }

        @Override
        public IO<OrderOutcome.Completed> run() {
            return this.run;
        }

        public String toString() {
            return "OrderProcess.Cancelable";
        }
    }

    public static final class Failed
    implements OrderProcess,
    Product,
    Serializable {
        private final Problem problem;

        public static Failed apply(Problem problem) {
            return OrderProcess$Failed$.MODULE$.apply(problem);
        }

        public static Failed fromProduct(Product product) {
            return OrderProcess$Failed$.MODULE$.fromProduct(product);
        }

        public static Failed unapply(Failed failed) {
            return OrderProcess$Failed$.MODULE$.unapply(failed);
        }

        public Failed(Problem problem) {
            this.problem = problem;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Failed)) return false;
            Failed failed = (Failed)object;
            Problem problem = this.problem();
            Problem problem2 = failed.problem();
            if (problem != null) {
                if (!((Object)problem).equals(problem2)) return false;
                return true;
            }
            if (problem2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Failed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Failed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "problem";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Problem problem() {
            return this.problem;
        }

        @Override
        public IO<OrderOutcome.Completed> run() {
            return IO$.MODULE$.pure((Object)OrderOutcome$Failed$.MODULE$.fromProblem(this.problem(), OrderOutcome$Failed$.MODULE$.fromProblem$default$2()));
        }

        @Override
        public IO<BoxedUnit> cancel(boolean immediately) {
            return IO$.MODULE$.unit();
        }

        public Failed copy(Problem problem) {
            return new Failed(problem);
        }

        public Problem copy$default$1() {
            return this.problem();
        }

        public Problem _1() {
            return this.problem();
        }
    }

    public static interface FiberCancelable
    extends OrderProcess {
        public static void $init$(FiberCancelable $this) {
            $this.js7$launcher$OrderProcess$FiberCancelable$_setter_$js7$launcher$OrderProcess$FiberCancelable$$fiberOnce_$eq(SetOnce$.MODULE$.apply(Tag$.MODULE$.apply(Fiber.class, LightTypeTag$.MODULE$.parse(92522235, "\u0001\u0001\u0001\u0018cats.effect.kernel.Fiber\u0003\u0000\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u000ecats.effect.IO\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0000\u0004\u0000\u0001\u0013java.lang.Throwable\u0001\u0001\u0000\u0000\u0004\u0000\u0001&js7.data.order.OrderOutcome$.Completed\u0001\u0002\u0003\u0000\u0000\u001bjs7.data.order.OrderOutcome\u0001\u0001\u0000\u0001", "\u0000\u0004\u0004\u0000\u0001\u0013java.lang.Throwable\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u000ecats.effect.IO\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0002\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0016cats.effect.IOPlatform\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0000\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0001\u0001\u0018cats.effect.kernel.Fiber\u0003\u0000\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0090\u0004\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0000\u0004\u0000\u0001&js7.data.order.OrderOutcome$.Completed\u0001\u0002\u0003\u0000\u0000\u001bjs7.data.order.OrderOutcome\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0002\u0003\u0000\u0000\u0090\b\u0001\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0002\u0003\u0000\u0000\u0090\b\u0001\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001", 30))));
        }

        public SetOnce<Fiber<IO, Throwable, OrderOutcome.Completed>> js7$launcher$OrderProcess$FiberCancelable$$fiberOnce();

        public void js7$launcher$OrderProcess$FiberCancelable$_setter_$js7$launcher$OrderProcess$FiberCancelable$$fiberOnce_$eq(SetOnce var1);

        public static IO onStarted$(FiberCancelable $this, Fiber fiber) {
            return $this.onStarted((Fiber<IO, Throwable, OrderOutcome.Completed>)fiber);
        }

        @Override
        default public IO<BoxedUnit> onStarted(Fiber<IO, Throwable, OrderOutcome.Completed> fiber) {
            return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.onStarted$$anonfun$1(fiber);
                return BoxedUnit.UNIT;
            });
        }

        public static IO cancel$(FiberCancelable $this, boolean immediately) {
            return $this.cancel(immediately);
        }

        @Override
        default public IO<BoxedUnit> cancel(boolean immediately) {
            return IO$.MODULE$.defer(this::cancel$$anonfun$2);
        }

        private void onStarted$$anonfun$1(Fiber fiber$1) {
            this.js7$launcher$OrderProcess$FiberCancelable$$fiberOnce().$colon$eq((Fiber<IO, Throwable, OrderOutcome.Completed>)fiber$1);
        }

        private IO cancel$$anonfun$2() {
            return (IO)this.js7$launcher$OrderProcess$FiberCancelable$$fiberOnce().orThrow().cancel();
        }
    }

    public static final class Simple
    implements OrderProcess {
        private final IO run;

        public Simple(IO<OrderOutcome.Completed> run) {
            this.run = run;
        }

        @Override
        public IO<OrderOutcome.Completed> run() {
            return this.run;
        }

        @Override
        public IO<BoxedUnit> cancel(boolean immediately) {
            return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.cancel$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        public String toString() {
            return "OrderProcess.Simple";
        }

        private final void cancel$$anonfun$1() {
            Logger LoggerImpl_this = OrderProcess$.js7$launcher$OrderProcess$$$logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("{}: cancel method is not implemented", (Object)this.toString());
                return;
            }
        }
    }
}

