/*
 * Decompiled with CFR 0.152.
 */
package js7.launcher.forwindows;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APIOptions;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import js7.base.log.Logger$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.system.OperatingSystem$;
import js7.launcher.forwindows.WindowsApi;
import js7.launcher.forwindows.WindowsApi$MyAdvapi32$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class WindowsApi$
implements Serializable {
    public static final long OFFSET$_m_4 = LazyVals$.MODULE$.getOffsetStatic(WindowsApi$.class.getDeclaredField("myAdvapi32$lzy1"));
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(WindowsApi$.class.getDeclaredField("myKernel32$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(WindowsApi$.class.getDeclaredField("myUserenv$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(WindowsApi$.class.getDeclaredField("advapi32$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(WindowsApi$.class.getDeclaredField("kernel32$lzy1"));
    private static final Logger logger;
    private static final int MAX_PATH;
    private volatile Object kernel32$lzy1;
    private volatile Object advapi32$lzy1;
    private volatile Object myUserenv$lzy1;
    private volatile Object myKernel32$lzy1;
    private volatile Object myAdvapi32$lzy1;
    public static final WindowsApi$MyAdvapi32$ MyAdvapi32;
    public static final WindowsApi$ MODULE$;

    private WindowsApi$() {
    }

    static {
        MODULE$ = new WindowsApi$();
        logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(WindowsApi$.class));
        MAX_PATH = 260;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(WindowsApi$.class);
    }

    public int MAX_PATH() {
        return MAX_PATH;
    }

    public Kernel32 kernel32() {
        Object object = this.kernel32$lzy1;
        if (object instanceof Kernel32) {
            return (Kernel32)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Kernel32)this.kernel32$lzyINIT1();
    }

    private Object kernel32$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.kernel32$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Kernel32 kernel32 = null;
                    try {
                        kernel32 = (Kernel32)Native.load((String)"kernel32", Kernel32.class, (Map)W32APIOptions.UNICODE_OPTIONS);
                        object2 = kernel32 == null ? LazyVals.NullValue$.MODULE$ : kernel32;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.kernel32$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return kernel32;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Advapi32 advapi32() {
        Object object = this.advapi32$lzy1;
        if (object instanceof Advapi32) {
            return (Advapi32)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Advapi32)this.advapi32$lzyINIT1();
    }

    private Object advapi32$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.advapi32$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Advapi32 advapi32 = null;
                    try {
                        advapi32 = (Advapi32)Native.load((String)"advapi32", Advapi32.class, (Map)W32APIOptions.UNICODE_OPTIONS);
                        object2 = advapi32 == null ? LazyVals.NullValue$.MODULE$ : advapi32;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.advapi32$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return advapi32;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public WindowsApi.MyUserenv myUserenv() {
        Object object = this.myUserenv$lzy1;
        if (object instanceof WindowsApi.MyUserenv) {
            return (WindowsApi.MyUserenv)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (WindowsApi.MyUserenv)this.myUserenv$lzyINIT1();
    }

    private Object myUserenv$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.myUserenv$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    WindowsApi.MyUserenv myUserenv = null;
                    try {
                        myUserenv = (WindowsApi.MyUserenv)Native.load((String)"userenv", WindowsApi.MyUserenv.class, (Map)W32APIOptions.UNICODE_OPTIONS);
                        object2 = myUserenv == null ? LazyVals.NullValue$.MODULE$ : myUserenv;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.myUserenv$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return myUserenv;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public WindowsApi.MyKernel32 myKernel32() {
        Object object = this.myKernel32$lzy1;
        if (object instanceof WindowsApi.MyKernel32) {
            return (WindowsApi.MyKernel32)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (WindowsApi.MyKernel32)this.myKernel32$lzyINIT1();
    }

    private Object myKernel32$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.myKernel32$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    WindowsApi.MyKernel32 myKernel32 = null;
                    try {
                        myKernel32 = (WindowsApi.MyKernel32)Native.load((String)"kernel32", WindowsApi.MyKernel32.class, (Map)W32APIOptions.UNICODE_OPTIONS);
                        object2 = myKernel32 == null ? LazyVals.NullValue$.MODULE$ : myKernel32;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.myKernel32$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return myKernel32;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public WindowsApi.MyAdvapi32 myAdvapi32() {
        Object object = this.myAdvapi32$lzy1;
        if (object instanceof WindowsApi.MyAdvapi32) {
            return (WindowsApi.MyAdvapi32)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (WindowsApi.MyAdvapi32)this.myAdvapi32$lzyINIT1();
    }

    private Object myAdvapi32$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.myAdvapi32$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    WindowsApi.MyAdvapi32 myAdvapi32 = null;
                    try {
                        myAdvapi32 = (WindowsApi.MyAdvapi32)Native.load((String)"advapi32", WindowsApi.MyAdvapi32.class, (Map)W32APIOptions.UNICODE_OPTIONS);
                        object2 = myAdvapi32 == null ? LazyVals.NullValue$.MODULE$ : myAdvapi32;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.myAdvapi32$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return myAdvapi32;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean waitForSingleObject(WinNT.HANDLE handle, int timeout) {
        if (timeout == 0) {
            return this.waitForSingleObject_(handle, 0);
        }
        return BoxesRunTime.unboxToBoolean((Object)scala.concurrent.package$.MODULE$.blocking(() -> WindowsApi$.waitForSingleObject$$anonfun$1(handle, timeout)));
    }

    public boolean dontWaitForSingleObject(WinNT.HANDLE handle) {
        return this.waitForSingleObject_(handle, 0);
    }

    private boolean waitForSingleObject_(WinNT.HANDLE handle, int timeout) {
        this.requireWindows("WaitForSingleObject");
        int n = this.kernel32().WaitForSingleObject(handle, timeout);
        switch (n) {
            case 0: {
                return true;
            }
            case 258: {
                return false;
            }
            case -1: {
                throw this.throwLastError("WaitForSingleObject");
            }
        }
        int o = n;
        throw new WindowsApi.WindowsException("WaitForSingleObject returned " + o);
    }

    public int processHandleCount() {
        IntByReference ref = new IntByReference();
        this.call("GetProcessHandleCount", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]), (Function0<Object>)((Function0 & Serializable)() -> WindowsApi$.processHandleCount$$anonfun$1(ref)));
        return ref.getValue();
    }

    public Path tempPath() {
        this.requireWindows("GetTempPath");
        char[] a = new char[this.MAX_PATH() + 1];
        int length = this.kernel32().GetTempPath(new WinDef.DWORD(Int$.MODULE$.int2long(a.length)), a).intValue();
        if (length <= 0 || length > a.length) {
            throw new WindowsApi.WindowsException("GetTempPath failed");
        }
        return Paths.get(new String(a, 0, length), new String[0]);
    }

    public Path windowsDirectory() {
        char[] a = new char[this.MAX_PATH() + 1];
        int length = this.myKernel32().GetSystemWindowsDirectory(a, a.length);
        if (length <= 0 || length > a.length) {
            throw new WindowsApi.WindowsException("GetSystemWindowsDirectory failed");
        }
        return Paths.get(new String(a, 0, length), new String[0]);
    }

    public WinNT.HANDLE openProcessToken(WinNT.HANDLE process, int desiredAccess) {
        return this.handleCall("OpenProcessToken", (Function1<WinNT.HANDLEByReference, Object>)(Function1 & Serializable)_$1 -> MODULE$.myAdvapi32().OpenProcessToken(process, desiredAccess, (WinNT.HANDLEByReference)_$1));
    }

    public scala.collection.immutable.Map<String, String> usersEnvironment(WinNT.HANDLE userToken) {
        Vector vector;
        PointerByReference ref = new PointerByReference();
        this.call("CreateEnvironmentBlock", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]), (Function0<Object>)((Function0 & Serializable)() -> WindowsApi$.$anonfun$1(ref, userToken)));
        Pointer handle = ref.getValue();
        try {
            ReusableBuilder builder = package$.MODULE$.Vector().newBuilder();
            this.continue$1(handle, builder, 0);
            vector = (Vector)builder.result();
        }
        finally {
            this.call("DestroyEnvironmentBlock", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]), (Function0<Object>)((Function0 & Serializable)() -> WindowsApi$.$anonfun$2(handle)));
        }
        Vector strings = vector;
        return ((IterableOnceOps)strings.map((Function1 & Serializable)o -> {
            int n = o.indexOf(61);
            if (-1 == n) {
                String string = (String)Predef$.MODULE$.ArrowAssoc(o);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"");
            }
            int i = n;
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)o.substring(0, i));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)o.substring(i + 1));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public WinNT.HANDLE handleCall(String name, Function1<WinNT.HANDLEByReference, Object> apiFunction) {
        WinNT.HANDLEByReference ref = new WinNT.HANDLEByReference();
        this.call(name, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]), (Function0<Object>)((Function0 & Serializable)() -> WindowsApi$.handleCall$$anonfun$1(apiFunction, ref)));
        return ref.getValue();
    }

    public void call(String functionName, Seq<String> args, Function0<Object> apiFunction) {
        boolean ok;
        this.requireWindows(functionName);
        Logger LoggerImpl_this = logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("Calling Windows API: {} {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{functionName, args.mkString(", ")}), Object.class));
        }
        if (!(ok = apiFunction.apply$mcZ$sp())) {
            throw this.throwLastError(functionName);
        }
    }

    public Nothing$ throwLastError(String function) {
        throw new WindowsApi.WindowsException(this.getLastErrorAsProblem(function).toString());
    }

    public Problem getLastErrorAsProblem(String function) {
        this.requireWindows("GetLastError");
        int err = this.kernel32().GetLastError();
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> WindowsApi$.getLastErrorAsProblem$$anonfun$1(err, function)), Problem$.MODULE$.apply$default$2());
    }

    public String messageIdToString(int id) {
        if (id <= -1056964609) {
            return StringOps$.MODULE$.format$extension("0x%08x", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)}));
        }
        return BoxesRunTime.boxToInteger((int)id).toString();
    }

    private void requireWindows(String functionName) {
        if (!OperatingSystem$.MODULE$.isWindows()) {
            throw scala.sys.package$.MODULE$.error("Windows API '" + functionName + "' is only available under Microsoft Windows");
        }
    }

    private static final boolean waitForSingleObject$$anonfun$1(WinNT.HANDLE handle$1, int timeout$1) {
        return MODULE$.waitForSingleObject_(handle$1, timeout$1);
    }

    private static final boolean processHandleCount$$anonfun$1(IntByReference ref$1) {
        return MODULE$.myKernel32().GetProcessHandleCount(MODULE$.kernel32().GetCurrentProcess(), ref$1);
    }

    private static final boolean $anonfun$1(PointerByReference ref$2, WinNT.HANDLE userToken$1) {
        return MODULE$.myUserenv().CreateEnvironmentBlock(ref$2, userToken$1, false);
    }

    private final void continue$1(Pointer handle$2, ReusableBuilder builder$1, int offset) {
        String string;
        while (!"".equals(string = handle$2.getWideString(Int$.MODULE$.int2long(offset)))) {
            String string2 = string;
            builder$1.$plus$eq((Object)string2);
            offset += 2 * (string2.length() + 1);
        }
        return;
    }

    private static final boolean $anonfun$2(Pointer handle$3) {
        return MODULE$.myUserenv().DestroyEnvironmentBlock(handle$3);
    }

    private static final boolean handleCall$$anonfun$1(Function1 apiFunction$1, WinNT.HANDLEByReference ref$3) {
        return BoxesRunTime.unboxToBoolean((Object)apiFunction$1.apply((Object)ref$3));
    }

    private static final String getLastErrorAsProblem$$anonfun$1(int err$1, String function$1) {
        return StringOps$.MODULE$.format$extension("WINDOWS-%s (%s) %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{MODULE$.messageIdToString(err$1), function$1, Kernel32Util.formatMessageFromLastErrorCode((int)err$1)}));
    }
}

