/*
 * Decompiled with CFR 0.152.
 */
package js7.launcher.forwindows;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import js7.base.generic.SecretString;
import js7.base.generic.SecretString$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.system.OperatingSystem$;
import js7.launcher.forwindows.CREDENTIAL;
import js7.launcher.forwindows.WindowsApi$;
import js7.launcher.forwindows.WindowsApi$MyAdvapi32$;
import js7.launcher.forwindows.WindowsProcessCredential;
import js7.launcher.forwindows.WindowsUserName;
import js7.launcher.forwindows.WindowsUserName$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class WindowsProcessCredential$
implements Mirror.Product,
Serializable {
    public static final WindowsProcessCredential$ MODULE$ = new WindowsProcessCredential$();

    private WindowsProcessCredential$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(WindowsProcessCredential$.class);
    }

    public WindowsProcessCredential apply(WindowsUserName userName, SecretString password) {
        return new WindowsProcessCredential(userName, password);
    }

    public WindowsProcessCredential unapply(WindowsProcessCredential x$1) {
        return x$1;
    }

    public Either<Problem, WindowsProcessCredential> byKey(String key) {
        return this.readCredential(key, (Function1 & Serializable)cred -> {
            byte[] passwordBytes = cred.credentialBlob.getByteArray(0L, cred.credentialBlobSize);
            SecretString password = SecretString$.MODULE$.apply(new String(passwordBytes, StandardCharsets.UTF_16LE));
            Arrays.fill(passwordBytes, (byte)0);
            return MODULE$.apply(MODULE$.toUser((CREDENTIAL)((Object)cred)), password);
        });
    }

    public Either<Problem, WindowsUserName> keyToUser(String key) {
        return this.readCredential(key, (Function1 & Serializable)cred -> MODULE$.toUser((CREDENTIAL)((Object)cred)));
    }

    private WindowsUserName toUser(CREDENTIAL cred) {
        return WindowsUserName$.MODULE$.apply(cred.userName.toString());
    }

    private <A> Either<Problem, A> readCredential(String key, Function1<CREDENTIAL, A> read) {
        Right right;
        if (!OperatingSystem$.MODULE$.isWindows()) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("Windows credential can only be read under Microsoft Windows"));
        }
        try {
            PointerByReference ref = new PointerByReference();
            WindowsApi$.MODULE$.call("CredRead", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]), (Function0<Object>)((Function0 & Serializable)() -> WindowsProcessCredential$.readCredential$$anonfun$1(key, ref)));
            try {
                CREDENTIAL credential = (CREDENTIAL)Structure.newInstance(CREDENTIAL.class, (Pointer)ref.getValue());
                credential.read();
                Object result = read.apply((Object)credential);
                credential.clear();
                right = package$.MODULE$.Right().apply(result);
            }
            finally {
                WindowsApi$.MODULE$.myAdvapi32().CredFree(ref.getValue());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3;
            Option option;
            Throwable throwable4 = throwable;
            if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty() && (throwable3 = (throwable2 = (Throwable)option.get())) instanceof Exception) {
                Exception e = (Exception)throwable3;
                right = package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("Windows Credential Manager does not return an entry named '" + key + "': " + e.getMessage()));
            }
            throw throwable;
        }
        return right;
    }

    public WindowsProcessCredential fromProduct(Product x$0) {
        return new WindowsProcessCredential((WindowsUserName)x$0.productElement(0), (SecretString)x$0.productElement(1));
    }

    private static final boolean readCredential$$anonfun$1(String key$1, PointerByReference ref$1) {
        return WindowsApi$.MODULE$.myAdvapi32().CredRead(key$1, WindowsApi$MyAdvapi32$.MODULE$.CRED_TYPE_GENERIC(), 0, ref$1);
    }
}

