/*
 * Decompiled with CFR 0.152.
 */
package js7.service.pgp;

import cats.Applicative;
import cats.Foldable;
import cats.Invariant$;
import cats.Show;
import cats.Show$;
import cats.UnorderedFoldable$;
import cats.effect.SyncIO;
import cats.effect.kernel.Resource;
import cats.instances.package;
import cats.syntax.FoldableOps$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.data.ByteSequence$ops$;
import js7.base.log.Logger$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.JavaTime$;
import js7.base.utils.Labeled;
import js7.base.utils.SyncResource$syntax$;
import js7.base.utils.SyncResource$syntax$RichSyncResource$;
import js7.service.pgp.PgpCommons$RichPGPPublicKey$;
import js7.service.pgp.PgpCommons$RichPGPPublicKeyRingCollection$;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.examples.PubringDump;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class PgpCommons$
implements Serializable {
    private static final Logger logger;
    private static final int BufferSize;
    private static final Show PGPPublicKeyShow;
    private static final Show PGPPublicKeyRingShow;
    private static final Show PGPPublicKeyRingCollectionShow;
    private static final Show PGPSecretKeyShow;
    private static final Show PGPSecretKeyRingShow;
    private static final Show PGPSecretKeyRingCollectionShow;
    private static final Show PGPSignatureShow;
    public static final PgpCommons$RichPGPPublicKey$ RichPGPPublicKey;
    public static final PgpCommons$RichPGPPublicKeyRingCollection$ RichPGPPublicKeyRingCollection;
    public static final PgpCommons$ MODULE$;

    private PgpCommons$() {
    }

    static {
        MODULE$ = new PgpCommons$();
        logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(PgpCommons$.class));
        Security.addProvider((Provider)new BouncyCastleProvider());
        BufferSize = 4096;
        PGPPublicKeyShow = Show$.MODULE$.apply((Show & Serializable)key -> StringOps$.MODULE$.format$extension("PGPPublicKey(%08X", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)key.getKeyID())})) + " userIDs=" + CollectionConverters$.MODULE$.IteratorHasAsScala(key.getUserIDs()).asScala().mkString("'", "', '", "'") + " fingerprint=" + this.fingerPrintAsString((PGPPublicKey)key) + " created=" + package.show$.MODULE$.toShow((Object)key.getCreationTime(), JavaTime$.MODULE$.JavaUtilDateShow()).show() + " algorithm=" + this.publicKeyAlgorithmToString(key.getAlgorithm()) + " isEncryptionKey=" + key.isEncryptionKey() + " isMasterKey=" + key.isMasterKey() + ")");
        PGPPublicKeyRingShow = Show$.MODULE$.apply((Show & Serializable)_$2 -> {
            Vector vector = (Vector)package.foldable$.MODULE$.catsSyntaxFoldOps((Object)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)_$2).asScala().toVector());
            return FoldableOps$.MODULE$.mkString_$extension((Object)vector, "PGPPublicKeyRing(", ", ", ")", this.PGPPublicKeyShow(), (Foldable)package.vector$.MODULE$.catsStdInstancesForVector());
        });
        PGPPublicKeyRingCollectionShow = Show$.MODULE$.apply((Show & Serializable)_$3 -> {
            Vector vector = (Vector)package.foldable$.MODULE$.catsSyntaxFoldOps((Object)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)_$3).asScala().toVector());
            return FoldableOps$.MODULE$.mkString_$extension((Object)vector, "", ", ", "", this.PGPPublicKeyRingShow(), (Foldable)package.vector$.MODULE$.catsStdInstancesForVector());
        });
        PGPSecretKeyShow = Show$.MODULE$.apply((Show & Serializable)key -> "PGPSecretKey(" + package.show$.MODULE$.toShow((Object)key.getPublicKey(), this.PGPPublicKeyShow()).show() + " cipher=" + this.cipherToString(key.getKeyEncryptionAlgorithm()) + " isSigningKey=" + key.isSigningKey() + " isMasterKey=" + key.isMasterKey() + ")");
        PGPSecretKeyRingShow = Show$.MODULE$.apply((Show & Serializable)o -> "PGPSecretKeyRing(" + package.show$.MODULE$.toShow((Object)o.getPublicKey(), this.PGPPublicKeyShow()).show() + ")");
        PGPSecretKeyRingCollectionShow = Show$.MODULE$.apply((Show & Serializable)o -> {
            Object[] objectArray = new Object[1];
            Vector vector = (Vector)package.foldable$.MODULE$.catsSyntaxFoldOps((Object)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)o).asScala().toVector());
            objectArray[0] = FoldableOps$.MODULE$.mkString_$extension((Object)vector, "", ", ", "", this.PGPSecretKeyRingShow(), (Foldable)package.vector$.MODULE$.catsStdInstancesForVector());
            return StringOps$.MODULE$.format$extension("PGPSecretKeyRingCollection(%s)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
        });
        PGPSignatureShow = Show$.MODULE$.apply((Show & Serializable)sig -> "PGPSignature(" + this.signatureTypeToString(sig.getSignatureType()) + ", created=" + package.show$.MODULE$.toShow((Object)sig.getCreationTime(), JavaTime$.MODULE$.JavaUtilDateShow()).show() + " hash=" + this.hashAlgorithmToString(sig.getHashAlgorithm()) + StringOps$.MODULE$.format$extension(" publicKeyID=%08X", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)sig.getKeyID())})) + ")");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PgpCommons$.class);
    }

    public String pgpPublicKeyToShortString(PGPPublicKey key) {
        return "PGPPublicKey userIDs=" + CollectionConverters$.MODULE$.IteratorHasAsScala(key.getUserIDs()).asScala().mkString("'", "', '", "'") + " fingerprint=" + this.fingerPrintAsString(key);
    }

    public Show<PGPPublicKey> PGPPublicKeyShow() {
        return PGPPublicKeyShow;
    }

    private String fingerPrintAsString(PGPPublicKey key) {
        return ByteSequence$ops$.MODULE$.toAllByteSequenceOps(Option$.MODULE$.apply((Object)key.getFingerprint()).fold(PgpCommons$::fingerPrintAsString$$anonfun$1, (Function1 & Serializable)_$1 -> (ByteArray)ByteArray$.MODULE$.apply((byte[])_$1)), ByteArray$.MODULE$.implicitByteSequence()).toHexRaw();
    }

    public Show<PGPPublicKeyRing> PGPPublicKeyRingShow() {
        return PGPPublicKeyRingShow;
    }

    public Show<PGPPublicKeyRingCollection> PGPPublicKeyRingCollectionShow() {
        return PGPPublicKeyRingCollectionShow;
    }

    public Show<PGPSecretKey> PGPSecretKeyShow() {
        return PGPSecretKeyShow;
    }

    public Show<PGPSecretKeyRing> PGPSecretKeyRingShow() {
        return PGPSecretKeyRingShow;
    }

    public Show<PGPSecretKeyRingCollection> PGPSecretKeyRingCollectionShow() {
        return PGPSecretKeyRingCollectionShow;
    }

    public Show<PGPSignature> PGPSignatureShow() {
        return PGPSignatureShow;
    }

    private String signatureTypeToString(int t) {
        int n = t;
        switch (n) {
            case 0: {
                return "binary document";
            }
            case 1: {
                return "canonical text document";
            }
            case 2: {
                return "stand alone";
            }
            case 16: {
                return "default certification";
            }
            case 17: {
                return "no certification";
            }
            case 18: {
                return "casual certification";
            }
            case 19: {
                return "positive certification";
            }
            case 24: {
                return "subkey binding";
            }
            case 25: {
                return "primarykey binding";
            }
            case 31: {
                return "direct key";
            }
            case 32: {
                return "key revocation";
            }
            case 40: {
                return "subkey revocation";
            }
            case 48: {
                return "certification revocation";
            }
            case 64: {
                return "timestamp";
            }
        }
        return BoxesRunTime.boxToInteger((int)t).toString();
    }

    private String hashAlgorithmToString(int hashAlgorithm) {
        int n = hashAlgorithm;
        switch (n) {
            case 2: {
                return "SHA-1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA-256";
            }
            case 9: {
                return "SHA-384";
            }
            case 10: {
                return "SHA-512";
            }
            case 11: {
                return "SHA-224";
            }
            case 6: {
                return "TIGER";
            }
        }
        return BoxesRunTime.boxToInteger((int)hashAlgorithm).toString();
    }

    private String publicKeyAlgorithmToString(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 1: {
                return "'RSA general'";
            }
            case 2: {
                return "'RSA encrypt'";
            }
            case 3: {
                return "'RSA sign'";
            }
            case 16: {
                return "'El Gamal encrypt'";
            }
            case 20: {
                return "'El Gamal general'";
            }
            case 21: {
                return "Diffie-Hellman";
            }
        }
        try {
            string = PubringDump.getAlgorithm((int)n);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                string = BoxesRunTime.boxToInteger((int)n).toString();
            }
            throw throwable;
        }
        return string;
    }

    private String cipherToString(int n) {
        Object object;
        try {
            object = PGPUtil.getSymmetricCipherName((int)n);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                object = "cipher-" + n;
            }
            throw throwable;
        }
        return object;
    }

    public void registerBouncyCastle() {
    }

    private void readMessage(Resource<SyncIO, InputStream> message, Function2<byte[], Object, BoxedUnit> update) {
        Resource resource = SyncResource$syntax$.MODULE$.RichSyncResource(message);
        SyncResource$syntax$RichSyncResource$.MODULE$.useSync$extension(resource, (JProcedure1 & Serializable)in -> {
            byte[] buffer = new byte[BufferSize];
            int length = 1;
            while (length > 0) {
                length = in.read(buffer);
                if (length <= 0) continue;
                update.apply((Object)buffer, (Object)BoxesRunTime.boxToInteger((int)length));
            }
        }, Tag$.MODULE$.apply(InputStream.class, LightTypeTag$.MODULE$.parse(-509388435, "\u0004\u0000\u0001\u0013java.io.InputStream\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\u0011java.io.Closeable\u0001\u0001\u0001\u0004\u0000\u0001\u0017java.lang.AutoCloseable\u0001\u0001\u0004\u0000\u0001\u0013java.io.InputStream\u0001\u0001\u0002\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30)));
    }

    public void writeSecretKeyAsAscii(PGPSecretKey secretKey, OutputStream out) {
        ArmoredOutputStream armored = new ArmoredOutputStream(out);
        new PGPSecretKeyRing(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)secretKey, (List)Nil$.MODULE$)).asJava()).encode((OutputStream)armored);
        armored.close();
    }

    public void writePublicKeyAsAscii(PGPPublicKey publicKey, OutputStream out) {
        ArmoredOutputStream armored = new ArmoredOutputStream(out);
        publicKey.encode((OutputStream)armored);
        armored.close();
    }

    public void writePublicKeyRingCollectionAsAscii(PGPPublicKeyRingCollection publicKey, OutputStream out) {
        ArmoredOutputStream armored = new ArmoredOutputStream(out);
        publicKey.encode((OutputStream)armored);
        armored.close();
    }

    public Either<Problem, PGPPublicKeyRingCollection> readPublicKeyRingCollection(scala.collection.immutable.Seq<Labeled<ByteArray>> keys) {
        return ((Either)package.traverse$.MODULE$.toTraverseOps(keys, UnorderedFoldable$.MODULE$.catsTraverseForSeq()).traverse((Function1 & Serializable)labeledKey -> MODULE$.toPGPPublicKeyRing((Labeled<ByteArray>)labeledKey), (Applicative)Invariant$.MODULE$.catsMonadErrorForEither())).map((Function1 & Serializable)keyRings -> new PGPPublicKeyRingCollection((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)keyRings).asJava()));
    }

    public PGPPublicKeyRingCollection readOrIgnorePublicKeyRingCollection(scala.collection.immutable.Seq<Labeled<ByteArray>> keys) {
        return new PGPPublicKeyRingCollection((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)keys.flatMap((Function1 & Serializable)key -> {
            Either<Problem, PGPPublicKeyRing> either = MODULE$.toPGPPublicKeyRing((Labeled<ByteArray>)key);
            if (either instanceof Left) {
                Problem problem = (Problem)((Left)either).value();
                Logger LoggerImpl_this = logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    LoggerImpl_this.underlying().error("Ignoring PGP public key due to: {}", (Object)problem);
                }
                return None$.MODULE$;
            }
            if (either instanceof Right) {
                PGPPublicKeyRing o = (PGPPublicKeyRing)((Right)either).value();
                return Some$.MODULE$.apply((Object)o);
            }
            throw new MatchError(either);
        })).asJava());
    }

    private Either<Problem, PGPPublicKeyRing> toPGPPublicKeyRing(Labeled<ByteArray> labeledKey) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)new PGPPublicKeyRing(PGPUtil.getDecoderStream((InputStream)labeledKey.value().toInputStream()), this.newFingerPrintCalculator()));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                right = package$.MODULE$.Left().apply((Object)Problem$.MODULE$.fromThrowable(t).withKey(labeledKey.label()));
            }
            throw throwable;
        }
        return right;
    }

    public KeyFingerPrintCalculator newFingerPrintCalculator() {
        return new JcaKeyFingerprintCalculator();
    }

    public PGPPublicKeyRingCollection toPublicKeyRingCollection(PGPPublicKey publicKey) {
        PGPPublicKeyRing ring = new PGPPublicKeyRing(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Nil().$colon$colon((Object)publicKey)).asJava());
        return new PGPPublicKeyRingCollection((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Nil().$colon$colon((Object)ring)).asJava());
    }

    public final PGPPublicKey RichPGPPublicKey(PGPPublicKey underlying) {
        return underlying;
    }

    public final PGPPublicKeyRingCollection RichPGPPublicKeyRingCollection(PGPPublicKeyRingCollection underlying) {
        return underlying;
    }

    private static final ByteArray fingerPrintAsString$$anonfun$1() {
        return ByteArray$.MODULE$.empty();
    }
}

