/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient;

import com.sos.commons.exception.SOSException;
import com.sos.commons.exception.SOSMissingDataException;
import com.sos.commons.httpclient.SOSRestClient;
import com.sos.commons.httpclient.exception.SOSBadRequestException;
import com.sos.commons.httpclient.exception.SOSConnectionRefusedException;
import com.sos.commons.httpclient.exception.SOSConnectionResetException;
import com.sos.commons.httpclient.exception.SOSNoResponseException;
import com.sos.commons.httpclient.exception.SOSSSLException;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class SOSRestApiClient {
    private static final String KEYSTORE_TYPE_DEFAULT = "PKCS12";
    private String accept = "application/json";
    private String basicAuthorization = null;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private List<String> origResponseHeaders = new ArrayList<String>();
    private List<String> cookies = new ArrayList<String>();
    private RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
    private CredentialsProvider credentialsProvider = null;
    private HostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
    private HttpResponse httpResponse;
    private HttpRequestRetryHandler httpRequestRetryHandler;
    private CloseableHttpClient httpClient = null;
    private boolean forcedClosingHttpClient = false;
    private boolean autoCloseHttpClient = true;
    private String keystorePath = null;
    private String keystorePass = null;
    private String keyStoreAlias = null;
    private String keystoreType = null;
    private String keyPass = null;
    private KeyStore clientCertificate = null;
    private char[] clientCertificatePass = null;
    private String clientCertificateAlias = null;
    private KeyStore truststore = null;
    private SSLContext sslContext = null;

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public void setBasicAuthorization(String basicAuthorization) {
        this.basicAuthorization = basicAuthorization;
    }

    public String getBasicAuthorization() {
        return this.basicAuthorization;
    }

    public int statusCode() {
        if (this.httpResponse.getStatusLine() != null) {
            return this.httpResponse.getStatusLine().getStatusCode();
        }
        return -1;
    }

    public String printStatusLine() {
        StatusLine s = this.httpResponse.getStatusLine();
        if (s != null) {
            return String.format("%s %d %s", s.getProtocolVersion(), s.getStatusCode(), s.getReasonPhrase());
        }
        return "statusline n/a";
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public String getResponseHeader(String key) {
        if (this.responseHeaders != null && key != null) {
            return this.responseHeaders.get(key.toLowerCase());
        }
        return null;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.requestConfigBuilder.setConnectTimeout(connectionTimeout);
    }

    public void setConnectionRequestTimeout(int connectionTimeout) {
        this.requestConfigBuilder.setConnectionRequestTimeout(connectionTimeout);
    }

    public void setSocketTimeout(int socketTimeout) {
        this.requestConfigBuilder.setSocketTimeout(socketTimeout);
    }

    public void setAllowAllHostnameVerifier(boolean flag) {
        this.hostnameVerifier = flag ? NoopHostnameVerifier.INSTANCE : null;
    }

    public void setHttpRequestRetryHandler(HttpRequestRetryHandler handler) {
        this.httpRequestRetryHandler = handler;
    }

    public void setProxy(String proxyHost, Integer proxyPort) {
        this.setProxy(proxyHost, proxyPort, null, null);
    }

    public void setProxy(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword) {
        this.requestConfigBuilder.setProxy(new HttpHost(proxyHost, proxyPort.intValue()));
        if (proxyUser != null && !proxyUser.isEmpty()) {
            this.credentialsProvider = new BasicCredentialsProvider();
            this.credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort.intValue()), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
        }
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    private Path getKeystorePath() throws SOSMissingDataException {
        String kStorePath = this.keystorePath;
        if (kStorePath == null) {
            kStorePath = System.getProperty("javax.net.ssl.keyStore");
        }
        if (kStorePath == null) {
            throw new SOSMissingDataException("The keystore path is missing.");
        }
        return Paths.get(kStorePath, new String[0]);
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    private char[] getKeystorePass() {
        String kStorePass = this.keystorePass;
        if (kStorePass == null) {
            kStorePass = System.getProperty("javax.net.ssl.keyStorePassword");
        }
        if (kStorePass != null) {
            return kStorePass.toCharArray();
        }
        return "".toCharArray();
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    private String getKeystoreType() {
        String kStoreType = this.keystoreType;
        if (kStoreType == null) {
            kStoreType = System.getProperty("javax.net.ssl.keyStoreType");
        }
        if (kStoreType == null) {
            kStoreType = KEYSTORE_TYPE_DEFAULT;
        }
        return kStoreType;
    }

    public void setKeyStoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
    }

    private String getKeyStoreAlias() {
        String kAlias = this.keyStoreAlias;
        if (kAlias == null) {
            kAlias = System.getProperty("javax.net.ssl.keyStoreAlias");
        }
        return kAlias;
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass;
    }

    private char[] getKeyPass() {
        String kPass = this.keyPass;
        if (kPass == null) {
            kPass = System.getProperty("javax.net.ssl.keyPassword");
        }
        if (kPass != null) {
            return kPass.toCharArray();
        }
        return "".toCharArray();
    }

    public void createHttpClient() {
        this.createHttpClient(this.getDefaultHttpClientBuilder());
    }

    public void createHttpClient(HttpClientBuilder builder) {
        if (this.httpClient == null) {
            if (builder == null) {
                builder = this.getDefaultHttpClientBuilder();
            }
            this.httpClient = builder.setDefaultRequestConfig(this.requestConfigBuilder.build()).build();
        }
    }

    public HttpClientBuilder getDefaultHttpClientBuilder() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.httpRequestRetryHandler != null) {
            builder.setRetryHandler(this.httpRequestRetryHandler);
        } else {
            builder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        }
        if (this.credentialsProvider != null) {
            builder.setDefaultCredentialsProvider(this.credentialsProvider);
        }
        if (this.sslContext != null) {
            builder.setSSLContext(this.sslContext);
        }
        if (this.hostnameVerifier != null) {
            builder.setSSLHostnameVerifier(this.hostnameVerifier);
        }
        return builder;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void closeHttpClient() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.httpClient = null;
        }
    }

    public void forcedClosingHttpClient() {
        try {
            if (this.httpClient != null) {
                this.forcedClosingHttpClient = true;
                this.httpClient.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.httpClient = null;
        }
    }

    public boolean isForcedClosingHttpClient() {
        return this.forcedClosingHttpClient;
    }

    public boolean isAutoCloseHttpClient() {
        return this.autoCloseHttpClient;
    }

    public void setAutoCloseHttpClient(boolean autoCloseHttpClient) {
        this.autoCloseHttpClient = autoCloseHttpClient;
    }

    public void setSSLContext() throws SOSSSLException {
        if (this.clientCertificate != null || this.truststore != null) {
            try {
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                if (this.clientCertificate != null) {
                    if (this.clientCertificateAlias != null && !this.clientCertificateAlias.isEmpty()) {
                        sslContextBuilder.loadKeyMaterial(this.clientCertificate, this.clientCertificatePass, (aliases, socket) -> this.clientCertificateAlias);
                    } else {
                        sslContextBuilder.loadKeyMaterial(this.clientCertificate, this.clientCertificatePass);
                    }
                }
                if (this.truststore != null) {
                    sslContextBuilder.loadTrustMaterial(this.truststore, null);
                }
                this.sslContext = sslContextBuilder.build();
            }
            catch (GeneralSecurityException e) {
                throw new SOSSSLException(e);
            }
        }
    }

    public void setSSLContext(KeyStore clientCertificate, char[] clientCertificatePass, KeyStore truststore) throws SOSSSLException {
        this.setSSLContext(clientCertificate, clientCertificatePass, null, truststore);
    }

    public void setSSLContext(KeyStore clientCertificate, char[] clientCertificatePass, String clientCertificateAlias, KeyStore truststore) throws SOSSSLException {
        if (clientCertificate != null) {
            this.setClientCertificate(clientCertificate, clientCertificatePass, clientCertificateAlias);
        }
        this.setTruststore(truststore);
        this.setSSLContext();
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public String executeRestServiceCommand(String restCommand, String urlParam) throws SOSException, SocketException {
        URI url;
        String s = ((String)urlParam).replaceFirst("^([^:]*)://.*$", "$1");
        if (s.equals(urlParam)) {
            urlParam = "http://" + (String)urlParam;
        }
        try {
            url = URI.create((String)urlParam);
        }
        catch (Exception e) {
            throw new SOSException((Throwable)e);
        }
        return this.executeRestServiceCommand(restCommand, url);
    }

    public String executeRestServiceCommand(String restCommand, URI uri) throws SOSException, SocketException {
        return this.executeRestServiceCommand(restCommand, uri, null);
    }

    public String executeRestService(String urlParam) throws SOSException, SocketException {
        return this.executeRestServiceCommand("get", urlParam);
    }

    public String executeRestServiceCommand(String restCommand, URI uri, String body) throws SOSException, SocketException {
        String result = "";
        if (body == null) {
            body = SOSRestClient.getParameter(restCommand);
        }
        if (restCommand.toLowerCase().startsWith("post")) {
            result = this.postRestService(uri, body);
        } else if ("get".equalsIgnoreCase(restCommand)) {
            result = this.getRestService(uri);
        } else if ("delete".equalsIgnoreCase(restCommand)) {
            result = this.deleteRestService(uri);
        } else if (restCommand.toLowerCase().startsWith("put")) {
            result = this.putRestService(uri, body);
        } else {
            throw new SOSException(String.format("Unknown rest command method: %s (usage: get|post(body)|delete|put(body))", restCommand));
        }
        return result;
    }

    public <B> String executeRestService(HttpMethod method, URI uri, B body) throws SocketException, SOSException {
        return this.executeRestService(method, uri, body, String.class);
    }

    public <T, B> T executeRestService(HttpMethod method, URI uri, B body, Class<T> clazz) throws SocketException, SOSException {
        switch (method) {
            case GET: {
                return this.getRestService(uri, clazz);
            }
            case POST: {
                return this.postRestService(uri, body, clazz);
            }
            case PUT: {
                return this.putRestService(uri, body, clazz);
            }
            case DELETE: {
                return this.deleteRestService(uri, clazz);
            }
        }
        return null;
    }

    public void addHeader(String header, String value) {
        this.headers.put(header, value);
    }

    public void addCookieHeader() {
        this.addCookieHeader(this.cookies);
    }

    public void addCookieHeader(List<String> _cookies) {
        if (_cookies != null & !_cookies.isEmpty()) {
            this.headers.put("Cookie", String.join((CharSequence)"; ", _cookies));
        }
    }

    public String deleteRestService(HttpHost target, String path) throws SOSException, SocketException {
        return this.getResponse(target, (HttpRequest)new HttpDelete(path), String.class);
    }

    public String deleteRestService(URI uri) throws SOSException, SocketException {
        return this.getResponse((HttpUriRequest)new HttpDelete(uri), String.class);
    }

    public <T> T deleteRestService(URI uri, Class<T> clazz) throws SOSException, SocketException {
        return this.getResponse((HttpUriRequest)new HttpDelete(uri), clazz);
    }

    public String getRestService(HttpHost target, String path) throws SOSException, SocketException {
        return this.getResponse(target, (HttpRequest)new HttpGet(path), String.class);
    }

    public String getRestService(URI uri) throws SOSException, SocketException {
        return this.getResponse((HttpUriRequest)new HttpGet(uri), String.class);
    }

    public <T> T getRestService(URI uri, Class<T> clazz) throws SOSException, SocketException {
        return this.getResponse((HttpUriRequest)new HttpGet(uri), clazz);
    }

    public Path getFilePathByRestService(URI uri, String prefix, boolean withGzipEncoding) throws SOSException, SocketException {
        return this.getFilePathResponse((HttpUriRequest)new HttpGet(uri), prefix, withGzipEncoding);
    }

    public StreamingOutput getStreamingOutputByRestService(URI uri, boolean withGzipEncoding) throws SOSException, SocketException {
        return this.getStreamingOutputResponse((HttpUriRequest)new HttpGet(uri), withGzipEncoding);
    }

    public <B> String postRestService(HttpHost target, String path, B body) throws SOSException {
        HttpPost requestPost = new HttpPost(path);
        HttpEntity entity = this.getEntity(body);
        if (entity != null) {
            requestPost.setEntity(entity);
        }
        return this.getResponse(target, (HttpRequest)requestPost, String.class);
    }

    public <T, B> T postRestService(HttpHost target, String path, B body, Class<T> clazz) throws SOSException {
        HttpPost requestPost = new HttpPost(path);
        HttpEntity entity = this.getEntity(body);
        if (entity != null) {
            requestPost.setEntity(entity);
        }
        return this.getResponse(target, (HttpRequest)requestPost, clazz);
    }

    public <B> String postRestService(URI uri, B body) throws SOSException {
        HttpPost requestPost = new HttpPost(uri);
        HttpEntity entity = this.getEntity(body);
        if (entity != null) {
            requestPost.setEntity(entity);
        }
        return this.getResponse((HttpUriRequest)requestPost, String.class);
    }

    public <T, B> T postRestService(URI uri, B body, Class<T> clazz) throws SOSException {
        HttpPost requestPost = new HttpPost(uri);
        HttpEntity entity = this.getEntity(body);
        if (entity != null) {
            requestPost.setEntity(entity);
        }
        return this.getResponse((HttpUriRequest)requestPost, clazz);
    }

    public <B> String putRestService(HttpHost target, String path, B body) throws SOSException, SocketException {
        HttpPut requestPut = new HttpPut(path);
        HttpEntity entity = this.getEntity(body);
        if (entity != null) {
            requestPut.setEntity(entity);
        }
        return this.getResponse(target, (HttpRequest)requestPut, String.class);
    }

    public <T, B> T putRestService(HttpHost target, String path, B body, Class<T> clazz) throws SOSException, SocketException {
        HttpPut requestPut = new HttpPut(path);
        HttpEntity entity = this.getEntity(body);
        if (entity != null) {
            requestPut.setEntity(entity);
        }
        return this.getResponse(target, (HttpRequest)requestPut, clazz);
    }

    public <B> String putRestService(URI uri, B body) throws SOSException, SocketException {
        HttpPut requestPut = new HttpPut(uri);
        HttpEntity entity = this.getEntity(body);
        if (entity != null) {
            requestPut.setEntity(entity);
        }
        return this.getResponse((HttpUriRequest)requestPut, String.class);
    }

    public <T, B> T putRestService(URI uri, B body, Class<T> clazz) throws SOSException, SocketException {
        HttpPut requestPut = new HttpPut(uri);
        HttpEntity entity = this.getEntity(body);
        if (entity != null) {
            requestPut.setEntity(entity);
        }
        return this.getResponse((HttpUriRequest)requestPut, clazz);
    }

    public String printHttpRequestHeaders() {
        return this.printHttpRequestHeaders(Collections.emptySet(), true);
    }

    public String printHttpRequestHeaders(Set<String> maskedHeaders, boolean pretty) {
        HashMap<String, String> h = new HashMap<String, String>();
        h.put("Accept", this.accept);
        h.putAll(this.headers);
        if (h.containsKey("Authorization")) {
            h.put("Authorization", "********");
        } else if (this.basicAuthorization != null && !this.basicAuthorization.isEmpty()) {
            h.put("Authorization", "********");
        }
        for (String maskedHeader : maskedHeaders) {
            if (!h.containsKey(maskedHeader)) continue;
            h.put(maskedHeader, "********");
        }
        Stream<String> s = h.entrySet().stream().map(e -> (String)e.getKey() + ": " + (String)e.getValue());
        if (pretty) {
            return s.collect(Collectors.joining(" \n\t> ", "Request headers \n\t> ", ""));
        }
        return s.collect(Collectors.joining("; ", "Request headers: ", ""));
    }

    public String printHttpResponseHeaders() {
        return this.printHttpResponseHeaders(true);
    }

    public String printHttpResponseHeaders(boolean pretty) {
        Stream s = this.origResponseHeaders.stream();
        if (pretty) {
            return s.collect(Collectors.joining(" \n\t< ", "Response headers \n\t< ", ""));
        }
        return s.collect(Collectors.joining("; ", "Response headers: ", ""));
    }

    private String getDataString(HashMap<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return result.toString();
    }

    private <B> HttpEntity getEntity(B body) throws SOSBadRequestException {
        ByteArrayEntity entity = null;
        if (body != null) {
            try {
                if (body instanceof HashMap) {
                    String b = this.getDataString((HashMap)body);
                    if (!b.isEmpty()) {
                        entity = new StringEntity(b, StandardCharsets.UTF_8);
                    }
                } else if (body instanceof String) {
                    String b = (String)body;
                    if (!b.isEmpty()) {
                        entity = new StringEntity(b, StandardCharsets.UTF_8);
                    }
                } else if (body instanceof byte[]) {
                    entity = new ByteArrayEntity((byte[])body);
                } else if (body instanceof InputStream) {
                    entity = new InputStreamEntity((InputStream)body);
                }
            }
            catch (Exception e) {
                throw new SOSBadRequestException(e);
            }
        }
        return entity;
    }

    private <T> T getResponse(HttpHost target, HttpRequest request, Class<T> clazz) throws SOSException {
        this.httpResponse = null;
        this.createHttpClient();
        this.setHttpRequestHeaders(request);
        try {
            this.httpResponse = this.httpClient.execute(target, request);
            return this.getResponse(clazz);
        }
        catch (SOSException e) {
            this.closeHttpClient();
            throw e;
        }
        catch (ClientProtocolException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException(request, (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            this.closeHttpClient();
            throw new SOSNoResponseException(request, (Throwable)e);
        }
        catch (HttpHostConnectException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException(request, (Throwable)e);
        }
        catch (SocketException e) {
            this.closeHttpClient();
            if ("connection reset".equalsIgnoreCase(e.getMessage())) {
                throw new SOSConnectionResetException(request, (Throwable)e);
            }
            throw new SOSConnectionRefusedException(request, (Throwable)e);
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException(request, (Throwable)e);
        }
    }

    private <T> T getResponse(HttpUriRequest request, Class<T> clazz) throws SOSException {
        this.httpResponse = null;
        this.createHttpClient();
        this.setHttpRequestHeaders((HttpRequest)request);
        try {
            this.httpResponse = this.httpClient.execute(request);
            return this.getResponse(clazz);
        }
        catch (SOSException e) {
            this.closeHttpClient();
            throw e;
        }
        catch (ClientProtocolException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            this.closeHttpClient();
            throw new SOSNoResponseException((HttpRequest)request, (Throwable)e);
        }
        catch (HttpHostConnectException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (SocketException e) {
            this.closeHttpClient();
            if ("connection reset".equalsIgnoreCase(e.getMessage())) {
                throw new SOSConnectionResetException((HttpRequest)request, (Throwable)e);
            }
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
    }

    private Path getFilePathResponse(HttpUriRequest request, String prefix, boolean withGzipEncoding) throws SOSException, SocketException {
        this.httpResponse = null;
        this.createHttpClient();
        this.setHttpRequestHeaders((HttpRequest)request);
        try {
            this.httpResponse = this.httpClient.execute(request);
            return this.getFilePathResponse(prefix, withGzipEncoding);
        }
        catch (SOSException e) {
            this.closeHttpClient();
            throw e;
        }
        catch (ClientProtocolException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            this.closeHttpClient();
            throw new SOSNoResponseException((HttpRequest)request, (Throwable)e);
        }
        catch (HttpHostConnectException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (SocketException e) {
            this.closeHttpClient();
            if ("connection reset".equalsIgnoreCase(e.getMessage())) {
                throw new SOSConnectionResetException((HttpRequest)request, (Throwable)e);
            }
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
    }

    private StreamingOutput getStreamingOutputResponse(HttpUriRequest request, boolean withGzipEncoding) throws SOSException, SocketException {
        this.httpResponse = null;
        this.createHttpClient();
        this.setHttpRequestHeaders((HttpRequest)request);
        try {
            this.httpResponse = this.httpClient.execute(request);
            return this.getStreamingOutputResponse(withGzipEncoding);
        }
        catch (SOSException e) {
            this.closeHttpClient();
            throw e;
        }
        catch (ClientProtocolException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            this.closeHttpClient();
            throw new SOSNoResponseException((HttpRequest)request, (Throwable)e);
        }
        catch (HttpHostConnectException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (SocketException e) {
            this.closeHttpClient();
            if ("connection reset".equalsIgnoreCase(e.getMessage())) {
                throw new SOSConnectionResetException((HttpRequest)request, (Throwable)e);
            }
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
    }

    private <T> T getResponse(Class<T> clazz) throws SOSNoResponseException {
        try {
            Object s = null;
            this.setHttpResponseHeaders();
            HttpEntity entity = this.httpResponse.getEntity();
            if (entity != null) {
                if (clazz.equals(String.class)) {
                    s = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                } else if (clazz.equals(byte[].class)) {
                    s = EntityUtils.toByteArray((HttpEntity)entity);
                } else if (clazz.equals(InputStream.class)) {
                    s = entity.getContent();
                }
            }
            if (this.isAutoCloseHttpClient()) {
                this.closeHttpClient();
            }
            return (T)s;
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSNoResponseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path getFilePathResponse(String prefix, boolean withGzipEncoding) throws SOSNoResponseException {
        Path path = null;
        try {
            this.setHttpResponseHeaders();
            HttpEntity entity = this.httpResponse.getEntity();
            if (entity != null) {
                InputStream instream = entity.getContent();
                OutputStream out = null;
                if (instream != null) {
                    try {
                        int length;
                        if (prefix == null) {
                            prefix = "sos-download-";
                        }
                        path = Files.createTempFile(prefix, null, new FileAttribute[0]);
                        out = withGzipEncoding ? new GZIPOutputStream(Files.newOutputStream(path, new OpenOption[0])) : Files.newOutputStream(path, new OpenOption[0]);
                        byte[] buffer = new byte[4096];
                        while ((length = instream.read(buffer)) > 0) {
                            out.write(buffer, 0, length);
                        }
                        out.flush();
                    }
                    finally {
                        try {
                            instream.close();
                            instream = null;
                        }
                        catch (Exception exception) {}
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (this.isAutoCloseHttpClient()) {
                this.closeHttpClient();
            }
            return path;
        }
        catch (Exception e) {
            throw new SOSNoResponseException(e);
        }
        finally {
            if (path != null) {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException iOException) {}
            }
            this.closeHttpClient();
        }
    }

    private StreamingOutput getStreamingOutputResponse(final boolean withGzipEncoding) throws SOSNoResponseException {
        StreamingOutput fileStream = null;
        try {
            this.setHttpResponseHeaders();
            HttpEntity entity = this.httpResponse.getEntity();
            if (entity != null) {
                final InputStream instream = entity.getContent();
                fileStream = new StreamingOutput(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void write(OutputStream output) throws IOException {
                        if (withGzipEncoding) {
                            output = new GZIPOutputStream(output);
                        }
                        try {
                            int length;
                            byte[] buffer = new byte[4096];
                            while ((length = instream.read(buffer)) > 0) {
                                output.write(buffer, 0, length);
                            }
                            output.flush();
                        }
                        finally {
                            try {
                                output.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                };
            }
            if (this.isAutoCloseHttpClient()) {
                this.closeHttpClient();
            }
            return fileStream;
        }
        catch (Exception e) {
            throw new SOSNoResponseException(e);
        }
        finally {
            this.closeHttpClient();
        }
    }

    private void setHttpRequestHeaders(HttpRequest request) {
        request.setHeader("Accept", this.accept);
        if (this.basicAuthorization != null && !this.basicAuthorization.isEmpty()) {
            request.setHeader("Authorization", "Basic " + this.basicAuthorization);
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            request.setHeader(entry.getKey(), entry.getValue());
        }
    }

    private void setHttpResponseHeaders() {
        if (this.httpResponse != null) {
            Header[] headers = this.httpResponse.getAllHeaders();
            this.responseHeaders.clear();
            this.origResponseHeaders.clear();
            for (Header header : headers) {
                if ("set-cookie".equals(header.getName().toLowerCase())) {
                    String[] cookieParts = header.getValue().split(";", 2);
                    if (cookieParts.length >= 1) {
                        this.cookies.add(cookieParts[0]);
                    }
                } else {
                    this.responseHeaders.put(header.getName().toLowerCase(), header.getValue());
                }
                this.origResponseHeaders.add(String.format("%s: %s", header.getName(), header.getValue()));
            }
        }
    }

    public void addAuthorizationHeader(String user, String password) {
        this.addAuthorizationHeader(user + ":" + password);
    }

    public void addAuthorizationHeader(String account) {
        byte[] authEncBytes = Base64.getEncoder().encode(account.getBytes());
        String authStringEnc = new String(authEncBytes);
        this.addHeader("Authorization", "Basic " + authStringEnc);
    }

    public void setClientCertificate() throws SOSMissingDataException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.clientCertificate = this.readKeyStore();
        this.clientCertificatePass = this.getKeyPass();
    }

    public void setClientCertificate(KeyStore clientCertificate, char[] clientCertificatePass, String clientCertificateAlias) {
        this.clientCertificate = clientCertificate;
        this.clientCertificatePass = clientCertificatePass;
        this.clientCertificateAlias = clientCertificateAlias;
    }

    public void setClientCertificate(String keystorePath, String keyPass, String keystoreAlias, String keystoreType, String keystorePass) throws SOSMissingDataException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.setKeystorePath(keystorePath);
        this.setKeyPass(keyPass);
        this.setKeystoreType(keystoreType);
        this.setKeystorePass(keystorePass);
        this.setKeyStoreAlias(keystoreAlias);
        this.clientCertificateAlias = this.getKeyStoreAlias();
        this.clientCertificate = this.readKeyStore();
        this.clientCertificatePass = this.getKeyPass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore readKeyStore() throws SOSMissingDataException, IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        InputStream keyStoreStream = null;
        try {
            keyStoreStream = Files.newInputStream(this.getKeystorePath(), new OpenOption[0]);
            KeyStore keyStore = KeyStore.getInstance(this.getKeystoreType());
            keyStore.load(keyStoreStream, this.getKeystorePass());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        finally {
            if (keyStoreStream != null) {
                try {
                    keyStoreStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setTruststore(KeyStore truststore) {
        this.truststore = truststore;
    }

    public static enum HttpMethod {
        POST,
        GET,
        PUT,
        DELETE;

    }
}

