/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import com.sos.commons.exception.SOSInvalidDataException;
import com.sos.commons.util.SOSString;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSDate {
    private static Logger LOGGER = LoggerFactory.getLogger(SOSDate.class);
    public static final String DATE_FORMAT = new String("yyyy-MM-dd");
    public static final String TIME_FORMAT = new String("HH:mm:ss");
    public static final String DATETIME_FORMAT = new String(DATE_FORMAT + " " + TIME_FORMAT);
    public static final String DATETIME_FORMAT_WITH_ZONE_OFFSET = new String(DATE_FORMAT + "'T'" + TIME_FORMAT + "Z");
    private static final boolean LENIENT = false;

    public static Date getDate(String date) throws SOSInvalidDataException {
        return SOSDate.getDate(date, null);
    }

    public static Date getDate(String date, TimeZone timeZone) throws SOSInvalidDataException {
        return SOSDate.parse(date, DATE_FORMAT, timeZone);
    }

    public static Date getDateTime(String date) throws SOSInvalidDataException {
        return SOSDate.getDateTime(date, null);
    }

    public static Date getDateTime(String date, TimeZone timeZone) throws SOSInvalidDataException {
        return SOSDate.parse(date, DATETIME_FORMAT, timeZone);
    }

    public static Date tryGetDateTime(String date, TimeZone timeZone) {
        try {
            return SOSDate.parse(date, DATETIME_FORMAT, timeZone);
        }
        catch (SOSInvalidDataException e) {
            return null;
        }
    }

    public static Date parse(String date, String format) throws SOSInvalidDataException {
        return SOSDate.parse(date, format, null);
    }

    public static Date parse(String date, String format, TimeZone timeZone) throws SOSInvalidDataException {
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(format == null ? DATETIME_FORMAT : format);
            df.setLenient(false);
            if (timeZone != null) {
                df.setTimeZone(timeZone);
            }
            return df.parse(date);
        }
        catch (Throwable e) {
            Object add = timeZone == null ? "" : "[" + timeZone + "]";
            throw new SOSInvalidDataException(String.format("[%s][%s]%s%s", date, format, add, e.toString()), e);
        }
    }

    public static String getCurrentDateAsString() throws SOSInvalidDataException {
        return SOSDate.getCurrentDateAsString(null);
    }

    public static String getCurrentDateAsString(TimeZone timeZone) throws SOSInvalidDataException {
        return SOSDate.format(new Date(), DATE_FORMAT, timeZone);
    }

    public static String getCurrentDateTimeAsString() throws SOSInvalidDataException {
        return SOSDate.getCurrentDateTimeAsString(null);
    }

    public static String getCurrentDateTimeAsString(TimeZone timeZone) throws SOSInvalidDataException {
        return SOSDate.format(new Date(), DATETIME_FORMAT, timeZone);
    }

    public static String getDateAsString(Date date) throws SOSInvalidDataException {
        return SOSDate.getDateAsString(date, null);
    }

    public static String getDateAsString(Date date, TimeZone timeZone) throws SOSInvalidDataException {
        return SOSDate.format(date, DATE_FORMAT, timeZone);
    }

    public static String getDateTimeAsString(Date date) throws SOSInvalidDataException {
        return SOSDate.getDateTimeAsString(date, null);
    }

    public static String tryGetDateTimeAsString(Date date) {
        try {
            return SOSDate.getDateTimeAsString(date, null);
        }
        catch (SOSInvalidDataException e) {
            return e.toString();
        }
    }

    public static String tryGetDateTimeAsString(Instant date) {
        try {
            return SOSDate.getDateTimeAsString(Date.from(date), null);
        }
        catch (SOSInvalidDataException e) {
            return e.toString();
        }
    }

    public static String getDateTimeAsString(Date date, TimeZone timeZone) throws SOSInvalidDataException {
        return SOSDate.format(date, DATETIME_FORMAT, timeZone);
    }

    public static String getDateTimeWithZoneOffsetAsString(Date date, TimeZone timeZone) throws SOSInvalidDataException {
        return SOSDate.format(date, DATETIME_FORMAT_WITH_ZONE_OFFSET, timeZone);
    }

    public static String getTimeAsString(Date date) throws SOSInvalidDataException {
        return SOSDate.getTimeAsString(date, null);
    }

    public static String getTimeAsString(Long seconds) throws SOSInvalidDataException {
        long HH = seconds / 3600L;
        long MM = seconds % 3600L / 60L;
        long SS = seconds % 60L;
        return String.format("%02d:%02d:%02d", HH, MM, SS);
    }

    public static String getTimeAsString(Date date, TimeZone timeZone) throws SOSInvalidDataException {
        return SOSDate.format(date, TIME_FORMAT, timeZone);
    }

    public static String getTimeAsString(Instant it) {
        try {
            return it.toString().split("T")[1].replace("Z", "");
        }
        catch (Throwable t) {
            return it.toString();
        }
    }

    public static String getDateWithTimeZoneAsString(Date date, String timeZone) throws SOSInvalidDataException {
        return SOSDate.format(date, DATE_FORMAT, SOSString.isEmpty(timeZone) ? null : TimeZone.getTimeZone(timeZone));
    }

    public static String getDateTimeWithTimeZoneAsString(Date date, String timeZone) throws SOSInvalidDataException {
        return SOSDate.format(date, DATETIME_FORMAT, SOSString.isEmpty(timeZone) ? null : TimeZone.getTimeZone(timeZone));
    }

    public static String getDateAsString(Calendar calendar) throws SOSInvalidDataException {
        if (calendar == null) {
            return null;
        }
        return SOSDate.format(calendar.getTime(), DATE_FORMAT);
    }

    public static String getDateTimeAsString(Calendar calendar) throws SOSInvalidDataException {
        if (calendar == null) {
            return null;
        }
        return SOSDate.format(calendar.getTime(), DATETIME_FORMAT);
    }

    public static String getDateAsString(long datetime) throws SOSInvalidDataException {
        return SOSDate.format(new Date(datetime), DATE_FORMAT);
    }

    public static String getDateTimeAsString(long datetime) throws SOSInvalidDataException {
        return SOSDate.format(new Date(datetime), DATETIME_FORMAT);
    }

    public static String format(String date, String format) throws SOSInvalidDataException {
        if (date == null) {
            return null;
        }
        Date d = null;
        d = "%now".equals(date) ? new Date() : SOSDate.getDateTime(date);
        return SOSDate.format(d, format, null);
    }

    public static String format(Date date, String format) throws SOSInvalidDataException {
        return SOSDate.format(date, format, null);
    }

    public static String format(Date date, String format, TimeZone timeZone) throws SOSInvalidDataException {
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(format == null ? DATETIME_FORMAT : format);
            df.setLenient(false);
            if (timeZone != null) {
                df.setTimeZone(timeZone);
            }
            return df.format(date);
        }
        catch (Throwable e) {
            Object add = timeZone == null ? "" : "[" + timeZone + "]";
            throw new SOSInvalidDataException(String.format("[%s][%s]%s%s", date, format, add, e.toString()), e);
        }
    }

    public static Long getMinutes(Date d) {
        if (d == null) {
            return 0L;
        }
        return d.getTime() / 1000L / 60L;
    }

    public static Long getSeconds(Date d) {
        if (d == null) {
            return 0L;
        }
        return d.getTime() / 1000L;
    }

    public static int getWeek(Date d) {
        if (d == null) {
            return 0;
        }
        return d.toInstant().atZone(ZoneId.systemDefault()).get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
    }

    public static int getMonth(Date d) {
        if (d == null) {
            return 0;
        }
        return d.toInstant().atZone(ZoneId.systemDefault()).getMonthValue();
    }

    public static int getQuarter(Date d) {
        if (d == null) {
            return 0;
        }
        return d.toInstant().atZone(ZoneId.systemDefault()).get(IsoFields.QUARTER_OF_YEAR);
    }

    public static int getYear(Date d) {
        if (d == null) {
            return 0;
        }
        return d.toInstant().atZone(ZoneId.systemDefault()).get(IsoFields.WEEK_BASED_YEAR);
    }

    public static String getDuration(Instant start, Instant end) {
        return SOSDate.getDuration(Duration.between(start, end));
    }

    public static String getDuration(Duration duration) {
        return duration == null ? null : duration.toString().replace("PT", "").toLowerCase();
    }

    public static String getDurationOfSeconds(long val) {
        return SOSDate.getDuration(Duration.ofSeconds(val));
    }

    public static String getDurationOfMillis(long val) {
        return SOSDate.getDuration(Duration.ofMillis(val));
    }

    public static boolean equals(Date val1, Date val2) {
        if (val1 == null && val2 == null) {
            return true;
        }
        if (val1 == null || val2 == null) {
            return false;
        }
        return val1.getTime() == val2.getTime();
    }

    public static Date add(Date input, long amountToAdd, TemporalUnit unit) {
        return SOSDate.add(input.toInstant(), amountToAdd, unit);
    }

    public static Date add(Instant input, long amountToAdd, TemporalUnit unit) {
        if (input == null) {
            return null;
        }
        return Date.from(input.plus(amountToAdd, unit));
    }

    public static Long resolveAge(String range, String age) throws SOSInvalidDataException {
        String[] parts;
        if (SOSString.isEmpty(age)) {
            throw new SOSInvalidDataException("age is empty");
        }
        int multiplicatorSeconds = -1;
        int multiplicatorMilliseconds = -1;
        switch (range) {
            case "ms": {
                multiplicatorSeconds = 60;
                multiplicatorMilliseconds = 1000;
                break;
            }
            case "s": {
                multiplicatorSeconds = 60;
                multiplicatorMilliseconds = 1;
                break;
            }
            default: {
                range = "m";
                multiplicatorSeconds = 1;
                multiplicatorMilliseconds = 1;
            }
        }
        Long result = 0L;
        for (String part : parts = age.trim().toLowerCase().split(" ")) {
            if (SOSString.isEmpty(part)) continue;
            String numericalPart = part;
            try {
                int len = part.length() - 1;
                String lastCharacter = part.substring(len);
                numericalPart = part.substring(0, len);
                switch (lastCharacter) {
                    case "w": {
                        result = result + (long)(multiplicatorMilliseconds * multiplicatorSeconds * 60 * 24 * 7) * Long.parseLong(numericalPart);
                        break;
                    }
                    case "d": {
                        result = result + (long)(multiplicatorMilliseconds * multiplicatorSeconds * 60 * 24) * Long.parseLong(numericalPart);
                        break;
                    }
                    case "h": {
                        result = result + (long)(multiplicatorMilliseconds * multiplicatorSeconds * 60) * Long.parseLong(numericalPart);
                        break;
                    }
                    case "m": {
                        result = result + (long)(multiplicatorMilliseconds * multiplicatorSeconds) * Long.parseLong(numericalPart);
                        break;
                    }
                    case "s": {
                        if (range.equals("m")) {
                            LOGGER.warn("[ignored][" + part + "]");
                            break;
                        }
                        result = result + (long)multiplicatorMilliseconds * Long.parseLong(numericalPart);
                        break;
                    }
                    default: {
                        result = result + Long.parseLong(part);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                throw new SOSInvalidDataException(String.format("[invalid numeric value][%s][%s][%s]%s", age, part, numericalPart, ex.toString()), (Throwable)ex);
            }
        }
        return result;
    }

    public static long getTimeAsSeconds(String val) {
        if (SOSString.isEmpty(val)) {
            return 0L;
        }
        int[] num = new int[]{1, 60, 3600, 86400};
        int j = 0;
        long seconds = 0L;
        String[] arr = val.split(":");
        if (arr.length == 2) {
            ++j;
        }
        for (int i = arr.length - 1; i >= 0; --i) {
            try {
                seconds += (long)(Integer.valueOf(arr[i].trim()) * num[j++]);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return seconds;
    }

    public static long getTimeAsMillis(String val) {
        return SOSDate.getTimeAsSeconds(val) * 1000L;
    }

    public static void main(String[] args) {
        try {
            Date d = new Date();
            System.out.println(SOSDate.getWeek(d));
            System.out.println(SOSDate.getMonth(d));
            System.out.println(SOSDate.getYear(d));
            System.out.println(SOSDate.format(d, "yyyy-MM-dd HH:mm:ss.SSSZZZZ", TimeZone.getTimeZone("PST")));
            System.out.println(SOSDate.format(d, "yyyy-MM-dd HH:mm:ss.SSSZZZZ", TimeZone.getTimeZone("Europe/Berlin")));
            System.out.println(SOSDate.getDurationOfSeconds(0L));
            System.out.println(SOSDate.getDurationOfSeconds(60L));
            System.out.println(SOSDate.getDurationOfSeconds(100000L));
            System.out.println(SOSDate.add(new Date(), 3L, (TemporalUnit)ChronoUnit.DAYS));
            System.out.println(SOSDate.add(new Date(), -3L, (TemporalUnit)ChronoUnit.DAYS));
        }
        catch (Exception e) {
            System.err.println("..error: " + e.toString());
        }
    }
}

