/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import com.sos.commons.util.SOSString;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SOSReflection {
    public static void changeAnnotationValue(Annotation annotation, String key, Object newValue) {
        Map memberValues;
        Field f;
        InvocationHandler handler = Proxy.getInvocationHandler(annotation);
        try {
            f = handler.getClass().getDeclaredField("memberValues");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        f.setAccessible(true);
        try {
            memberValues = (Map)f.get(handler);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        Object oldValue = memberValues.get(key);
        if (oldValue == null || oldValue.getClass() != newValue.getClass()) {
            throw new IllegalArgumentException();
        }
        memberValues.put(key, newValue);
    }

    public static void setDeclaredFieldValue(Object o, String fieldName, Object fieldValue) throws Exception {
        Field f = o.getClass().getDeclaredField(fieldName);
        f.setAccessible(true);
        f.set(o, fieldValue);
    }

    public static List<Field> getFields(Class<?> type) {
        if (type == null) {
            return null;
        }
        return Arrays.asList(type.getFields());
    }

    public static List<Field> getDeclaredFields(Class<?> type) {
        if (type == null) {
            return null;
        }
        return Arrays.asList(type.getDeclaredFields());
    }

    public static List<Field> getAllDeclaredFields(Class<?> type) {
        if (type == null) {
            return null;
        }
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            result.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return result;
    }

    public static List<Method> getDeclaredMethods(Class<?> type) {
        if (type == null) {
            return null;
        }
        return Arrays.asList(type.getDeclaredMethods());
    }

    public static List<Method> getAllDeclaredMethods(Class<?> type) {
        if (type == null) {
            return null;
        }
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            result.addAll(Arrays.asList(c.getDeclaredMethods()));
        }
        return result;
    }

    public static Map<String, Method> getAllDeclaredMethodsAsMap(Class<?> type) {
        if (type == null) {
            return null;
        }
        HashMap<String, Method> result = new HashMap<String, Method>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                result.putIfAbsent(m.getName(), m);
            }
        }
        return result;
    }

    public static List<Method> getMethods(Class<?> type) {
        if (type == null) {
            return null;
        }
        return Arrays.asList(type.getMethods());
    }

    public static List<Method> getAllMethods(Class<?> type) {
        if (type == null) {
            return null;
        }
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            result.addAll(Arrays.asList(c.getMethods()));
        }
        return result;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        for (Field field : obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object val = field.get(obj);
                if (val == null) continue;
                if (val instanceof CharSequence) {
                    if (SOSString.isEmpty(val.toString())) continue;
                    return false;
                }
                return false;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return true;
    }

    public static List<Path> getJarsFromClassPath(String specificDirectory) {
        String[] arr = System.getProperty("java.class.path").split(File.pathSeparator);
        return Stream.of(arr).filter(f -> f.endsWith(".jar")).map(x$0 -> Paths.get(x$0, new String[0])).filter(path -> {
            File file = path.toFile();
            return file.isFile() && file.getParentFile().getName().equals(specificDirectory);
        }).collect(Collectors.toList());
    }

    public static List<Class<?>> findClassesInJarFile(Path filePath, Class<?> targetInterface) throws Exception {
        File file = filePath.toFile();
        ArrayList r = new ArrayList();
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            URL[] urls = new URL[]{new URL("jar:file:" + file.getAbsolutePath() + "!/")};
            URLClassLoader classLoader = URLClassLoader.newInstance(urls);
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                String className = entry.getName().replace("/", ".").replace(".class", "");
                try {
                    Class<?> clazz = classLoader.loadClass(className);
                    if (!targetInterface.isAssignableFrom(clazz) || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) continue;
                    r.add(clazz);
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {}
            }
        }
        return r;
    }

    public static boolean isArray(Class<?> cls) {
        return cls.isArray();
    }

    public static boolean isCollection(Type type) throws ClassNotFoundException {
        return SOSReflection.isCollection(Class.forName(SOSReflection.normalizeClassForName(type.getTypeName())));
    }

    public static boolean isCollection(Class<?> cls) {
        return Collection.class.isAssignableFrom(cls);
    }

    public static boolean isSet(Type type) throws ClassNotFoundException {
        return SOSReflection.isSet(Class.forName(SOSReflection.normalizeClassForName(type.getTypeName())));
    }

    public static boolean isSet(Class<?> cls) {
        return Set.class.isAssignableFrom(cls);
    }

    public static boolean isMap(Type type) throws ClassNotFoundException {
        return SOSReflection.isMap(Class.forName(SOSReflection.normalizeClassForName(type.getTypeName())));
    }

    public static boolean isMap(Class<?> cls) {
        return Map.class.isAssignableFrom(cls);
    }

    public static boolean isList(Type type) throws ClassNotFoundException {
        return SOSReflection.isList(Class.forName(SOSReflection.normalizeClassForName(type.getTypeName())));
    }

    public static boolean isList(Class<?> cls) {
        return List.class.isAssignableFrom(cls);
    }

    public static boolean isEnum(Type type) throws ClassNotFoundException {
        return SOSReflection.isEnum(Class.forName(SOSReflection.normalizeClassForName(type.getTypeName())));
    }

    public static boolean isEnum(Class<?> cls) {
        return Enum.class.isAssignableFrom(cls);
    }

    public static Enum<?> enumValueOf(String enumClassName, String val) throws ClassNotFoundException {
        return Enum.valueOf(Class.forName(enumClassName), val);
    }

    public static <T extends Enum<?>> T enumIgnoreCaseValueOf(String enumClassName, String val) throws ClassNotFoundException {
        return (T)SOSReflection.enumIgnoreCaseValueOf(Class.forName(enumClassName), val);
    }

    public static <T extends Enum<?>> T enumIgnoreCaseValueOf(Class<T> enumeration, String val) {
        return (T)((Enum)Stream.of((Enum[])enumeration.getEnumConstants()).filter(e -> e.name().equalsIgnoreCase(val)).findAny().orElse(null));
    }

    private static String normalizeClassForName(String className) {
        int indx = className.indexOf(60);
        return indx > -1 ? className.substring(0, indx) : className;
    }
}

