/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.common;

import com.sos.commons.util.SOSShell;
import com.sos.commons.util.SOSString;
import java.util.Map;

public class SOSEnv {
    private Map<String, String> localEnvs;
    private Map<String, String> globalEnvs;

    public SOSEnv() {
    }

    public SOSEnv(Map<String, String> localEnvs) {
        this(localEnvs, null);
    }

    public SOSEnv(Map<String, String> localEnvs, Map<String, String> globalEnvs) {
        this.localEnvs = localEnvs;
        this.globalEnvs = globalEnvs;
    }

    public Map<String, String> getLocalEnvs() {
        return this.localEnvs;
    }

    public void setLocalEnvs(Map<String, String> val) {
        this.localEnvs = val;
    }

    public Map<String, String> getGlobalEnvs() {
        return this.globalEnvs;
    }

    public void setGlobalEnvs(Map<String, String> val) {
        this.globalEnvs = val;
    }

    public static String newLine2Space(String value) {
        return value.replaceAll("\\r\\n|\\r|\\n", " ");
    }

    public static String escapeValue(String val) {
        return SOSEnv.escapeValue(val, SOSShell.IS_WINDOWS);
    }

    public static String escapeValue(String val, boolean isWindows) {
        if (SOSString.isEmpty(val)) {
            return val;
        }
        val = SOSString.remove4ByteCharacters(val).trim();
        return isWindows ? SOSEnv.escapeValue4Windows(val) : SOSEnv.escapeValue4Unix(val);
    }

    private static String escapeValue4Windows(String val) {
        return val.replaceAll("([<>&%^|\"'!()\\[\\]])", "^$1");
    }

    private static String escapeValue4Unix(String val) {
        return val.replaceAll("([\"<>&%';`$(){}\\[\\]|^#~?*])", "\\\\$1");
    }
}

