/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.SerializableDatabase;
import org.linguafranca.pwdb.StreamFormat;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.KdbxHeader;
import org.linguafranca.pwdb.kdbx.KdbxSerializer;

public class KdbxStreamFormat
implements StreamFormat<KdbxHeader> {
    private KdbxHeader kdbxHeader;

    public KdbxStreamFormat() {
        this(new KdbxHeader(3));
    }

    @Deprecated
    public KdbxStreamFormat(Version version) {
        this(version.getVersionNum() == 3 ? new KdbxHeader() : new KdbxHeader(4));
    }

    public KdbxStreamFormat(KdbxHeader kdbxHeader) {
        this.kdbxHeader = kdbxHeader;
    }

    public void load(SerializableDatabase serializableDatabase, Credentials credentials, InputStream encryptedInputStream) throws IOException {
        try (InputStream decryptedInputStream = KdbxSerializer.createUnencryptedInputStream(credentials, this.kdbxHeader, encryptedInputStream);){
            serializableDatabase.setEncryption(this.kdbxHeader.getStreamEncryptor());
            serializableDatabase.load(decryptedInputStream);
            if (this.kdbxHeader.getVersion() == 3 && !Arrays.equals(serializableDatabase.getHeaderHash(), this.kdbxHeader.getHeaderHash())) {
                throw new IllegalStateException("Header hash does not match");
            }
            if (this.kdbxHeader.getVersion() == 4) {
                int count = 0;
                for (byte[] binary : this.kdbxHeader.getBinaries()) {
                    serializableDatabase.addBinary(count, Arrays.copyOfRange(binary, 1, binary.length));
                    ++count;
                }
            }
        }
    }

    public void save(SerializableDatabase serializableDatabase, Credentials credentials, OutputStream outputStream) throws IOException {
        Helpers.isV4.set(this.kdbxHeader.getVersion() == 4);
        if (this.kdbxHeader.getVersion() == 4) {
            for (int a = 0; a < serializableDatabase.getBinaryCount(); ++a) {
                int attachmentLength = serializableDatabase.getBinary(a).length;
                byte[] binary = new byte[attachmentLength + 1];
                binary[0] = 0;
                System.arraycopy(serializableDatabase.getBinary(a), 0, binary, 1, attachmentLength);
                this.kdbxHeader.addBinary(binary);
            }
        }
        try (OutputStream encryptedOutputStream = KdbxSerializer.createEncryptedOutputStream(credentials, this.kdbxHeader, outputStream);){
            if (this.kdbxHeader.getVersion() == 3) {
                serializableDatabase.setHeaderHash(this.kdbxHeader.getHeaderHash());
            }
            serializableDatabase.setEncryption(this.kdbxHeader.getStreamEncryptor());
            serializableDatabase.save(encryptedOutputStream);
            encryptedOutputStream.flush();
        }
    }

    public KdbxHeader getStreamConfiguration() {
        return this.kdbxHeader;
    }

    public void setStreamConfiguration(KdbxHeader configuration) {
        this.kdbxHeader = configuration;
    }

    @Deprecated
    public static enum Version {
        KDBX31(3),
        KDBX4(4);

        private final int version;

        private Version(int num) {
            this.version = num;
        }

        int getVersionNum() {
            return this.version;
        }
    }
}

