/*
 * Decompiled with CFR 0.152.
 */
package fs2.hashing;

import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.hashing.Hash;
import fs2.hashing.Hash$;
import fs2.hashing.HashAlgorithm;
import fs2.hashing.HashAlgorithm$MD5$;
import fs2.hashing.HashAlgorithm$Named$;
import fs2.hashing.HashAlgorithm$SHA1$;
import fs2.hashing.HashAlgorithm$SHA224$;
import fs2.hashing.HashAlgorithm$SHA256$;
import fs2.hashing.HashAlgorithm$SHA384$;
import fs2.hashing.HashAlgorithm$SHA3_224$;
import fs2.hashing.HashAlgorithm$SHA3_256$;
import fs2.hashing.HashAlgorithm$SHA3_384$;
import fs2.hashing.HashAlgorithm$SHA3_512$;
import fs2.hashing.HashAlgorithm$SHA512$;
import fs2.hashing.HashAlgorithm$SHA512_224$;
import fs2.hashing.HashAlgorithm$SHA512_256$;
import fs2.hashing.Hasher;
import fs2.hashing.SyncHasher;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import scala.reflect.ClassTag$;

public interface HasherCompanionPlatform {
    public static Resource apply$(HasherCompanionPlatform $this, HashAlgorithm algorithm, Sync evidence$1) {
        return $this.apply(algorithm, evidence$1);
    }

    default public <F> Resource<F, Hasher<F>> apply(HashAlgorithm algorithm, Sync<F> evidence$1) {
        return package$.MODULE$.Resource().eval(package$.MODULE$.Sync().apply(evidence$1).delay(() -> this.apply$$anonfun$1(algorithm, evidence$1)));
    }

    public static Resource hmac$(HasherCompanionPlatform $this, HashAlgorithm algorithm, Chunk key, Sync evidence$1) {
        return $this.hmac(algorithm, key, evidence$1);
    }

    default public <F> Resource<F, Hasher<F>> hmac(HashAlgorithm algorithm, Chunk<Object> key, Sync<F> evidence$1) {
        return package$.MODULE$.Resource().eval(package$.MODULE$.Sync().apply(evidence$1).delay(() -> this.hmac$$anonfun$1(algorithm, key, evidence$1)));
    }

    public static Hasher unsafe$(HasherCompanionPlatform $this, HashAlgorithm algorithm, Sync evidence$1) {
        return $this.unsafe(algorithm, evidence$1);
    }

    default public <F> Hasher<F> unsafe(HashAlgorithm algorithm, Sync<F> evidence$1) {
        return this.unsafeFromMessageDigest(MessageDigest.getInstance(this.toAlgorithmString(algorithm)), evidence$1);
    }

    public static String toAlgorithmString$(HasherCompanionPlatform $this, HashAlgorithm algorithm) {
        return $this.toAlgorithmString(algorithm);
    }

    default public String toAlgorithmString(HashAlgorithm algorithm) {
        HashAlgorithm hashAlgorithm = algorithm;
        if (HashAlgorithm$MD5$.MODULE$.equals(hashAlgorithm)) {
            return "MD5";
        }
        if (HashAlgorithm$SHA1$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-1";
        }
        if (HashAlgorithm$SHA224$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-224";
        }
        if (HashAlgorithm$SHA256$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-256";
        }
        if (HashAlgorithm$SHA384$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-384";
        }
        if (HashAlgorithm$SHA512$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-512";
        }
        if (HashAlgorithm$SHA512_224$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-512/224";
        }
        if (HashAlgorithm$SHA512_256$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-512/256";
        }
        if (HashAlgorithm$SHA3_224$.MODULE$.equals(hashAlgorithm)) {
            return "SHA3-224";
        }
        if (HashAlgorithm$SHA3_256$.MODULE$.equals(hashAlgorithm)) {
            return "SHA3-256";
        }
        if (HashAlgorithm$SHA3_384$.MODULE$.equals(hashAlgorithm)) {
            return "SHA3-384";
        }
        if (HashAlgorithm$SHA3_512$.MODULE$.equals(hashAlgorithm)) {
            return "SHA3-512";
        }
        if (hashAlgorithm instanceof HashAlgorithm.Named) {
            String string;
            HashAlgorithm.Named named = HashAlgorithm$Named$.MODULE$.unapply((HashAlgorithm.Named)hashAlgorithm);
            String name = string = named._1();
            return name;
        }
        HashAlgorithm other = hashAlgorithm;
        throw scala.sys.package$.MODULE$.error(new StringBuilder(22).append("unsupported algorithm ").append(other).toString());
    }

    public static Hasher unsafeHmac$(HasherCompanionPlatform $this, HashAlgorithm algorithm, Chunk key, Sync evidence$1) {
        return $this.unsafeHmac(algorithm, key, evidence$1);
    }

    default public <F> Hasher<F> unsafeHmac(HashAlgorithm algorithm, Chunk<Object> key, Sync<F> evidence$1) {
        String name = this.toMacAlgorithmString(algorithm);
        Mac mac = Mac.getInstance(name);
        mac.init(new SecretKeySpec((byte[])key.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), name));
        return this.unsafeFromMac(mac, evidence$1);
    }

    public static String toMacAlgorithmString$(HasherCompanionPlatform $this, HashAlgorithm algorithm) {
        return $this.toMacAlgorithmString(algorithm);
    }

    default public String toMacAlgorithmString(HashAlgorithm algorithm) {
        HashAlgorithm hashAlgorithm = algorithm;
        if (HashAlgorithm$MD5$.MODULE$.equals(hashAlgorithm)) {
            return "HmacMD5";
        }
        if (HashAlgorithm$SHA1$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA1";
        }
        if (HashAlgorithm$SHA224$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA224";
        }
        if (HashAlgorithm$SHA256$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA256";
        }
        if (HashAlgorithm$SHA384$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA384";
        }
        if (HashAlgorithm$SHA512$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA512";
        }
        if (HashAlgorithm$SHA512_224$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA512/224";
        }
        if (HashAlgorithm$SHA512_256$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA512/256";
        }
        if (HashAlgorithm$SHA3_224$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA3-224";
        }
        if (HashAlgorithm$SHA3_256$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA3-256";
        }
        if (HashAlgorithm$SHA3_384$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA3-384";
        }
        if (HashAlgorithm$SHA3_512$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA3-512";
        }
        if (hashAlgorithm instanceof HashAlgorithm.Named) {
            String string;
            HashAlgorithm.Named named = HashAlgorithm$Named$.MODULE$.unapply((HashAlgorithm.Named)hashAlgorithm);
            String name = string = named._1();
            return name;
        }
        HashAlgorithm other = hashAlgorithm;
        throw scala.sys.package$.MODULE$.error(new StringBuilder(22).append("unsupported algorithm ").append(other).toString());
    }

    public static Hasher unsafeFromMessageDigest$(HasherCompanionPlatform $this, MessageDigest d, Sync evidence$1) {
        return $this.unsafeFromMessageDigest(d, evidence$1);
    }

    default public <F> Hasher<F> unsafeFromMessageDigest(MessageDigest d, Sync<F> evidence$1) {
        return new SyncHasher<F>(evidence$1, d){
            private final MessageDigest d$2;
            {
                this.d$2 = d$1;
                super(evidence$1$3);
            }

            public void unsafeUpdate(Chunk chunk) {
                Chunk.ArraySlice<O2> slice = chunk.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE));
                this.d$2.update((byte[])slice.values(), slice.offset(), slice.size());
            }

            public Hash unsafeHash() {
                return Hash$.MODULE$.apply(Chunk$.MODULE$.array(this.d$2.digest(), ClassTag$.MODULE$.apply(Byte.TYPE)));
            }
        };
    }

    public static Hasher unsafeFromMac$(HasherCompanionPlatform $this, Mac d, Sync evidence$1) {
        return $this.unsafeFromMac(d, evidence$1);
    }

    default public <F> Hasher<F> unsafeFromMac(Mac d, Sync<F> evidence$1) {
        return new SyncHasher<F>(evidence$1, d){
            private final Mac d$4;
            {
                this.d$4 = d$3;
                super(evidence$1$4);
            }

            public void unsafeUpdate(Chunk chunk) {
                Chunk.ArraySlice<O2> slice = chunk.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE));
                this.d$4.update((byte[])slice.values(), slice.offset(), slice.size());
            }

            public Hash unsafeHash() {
                return Hash$.MODULE$.apply(Chunk$.MODULE$.array(this.d$4.doFinal(), ClassTag$.MODULE$.apply(Byte.TYPE)));
            }
        };
    }

    private Hasher apply$$anonfun$1(HashAlgorithm algorithm$1, Sync evidence$1$1) {
        return this.unsafe(algorithm$1, evidence$1$1);
    }

    private Hasher hmac$$anonfun$1(HashAlgorithm algorithm$2, Chunk key$1, Sync evidence$1$2) {
        return this.unsafeHmac(algorithm$2, key$1, evidence$1$2);
    }
}

