/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jaxb;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.pwdb.base.AbstractEntry;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbDatabase;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbGroup;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbIcon;
import org.linguafranca.pwdb.kdbx.jaxb.binding.Binaries;
import org.linguafranca.pwdb.kdbx.jaxb.binding.BinaryField;
import org.linguafranca.pwdb.kdbx.jaxb.binding.JaxbEntryBinding;
import org.linguafranca.pwdb.kdbx.jaxb.binding.JaxbGroupBinding;
import org.linguafranca.pwdb.kdbx.jaxb.binding.StringField;
import org.linguafranca.pwdb.kdbx.jaxb.binding.Times;

public class JaxbEntry
extends AbstractEntry<JaxbDatabase, JaxbGroup, JaxbEntry, JaxbIcon> {
    protected JaxbDatabase database;
    protected JaxbEntryBinding delegate;

    public JaxbEntry(JaxbDatabase jaxbDatabase) {
        this.database = jaxbDatabase;
        this.delegate = new JaxbEntryBinding();
        for (String s : STANDARD_PROPERTY_NAMES) {
            StringField field = jaxbDatabase.getObjectFactory().createStringField();
            field.setKey(s);
            StringField.Value value = jaxbDatabase.getObjectFactory().createStringFieldValue();
            value.setValue("");
            field.setValue(value);
            this.delegate.getString().add(field);
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        Times times = new Times();
        times.setLastModificationTime(now);
        times.setCreationTime(now);
        times.setLastAccessTime(now);
        times.setExpiryTime(now);
        times.setExpires(false);
        times.setUsageCount(0);
        times.setLocationChanged(now);
        this.delegate.setTimes(times);
        this.delegate.setUUID(UUID.randomUUID());
    }

    public JaxbEntry(JaxbDatabase database, JaxbEntryBinding entry) {
        this.database = database;
        this.delegate = entry;
    }

    public String getProperty(String name) {
        for (StringField field : this.delegate.getString()) {
            if (!field.getKey().equals(name)) continue;
            return field.getValue().getValue();
        }
        return null;
    }

    public void setProperty(String name, String value) {
        StringField field2;
        StringField toRemove = null;
        for (StringField field2 : this.delegate.getString()) {
            if (!field2.getKey().equals(name)) continue;
            toRemove = field2;
            break;
        }
        if (toRemove != null) {
            this.delegate.getString().remove(toRemove);
        }
        StringField.Value fieldValue = this.database.getObjectFactory().createStringFieldValue();
        fieldValue.setValue(value);
        fieldValue.setProtected(false);
        field2 = this.database.getObjectFactory().createStringField();
        field2.setKey(name);
        field2.setValue(fieldValue);
        this.delegate.getString().add(field2);
        this.touch();
    }

    public boolean removeProperty(String name) throws IllegalArgumentException {
        if (STANDARD_PROPERTY_NAMES.contains(name)) {
            throw new IllegalArgumentException("may not remove property: " + name);
        }
        StringField toRemove = null;
        for (StringField field : this.delegate.getString()) {
            if (!field.getKey().equals(name)) continue;
            toRemove = field;
            break;
        }
        if (toRemove == null) {
            return false;
        }
        this.delegate.getString().remove(toRemove);
        this.touch();
        return true;
    }

    public List<String> getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StringField stringField : this.delegate.getString()) {
            result.add(stringField.getKey());
        }
        return result;
    }

    public byte[] getBinaryProperty(String name) {
        for (BinaryField binaryField : this.delegate.getBinary()) {
            if (!binaryField.getKey().equals(name)) continue;
            Integer ref = binaryField.getValue().getRef();
            for (Binaries.Binary binary : this.database.getKeePassFile().getMeta().getBinaries().getBinary()) {
                if (!binary.getID().equals(ref)) continue;
                if (binary.getCompressed().booleanValue()) {
                    return Helpers.unzipBinaryContent((byte[])binary.getValue());
                }
                return binary.getValue();
            }
        }
        return null;
    }

    public void setBinaryProperty(String name, byte[] value) {
        BinaryField toRemove = null;
        for (BinaryField binaryField : this.delegate.getBinary()) {
            if (!binaryField.getKey().equals(name)) continue;
            toRemove = binaryField;
            break;
        }
        if (toRemove != null) {
            this.delegate.getBinary().remove(toRemove);
        }
        Integer max = -1;
        List<Binaries.Binary> binaryList = this.database.getKeePassFile().getMeta().getBinaries().getBinary();
        for (Binaries.Binary binary : binaryList) {
            if (binary.getID() <= max) continue;
            max = binary.getID();
        }
        Integer n = max;
        Integer n2 = max = Integer.valueOf(max + 1);
        this.database.createBinary(value, max);
        BinaryField binaryField = this.database.getObjectFactory().createBinaryField();
        binaryField.setKey(name);
        BinaryField.Value value2 = this.database.getObjectFactory().createBinaryFieldValue();
        value2.setRef(max);
        binaryField.setValue(value2);
        this.delegate.getBinary().add(binaryField);
        this.touch();
    }

    public boolean removeBinaryProperty(String name) throws UnsupportedOperationException {
        BinaryField toRemove = null;
        for (BinaryField binaryField : this.delegate.getBinary()) {
            if (!binaryField.getKey().equals(name)) continue;
            toRemove = binaryField;
            break;
        }
        if (toRemove == null) {
            return false;
        }
        this.delegate.getBinary().remove(toRemove);
        this.touch();
        return true;
    }

    public List<String> getBinaryPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (BinaryField binaryField : this.delegate.getBinary()) {
            result.add(binaryField.getKey());
        }
        return result;
    }

    public JaxbGroup getParent() {
        if (this.delegate.parent == null) {
            return null;
        }
        return new JaxbGroup(this.database, (JaxbGroupBinding)this.delegate.parent);
    }

    @NotNull
    public UUID getUuid() {
        return this.delegate.getUUID();
    }

    public JaxbIcon getIcon() {
        return new JaxbIcon(this.delegate.getIconID());
    }

    public void setIcon(JaxbIcon icon) {
        this.delegate.setIconID(icon.getIndex());
        this.touch();
    }

    public Date getLastAccessTime() {
        return this.delegate.getTimes().getLastAccessTime();
    }

    public Date getCreationTime() {
        return this.delegate.getTimes().getCreationTime();
    }

    public boolean getExpires() {
        return this.delegate.getTimes().getExpires();
    }

    public void setExpires(boolean expires) {
        this.delegate.getTimes().setExpires(true);
    }

    public Date getExpiryTime() {
        return this.delegate.getTimes().getExpiryTime();
    }

    public void setExpiryTime(Date expiryTime) throws IllegalArgumentException {
        if (expiryTime == null) {
            throw new IllegalArgumentException("expiryTime may not be null");
        }
        this.delegate.getTimes().setExpiryTime(expiryTime);
    }

    public Date getLastModificationTime() {
        return this.delegate.getTimes().getLastModificationTime();
    }

    protected void touch() {
        this.database.setDirty(true);
        this.delegate.getTimes().setLastModificationTime(new Date());
    }
}

