/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import cats.Show$;
import cats.effect.CpuStarvationCheckPlatform;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.metrics.CpuStarvationMetrics;
import cats.effect.metrics.CpuStarvationWarningMetrics;
import cats.effect.metrics.CpuStarvationWarningMetrics$;
import cats.effect.std.Console$;
import cats.effect.unsafe.IORuntimeConfig;
import cats.syntax.ApplicativeByNameOps$;
import cats.syntax.package;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;

public final class CpuStarvationCheck$
extends CpuStarvationCheckPlatform
implements Serializable {
    public static final CpuStarvationCheck$ MODULE$ = new CpuStarvationCheck$();

    private CpuStarvationCheck$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CpuStarvationCheck$.class);
    }

    public IO<Nothing$> run(IORuntimeConfig runtimeConfig, CpuStarvationMetrics metrics, Function1<CpuStarvationWarningMetrics, IO<BoxedUnit>> onCpuStarvationWarn) {
        Duration threshold = runtimeConfig.cpuStarvationCheckInterval().$times(1.0 + runtimeConfig.cpuStarvationCheckThreshold());
        return IO$.MODULE$.monotonic().flatMap((Function1 & Serializable)_$1 -> this.go$1(runtimeConfig, metrics, (Function1)onCpuStarvationWarn, threshold, (FiniteDuration)_$1)).delayBy(runtimeConfig.cpuStarvationCheckInitialDelay());
    }

    public IO<BoxedUnit> logWarning(CpuStarvationWarningMetrics cpuStarvationWarningMetrics) {
        return (IO)Console$.MODULE$.make(IO$.MODULE$.asyncForIO()).errorln((Object)this.mkWarning(cpuStarvationWarningMetrics.starvationInterval().$times(cpuStarvationWarningMetrics.starvationThreshold()), cpuStarvationWarningMetrics.occurrenceTime()), Show$.MODULE$.catsShowForString());
    }

    private String mkWarning(Duration threshold, FiniteDuration when) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(447).append("|").append(this.format(when)).append(" [WARNING] Your app's responsiveness to a new asynchronous\n        | event (such as a new connection, an upstream response, or a timer) was in excess\n        | of ").append(threshold).append(". Your CPU is probably starving. Consider increasing the\n        | granularity of your delays or adding more cedes. This may also be a sign that you\n        | are unintentionally running blocking I/O operations (such as File or InetAddress)\n        | without the blocking combinator.").toString())).replaceAll("\n", "");
    }

    private final IO go$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(IORuntimeConfig runtimeConfig$6, CpuStarvationMetrics metrics$6, Function1 onCpuStarvationWarn$6, FiniteDuration delta$3, FiniteDuration fd$1) {
        return ((IO)onCpuStarvationWarn$6.apply((Object)CpuStarvationWarningMetrics$.MODULE$.apply(fd$1, delta$3.$minus(runtimeConfig$6.cpuStarvationCheckInterval()), runtimeConfig$6.cpuStarvationCheckThreshold(), runtimeConfig$6.cpuStarvationCheckInterval()))).$times$greater(metrics$6.incCpuStarvationCount());
    }

    private final IO go$1$$anonfun$1$$anonfun$1$$anonfun$1(IORuntimeConfig runtimeConfig$4, CpuStarvationMetrics metrics$4, Function1 onCpuStarvationWarn$4, Duration threshold$4, FiniteDuration delta$1) {
        return IO$.MODULE$.realTime().flatMap((Function1 & Serializable)fd -> {
            Function0 function0 = package.all$.MODULE$.catsSyntaxApplicativeByName(() -> this.go$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(runtimeConfig$4, metrics$4, onCpuStarvationWarn$4, delta$1, fd));
            return (IO)ApplicativeByNameOps$.MODULE$.whenA$extension(function0, delta$1.$greater$eq((Object)threshold$4), IO$.MODULE$.asyncForIO());
        });
    }

    private final IO go$1$$anonfun$1$$anonfun$1$$anonfun$2(IORuntimeConfig runtimeConfig$7, CpuStarvationMetrics metrics$7, Function1 onCpuStarvationWarn$7, Duration threshold$6, FiniteDuration now$1) {
        return this.go$1(runtimeConfig$7, metrics$7, onCpuStarvationWarn$7, threshold$6, now$1);
    }

    private final IO go$1$$anonfun$1(IORuntimeConfig runtimeConfig$2, CpuStarvationMetrics metrics$2, Function1 onCpuStarvationWarn$2, Duration threshold$2, FiniteDuration initial$1) {
        return IO$.MODULE$.monotonic().flatMap((Function1 & Serializable)now -> {
            FiniteDuration delta = now.$minus(initial$1);
            return metrics$2.recordClockDrift(delta.$minus(runtimeConfig$2.cpuStarvationCheckInterval())).$greater$greater(() -> this.go$1$$anonfun$1$$anonfun$1$$anonfun$1(runtimeConfig$2, metrics$2, onCpuStarvationWarn$2, threshold$2, delta)).$greater$greater(() -> this.go$1$$anonfun$1$$anonfun$1$$anonfun$2(runtimeConfig$2, metrics$2, onCpuStarvationWarn$2, threshold$2, now));
        });
    }

    private final IO go$1(IORuntimeConfig runtimeConfig$1, CpuStarvationMetrics metrics$1, Function1 onCpuStarvationWarn$1, Duration threshold$1, FiniteDuration initial) {
        return IO$.MODULE$.sleep(runtimeConfig$1.cpuStarvationCheckInterval()).$greater$greater(() -> this.go$1$$anonfun$1(runtimeConfig$1, metrics$1, onCpuStarvationWarn$1, threshold$1, initial));
    }
}

