/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import cats.effect.Trace$;
import cats.effect.tracing.RingBuffer;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class Trace {
    private final List<StackTraceElement> frames;

    public static Trace apply(RingBuffer ringBuffer) {
        return Trace$.MODULE$.apply(ringBuffer);
    }

    public Trace(List<StackTraceElement> frames) {
        this.frames = frames;
    }

    private String renderStackTraceElement(StackTraceElement ste) {
        return new StringBuilder(5).append(ste.getClassName()).append(".").append(ste.getMethodName()).append(" (").append(ste.getFileName()).append(":").append(ste.getLineNumber()).append(")").toString();
    }

    public String pretty() {
        String TurnRight = "\u2570";
        String Junction = "\u251c";
        IntRef captured = IntRef.create((int)0);
        List indexedRenderedStackTrace = this.frames.map((Function1 & Serializable)frame -> {
            int n;
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.renderStackTraceElement((StackTraceElement)frame));
            Tuple2 res = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)captured$1.elem));
            captured$1.elem = n = captured$1.elem + 1;
            return res;
        });
        String acc0 = new StringBuilder(24).append("Trace: ").append(captured.elem).append(" frames captured\n").toString();
        String acc1 = indexedRenderedStackTrace.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String tag = (String)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (index == 0) {
                    return new StringBuilder(1).append(Junction).append(" ").append(tag).toString();
                }
                if (index == captured$2.elem - 1) {
                    return new StringBuilder(1).append(TurnRight).append(" ").append(tag).toString();
                }
                return new StringBuilder(1).append(Junction).append(" ").append(tag).toString();
            }
            throw new MatchError((Object)tuple2);
        }).mkString("\n");
        return new StringBuilder(0).append(acc0).append(acc1).toString();
    }

    public String compact() {
        return this.frames.map((Function1 & Serializable)ste -> this.renderStackTraceElement((StackTraceElement)ste)).mkString(", ");
    }

    public List<StackTraceElement> toList() {
        return this.frames;
    }

    public String toString() {
        return this.compact();
    }
}

