/*
 * Decompiled with CFR 0.152.
 */
package izumi.reflect.thirdparty.internal.boopickle;

import izumi.reflect.thirdparty.internal.boopickle.IdentMap;
import izumi.reflect.thirdparty.internal.boopickle.IdentMap$;
import izumi.reflect.thirdparty.internal.boopickle.PickleState;
import izumi.reflect.thirdparty.internal.boopickle.Pickler;
import izumi.reflect.thirdparty.internal.boopickle.UnpickleState;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;

public class CompositePickler<A>
implements Pickler<A> {
    private IdentMap picklerClasses = IdentMap$.MODULE$.empty();
    private final ArrayBuffer<Tuple2<Class<?>, Pickler<?>>> picklers = ArrayBuffer$.MODULE$.empty();

    @Override
    public void pickle(A obj, PickleState state) {
        if (obj == null) {
            state.enc().writeInt(0);
            return;
        }
        Class<?> clz = obj.getClass();
        Option<Object> option = this.picklerClasses.apply(clz);
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(44).append("This CompositePickler doesn't know class '").append(clz.getName()).append("'.").toString());
        }
        if (option instanceof Some) {
            int idx = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            Pickler pickler = (Pickler)((Tuple2)this.picklers.apply(idx - 2))._2();
            state.enc().writeInt(idx - 1);
            pickler.pickle(obj, state);
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public A unpickle(UnpickleState state) {
        int idx = state.dec().readInt();
        if (idx == 0) {
            return null;
        }
        if (idx < 0 || idx > this.picklers.size()) {
            throw new IllegalStateException(new StringBuilder(46).append("Index ").append(idx).append(" is not defined in this CompositePickler").toString());
        }
        return ((Pickler)((Tuple2)this.picklers.apply(idx - 1))._2()).unpickle(state);
    }

    private <B> void addPickler(Pickler<B> pickler, ClassTag<B> tag) {
        Class clz = tag.runtimeClass();
        if (this.picklerClasses.apply(clz).isDefined()) {
            throw new IllegalArgumentException(new StringBuilder(53).append("Cannot add same class (").append(clz.getName()).append(") twice to a composite pickler").toString());
        }
        this.picklerClasses = this.picklerClasses.updated(clz);
        this.picklers.append((Object)Tuple2$.MODULE$.apply((Object)clz, pickler));
    }

    public <B extends A> CompositePickler<A> addConcreteType(Pickler<B> pickler, ClassTag<B> tag) {
        this.addPickler(pickler, tag);
        return this;
    }
}

