/*
 * Decompiled with CFR 0.152.
 */
package izumi.reflect.thirdparty.internal.boopickle;

import izumi.reflect.thirdparty.internal.boopickle.Decoder;
import izumi.reflect.thirdparty.internal.boopickle.StringCodec$;
import izumi.reflect.thirdparty.internal.boopickle.StringCodecBase;
import java.nio.ByteBuffer;

public class DecoderSize
implements Decoder {
    private final ByteBuffer buf;
    private final StringCodecBase stringCodec;

    public DecoderSize(ByteBuffer buf) {
        this.buf = buf;
        this.stringCodec = StringCodec$.MODULE$;
    }

    public ByteBuffer buf() {
        return this.buf;
    }

    public StringCodecBase stringCodec() {
        return this.stringCodec;
    }

    @Override
    public byte readByte() {
        return this.buf().get();
    }

    @Override
    public int readInt() {
        int b = this.buf().get() & 0xFF;
        if ((b & 0x80) != 0) {
            int sign = (b & 0x10) == 0 ? 1 : -1;
            int b0 = b & 0xF;
            int n = b >> 4;
            switch (n) {
                case 8: 
                case 9: {
                    int b1 = this.buf().get() & 0xFF;
                    return sign * (b0 << 8 | b1);
                }
                case 10: 
                case 11: {
                    int b1 = this.buf().get() & 0xFF;
                    int b2 = this.buf().get() & 0xFF;
                    return sign * (b0 << 16 | b1 << 8 | b2);
                }
                case 12: 
                case 13: {
                    int b1 = this.buf().get() & 0xFF;
                    int b2 = this.buf().get() & 0xFF;
                    int b3 = this.buf().get() & 0xFF;
                    return sign * (b0 << 24 | b1 << 16 | b2 << 8 | b3);
                }
            }
            if (14 == n && b == 224) {
                return sign * this.readRawInt();
            }
            throw new IllegalArgumentException("Unknown integer coding");
        }
        return b;
    }

    public int readRawInt() {
        return this.buf().getInt();
    }

    @Override
    public String readString() {
        int len = this.readInt();
        return this.stringCodec().decodeFast(len, this.buf());
    }

    @Override
    public String readString(int len) {
        return this.stringCodec().decodeFast(len, this.buf());
    }
}

