/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.sign;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum JocKeyType {
    PRIVATE(0),
    PUBLIC(1),
    X509(2),
    CA(3);

    private final Integer value;
    private static final Map<Integer, JocKeyType> CONSTANTS;

    private JocKeyType(Integer value) {
        this.value = value;
    }

    @JsonValue
    public Integer value() {
        return this.value;
    }

    @JsonCreator
    public static JocKeyType fromValue(Integer value) {
        JocKeyType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("" + value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<Integer, JocKeyType>();
        for (JocKeyType c : JocKeyType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

