/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.common.logger;

import com.sos.commons.util.common.logger.ISOSLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SOSSlf4jLogger
implements ISOSLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSlf4jLogger.class);
    private static final String LOGGER_CLASS_NAME = SOSSlf4jLogger.class.getName();
    private static final String THREAD_CLASS_NAME = Thread.class.getName();
    private final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private final boolean isTraceEnabled = LOGGER.isTraceEnabled();

    @Override
    public void info(Object msg) {
        try {
            this.setMDC();
            LOGGER.info(String.valueOf(msg));
        }
        finally {
            this.clearMDC();
        }
    }

    @Override
    public void info(String format, Object ... args) {
        try {
            this.setMDC();
            if (args.length > 0) {
                LOGGER.info(String.format(format, args));
            } else {
                LOGGER.info(format);
            }
        }
        finally {
            this.clearMDC();
        }
    }

    @Override
    public void debug(Object msg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        try {
            this.setMDC();
            LOGGER.debug(String.valueOf(msg));
        }
        finally {
            this.clearMDC();
        }
    }

    @Override
    public void debug(String format, Object ... args) {
        if (!this.isDebugEnabled()) {
            return;
        }
        try {
            this.setMDC();
            if (args.length > 0) {
                LOGGER.debug(String.format(format, args));
            } else {
                LOGGER.debug(format);
            }
        }
        finally {
            this.clearMDC();
        }
    }

    @Override
    public void trace(Object msg) {
        if (!this.isTraceEnabled()) {
            return;
        }
        try {
            this.setMDC();
            LOGGER.trace(String.valueOf(msg));
        }
        finally {
            this.clearMDC();
        }
    }

    @Override
    public void trace(String format, Object ... args) {
        if (!this.isTraceEnabled()) {
            return;
        }
        try {
            this.setMDC();
            if (args.length > 0) {
                LOGGER.trace(String.format(format, args));
            } else {
                LOGGER.trace(format);
            }
        }
        finally {
            this.clearMDC();
        }
    }

    @Override
    public void warn(Object msg) {
        try {
            this.setMDC();
            LOGGER.warn(String.valueOf(msg));
        }
        finally {
            this.clearMDC();
        }
    }

    @Override
    public void warn(String format, Object ... args) {
        try {
            this.setMDC();
            if (args.length > 0) {
                LOGGER.warn(String.format(format, args));
            } else {
                LOGGER.warn(format);
            }
        }
        finally {
            this.clearMDC();
        }
    }

    @Override
    public void warn(String msg, Throwable e) {
        try {
            this.setMDC();
            LOGGER.warn(msg, e);
        }
        finally {
            this.clearMDC();
        }
    }

    @Override
    public void error(Object msg) {
        try {
            this.setMDC();
            LOGGER.error(String.valueOf(msg));
        }
        finally {
            this.clearMDC();
        }
    }

    @Override
    public void error(String format, Object ... args) {
        try {
            this.setMDC();
            if (args.length > 0) {
                LOGGER.error(String.format(format, args));
            } else {
                LOGGER.error(format);
            }
        }
        finally {
            this.clearMDC();
        }
    }

    @Override
    public void error(String msg, Throwable e) {
        try {
            this.setMDC();
            LOGGER.error(msg, e);
        }
        finally {
            this.clearMDC();
        }
    }

    @Override
    public void error(Throwable e) {
        try {
            this.setMDC();
            LOGGER.warn(e.toString(), e);
        }
        finally {
            this.clearMDC();
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    private void setMDC() {
        StackTraceElement caller = SOSSlf4jLogger.findCaller();
        if (caller != null) {
            MDC.put((String)"F", (String)caller.getFileName());
            MDC.put((String)"L", (String)String.valueOf(caller.getLineNumber()));
        }
    }

    private void clearMDC() {
        MDC.clear();
    }

    private static StackTraceElement findCaller() {
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        for (int i = 2; i < st.length; ++i) {
            StackTraceElement e = st[i];
            String cn = e.getClassName();
            if (cn.equals(LOGGER_CLASS_NAME) || cn.startsWith(THREAD_CLASS_NAME)) continue;
            return e;
        }
        return null;
    }
}

