/*
 * Decompiled with CFR 0.152.
 */
package js7.base.crypt.x509;

import cats.Show;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import js7.base.Problems$MessageSignedByUnknownProblem$;
import js7.base.Problems$TamperedWithSignedMessageProblem$;
import js7.base.auth.DistinguishedName;
import js7.base.auth.DistinguishedName$;
import js7.base.crypt.GenericSignature;
import js7.base.crypt.SignatureVerifier;
import js7.base.crypt.SignerId;
import js7.base.crypt.SignerId$;
import js7.base.crypt.x509.X509Cert;
import js7.base.crypt.x509.X509Cert$;
import js7.base.crypt.x509.X509Signature;
import js7.base.crypt.x509.X509SignatureVerifier$;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.Labeled;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichPartialFunction$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class X509SignatureVerifier
implements SignatureVerifier {
    private final Seq<X509Cert> trustedCertificates;
    private final Seq<X509Cert> trustedRootCertificates;
    private final Map<DistinguishedName, X509Cert> signerDNToTrustedCertificate;
    private final String publicKeyOrigin;

    public static Either<Problem, X509SignatureVerifier> checked(Seq<Labeled<ByteArray>> seq, String string) {
        return X509SignatureVerifier$.MODULE$.checked(seq, string);
    }

    public static String filenameExtension() {
        return X509SignatureVerifier$.MODULE$.filenameExtension();
    }

    public static Either<Problem, X509Signature> genericSignatureToSignature(GenericSignature genericSignature) {
        return X509SignatureVerifier$.MODULE$.genericSignatureToSignature(genericSignature);
    }

    public static X509SignatureVerifier ignoreInvalid(Seq<Labeled<ByteArray>> seq, String string) {
        return X509SignatureVerifier$.MODULE$.ignoreInvalid((Seq)seq, string);
    }

    public static String recommendedKeyDirectoryName() {
        return X509SignatureVerifier$.MODULE$.recommendedKeyDirectoryName();
    }

    public static String typeName() {
        return X509SignatureVerifier$.MODULE$.typeName();
    }

    public static Show<X509Certificate> x509CertificateShow() {
        return X509SignatureVerifier$.MODULE$.x509CertificateShow();
    }

    public static String checked$default$2() {
        return X509SignatureVerifier$.MODULE$.checked$default$2();
    }

    public X509SignatureVerifier(Seq<X509Cert> trustedCertificates, Seq<X509Cert> trustedRootCertificates, Map<DistinguishedName, X509Cert> signerDNToTrustedCertificate, String publicKeyOrigin) {
        this.trustedCertificates = trustedCertificates;
        this.trustedRootCertificates = trustedRootCertificates;
        this.signerDNToTrustedCertificate = signerDNToTrustedCertificate;
        this.publicKeyOrigin = publicKeyOrigin;
    }

    @Override
    public String publicKeyOrigin() {
        return this.publicKeyOrigin;
    }

    @Override
    public X509SignatureVerifier$ companion() {
        return X509SignatureVerifier$.MODULE$;
    }

    @Override
    public Seq<String> publicKeys() {
        return (Seq)this.trustedCertificates.map((Function1 & Serializable)o -> X509Cert$.MODULE$.CertificatePem().toPem(ByteArray$.MODULE$.unsafeWrap(o.x509Certificate().getEncoded())));
    }

    @Override
    public Seq<String> publicKeysToStrings() {
        return (Seq)((SeqOps)new .colon.colon((Object)("X.509 origin=" + this.publicKeyOrigin()), (List)Nil$.MODULE$)).$plus$plus((IterableOnce)this.trustedCertificates.map((Function1 & Serializable)o -> "  " + o.toLongString()));
    }

    public Either<Problem, Seq<SignerId>> verify(ByteArray document, X509Signature signature) {
        Either<SignerId, X509Cert> either = signature.signerIdOrCertificate();
        if (either instanceof Left) {
            SignerId signerId = (SignerId)((Left)either).value();
            return DistinguishedName$.MODULE$.checked(signerId.string()).flatMap((Function1 & Serializable)dn -> {
                PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.signerDNToTrustedCertificate);
                return ScalaUtils$syntax$RichPartialFunction$.MODULE$.rightOr$extension(partialFunction, dn, (Function0<Problem>)((Function0 & Serializable)() -> X509SignatureVerifier.verify$$anonfun$1$$anonfun$1(signerId)));
            }).flatMap((Function1 & Serializable)trustedCertificate -> this.verifySignature(document, signature, (X509Cert)trustedCertificate).map((Function1 & Serializable)_$1 -> package$.MODULE$.Nil().$colon$colon(_$1)));
        }
        if (either instanceof Right) {
            X509Cert signerCertificate = (X509Cert)((Right)either).value();
            return Checked$.MODULE$.catchNonFatalFlatten(() -> this.verify$$anonfun$3(document, signature, signerCertificate));
        }
        throw new MatchError(either);
    }

    private Either<Problem, SignerId> verifySignature(ByteArray document, X509Signature signature, X509Cert cert) {
        return Checked$.MODULE$.catchNonFatalFlatten(() -> X509SignatureVerifier.verifySignature$$anonfun$1(signature, cert, document));
    }

    private Either<Problem, BoxedUnit> verifySignersCertificate(X509Cert signatureCertificate, PublicKey publicKey) {
        Right right;
        try {
            signatureCertificate.x509Certificate().verify(publicKey);
            right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                Throwable t = throwable3;
                Throwable throwable4 = t;
                if (throwable4 instanceof SignatureException) {
                    Logger LoggerImpl_this = X509SignatureVerifier$.js7$base$crypt$x509$X509SignatureVerifier$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        Throwable throwable5 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                        LoggerImpl_this.underlying().debug(ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable5));
                    }
                } else {
                    Logger LoggerImpl_this = X509SignatureVerifier$.js7$base$crypt$x509$X509SignatureVerifier$$$logger;
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        LoggerImpl_this.underlying().warn(t.toString());
                    }
                }
                right = package$.MODULE$.Left().apply((Object)Problems$MessageSignedByUnknownProblem$.MODULE$);
            }
            throw throwable;
        }
        return right;
    }

    private static final String verify$$anonfun$1$$anonfun$1$$anonfun$1(SignerId signerId$3) {
        return "The signature's SignerId is unknown: " + signerId$3.string();
    }

    private static final Problem verify$$anonfun$1$$anonfun$1(SignerId signerId$2) {
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> X509SignatureVerifier.verify$$anonfun$1$$anonfun$1$$anonfun$1(signerId$2)), Problem$.MODULE$.apply$default$2());
    }

    private final Either verify$$anonfun$3(ByteArray document$2, X509Signature signature$2, X509Cert signerCertificate$1) {
        Option option = ScalaUtils$syntax$.MODULE$.takeThrough(this.trustedRootCertificates.iterator().map((Function1 & Serializable)rootCert -> this.verifySignature(document$2, signature$2, signerCertificate$1).flatMap((Function1 & Serializable)signerId -> this.verifySignersCertificate(signerCertificate$1, rootCert.x509Certificate().getPublicKey()).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return signerId;
        }))), (Function1 & Serializable)_$2 -> _$2.isLeft()).toVector().lastOption();
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)Problems$MessageSignedByUnknownProblem$.MODULE$);
        }
        if (option instanceof Some) {
            Either checkedSignerId = (Either)((Some)option).value();
            return checkedSignerId.map((Function1 & Serializable)_$3 -> package$.MODULE$.Nil().$colon$colon(_$3));
        }
        throw new MatchError((Object)option);
    }

    private static final Either verifySignature$$anonfun$1(X509Signature signature$4, X509Cert cert$1, ByteArray document$4) {
        Signature sig = Signature.getInstance(signature$4.algorithm().string());
        sig.initVerify(cert$1.x509Certificate().getPublicKey());
        sig.update(document$4.unsafeArray());
        boolean verified = sig.verify(signature$4.byteArray().unsafeArray());
        if (!verified) {
            return package$.MODULE$.Left().apply((Object)Problems$TamperedWithSignedMessageProblem$.MODULE$);
        }
        return package$.MODULE$.Right().apply((Object)SignerId$.MODULE$.apply(cert$1.x509Certificate().getSubjectX500Principal().toString()));
    }
}

