/*
 * Decompiled with CFR 0.152.
 */
package js7.base.io;

import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.effect.kernel.Resource;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.data.ByteSequence;
import js7.base.data.Writable;
import js7.base.io.JavaResource$;
import js7.base.io.JavaResource$UnknownJavaResourceProblem$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.problem.Problem;
import js7.base.problem.ProblemCode;
import js7.base.utils.AutoClosing$;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;

public final class JavaResource
implements Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JavaResource.class.getDeclaredField("checkedUrl$lzy1"));
    private final ClassLoader classLoader;
    private final String path;
    private volatile Object checkedUrl$lzy1;
    private final Resource<SyncIO, InputStream> asResource;

    public static JavaResource apply(ClassLoader classLoader, String string) {
        return JavaResource$.MODULE$.apply(classLoader, string);
    }

    public static JavaResource apply(String string) {
        return JavaResource$.MODULE$.apply(string);
    }

    public static JavaResource fromProduct(Product product) {
        return JavaResource$.MODULE$.fromProduct(product);
    }

    public static JavaResource unapply(JavaResource javaResource) {
        return JavaResource$.MODULE$.unapply(javaResource);
    }

    public static Writable<JavaResource> writable() {
        return JavaResource$.MODULE$.writable();
    }

    public JavaResource(ClassLoader classLoader, String path) {
        this.classLoader = classLoader;
        this.path = path;
        Objects.requireNonNull(classLoader);
        Predef$.MODULE$.require(!path.startsWith("/"), () -> JavaResource.$init$$$anonfun$1(path));
        this.asResource = cats.effect.package$.MODULE$.Resource().fromAutoCloseable((Object)SyncIO$.MODULE$.apply(this::$init$$$anonfun$2), SyncIO$.MODULE$.syncForSyncIO());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof JavaResource)) return false;
        JavaResource javaResource = (JavaResource)object;
        ClassLoader classLoader = this.classLoader();
        ClassLoader classLoader2 = javaResource.classLoader();
        if (classLoader == null) {
            if (classLoader2 != null) {
                return false;
            }
        } else if (!classLoader.equals(classLoader2)) return false;
        String string = this.path();
        String string2 = javaResource.path();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof JavaResource;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "JavaResource";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "classLoader";
        }
        if (1 == n2) {
            return "path";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public String path() {
        return this.path;
    }

    private Either<Problem, URL> checkedUrl() {
        Object object = this.checkedUrl$lzy1;
        if (object instanceof Either) {
            return (Either)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Either)this.checkedUrl$lzyINIT1();
    }

    private Object checkedUrl$lzyINIT1() {
        Object object;
        block9: {
            while (true) {
                if ((object = this.checkedUrl$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Right right = null;
                    try {
                        URL uRL = this.classLoader().getResource(this.path());
                        if (uRL == null) {
                            v0 = package$.MODULE$.Left().apply((Object)JavaResource$UnknownJavaResourceProblem$.MODULE$.apply(this.path()));
                        } else {
                            URL url = uRL;
                            v0 = right = package$.MODULE$.Right().apply((Object)url);
                        }
                        object2 = right == null ? LazyVals.NullValue$.MODULE$ : right;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.checkedUrl$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.checkedUrl$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return right;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block9;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean exists() {
        return !this.checkedUrl().left().exists((Function1 & Serializable)_$1 -> _$1 instanceof UnknownJavaResourceProblem);
    }

    public JavaResource requireExistence() {
        this.url();
        return this;
    }

    public Seq<Path> copyToFiles(Iterable<String> resourceNames, Path directory, Seq<CopyOption> copyOptions) {
        Iterable resourcePathAndDllFiles = (Iterable)resourceNames.map((Function1 & Serializable)name -> Tuple2$.MODULE$.apply((Object)this.$div((String)name), (Object)directory.resolve((String)name)));
        resourcePathAndDllFiles.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            JavaResource resourcePath = (JavaResource)tuple2._1();
            Path file = (Path)tuple2._2();
            return resourcePath.copyToFile(file, copyOptions);
        });
        return (Seq)resourcePathAndDllFiles.toVector().map((Function1 & Serializable)_$2 -> (Path)_$2._2());
    }

    public Path copyToFile(Path file, Seq<CopyOption> copyOptions) {
        AutoClosing$.MODULE$.autoClosing(this.openStream(), (Function1 & Serializable)in -> Files.copy(in, file, (CopyOption[])Arrays$.MODULE$.seqToArray(copyOptions, CopyOption.class)));
        return file;
    }

    public void writeToStream(OutputStream out) {
        AutoClosing$.MODULE$.autoClosing(this.openStream(), (Function1 & Serializable)_$3 -> _$3.transferTo(out));
    }

    public byte[] contentBytes() {
        return ((ByteArray)this.readAs(ByteArray$.MODULE$.implicitByteSequence())).unsafeArray();
    }

    public <ByteSeq> ByteSeq readAs(ByteSequence<ByteSeq> ByteSeq) {
        return (ByteSeq)AutoClosing$.MODULE$.autoClosing(this.openStream(), (Function1 & Serializable)in -> ByteSeq.fromInputStreamUnlimited((InputStream)in));
    }

    public String asUTF8String() {
        return ((ByteArray)this.readAs(ByteArray$.MODULE$.implicitByteSequence())).utf8String();
    }

    public Properties toProperties() {
        Properties props = new Properties();
        try (InputStream in = this.openStream();){
            props.load(in);
        }
        return props;
    }

    public String simpleName() {
        return new File(this.path()).getName();
    }

    public boolean isValid() {
        return this.checkedUrl().isRight();
    }

    public Resource<SyncIO, InputStream> asResource() {
        return this.asResource;
    }

    public InputStream openStream() {
        return this.url().openStream();
    }

    public URI uri() {
        return this.url().toURI();
    }

    public URL url() {
        Either either = Checked$.MODULE$.Ops(this.checkedUrl());
        return (URL)Checked$Ops$.MODULE$.orThrow$extension(either);
    }

    public JavaResource $div(String tail) {
        String string = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.path()), "/") + "/" + tail;
        ClassLoader classLoader = this.copy$default$1();
        return this.copy(classLoader, string);
    }

    public String toString() {
        return this.path();
    }

    public JavaResource copy(ClassLoader classLoader, String path) {
        return new JavaResource(classLoader, path);
    }

    public ClassLoader copy$default$1() {
        return this.classLoader();
    }

    public String copy$default$2() {
        return this.path();
    }

    public ClassLoader _1() {
        return this.classLoader();
    }

    public String _2() {
        return this.path();
    }

    private static final Object $init$$$anonfun$1(String path$2) {
        return "JavaResource must not start with a slash: " + path$2;
    }

    private final InputStream $init$$$anonfun$2() {
        return this.openStream();
    }

    public static final class UnknownJavaResourceProblem
    implements Problem,
    Problem.Simple,
    Problem.HasCode,
    Problem.Coded,
    Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(UnknownJavaResourceProblem.class.getDeclaredField("message$lzy1"));
        private volatile Object message$lzy1;
        private ProblemCode code;
        private final String path;

        public static UnknownJavaResourceProblem apply(String string) {
            return JavaResource$UnknownJavaResourceProblem$.MODULE$.apply(string);
        }

        public static UnknownJavaResourceProblem fromProduct(Product product) {
            return JavaResource$UnknownJavaResourceProblem$.MODULE$.fromProduct(product);
        }

        public static UnknownJavaResourceProblem unapply(UnknownJavaResourceProblem unknownJavaResourceProblem) {
            return JavaResource$UnknownJavaResourceProblem$.MODULE$.unapply(unknownJavaResourceProblem);
        }

        public UnknownJavaResourceProblem(String path) {
            this.path = path;
            Problem.Simple.$init$(this);
            Problem.Coded.$init$(this);
            Statics.releaseFence();
        }

        @Override
        public final String message() {
            Object object = this.message$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.message$lzyINIT1();
        }

        private Object message$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.message$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = Problem.Simple.message$(this);
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.message$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public ProblemCode code() {
            return this.code;
        }

        @Override
        public void js7$base$problem$Problem$Coded$_setter_$code_$eq(ProblemCode x$0) {
            this.code = x$0;
        }

        public boolean canEqual(Object that) {
            return that instanceof UnknownJavaResourceProblem;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UnknownJavaResourceProblem";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String path() {
            return this.path;
        }

        @Override
        public Map<String, String> arguments() {
            return new Map.Map1((Object)"path", (Object)this.path());
        }

        public UnknownJavaResourceProblem copy(String path) {
            return new UnknownJavaResourceProblem(path);
        }

        public String copy$default$1() {
            return this.path();
        }

        public String _1() {
            return this.path();
        }
    }
}

