/*
 * Decompiled with CFR 0.152.
 */
package js7.base.io.file;

import cats.Functor;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import com.typesafe.scalalogging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import js7.base.data.Writable;
import js7.base.data.Writable$ops$;
import js7.base.io.file.FileDeleter$;
import js7.base.io.file.FileUtils$implicits$;
import js7.base.io.file.FileUtils$syntax$;
import js7.base.io.file.FileUtils$syntax$RichPath$;
import js7.base.log.Logger$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.AutoClosing$;
import js7.base.utils.Closer;
import js7.base.utils.Closer$;
import js7.base.utils.Closer$syntax$;
import js7.base.utils.Closer$syntax$RichClosersAny$;
import js7.base.utils.JavaCollections$syntax$;
import js7.base.utils.JavaCollections$syntax$JavaStreamToScala$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Factory;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

public final class FileUtils$
implements Serializable {
    private static final Logger logger;
    private static final Path EmptyPath;
    private static final Path WorkingDirectory;
    public static final FileUtils$implicits$ implicits;
    public static final FileUtils$syntax$ syntax;
    private static final String FilenameCharacterSet;
    private static final int ShortNameSize;
    private static final long ShortNamePermutationCount;
    private static final UnanchoredRegex RelativePathRegex;
    public static final FileUtils$ MODULE$;

    private FileUtils$() {
    }

    static {
        MODULE$ = new FileUtils$();
        logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(FileUtils$.class));
        EmptyPath = Paths.get("", new String[0]);
        WorkingDirectory = Paths.get((String)scala.sys.package$.MODULE$.props().apply((Object)"user.dir"), new String[0]).toAbsolutePath();
        FilenameCharacterSet = "abcdefghijklmnopqrstuvwxyz0123456789";
        ShortNameSize = 6;
        ShortNamePermutationCount = BoxesRunTime.unboxToLong((Object)package$.MODULE$.List().fill(MODULE$.ShortNameSize(), MODULE$::$init$$$anonfun$1).product((Numeric)Numeric.LongIsIntegral$.MODULE$));
        RelativePathRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(/|\\\\|..?/|..?\\\\)|([/\\\\]..?([/\\\\]|$))")).unanchored();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileUtils$.class);
    }

    public Path EmptyPath() {
        return EmptyPath;
    }

    public Path WorkingDirectory() {
        return WorkingDirectory;
    }

    public Path temporaryDirectory() {
        return Paths.get((String)scala.sys.package$.MODULE$.props().apply((Object)"java.io.tmpdir"), new String[0]);
    }

    public <A extends Path> Path touchAndDeleteWithCloser(A path, Closer closer) {
        this.touchFile(path);
        Path path2 = (Path)Closer$syntax$.MODULE$.RichClosersAny(path);
        Closer$syntax$RichClosersAny$.MODULE$.withCloser$extension(path2, (JProcedure1 & Serializable)x$0 -> Files.delete(x$0), closer);
        return path;
    }

    public void touchFile(Path path) {
        File file = path.toFile();
        if (!file.createNewFile() && !file.setLastModified(System.currentTimeMillis())) {
            throw new IOException("touchFile file: unable to update modification time of " + file);
        }
    }

    public void copyDirectoryContent(Path from, Path to, Seq<CopyOption> options) {
        if (!Files.exists(to, new LinkOption[0])) {
            Files.createDirectory(to, new FileAttribute[0]);
        }
        AutoClosing$.MODULE$.autoClosing(Files.list(from), (JProcedure1 & Serializable)stream -> {
            Stream stream2 = JavaCollections$syntax$.MODULE$.JavaStreamToScala(stream);
            JavaCollections$syntax$JavaStreamToScala$.MODULE$.asScala$extension(stream2).foreach((Function1 & Serializable)file -> {
                Path destination = to.resolve(file.getFileName());
                if (Files.isDirectory(file, new LinkOption[0])) {
                    MODULE$.copyDirectoryContent((Path)file, destination, (Seq<CopyOption>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CopyOption[0]));
                    return BoxedUnit.UNIT;
                }
                return Files.copy(file, destination, (CopyOption[])Arrays$.MODULE$.seqToArray(options, CopyOption.class));
            });
        });
    }

    public Path createShortNamedDirectory(Path directory, String prefix) {
        Path path;
        while (true) {
            try {
                path = Files.createDirectory(FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(directory), prefix + this.newRandomFilenameString()), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            break;
        }
        return path;
    }

    public int ShortNameSize() {
        return ShortNameSize;
    }

    public long ShortNamePermutationCount() {
        return ShortNamePermutationCount;
    }

    private String newRandomFilenameString() {
        return package$.MODULE$.Iterator().fill(this.ShortNameSize(), FileUtils$::newRandomFilenameString$$anonfun$1).map((Function1)Predef$.MODULE$.wrapString(FilenameCharacterSet)).mkString();
    }

    public <A> A withTemporaryFile(Function1<Path, A> body) {
        return this.withTemporaryFile("", ".tmp", (Seq<FileAttribute<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FileAttribute[0]), body);
    }

    public <A> A withTemporaryFile(String prefix, String suffix, Seq<FileAttribute<?>> attributes, Function1<Path, A> body) {
        return this.autoDeleting(Files.createTempFile(prefix, suffix, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes, FileAttribute.class)), body);
    }

    public <F> Resource<F, Path> temporaryFileResource(String prefix, String suffix, Seq<FileAttribute<?>> attributes, Sync<F> F) {
        return cats.effect.package$.MODULE$.Resource().make(F.delay(() -> FileUtils$.temporaryFileResource$$anonfun$1(prefix, suffix, attributes)), (Function1 & Serializable)file -> F.delay((Function0 & Serializable)() -> {
            FileUtils$.temporaryFileResource$$anonfun$2$$anonfun$1(file);
            return BoxedUnit.UNIT;
        }), F);
    }

    public <F> String temporaryFileResource$default$1() {
        return "";
    }

    public <F> String temporaryFileResource$default$2() {
        return ".tmp";
    }

    public Resource<IO, Path> temporaryFileResource(Path directory, String prefix, String suffix, Seq<FileAttribute<?>> attributes) {
        return cats.effect.package$.MODULE$.Resource().make((Object)IO$.MODULE$.apply(() -> FileUtils$.temporaryFileResource$$anonfun$3(directory, prefix, suffix, attributes)), (Function1 & Serializable)file -> IO$.MODULE$.interruptible((Function0 & Serializable)() -> {
            FileUtils$.temporaryFileResource$$anonfun$4$$anonfun$1(file);
            return BoxedUnit.UNIT;
        }), (Functor)IO$.MODULE$.asyncForIO());
    }

    public <A> A autoDeleting(Path file, Function1<Path, A> body) {
        return Closer$.MODULE$.withCloser((Function1 & Serializable)closer -> {
            closer.onClose((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                FileUtils$.autoDeleting$$anonfun$1$$anonfun$1(file);
                return BoxedUnit.UNIT;
            });
            return body.apply((Object)file);
        });
    }

    public <A> A withTemporaryDirectory(String prefix, Function1<Path, A> body) {
        Path dir = Files.createTempDirectory(prefix, new FileAttribute[0]);
        return Closer$.MODULE$.withCloser((Function1 & Serializable)closer -> {
            closer.onClose((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                FileUtils$.withTemporaryDirectory$$anonfun$1$$anonfun$1(dir);
                return BoxedUnit.UNIT;
            });
            return body.apply((Object)dir);
        });
    }

    public <A> String withTemporaryDirectory$default$1() {
        return "";
    }

    public <F> Resource<F, Path> temporaryDirectoryResource(String prefix, Sync<F> F) {
        return cats.effect.package$.MODULE$.Resource().make(F.delay(() -> FileUtils$.temporaryDirectoryResource$$anonfun$1(prefix)), (Function1 & Serializable)dir -> F.delay((Function0 & Serializable)() -> {
            FileUtils$.temporaryDirectoryResource$$anonfun$2$$anonfun$1(dir);
            return BoxedUnit.UNIT;
        }), F);
    }

    public <F> Resource<F, Path> provideFile(Path file, Sync<F> F) {
        return cats.effect.package$.MODULE$.Resource().make(F.delay(() -> FileUtils$.provideFile$$anonfun$1(file)), (Function1 & Serializable)_$8 -> F.delay((Function0 & Serializable)() -> {
            FileUtils$.provideFile$$anonfun$2$$anonfun$1(file);
            return BoxedUnit.UNIT;
        }), F);
    }

    public void deleteDirectoryRecursively(Path dir) {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Not a directory: " + dir);
        }
        if (!Files.isSymbolicLink(dir)) {
            this.deleteDirectoryContentRecursively(dir);
        }
        this.loggingDelete(dir);
    }

    public void deleteDirectoryContentRecursively(Path dir) {
        FileUtils$syntax$RichPath$.MODULE$.directoryContents$extension(FileUtils$syntax$.MODULE$.RichPath(dir)).foreach((Function1)(JProcedure1 & Serializable)f -> {
            if (Files.isDirectory(f, new LinkOption[0]) && !Files.isSymbolicLink(f)) {
                MODULE$.deleteDirectoryContentRecursively((Path)f);
            }
            MODULE$.loggingDelete((Path)f);
        });
    }

    public void tryDeleteDirectoryContentRecursively(Path dir) {
        FileUtils$syntax$RichPath$.MODULE$.directoryContents$extension(FileUtils$syntax$.MODULE$.RichPath(dir)).foreach((Function1)(JProcedure1 & Serializable)f -> {
            if (Files.isDirectory(f, new LinkOption[0]) && !Files.isSymbolicLink(f)) {
                MODULE$.deleteDirectoryContentRecursively((Path)f);
            }
            try {
                MODULE$.loggingDelete((Path)f);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    Logger LoggerImpl_this = logger;
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = f;
                        Throwable throwable4 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                        objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable4);
                        LoggerImpl_this.underlying().warn("Delete {} => {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
                    }
                }
                throw throwable;
            }
        });
    }

    private void loggingDelete(Path file) {
        Files.delete(file);
        Logger LoggerImpl_this = logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("Deleted file {}", (Object)file);
            return;
        }
    }

    public AutoCloseable nestedPathsIterator(Path directory, Seq<FileVisitOption> options) {
        return new AutoCloseable(directory, options){
            private final Stream javaStream;
            private final Iterator underlyingIterator;
            {
                this.javaStream = Files.walk(directory$2, (FileVisitOption[])Arrays$.MODULE$.seqToArray(options$3, FileVisitOption.class));
                Stream stream = JavaCollections$syntax$.MODULE$.JavaStreamToScala(this.javaStream);
                this.underlyingIterator = JavaCollections$syntax$JavaStreamToScala$.MODULE$.asScala$extension(stream);
            }

            public void close() {
                this.javaStream.close();
            }

            public boolean hasNext() {
                return this.underlyingIterator.hasNext();
            }

            public Path next() {
                return (Path)this.underlyingIterator.next();
            }
        };
    }

    public Either<Problem, String> checkRelativePath(String path) {
        if (path.isEmpty()) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)FileUtils$::checkRelativePath$$anonfun$1), Problem$.MODULE$.apply$default$2()));
        }
        if (((Regex)RelativePathRegex).pattern().matcher(path).find()) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> FileUtils$.checkRelativePath$$anonfun$2(path)), Problem$.MODULE$.apply$default$2()));
        }
        return package$.MODULE$.Right().apply((Object)path);
    }

    private final long $init$$$anonfun$1() {
        return Predef$.MODULE$.wrapString(FilenameCharacterSet).toSet().size();
    }

    public static final /* synthetic */ void js7$base$io$file$FileUtils$syntax$RichPath$$$_$write$extension$$anonfun$1(Object writable$1, Writable evidence$1$1, BufferedOutputStream _$1) {
        Writable$ops$.MODULE$.toAllWritableOps(writable$1, evidence$1$1).writeToStream(_$1);
    }

    public static final /* synthetic */ void js7$base$io$file$FileUtils$syntax$RichPath$$$_$$plus$plus$eq$extension$$anonfun$1(Object writable$2, Writable evidence$1$2, BufferedOutputStream _$2) {
        Writable$ops$.MODULE$.toAllWritableOps(writable$2, evidence$1$2).writeToStream(_$2);
    }

    public static final BufferedInputStream js7$base$io$file$FileUtils$syntax$RichPath$$$_$inputStreamResource$extension$$anonfun$1(Path $this$1) {
        return new BufferedInputStream(new FileInputStream($this$1.toFile()));
    }

    public static final /* synthetic */ Object js7$base$io$file$FileUtils$syntax$RichPath$$$_$directoryContentsAs$extension$$anonfun$1(Factory factory$1, Stream _$4) {
        Stream stream = JavaCollections$syntax$.MODULE$.JavaStreamToScala(_$4);
        return JavaCollections$syntax$JavaStreamToScala$.MODULE$.asScala$extension(stream).to(factory$1);
    }

    private static final int newRandomFilenameString$$anonfun$1() {
        return ThreadLocalRandom.current().nextInt(FilenameCharacterSet.length());
    }

    private static final Path temporaryFileResource$$anonfun$1(String prefix$1, String suffix$1, Seq attributes$1) {
        return Files.createTempFile(prefix$1, suffix$1, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes$1, FileAttribute.class));
    }

    private static final void temporaryFileResource$$anonfun$2$$anonfun$1(Path file$1) {
        Files.deleteIfExists(file$1);
    }

    private static final Path temporaryFileResource$$anonfun$3(Path directory$1, String prefix$2, String suffix$2, Seq attributes$2) {
        return Files.createTempFile(directory$1, prefix$2, suffix$2, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes$2, FileAttribute.class));
    }

    private static final void temporaryFileResource$$anonfun$4$$anonfun$1(Path file$2) {
        FileDeleter$.MODULE$.tryDeleteFile(file$2);
    }

    private static final void autoDeleting$$anonfun$1$$anonfun$1(Path file$4) {
        Files.deleteIfExists(file$4);
    }

    private static final void withTemporaryDirectory$$anonfun$1$$anonfun$1(Path dir$2) {
        MODULE$.deleteDirectoryRecursively(dir$2);
    }

    private static final Path temporaryDirectoryResource$$anonfun$1(String prefix$3) {
        return Files.createTempDirectory(prefix$3, new FileAttribute[0]);
    }

    private static final void temporaryDirectoryResource$$anonfun$2$$anonfun$1(Path dir$3) {
        MODULE$.deleteDirectoryRecursively(dir$3);
    }

    private static final Path provideFile$$anonfun$1(Path file$5) {
        Files.deleteIfExists(file$5);
        return file$5;
    }

    private static final void provideFile$$anonfun$2$$anonfun$1(Path file$7) {
        block2: {
            try {
                Files.deleteIfExists(file$7);
            }
            catch (IOException t) {
                Logger LoggerImpl_this = logger;
                if (!LoggerImpl_this.underlying().isErrorEnabled()) break block2;
                LoggerImpl_this.underlying().error("Delete {} => {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{file$7, t}), Object.class));
            }
        }
    }

    private static final String checkRelativePath$$anonfun$1() {
        return "Relative file path must not be empty";
    }

    private static final String checkRelativePath$$anonfun$2(String path$1) {
        return "Not a valid relative file path: " + path$1;
    }
}

