/*
 * Decompiled with CFR 0.152.
 */
package js7.base.time;

import cats.effect.IO;
import cats.effect.unsafe.Scheduler;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichLong$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.TestScheduler$;
import js7.base.time.TestScheduler$Task$;
import js7.base.time.Timestamp;
import js7.base.time.Timestamp$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.BuildFrom$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven;
import scala.util.Random$;

public final class TestScheduler
implements Scheduler {
    private final SortedSet<Task> queue;
    public volatile long js7$base$time$TestScheduler$$_monotonicNanos;
    public volatile long js7$base$time$TestScheduler$$_wallTimeShift;
    private final AtomicLong nextId;
    public final TestScheduler$Task$ Task$lzy1;

    public static Timestamp $lessinit$greater$default$1() {
        return TestScheduler$.MODULE$.$lessinit$greater$default$1();
    }

    public TestScheduler(Timestamp start) {
        block0: {
            this.Task$lzy1 = new TestScheduler$Task$(this);
            this.queue = (SortedSet)SortedSet$.MODULE$.empty((Object)Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            this.js7$base$time$TestScheduler$$_monotonicNanos = 0L;
            this.js7$base$time$TestScheduler$$_wallTimeShift = start.toEpochMilli();
            this.nextId = new AtomicLong(1L);
            Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
            if (!LoggerImpl_this.underlying().isInfoEnabled()) break block0;
            LoggerImpl_this.underlying().info("new \u23f0 {} _monotonicNanos={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.now(), BoxesRunTime.boxToLong((long)this.js7$base$time$TestScheduler$$_monotonicNanos)}), Object.class));
        }
    }

    public Runnable sleep(FiniteDuration delay, Runnable runnable) {
        long id = this.nextId.getAndIncrement();
        Task task = this.Task().apply(this.js7$base$time$TestScheduler$$_monotonicNanos + delay.toNanos(), id, runnable);
        Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("\u23f0 schedule {}", (Object)task);
        }
        TestScheduler testScheduler = this;
        synchronized (testScheduler) {
            SortedSet cfr_ignored_0 = (SortedSet)this.queue.$plus$eq((Object)task);
        }
        this.logTasks(true);
        return () -> {
            TestScheduler testScheduler = this;
            synchronized (testScheduler) {
                SortedSet cfr_ignored_0 = (SortedSet)this.queue.$minus$eq((Object)task);
            }
        };
    }

    public long monotonicNanos() {
        return this.js7$base$time$TestScheduler$$_monotonicNanos;
    }

    public long nowMillis() {
        long l;
        TestScheduler testScheduler = this;
        synchronized (testScheduler) {
            l = this.js7$base$time$TestScheduler$$_wallTimeShift + this.js7$base$time$TestScheduler$$_monotonicNanos / 1000000L;
        }
        return l;
    }

    public Timestamp now() {
        return Timestamp$.MODULE$.ofEpochMilli(this.nowMillis());
    }

    public <A> A lock(Function0<A> body, NotGiven<.less.colon.less<A, IO<?>>> x$2) {
        Object object;
        TestScheduler testScheduler = this;
        synchronized (testScheduler) {
            object = body.apply();
        }
        return (A)object;
    }

    public void resetNow(Timestamp timestamp) {
        TestScheduler testScheduler = this;
        synchronized (testScheduler) {
            this.js7$base$time$TestScheduler$$_wallTimeShift += timestamp.$minus(this.now()).toMillis();
            Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("resetNow \u23f0 := {}", (Object)this.now());
            }
        }
        this.logTasks(true);
    }

    public void tick(FiniteDuration duration) {
        Vector<Task> vector;
        TestScheduler testScheduler = this;
        synchronized (testScheduler) {
            this.js7$base$time$TestScheduler$$_monotonicNanos += duration.toNanos();
            String plus = ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(ScalaTime$RichFiniteDuration$.MODULE$.isPositive$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration))), (Function0<String>)((Function0 & Serializable)TestScheduler::$anonfun$1));
            Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("\u23f0 := {} {}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.now(), plus, ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration))}), Object.class));
            }
            vector = this.awokenTasks();
        }
        Vector<Task> tasks = vector;
        ((Vector)Random$.MODULE$.shuffle(tasks, BuildFrom$.MODULE$.buildFromIterableOps())).foreach((Function1)(JProcedure1 & Serializable)task -> {
            Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
            if (LoggerImpl_this.underlying().isTraceEnabled()) {
                LoggerImpl_this.underlying().trace("\ud83d\udd14 run {}", task);
            }
            task.runnable().run();
        });
    }

    private Vector<Task> awokenTasks() {
        Task task;
        VectorBuilder tasks = new VectorBuilder();
        long now = this.js7$base$time$TestScheduler$$_monotonicNanos;
        while (this.queue.nonEmpty() && now >= (task = (Task)this.queue.head()).at()) {
            tasks.$plus$eq((Object)task);
            this.queue.remove((Object)task);
        }
        return tasks.result();
    }

    private void logTasks(boolean indent) {
        Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            Vector vector;
            TestScheduler testScheduler = this;
            synchronized (testScheduler) {
                vector = package$.MODULE$.Vector().from(this.queue);
            }
            Vector tasks = vector;
            if (tasks.nonEmpty()) {
                ObjectRef prefix = ObjectRef.create((Object)"");
                ObjectRef lastPrefix = ObjectRef.create((Object)"");
                if (indent) {
                    prefix.elem = "\u251c";
                    lastPrefix.elem = "\u2514";
                }
                Task last = (Task)tasks.last();
                tasks.foreach((Function1)(JProcedure1 & Serializable)task -> {
                    String prfx = task == last ? (String)lastPrefix$1.elem : (String)prefix$1.elem;
                    Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
                    if (LoggerImpl_this.underlying().isTraceEnabled()) {
                        LoggerImpl_this.underlying().trace("{}Task queue: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{prfx, task}), Object.class));
                        return;
                    }
                });
                return;
            }
            return;
        }
    }

    private boolean logTasks$default$1() {
        return false;
    }

    private final TestScheduler$Task$ Task() {
        return this.Task$lzy1;
    }

    private static final String $anonfun$1() {
        return "+";
    }

    public static final String js7$base$time$TestScheduler$Task$$_$_$$anonfun$2() {
        return "+";
    }

    public final class Task
    implements Ordered<Task>,
    Product,
    Serializable {
        private final long at;
        private final long id;
        private final Runnable runnable;
        private final /* synthetic */ TestScheduler $outer;

        public Task(TestScheduler $outer, long at, long id, Runnable runnable) {
            this.at = at;
            this.id = id;
            this.runnable = runnable;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.at()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.id()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.runnable()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Task)) return false;
            if (((Task)object).js7$base$time$TestScheduler$Task$$$outer() != this.$outer) return false;
            Task task = (Task)object;
            if (this.at() != task.at()) return false;
            if (this.id() != task.id()) return false;
            Runnable runnable = this.runnable();
            Runnable runnable2 = task.runnable();
            if (runnable != null) {
                if (!runnable.equals(runnable2)) return false;
                return true;
            }
            if (runnable2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Task;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Task";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "at";
                }
                case 1: {
                    return "id";
                }
                case 2: {
                    return "runnable";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long at() {
            return this.at;
        }

        public long id() {
            return this.id;
        }

        public Runnable runnable() {
            return this.runnable;
        }

        public int compare(Task that) {
            int n = new RichLong(Predef$.MODULE$.longWrapper(this.at())).compare((Object)BoxesRunTime.boxToLong((long)that.at()));
            if (0 == n) {
                return Long.compare(this.id(), that.id());
            }
            int i = n;
            return i;
        }

        public String toString() {
            long current = this.$outer.js7$base$time$TestScheduler$$_monotonicNanos;
            String plus = ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.at() <= current), (Function0<String>)((Function0 & Serializable)TestScheduler::js7$base$time$TestScheduler$Task$$_$_$$anonfun$2));
            return Timestamp$.MODULE$.ofEpochMilli(this.$outer.js7$base$time$TestScheduler$$_wallTimeShift + this.at() / 1000000L) + (" due=" + plus + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$DurationRichLong$.MODULE$.ns$extension(ScalaTime$.MODULE$.DurationRichLong(current - this.at())))) + " " + this.runnable());
        }

        public Task copy(long at, long id, Runnable runnable) {
            return new Task(this.$outer, at, id, runnable);
        }

        public long copy$default$1() {
            return this.at();
        }

        public long copy$default$2() {
            return this.id();
        }

        public Runnable copy$default$3() {
            return this.runnable();
        }

        public long _1() {
            return this.at();
        }

        public long _2() {
            return this.id();
        }

        public Runnable _3() {
            return this.runnable();
        }

        public final /* synthetic */ TestScheduler js7$base$time$TestScheduler$Task$$$outer() {
            return this.$outer;
        }
    }
}

