/*
 * Decompiled with CFR 0.152.
 */
package js7.base.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.utils.Closer$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.sys.package$;
import scala.util.control.NonFatal$;

public final class Closer
implements AutoCloseable {
    private final ConcurrentLinkedDeque<AutoCloseable> stack = new ConcurrentLinkedDeque();
    private final AtomicReference<Throwable> throwable;

    public static void closeOrdered(Seq<AutoCloseable> seq) {
        Closer$.MODULE$.closeOrdered(seq);
    }

    public static <A> A withCloser(Function1<Closer, A> function1) {
        return Closer$.MODULE$.withCloser(function1);
    }

    public Closer() {
        Object initial$proxy1 = null;
        this.throwable = new AtomicReference<Object>(initial$proxy1);
    }

    public void onCloseOrShutdown(Function0<BoxedUnit> body) {
        this.onClose(body);
        this.whenNotClosedAtShutdown(body);
    }

    public void whenNotClosedAtShutdown(Function0<BoxedUnit> body) {
        Thread hook = new Thread(body, this){
            private final Function0 body$1;
            {
                this.body$1 = body$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super("ShutdownHook for " + $outer.toString());
            }

            public void run() {
                this.body$1.apply$mcV$sp();
            }
        };
        package$.MODULE$.runtime().addShutdownHook(hook);
        this.onClose((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            Closer.whenNotClosedAtShutdown$$anonfun$1(hook);
            return BoxedUnit.UNIT;
        });
    }

    public void closeThen(Function0<BoxedUnit> body) {
        Closer c = new Closer();
        c.onClose(body);
        c.register(this);
        c.close();
    }

    public void onClose(Function0<BoxedUnit> closeable) {
        this.register(() -> closeable.apply$mcV$sp());
    }

    public void register(AutoCloseable closeable) {
        this.stack.add(Objects.requireNonNull(closeable));
    }

    @Override
    public void close() {
        while (true) {
            AutoCloseable autoCloseable;
            if ((autoCloseable = this.stack.pollLast()) == null) {
                Throwable throwable = this.throwable.get();
                if (throwable == null) {
                    return;
                }
                if (throwable != null) {
                    Throwable t = throwable;
                    throw t;
                }
                throw new MatchError((Object)throwable);
            }
            AutoCloseable closeable = autoCloseable;
            try {
                closeable.close();
                continue;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable tt;
                    Throwable throwable3 = (Throwable)option.get();
                    Throwable t = throwable3;
                    if (this.throwable.compareAndSet(null, t) || !(!((tt = this.throwable.get()) == null)) || tt == t) continue;
                    Logger LoggerImpl_this = Closer$.js7$base$utils$Closer$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("Throwable.addSuppressed({})", (Object)t);
                    }
                    tt.addSuppressed(t);
                    continue;
                }
                if (throwable2 != null) {
                    Throwable fatal = throwable2;
                    throw fatal;
                }
                throw throwable;
            }
            break;
        }
    }

    private static final void whenNotClosedAtShutdown$$anonfun$1(Thread hook$1) {
        package$.MODULE$.runtime().removeShutdownHook(hook$1);
    }
}

