/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.DeferredSource;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import cats.effect.unsafe.IORuntime;
import com.typesafe.scalalogging.Logger;
import fs2.Stream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.SyncDeadline;
import js7.base.catsutils.SyncDeadline$;
import js7.base.catsutils.SyncDeadline$Now$;
import js7.base.eventbus.EventPublisher;
import js7.base.fs2utils.Fs2PubSub;
import js7.base.log.BlockingSymbol;
import js7.base.log.CorrelId;
import js7.base.log.CorrelId$;
import js7.base.log.LogLevel;
import js7.base.log.LogLevel$;
import js7.base.log.Logger$;
import js7.base.log.Logger$syntax$;
import js7.base.log.Slf4jUtils$syntax$;
import js7.base.log.Slf4jUtils$syntax$LevelLogger$;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.utils.Tests$;
import js7.cluster.ClusterConf;
import js7.cluster.ClusterWatchCounterpart$;
import js7.cluster.ClusterWatchCounterpart$CurrentClusterWatchId$;
import js7.cluster.ClusterWatchCounterpart$TestConfirmed$;
import js7.cluster.ClusterWatchCounterpart$TestWaitingForConfirmation$;
import js7.cluster.ClusterWatchUniquenessChecker;
import js7.cluster.watch.api.ClusterWatchConfirmation;
import js7.cluster.watch.api.ClusterWatchConfirmation$;
import js7.data.Problems$ClusterModuleShuttingDownProblem$;
import js7.data.cluster.ClusterEvent;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterTiming;
import js7.data.cluster.ClusterWatchCheckEvent$;
import js7.data.cluster.ClusterWatchCheckState$;
import js7.data.cluster.ClusterWatchId;
import js7.data.cluster.ClusterWatchProblems$ClusterNodeLossNotConfirmedProblem$;
import js7.data.cluster.ClusterWatchProblems$ClusterWatchIdDoesNotMatchProblem$;
import js7.data.cluster.ClusterWatchProblems$ClusterWatchRequestDoesNotMatchProblem$;
import js7.data.cluster.ClusterWatchProblems$NoClusterWatchProblem$;
import js7.data.cluster.ClusterWatchProblems$OtherClusterWatchStillAliveProblem$;
import js7.data.cluster.ClusterWatchRequest;
import js7.data.cluster.ClusterWatchRequest$RequestId$;
import js7.data.cluster.ClusterWatchingCommand;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Random$;
import scala.util.Right;
import sourcecode.Enclosing$;

public final class ClusterWatchCounterpart
implements Service,
StoppableByRequest,
Service.StoppableByRequest {
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private final Fs2PubSub<IO, ClusterWatchRequest> pubsub;
    private final ClusterConf clusterConf;
    public final ClusterTiming js7$cluster$ClusterWatchCounterpart$$timing;
    private final DeferredSource<IO, BoxedUnit> shuttingDown;
    private final EventPublisher<Object> testEventPublisher;
    private final IORuntime ioRuntime;
    private final AtomicLong nextRequestId;
    private final AsyncLock lock;
    private final AtomicReference<Option<Requested>> _requested;
    private final ClusterWatchUniquenessChecker clusterWatchUniquenessChecker;
    private volatile Option<CurrentClusterWatchId> currentClusterWatchId;
    public final ClusterWatchCounterpart$CurrentClusterWatchId$ CurrentClusterWatchId$lzy1;

    public static Resource<IO, ClusterWatchCounterpart> resource(ClusterConf clusterConf, ClusterTiming clusterTiming, DeferredSource<IO, BoxedUnit> deferredSource, EventPublisher<Object> eventPublisher, IORuntime iORuntime) {
        return ClusterWatchCounterpart$.MODULE$.resource(clusterConf, clusterTiming, deferredSource, eventPublisher, iORuntime);
    }

    public ClusterWatchCounterpart(Fs2PubSub<IO, ClusterWatchRequest> pubsub, ClusterConf clusterConf, ClusterTiming timing, DeferredSource<IO, BoxedUnit> shuttingDown, EventPublisher<Object> testEventPublisher, IORuntime ioRuntime) {
        this.pubsub = pubsub;
        this.clusterConf = clusterConf;
        this.js7$cluster$ClusterWatchCounterpart$$timing = timing;
        this.shuttingDown = shuttingDown;
        this.testEventPublisher = testEventPublisher;
        this.ioRuntime = ioRuntime;
        this.CurrentClusterWatchId$lzy1 = new ClusterWatchCounterpart$CurrentClusterWatchId$(this);
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        long initial$proxy1 = Tests$.MODULE$.isTest() ? 1L : Random$.MODULE$.nextLong(Long.MAX_VALUE - 96000000L / timing.heartbeat().toSeconds()) / 1000000L * 1000000L;
        this.nextRequestId = new AtomicLong(initial$proxy1);
        this.lock = AsyncLock$.MODULE$.apply(Enclosing$.MODULE$.apply("js7.cluster.ClusterWatchCounterpart#lock"));
        None$ initial$proxy2 = None$.MODULE$;
        this._requested = new AtomicReference<None$>(initial$proxy2);
        this.clusterWatchUniquenessChecker = new ClusterWatchUniquenessChecker(clusterConf.clusterWatchUniquenessMemorySize());
        this.currentClusterWatchId = None$.MODULE$;
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    @Override
    public IO<Service.Started> start() {
        return this.startService(this.untilStopRequested());
    }

    public IO<Either<Problem, Option<ClusterWatchConfirmation>>> checkClusterState(ClusterState.HasNodes clusterState, boolean clusterWatchIdChangeAllowed) {
        if (!(clusterState.setting().clusterWatchId().isDefined() || clusterWatchIdChangeAllowed || clusterState instanceof ClusterState.Coupled || clusterState instanceof ClusterState.PassiveLost || clusterState instanceof ClusterState.FailedOver)) {
            return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, None$.MODULE$);
        }
        return this.initializeCurrentClusterWatchId(clusterState).flatMap((Function1 & Serializable)_$1 -> (IO)CorrelId$.MODULE$.use((Function1<CorrelId, Object>)(Function1 & Serializable)correlId -> this.check(clusterState.setting().clusterWatchId(), (Function1<ClusterWatchRequest.RequestId, ClusterWatchRequest>)(Function1 & Serializable)_$2 -> ClusterWatchCheckState$.MODULE$.apply((ClusterWatchRequest.RequestId)_$2, (CorrelId)correlId, this.clusterConf.ownId(), clusterState), clusterWatchIdChangeAllowed, true).map((Function1 & Serializable)_$3 -> _$3.map((Function1 & Serializable)_$4 -> Some$.MODULE$.apply(_$4))), IO$.MODULE$.asyncForIO()));
    }

    private IO<BoxedUnit> initializeCurrentClusterWatchId(ClusterState.HasNodes clusterState) {
        return SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)now -> {
            if (this.currentClusterWatchId.isEmpty()) {
                clusterState.setting().clusterWatchId().foreach((Function1)(JProcedure1 & Serializable)clusterWatchId -> {
                    Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                    if (LoggerImpl_this.underlying().isTraceEnabled()) {
                        LoggerImpl_this.underlying().trace("initializeCurrentClusterWatchId {}", clusterWatchId);
                    }
                    this.currentClusterWatchId = Some$.MODULE$.apply((Object)this.CurrentClusterWatchId().apply((ClusterWatchId)clusterWatchId, (SyncDeadline.Now)now));
                });
                return;
            }
        });
    }

    public IO<Either<Problem, Option<ClusterWatchConfirmation>>> applyEvent(ClusterEvent event, ClusterState.HasNodes clusterState, boolean clusterWatchIdChangeAllowed, boolean forceWhenUntaught) {
        return (IO)CorrelId$.MODULE$.use((Function1<CorrelId, Object>)(Function1 & Serializable)correlId -> {
            ClusterEvent clusterEvent = event;
            if (clusterEvent instanceof ClusterEvent.ClusterNodesAppointed || clusterEvent instanceof ClusterEvent.ClusterCouplingPrepared) {
                if (!clusterState.setting().clusterWatchId().isDefined()) {
                    return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, None$.MODULE$);
                }
            }
            return this.check(clusterState.setting().clusterWatchId(), (Function1<ClusterWatchRequest.RequestId, ClusterWatchRequest>)(Function1 & Serializable)_$5 -> ClusterWatchCheckEvent$.MODULE$.apply((ClusterWatchRequest.RequestId)_$5, (CorrelId)correlId, this.clusterConf.ownId(), event, clusterState, forceWhenUntaught), clusterWatchIdChangeAllowed, this.check$default$4()).map((Function1 & Serializable)_$6 -> _$6.map((Function1 & Serializable)_$7 -> Some$.MODULE$.apply(_$7)));
        }, IO$.MODULE$.asyncForIO());
    }

    public boolean applyEvent$default$3() {
        return false;
    }

    public boolean applyEvent$default$4() {
        return false;
    }

    private IO<Either<Problem, ClusterWatchConfirmation>> check(Option<ClusterWatchId> clusterWatchId, Function1<ClusterWatchRequest.RequestId, ClusterWatchRequest> toRequest, boolean clusterWatchIdChangeAllowed, boolean isHeartbeat) {
        if (!clusterWatchIdChangeAllowed && !clusterWatchId.isDefined()) {
            return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, ClusterWatchProblems$NoClusterWatchProblem$.MODULE$);
        }
        return IO$.MODULE$.defer(() -> this.check$$anonfun$1(toRequest, clusterWatchIdChangeAllowed, isHeartbeat, clusterWatchId));
    }

    private boolean check$default$4() {
        return false;
    }

    private IO<Either<Problem, ClusterWatchConfirmation>> check2(Option<ClusterWatchId> clusterWatchId, ClusterWatchRequest request, Requested requested) {
        return SyncDeadline$.MODULE$.now().flatMap((Function1 & Serializable)since -> IO$.MODULE$.defer(() -> this.check2$$anonfun$1$$anonfun$1(requested, request, clusterWatchId, since)));
    }

    public IO<Either<Problem, BoxedUnit>> executeClusterWatchConfirm(ClusterWatchingCommand.ClusterWatchConfirm confirm) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(() -> this.executeClusterWatchConfirm$$anonfun$1(confirm)));
        IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$8 -> IO$.MODULE$.apply(() -> this.executeClusterWatchConfirm$$anonfun$2$$anonfun$1(confirm)), IO$.MODULE$.asyncForIO()));
        IO iO3 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO2, (Function1 & Serializable)requested -> {
            Problem problem;
            Either<Problem, ClusterWatchConfirmation> confirmation = this.toConfirmation(confirm);
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(requested.request().maybeEvent(), confirmation);
            Option option = (Option)tuple2._1();
            Either either = (Either)tuple2._2();
            if (option instanceof Some && ((Some)option).value() instanceof ClusterEvent.ClusterPassiveLost && either instanceof Left && (problem = (Problem)((Left)either).value()).is(ClusterWatchProblems$ClusterNodeLossNotConfirmedProblem$.MODULE$)) {
                this._requested.compareAndSet((Option<Requested>)None$.MODULE$, (Option<Requested>)Some$.MODULE$.apply(requested));
                Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn(problem.toString());
                }
                return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, BoxedUnit.UNIT);
            }
            confirm.manualConfirmer().foreach((Function1)(JProcedure1 & Serializable)confirmer -> {
                Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("\u203c\ufe0f {} has MANUALLY BEEN CONFIRMED by '{}' \u203c\ufe0f", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{requested.request().maybeEvent().fold(ClusterWatchCounterpart::executeClusterWatchConfirm$$anonfun$3$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$9 -> ScalaUtils$syntax$.MODULE$.RichJavaClass(_$9.getClass()).simpleScalaName()), confirmer}), Object.class));
                    return;
                }
            });
            return requested.confirm(confirmation);
        }, IO$.MODULE$.asyncForIO()));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO3, (Function1 & Serializable)_$10 -> SyncDeadline$.MODULE$.usingNow((Function1 & Serializable)contextual$5 -> {
            this.currentClusterWatchId.foreach((Function1)(JProcedure1 & Serializable)o -> o.touch(confirm.clusterWatchId(), (SyncDeadline.Now)contextual$5));
            return Checked$.MODULE$.unit();
        }), IO$.MODULE$.asyncForIO());
    }

    private Either<Problem, ClusterWatchConfirmation> toConfirmation(ClusterWatchingCommand.ClusterWatchConfirm confirm) {
        return confirm.problem().toLeft(() -> ClusterWatchCounterpart.toConfirmation$$anonfun$1(confirm));
    }

    private Either<Problem, Requested> takeRequest(ClusterWatchingCommand.ClusterWatchConfirm confirm) {
        Option<Requested> option;
        block14: {
            Requested requested;
            Some value;
            do {
                if (None$.MODULE$.equals(option = this._requested.get())) {
                    Logger LoggerImpl_this;
                    Option<CurrentClusterWatchId> option2 = this.currentClusterWatchId;
                    if (option2 instanceof Some) {
                        CurrentClusterWatchId o = (CurrentClusterWatchId)((Some)option2).value();
                        ClusterWatchId clusterWatchId = o.clusterWatchId();
                        ClusterWatchId clusterWatchId2 = confirm.clusterWatchId();
                        if (clusterWatchId == null ? clusterWatchId2 != null : !((Object)clusterWatchId).equals(clusterWatchId2)) {
                            return scala.package$.MODULE$.Left().apply((Object)ClusterWatchProblems$OtherClusterWatchStillAliveProblem$.MODULE$.apply(confirm.clusterWatchId(), o.clusterWatchId()));
                        }
                    }
                    if ((LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger).underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("\u2753 {} confirms, but no request is present", (Object)confirm.clusterWatchId());
                    }
                    return scala.package$.MODULE$.Left().apply((Object)ClusterWatchProblems$ClusterWatchRequestDoesNotMatchProblem$.MODULE$);
                }
                if (!(option instanceof Some)) break block14;
                Some some = (Some)option;
                requested = (Requested)some.value();
                value = some;
                Option<ClusterWatchId> option3 = requested.clusterWatchId();
                if (option3 instanceof Some) {
                    ClusterWatchId o;
                    ClusterWatchId clusterWatchId;
                    ClusterWatchId o2;
                    ClusterWatchId clusterWatchId3 = o2 = (clusterWatchId = (ClusterWatchId)((Some)option3).value());
                    ClusterWatchId clusterWatchId4 = confirm.clusterWatchId();
                    if ((clusterWatchId3 == null ? clusterWatchId4 != null : !((Object)clusterWatchId3).equals(clusterWatchId4)) && this.currentClusterWatchId.exists((Function1 & Serializable)_$11 -> _$11.isStillAlive(SyncDeadline$Now$.MODULE$.given_Now(this.ioRuntime)))) {
                        return scala.package$.MODULE$.Left().apply((Object)ClusterWatchProblems$OtherClusterWatchStillAliveProblem$.MODULE$.apply(confirm.clusterWatchId(), o2));
                    }
                    ClusterWatchId clusterWatchId5 = o = clusterWatchId;
                    ClusterWatchId clusterWatchId6 = confirm.clusterWatchId();
                    if ((clusterWatchId5 == null ? clusterWatchId6 != null : !((Object)clusterWatchId5).equals(clusterWatchId6)) && !confirm.manualConfirmer().isDefined() && !requested.clusterWatchIdChangeAllowed()) {
                        return scala.package$.MODULE$.Left().apply((Object)ClusterWatchProblems$ClusterWatchIdDoesNotMatchProblem$.MODULE$.apply(confirm.clusterWatchId(), o, requested.request()));
                    }
                }
                ClusterWatchRequest.RequestId requestId = confirm.requestId();
                ClusterWatchRequest.RequestId requestId2 = requested.id();
                if (!(requestId == null ? requestId2 != null : !((Object)requestId).equals(requestId2))) continue;
                ClusterWatchProblems$ClusterWatchRequestDoesNotMatchProblem$ problem = ClusterWatchProblems$ClusterWatchRequestDoesNotMatchProblem$.MODULE$;
                Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("\u26d4 {} id={} but _requested={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{problem, confirm.requestId(), requested.id()}), Object.class));
                }
                return scala.package$.MODULE$.Left().apply((Object)problem);
            } while (!this._requested.compareAndSet((Option<Requested>)value, (Option<Requested>)None$.MODULE$));
            Option<ClusterWatchId> option4 = requested.clusterWatchId();
            if (None$.MODULE$.equals(option4)) {
                Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("{} will be registered", (Object)confirm.clusterWatchId());
                }
            } else if (option4 instanceof Some) {
                Logger LoggerImpl_this;
                ClusterWatchId o = (ClusterWatchId)((Some)option4).value();
                ClusterWatchId clusterWatchId = confirm.clusterWatchId();
                ClusterWatchId clusterWatchId7 = o;
                if ((clusterWatchId == null ? clusterWatchId7 != null : !((Object)clusterWatchId).equals(clusterWatchId7)) && (LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger).underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("{} will replace registered {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{confirm.clusterWatchId(), o}), Object.class));
                }
            }
            return scala.package$.MODULE$.Right().apply((Object)requested);
        }
        throw new MatchError(option);
    }

    public IO<BoxedUnit> onClusterWatchRegistered(ClusterWatchId clusterWatchId) {
        return SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)now -> {
            Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
            if (LoggerImpl_this.underlying().isTraceEnabled()) {
                LoggerImpl_this.underlying().trace("onClusterWatchRegistered {}", (Object)clusterWatchId);
            }
            this.currentClusterWatchId = Some$.MODULE$.apply((Object)this.CurrentClusterWatchId().apply(clusterWatchId, (SyncDeadline.Now)now));
        });
    }

    public Stream<IO, ClusterWatchRequest> newStream() {
        return this.pubsub.newStream();
    }

    public String toString() {
        return "ClusterWatchCounterpart";
    }

    private final ClusterWatchCounterpart$CurrentClusterWatchId$ CurrentClusterWatchId() {
        return this.CurrentClusterWatchId$lzy1;
    }

    private static final String check$$anonfun$1$$anonfun$1$$anonfun$1() {
        return ",clusterWatchIdChangeAllowed=false";
    }

    private static final Object check$$anonfun$1$$anonfun$1(ClusterWatchRequest request$1, boolean clusterWatchIdChangeAllowed$5) {
        return request$1 + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(!clusterWatchIdChangeAllowed$5), (Function0<String>)((Function0 & Serializable)ClusterWatchCounterpart::check$$anonfun$1$$anonfun$1$$anonfun$1));
    }

    private final IO check$$anonfun$1(Function1 toRequest$1, boolean clusterWatchIdChangeAllowed$4, boolean isHeartbeat$1, Option clusterWatchId$1) {
        ClusterWatchRequest.RequestId reqId = ClusterWatchRequest$RequestId$.MODULE$.apply(this.nextRequestId.getAndIncrement());
        ClusterWatchRequest request = (ClusterWatchRequest)toRequest$1.apply((Object)reqId);
        return this.lock.lock(Logger$syntax$.MODULE$.traceIOWithResult(ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger, "check", (Function0<Object>)((Function0 & Serializable)() -> ClusterWatchCounterpart.check$$anonfun$1$$anonfun$1(request, clusterWatchIdChangeAllowed$4)), (Function1 & Serializable)a -> {
            if (isHeartbeat$1 && a.isRight()) {
                return "\ud83d\udc9a " + a;
            }
            return a;
        }, isHeartbeat$1 ? Logger$.MODULE$.Heartbeat() : null, this.check2((Option<ClusterWatchId>)clusterWatchId$1, request, new Requested((Option<ClusterWatchId>)clusterWatchId$1, request, clusterWatchIdChangeAllowed$4))), Enclosing$.MODULE$.apply("js7.cluster.ClusterWatchCounterpart#check"));
    }

    private static final String check2$$anonfun$1$$anonfun$1$$anonfun$1(ClusterWatchRequest request$4) {
        return "ClusterWatch.send(" + request$4 + ")";
    }

    private final void check2$$anonfun$1$$anonfun$1$$anonfun$2(ClusterWatchRequest request$5) {
        this.testEventPublisher.publish(ClusterWatchCounterpart$TestWaitingForConfirmation$.MODULE$.apply(request$5));
    }

    private static final Throwable check2$$anonfun$1$$anonfun$1$$anonfun$3() {
        return new RequestTimeoutException();
    }

    private static final String check2$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "any ClusterWatch";
    }

    private static final String check2$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1() {
        return " (or other)";
    }

    private final String message$proxy3$1(ClusterWatchRequest request$11, Problem problem$2, SyncDeadline.Now since$7) {
        return "\u26a0\ufe0f  " + request$11.toShortString() + " => " + problem$2 + " \u00b7 after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(since$7.elapsed(SyncDeadline$Now$.MODULE$.given_Now(this.ioRuntime))));
    }

    private final String check2$$anonfun$1$$anonfun$1$$anonfun$5$$anonfun$1$$anonfun$1(ClusterWatchRequest request$19, Problem problem$4, SyncDeadline.Now since$13) {
        return this.message$proxy3$1(request$19, problem$4, since$13);
    }

    private final void check2$$anonfun$1$$anonfun$1$$anonfun$5$$anonfun$1(BlockingSymbol sym$5, ClusterWatchRequest request$10, Problem problem$1, SyncDeadline.Now since$6) {
        LogLevel level$proxy1 = (LogLevel)Ordering.Implicits$.MODULE$.infixOrderingOps((Object)sym$5.relievedLogLevel(), LogLevel$.MODULE$.given_Ordering_LogLevel()).min((Object)LogLevel$.Debug);
        Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger.underlying()), level$proxy1, (Function0<String>)((Function0 & Serializable)() -> this.check2$$anonfun$1$$anonfun$1$$anonfun$5$$anonfun$1$$anonfun$1(request$10, problem$1, since$6)));
    }

    private static final void check2$$anonfun$1$$anonfun$1$$anonfun$5$$anonfun$2(ClusterWatchRequest request$12, Problem problem$3) {
        Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
        if (LoggerImpl_this.underlying().isWarnEnabled()) {
            LoggerImpl_this.underlying().warn("\u26d4 ClusterWatch rejected {}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{request$12.toShortString(), problem$3}), Object.class));
            return;
        }
    }

    private static final String message$proxy5$1(ClusterWatchConfirmation confirmation$2, ClusterWatchRequest request$14, SyncDeadline.Now since$9, SyncDeadline.Now contextual$2$1) {
        return "\ud83d\udfe2 " + confirmation$2.clusterWatchId() + " finally confirmed " + request$14.toShortString() + " after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(since$9.elapsed(contextual$2$1)));
    }

    private static final String check2$$anonfun$1$$anonfun$1$$anonfun$5$$anonfun$3$$anonfun$1(ClusterWatchConfirmation confirmation$3, ClusterWatchRequest request$22, SyncDeadline.Now since$15, SyncDeadline.Now contextual$2$2) {
        return ClusterWatchCounterpart.message$proxy5$1(confirmation$3, request$22, since$15, contextual$2$2);
    }

    private final void check2$$anonfun$1$$anonfun$1$$anonfun$7() {
        this._requested.set((Option<Requested>)None$.MODULE$);
    }

    private final IO check2$$anonfun$1$$anonfun$1(Requested requested$2, ClusterWatchRequest request$3, Option clusterWatchId$3, SyncDeadline.Now since$1) {
        this._requested.set((Option<Requested>)Some$.MODULE$.apply((Object)requested$2));
        BlockingSymbol sym = new BlockingSymbol();
        IO iO = this.pubsub.publish(request$3);
        return ((IO)MonixLikeExtensions$.MODULE$.onErrorRestartLoop(CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)() -> ClusterWatchCounterpart.check2$$anonfun$1$$anonfun$1$$anonfun$1(request$3)), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO)).$times$greater(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.check2$$anonfun$1$$anonfun$1$$anonfun$2(request$3);
            return BoxedUnit.UNIT;
        })).$times$greater(CatsEffectExtensions$.MODULE$.timeoutAndFail(requested$2.untilConfirmed(), (Duration)this.js7$cluster$ClusterWatchCounterpart$$timing.clusterWatchReactionTimeout(), (Function0<Throwable>)((Function0 & Serializable)ClusterWatchCounterpart::check2$$anonfun$1$$anonfun$1$$anonfun$3))), BoxedUnit.UNIT, (Function3 & Serializable)(x$12, x$2, x$3) -> {
            Tuple3 tuple3 = Tuple3$.MODULE$.apply(x$12, x$2, x$3);
            Throwable throwable = (Throwable)tuple3._1();
            if (throwable instanceof RequestTimeoutException) {
                Function1 retry = (Function1)tuple3._3();
                return ((IO)this.shuttingDown.tryGet()).flatMap((Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        Object object = ((Some)option).value();
                        if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                            return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problems$ClusterModuleShuttingDownProblem$.MODULE$);
                        }
                    }
                    if (None$.MODULE$.equals(option)) {
                        return SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)contextual$1 -> {
                            sym.onWarn();
                            Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                                LoggerImpl_this.underlying().warn(sym + " Still trying to get a confirmation from " + clusterWatchId$3.fold(ClusterWatchCounterpart::check2$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1, (Function1 & Serializable)id -> id.toString() + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(requested$2.clusterWatchIdChangeAllowed()), (Function0<String>)((Function0 & Serializable)ClusterWatchCounterpart::check2$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1))) + (" for " + request$3.toShortString() + " for " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(since$1.elapsed((SyncDeadline.Now)contextual$1))) + "..."));
                                return;
                            }
                        }).$times$greater((IO)retry.apply((Object)BoxedUnit.UNIT));
                    }
                    throw new MatchError((Object)option);
                });
            }
            Throwable t = throwable;
            return IO$.MODULE$.raiseError(t);
        }, IO$.MODULE$.asyncForIO())).flatTap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Problem problem = (Problem)((Left)either).value();
                if (((Object)Problems$ClusterModuleShuttingDownProblem$.MODULE$).equals(problem)) {
                    Problem problem2 = problem;
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        this.check2$$anonfun$1$$anonfun$1$$anonfun$5$$anonfun$1(sym, request$3, problem2, since$1);
                        return BoxedUnit.UNIT;
                    });
                }
                Problem problem3 = problem;
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    ClusterWatchCounterpart.check2$$anonfun$1$$anonfun$1$$anonfun$5$$anonfun$2(request$3, problem3);
                    return BoxedUnit.UNIT;
                });
            }
            if (either instanceof Right) {
                ClusterWatchConfirmation confirmation = (ClusterWatchConfirmation)((Right)either).value();
                this.testEventPublisher.publish(ClusterWatchCounterpart$TestConfirmed$.MODULE$.apply(request$3, confirmation));
                return SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)contextual$2 -> {
                    LogLevel level$proxy2 = sym.relievedLogLevel();
                    Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger.underlying()), level$proxy2, (Function0<String>)((Function0 & Serializable)() -> ClusterWatchCounterpart.check2$$anonfun$1$$anonfun$1$$anonfun$5$$anonfun$3$$anonfun$1(confirmation, request$3, since$1, contextual$2)));
                });
            }
            throw new MatchError((Object)either);
        }).guaranteeCase((Function1 & Serializable)x$1 -> {
            Outcome outcome = x$1;
            if (outcome instanceof Outcome.Errored) {
                Throwable throwable;
                package$.MODULE$.Outcome();
                Outcome.Errored errored = Outcome.Errored$.MODULE$.unapply((Outcome.Errored)outcome);
                Throwable t = throwable = (Throwable)errored._1();
                if (sym.warnLogged()) {
                    return SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)contextual$3 -> {
                        Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                        if (LoggerImpl_this.underlying().isWarnEnabled()) {
                            Object[] objectArray = new Object[3];
                            objectArray[0] = request$3.toShortString();
                            Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                            objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable);
                            objectArray[2] = ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(since$1.elapsed((SyncDeadline.Now)contextual$3)));
                            LoggerImpl_this.underlying().warn("\ud83d\udca5 {} => {} \u00b7 after {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
                            return;
                        }
                    });
                }
            }
            if (outcome instanceof Outcome.Canceled) {
                package$.MODULE$.Outcome();
                if (Outcome.Canceled$.MODULE$.unapply((Outcome.Canceled)outcome) && sym.warnLogged()) {
                    return SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)contextual$4 -> {
                        Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                        if (LoggerImpl_this.underlying().isInfoEnabled()) {
                            LoggerImpl_this.underlying().info("\u25fc\ufe0f  {} => Canceled after {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{request$3.toShortString(), ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(since$1.elapsed((SyncDeadline.Now)contextual$4)))}), Object.class));
                            return;
                        }
                    });
                }
            }
            return IO$.MODULE$.unit();
        }).guarantee(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.check2$$anonfun$1$$anonfun$1$$anonfun$7();
            return BoxedUnit.UNIT;
        }));
    }

    private final Either executeClusterWatchConfirm$$anonfun$1(ClusterWatchingCommand.ClusterWatchConfirm confirm$1) {
        return this.clusterWatchUniquenessChecker.check(confirm$1.clusterWatchId(), confirm$1.clusterWatchRunId());
    }

    private final Either executeClusterWatchConfirm$$anonfun$2$$anonfun$1(ClusterWatchingCommand.ClusterWatchConfirm confirm$3) {
        return this.takeRequest(confirm$3);
    }

    private static final String executeClusterWatchConfirm$$anonfun$3$$anonfun$1$$anonfun$1() {
        return "?";
    }

    private static final ClusterWatchConfirmation toConfirmation$$anonfun$1(ClusterWatchingCommand.ClusterWatchConfirm confirm$8) {
        return ClusterWatchConfirmation$.MODULE$.apply(confirm$8.requestId(), confirm$8.clusterWatchId(), confirm$8.clusterWatchRunId());
    }

    public class CurrentClusterWatchId
    implements Product,
    Serializable {
        private final ClusterWatchId clusterWatchId;
        private final SyncDeadline.Now initialNow;
        private SyncDeadline expires;
        private final /* synthetic */ ClusterWatchCounterpart $outer;

        public CurrentClusterWatchId(ClusterWatchCounterpart $outer, ClusterWatchId clusterWatchId, SyncDeadline.Now initialNow) {
            this.clusterWatchId = clusterWatchId;
            this.initialNow = initialNow;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.expires = initialNow.$plus($outer.js7$cluster$ClusterWatchCounterpart$$timing.clusterWatchIdTimeout());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CurrentClusterWatchId)) return false;
            if (((CurrentClusterWatchId)object).js7$cluster$ClusterWatchCounterpart$CurrentClusterWatchId$$$outer() != this.$outer) return false;
            CurrentClusterWatchId currentClusterWatchId = (CurrentClusterWatchId)object;
            ClusterWatchId clusterWatchId = this.clusterWatchId();
            ClusterWatchId clusterWatchId2 = currentClusterWatchId.clusterWatchId();
            if (clusterWatchId == null) {
                if (clusterWatchId2 != null) {
                    return false;
                }
            } else if (!((Object)clusterWatchId).equals(clusterWatchId2)) return false;
            SyncDeadline.Now now = this.initialNow();
            SyncDeadline.Now now2 = currentClusterWatchId.initialNow();
            if (now == null) {
                if (now2 != null) {
                    return false;
                }
            } else if (!((Object)now).equals(now2)) return false;
            if (!currentClusterWatchId.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof CurrentClusterWatchId;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CurrentClusterWatchId";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "clusterWatchId";
            }
            if (1 == n2) {
                return "initialNow";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ClusterWatchId clusterWatchId() {
            return this.clusterWatchId;
        }

        public SyncDeadline.Now initialNow() {
            return this.initialNow;
        }

        public void touch(ClusterWatchId clusterWatchId, SyncDeadline.Now now) {
            ClusterWatchId clusterWatchId2 = clusterWatchId;
            ClusterWatchId clusterWatchId3 = this.clusterWatchId();
            if (!(clusterWatchId2 != null ? !((Object)clusterWatchId2).equals(clusterWatchId3) : clusterWatchId3 != null)) {
                this.expires = now.$plus(this.$outer.js7$cluster$ClusterWatchCounterpart$$timing.clusterWatchIdTimeout());
                return;
            }
        }

        public boolean isStillAlive(SyncDeadline.Now x$1) {
            return this.expires.hasTimeLeft(x$1);
        }

        public String toString() {
            return this.clusterWatchId().toString();
        }

        public CurrentClusterWatchId copy(ClusterWatchId clusterWatchId, SyncDeadline.Now initialNow) {
            return new CurrentClusterWatchId(this.$outer, clusterWatchId, initialNow);
        }

        public ClusterWatchId copy$default$1() {
            return this.clusterWatchId();
        }

        public SyncDeadline.Now copy$default$2() {
            return this.initialNow();
        }

        public ClusterWatchId _1() {
            return this.clusterWatchId();
        }

        public SyncDeadline.Now _2() {
            return this.initialNow();
        }

        public final /* synthetic */ ClusterWatchCounterpart js7$cluster$ClusterWatchCounterpart$CurrentClusterWatchId$$$outer() {
            return this.$outer;
        }
    }

    public static class RequestTimeoutException
    extends Exception {
    }

    public static final class Requested {
        private final Option<ClusterWatchId> clusterWatchId;
        private final ClusterWatchRequest request;
        private final boolean clusterWatchIdChangeAllowed;
        private final Deferred<IO, Either<Problem, ClusterWatchConfirmation>> confirmation;

        public Requested(Option<ClusterWatchId> clusterWatchId, ClusterWatchRequest request, boolean clusterWatchIdChangeAllowed) {
            this.clusterWatchId = clusterWatchId;
            this.request = request;
            this.clusterWatchIdChangeAllowed = clusterWatchIdChangeAllowed;
            this.confirmation = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        }

        public Option<ClusterWatchId> clusterWatchId() {
            return this.clusterWatchId;
        }

        public ClusterWatchRequest request() {
            return this.request;
        }

        public boolean clusterWatchIdChangeAllowed() {
            return this.clusterWatchIdChangeAllowed;
        }

        public ClusterWatchRequest.RequestId id() {
            return this.request().requestId();
        }

        public IO<Either<Problem, ClusterWatchConfirmation>> untilConfirmed() {
            return (IO)this.confirmation.get();
        }

        public IO<Either<Problem, BoxedUnit>> confirm(Either<Problem, ClusterWatchConfirmation> confirm) {
            return ((IO)this.confirmation.complete(confirm)).as(Checked$.MODULE$.unit());
        }

        public String toString() {
            return "Requested(" + this.id() + "," + this.clusterWatchId() + ",clusterWatchIdChangeAllowed=" + this.clusterWatchIdChangeAllowed() + ")";
        }
    }

    public static final class TestConfirmed
    implements Product,
    Serializable {
        private final ClusterWatchRequest request;
        private final ClusterWatchConfirmation confirmation;

        public static TestConfirmed apply(ClusterWatchRequest clusterWatchRequest, ClusterWatchConfirmation clusterWatchConfirmation) {
            return ClusterWatchCounterpart$TestConfirmed$.MODULE$.apply(clusterWatchRequest, clusterWatchConfirmation);
        }

        public static TestConfirmed fromProduct(Product product) {
            return ClusterWatchCounterpart$TestConfirmed$.MODULE$.fromProduct(product);
        }

        public static TestConfirmed unapply(TestConfirmed testConfirmed) {
            return ClusterWatchCounterpart$TestConfirmed$.MODULE$.unapply(testConfirmed);
        }

        public TestConfirmed(ClusterWatchRequest request, ClusterWatchConfirmation confirmation) {
            this.request = request;
            this.confirmation = confirmation;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TestConfirmed)) return false;
            TestConfirmed testConfirmed = (TestConfirmed)object;
            ClusterWatchRequest clusterWatchRequest = this.request();
            ClusterWatchRequest clusterWatchRequest2 = testConfirmed.request();
            if (clusterWatchRequest == null) {
                if (clusterWatchRequest2 != null) {
                    return false;
                }
            } else if (!clusterWatchRequest.equals(clusterWatchRequest2)) return false;
            ClusterWatchConfirmation clusterWatchConfirmation = this.confirmation();
            ClusterWatchConfirmation clusterWatchConfirmation2 = testConfirmed.confirmation();
            if (clusterWatchConfirmation == null) {
                if (clusterWatchConfirmation2 == null) return true;
                return false;
            } else {
                if (!((Object)clusterWatchConfirmation).equals(clusterWatchConfirmation2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TestConfirmed;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "TestConfirmed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "request";
            }
            if (1 == n2) {
                return "confirmation";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ClusterWatchRequest request() {
            return this.request;
        }

        public ClusterWatchConfirmation confirmation() {
            return this.confirmation;
        }

        public TestConfirmed copy(ClusterWatchRequest request, ClusterWatchConfirmation confirmation) {
            return new TestConfirmed(request, confirmation);
        }

        public ClusterWatchRequest copy$default$1() {
            return this.request();
        }

        public ClusterWatchConfirmation copy$default$2() {
            return this.confirmation();
        }

        public ClusterWatchRequest _1() {
            return this.request();
        }

        public ClusterWatchConfirmation _2() {
            return this.confirmation();
        }
    }

    public static final class TestWaitingForConfirmation
    implements Product,
    Serializable {
        private final ClusterWatchRequest request;

        public static TestWaitingForConfirmation apply(ClusterWatchRequest clusterWatchRequest) {
            return ClusterWatchCounterpart$TestWaitingForConfirmation$.MODULE$.apply(clusterWatchRequest);
        }

        public static TestWaitingForConfirmation fromProduct(Product product) {
            return ClusterWatchCounterpart$TestWaitingForConfirmation$.MODULE$.fromProduct(product);
        }

        public static TestWaitingForConfirmation unapply(TestWaitingForConfirmation testWaitingForConfirmation) {
            return ClusterWatchCounterpart$TestWaitingForConfirmation$.MODULE$.unapply(testWaitingForConfirmation);
        }

        public TestWaitingForConfirmation(ClusterWatchRequest request) {
            this.request = request;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TestWaitingForConfirmation)) return false;
            TestWaitingForConfirmation testWaitingForConfirmation = (TestWaitingForConfirmation)object;
            ClusterWatchRequest clusterWatchRequest = this.request();
            ClusterWatchRequest clusterWatchRequest2 = testWaitingForConfirmation.request();
            if (clusterWatchRequest != null) {
                if (!clusterWatchRequest.equals(clusterWatchRequest2)) return false;
                return true;
            }
            if (clusterWatchRequest2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TestWaitingForConfirmation;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TestWaitingForConfirmation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "request";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ClusterWatchRequest request() {
            return this.request;
        }

        public TestWaitingForConfirmation copy(ClusterWatchRequest request) {
            return new TestWaitingForConfirmation(request);
        }

        public ClusterWatchRequest copy$default$1() {
            return this.request();
        }

        public ClusterWatchRequest _1() {
            return this.request();
        }
    }
}

