/*
 * Decompiled with CFR 0.152.
 */
package js7.common.pekkohttp.web;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Resource;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.log.Logger$syntax$;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.typeclasses.IsEmpty$;
import js7.base.utils.typeclasses.IsEmpty$syntax$;
import js7.common.pekkohttp.web.PekkoWebServer;
import js7.common.pekkohttp.web.SinglePortPekkoWebServer$;
import js7.common.pekkohttp.web.SinglePortPekkoWebServer$Binding$;
import js7.common.pekkohttp.web.data.WebServerBinding;
import js7.common.pekkohttp.web.data.WebServerPort;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directives$;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.util.ApplyConverter$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;

public final class SinglePortPekkoWebServer
implements Service,
StoppableByRequest,
Service.StoppableByRequest {
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private final Binding binding;
    private final ActorSystem actorSystem;

    public static Resource<IO, SinglePortPekkoWebServer> resource(WebServerBinding webServerBinding, Function1<PekkoWebServer.RouteBinding, PekkoWebServer.BoundRoute> function1, FiniteDuration finiteDuration, FiniteDuration finiteDuration2, boolean bl, ActorSystem actorSystem) {
        return SinglePortPekkoWebServer$.MODULE$.resource(webServerBinding, function1, finiteDuration, finiteDuration2, bl, actorSystem);
    }

    public SinglePortPekkoWebServer(Binding binding, ActorSystem actorSystem) {
        this.binding = binding;
        this.actorSystem = actorSystem;
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    @Override
    public IO<Service.Started> start() {
        return this.startService(this.untilStopRequested().$times$greater(this.onStop()));
    }

    private IO<BoxedUnit> onStop() {
        return this.binding.stop();
    }

    public String toString() {
        return "SinglePortPekkoWebServer(" + this.binding + ")";
    }

    public static final class Binding
    implements Product,
    Serializable {
        private final WebServerBinding webServerBinding;
        private final Http.ServerBinding pekkoBinding;
        private final FiniteDuration shutdownTimeout;
        private final FiniteDuration shutdownDelay;
        private final Deferred<IO, Deadline> whenTerminating;
        private final WebServerPort webServerPort;

        public static Binding apply(WebServerBinding webServerBinding, Http.ServerBinding serverBinding, FiniteDuration finiteDuration, FiniteDuration finiteDuration2, Deferred<IO, Deadline> deferred) {
            return SinglePortPekkoWebServer$Binding$.MODULE$.apply(webServerBinding, serverBinding, finiteDuration, finiteDuration2, deferred);
        }

        public static Binding fromProduct(Product product) {
            return SinglePortPekkoWebServer$Binding$.MODULE$.fromProduct(product);
        }

        public static Binding unapply(Binding binding) {
            return SinglePortPekkoWebServer$Binding$.MODULE$.unapply(binding);
        }

        public Binding(WebServerBinding webServerBinding, Http.ServerBinding pekkoBinding, FiniteDuration shutdownTimeout, FiniteDuration shutdownDelay, Deferred<IO, Deadline> whenTerminating) {
            this.webServerBinding = webServerBinding;
            this.pekkoBinding = pekkoBinding;
            this.shutdownTimeout = shutdownTimeout;
            this.shutdownDelay = shutdownDelay;
            this.whenTerminating = whenTerminating;
            this.webServerPort = webServerBinding.toWebServerPort();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Binding)) return false;
            Binding binding = (Binding)object;
            WebServerBinding webServerBinding = this.webServerBinding();
            WebServerBinding webServerBinding2 = binding.webServerBinding();
            if (webServerBinding == null) {
                if (webServerBinding2 != null) {
                    return false;
                }
            } else if (!webServerBinding.equals(webServerBinding2)) return false;
            Http.ServerBinding serverBinding = this.pekkoBinding();
            Http.ServerBinding serverBinding2 = binding.pekkoBinding();
            if (serverBinding == null) {
                if (serverBinding2 != null) {
                    return false;
                }
            } else if (!serverBinding.equals(serverBinding2)) return false;
            FiniteDuration finiteDuration = this.shutdownTimeout();
            FiniteDuration finiteDuration2 = binding.shutdownTimeout();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            FiniteDuration finiteDuration3 = this.shutdownDelay();
            FiniteDuration finiteDuration4 = binding.shutdownDelay();
            if (finiteDuration3 == null) {
                if (finiteDuration4 != null) {
                    return false;
                }
            } else if (!finiteDuration3.equals(finiteDuration4)) return false;
            Deferred<IO, Deadline> deferred = this.whenTerminating();
            Deferred<IO, Deadline> deferred2 = binding.whenTerminating();
            if (deferred == null) {
                if (deferred2 == null) return true;
                return false;
            } else {
                if (!deferred.equals(deferred2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Binding;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Binding";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "webServerBinding";
                }
                case 1: {
                    return "pekkoBinding";
                }
                case 2: {
                    return "shutdownTimeout";
                }
                case 3: {
                    return "shutdownDelay";
                }
                case 4: {
                    return "whenTerminating";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public WebServerBinding webServerBinding() {
            return this.webServerBinding;
        }

        public Http.ServerBinding pekkoBinding() {
            return this.pekkoBinding;
        }

        public FiniteDuration shutdownTimeout() {
            return this.shutdownTimeout;
        }

        public FiniteDuration shutdownDelay() {
            return this.shutdownDelay;
        }

        public Deferred<IO, Deadline> whenTerminating() {
            return this.whenTerminating;
        }

        public WebServerPort webServerPort() {
            return this.webServerPort;
        }

        public IO<BoxedUnit> stop() {
            return this.unbind().$times$greater(Logger$syntax$.MODULE$.debugIO(SinglePortPekkoWebServer$.js7$common$pekkohttp$web$SinglePortPekkoWebServer$$$logger, this.webServerBinding() + " terminate(" + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.shutdownTimeout())) + ")", (Function0<Object>)((Function0 & Serializable)SinglePortPekkoWebServer$::js7$common$pekkohttp$web$SinglePortPekkoWebServer$Binding$$_$stop$$anonfun$1), CatsEffectExtensions$.MODULE$.fromFutureDummyCancelable(IO$.MODULE$, IO$.MODULE$.apply(this::stop$$anonfun$2))).void());
        }

        private IO<BoxedUnit> unbind() {
            return IO$.MODULE$.both(IO$.MODULE$.fromFuture(Logger$syntax$.MODULE$.debugIO(SinglePortPekkoWebServer$.js7$common$pekkohttp$web$SinglePortPekkoWebServer$$$logger, this.webServerBinding() + " unbind", (Function0<Object>)((Function0 & Serializable)SinglePortPekkoWebServer$::js7$common$pekkohttp$web$SinglePortPekkoWebServer$Binding$$_$unbind$$anonfun$1), IO$.MODULE$.apply(this::unbind$$anonfun$2))), IO$.MODULE$.apply(SinglePortPekkoWebServer$::js7$common$pekkohttp$web$SinglePortPekkoWebServer$Binding$$_$unbind$$anonfun$3).flatMap((Function1 & Serializable)now -> ((IO)this.whenTerminating().complete((Object)now.$plus(this.shutdownTimeout()))).$times$greater(IO$.MODULE$.whenA(ScalaTime$RichFiniteDuration$.MODULE$.isPositive$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.shutdownDelay())), this::unbind$$anonfun$4$$anonfun$1)))).void();
        }

        public String toString() {
            return this.webServerPort().toString();
        }

        public Binding copy(WebServerBinding webServerBinding, Http.ServerBinding pekkoBinding, FiniteDuration shutdownTimeout, FiniteDuration shutdownDelay, Deferred<IO, Deadline> whenTerminating) {
            return new Binding(webServerBinding, pekkoBinding, shutdownTimeout, shutdownDelay, whenTerminating);
        }

        public WebServerBinding copy$default$1() {
            return this.webServerBinding();
        }

        public Http.ServerBinding copy$default$2() {
            return this.pekkoBinding();
        }

        public FiniteDuration copy$default$3() {
            return this.shutdownTimeout();
        }

        public FiniteDuration copy$default$4() {
            return this.shutdownDelay();
        }

        public Deferred<IO, Deadline> copy$default$5() {
            return this.whenTerminating();
        }

        public WebServerBinding _1() {
            return this.webServerBinding();
        }

        public Http.ServerBinding _2() {
            return this.pekkoBinding();
        }

        public FiniteDuration _3() {
            return this.shutdownTimeout();
        }

        public FiniteDuration _4() {
            return this.shutdownDelay();
        }

        public Deferred<IO, Deadline> _5() {
            return this.whenTerminating();
        }

        private final Future stop$$anonfun$2() {
            return this.pekkoBinding().terminate(this.shutdownTimeout());
        }

        private final Future unbind$$anonfun$2() {
            return this.pekkoBinding().unbind();
        }

        private final IO unbind$$anonfun$4$$anonfun$1() {
            return Logger$syntax$.MODULE$.debugIO(SinglePortPekkoWebServer$.js7$common$pekkohttp$web$SinglePortPekkoWebServer$$$logger, this.webServerBinding() + " Delay web server termination for " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.shutdownDelay())), (Function0<Object>)((Function0 & Serializable)SinglePortPekkoWebServer$::js7$common$pekkohttp$web$SinglePortPekkoWebServer$Binding$$_$unbind$$anonfun$4$$anonfun$1$$anonfun$1), IO$.MODULE$.sleep(this.shutdownDelay()));
        }
    }

    public static final class DelayedRouteDelegator {
        private final PekkoWebServer.BoundRoute boundRoute;
        private final AtomicReference<Option<Try<Function1<RequestContext, Future<RouteResult>>>>> _realRoute;

        public DelayedRouteDelegator(PekkoWebServer.BoundRoute boundRoute) {
            this.boundRoute = boundRoute;
            Option initial$proxy1 = package.all$.MODULE$.none();
            this._realRoute = new AtomicReference<Option>(initial$proxy1);
        }

        public IO<BoxedUnit> start(WebServerBinding binding, String name) {
            return CatsEffectExtensions$.MODULE$.startAndForget(this.boundRoute.webServerRoute().flatTap((Function1 & Serializable)realRoute -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.start$$anonfun$1$$anonfun$1((Function1)realRoute, binding, name);
                return BoxedUnit.UNIT;
            })));
        }

        public Function1<RequestContext, Future<RouteResult>> webServerRoute() {
            return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractRequest(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)_$2 -> this.selectBoundRoute());
        }

        public Function1<RequestContext, Future<RouteResult>> selectBoundRoute() {
            Option<Try<Function1<RequestContext, Future<RouteResult>>>> option = this._realRoute.get();
            if (None$.MODULE$.equals(option)) {
                return this.boundRoute.stillNotAvailableRoute();
            }
            if (option instanceof Some) {
                Try try_ = (Try)((Some)option).value();
                if (try_ instanceof Failure) {
                    Throwable t = ((Failure)try_).exception();
                    throw t;
                }
                if (try_ instanceof Success) {
                    Function1 realRoute = (Function1)((Success)try_).value();
                    return realRoute;
                }
            }
            throw new MatchError(option);
        }

        private final void start$$anonfun$1$$anonfun$1(Function1 realRoute$1, WebServerBinding binding$4, String name$1) {
            if (this._realRoute.compareAndSet((Option<Try<Function1<RequestContext, Future<RouteResult>>>>)None$.MODULE$, (Option<Try<Function1<RequestContext, Future<RouteResult>>>>)Some$.MODULE$.apply((Object)Success$.MODULE$.apply((Object)realRoute$1)))) {
                String serviceName = (String)IsEmpty$syntax$.MODULE$.ifNonEmpty(this.boundRoute.serviceName(), IsEmpty$.MODULE$.given_IsEmpty_String()).fold(SinglePortPekkoWebServer$::js7$common$pekkohttp$web$SinglePortPekkoWebServer$DelayedRouteDelegator$$_$_$$anonfun$3, SinglePortPekkoWebServer$::js7$common$pekkohttp$web$SinglePortPekkoWebServer$DelayedRouteDelegator$$_$_$$anonfun$4);
                String securityHint = this.boundRoute.startupSecurityHint(binding$4.scheme());
                Logger LoggerImpl_this = SinglePortPekkoWebServer$.js7$common$pekkohttp$web$SinglePortPekkoWebServer$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("{} {}web services are available{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{name$1, serviceName, securityHint}), Object.class));
                    return;
                }
                return;
            }
        }
    }
}

