/*
 * Decompiled with CFR 0.152.
 */
package js7.common.pekkohttp.web.session;

import cats.Apply;
import cats.FlatMap;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.package$;
import cats.effect.std.AtomicCell;
import cats.effect.std.AtomicCell$;
import cats.syntax.ApplyOps$;
import cats.syntax.package;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.auth.SessionToken;
import js7.base.auth.SessionToken$;
import js7.base.auth.SimpleUser;
import js7.base.auth.UserId;
import js7.base.auth.UserId$;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.UnsafeMemoizable$;
import js7.base.generic.Completed$package$Completed$;
import js7.base.io.file.FileUtils$;
import js7.base.io.file.FileUtils$syntax$;
import js7.base.io.file.FileUtils$syntax$RichPath$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.problem.Problems$InvalidSessionTokenProblem$;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.system.ServerOperatingSystem$;
import js7.base.time.JavaTimeConverters$;
import js7.base.time.JavaTimeConverters$AsScalaDuration$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.Assertions$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.version.Js7Versions$;
import js7.base.version.Version;
import js7.common.auth.SecretStringGenerator$;
import js7.common.http.PekkoHttpClient$x$minusjs7$minussession$;
import js7.common.pekkohttp.web.session.Session;
import js7.common.pekkohttp.web.session.SessionInit;
import js7.common.pekkohttp.web.session.SessionInit$;
import js7.common.pekkohttp.web.session.SessionRegister$;
import js7.common.pekkohttp.web.session.SessionRegister$State$;
import js7.common.pekkohttp.web.session.SessionRegister$cleanUp$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.ChainingOps$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.package;
import sourcecode.Enclosing$;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public final class SessionRegister<S extends Session>
implements Service.StoppableByRequest {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SessionRegister.class.getDeclaredField("cleanUp$lzy1"));
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private final Function1<SessionInit, S> newSession;
    private final Tag<S> evidence$1;
    private final String componentName;
    private final FiniteDuration sessionTimeout;
    public final FiniteDuration js7$common$pekkohttp$web$session$SessionRegister$$cleanupInterval;
    public final IO<AtomicCell<IO, State>> js7$common$pekkohttp$web$session$SessionRegister$$cell;
    private final Deferred<IO, Either<Problem, S>> deferredSystemSession;
    private final IO<Either<Problem, S>> systemSession;
    private final IO<Either<Problem, SimpleUser>> systemUser;
    private volatile Object cleanUp$lzy1;
    public final SessionRegister$State$ State$lzy1;

    public static Config TestConfig() {
        return SessionRegister$.MODULE$.TestConfig();
    }

    public static <S extends Session> SessionRegister<S> forTest(Function1<SessionInit, S> function1, Config config, Tag<S> tag) {
        return SessionRegister$.MODULE$.forTest(function1, config, tag);
    }

    public static <S extends Session> Resource<IO, SessionRegister<S>> resource(Function1<SessionInit, S> function1, Config config, Tag<S> tag) {
        return SessionRegister$.MODULE$.resource(function1, config, tag);
    }

    public SessionRegister(Function1<SessionInit, S> newSession, Config config, Tag<S> evidence$1) {
        this.newSession = newSession;
        this.evidence$1 = evidence$1;
        this.State$lzy1 = new SessionRegister$State$(this);
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        this.componentName = config.getString("js7.component.name");
        this.sessionTimeout = JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration(config.getDuration("js7.auth.session.timeout")));
        this.js7$common$pekkohttp$web$session$SessionRegister$$cleanupInterval = this.sessionTimeout.$div(4L);
        boolean bl = AtomicCell$.MODULE$.apply();
        this.js7$common$pekkohttp$web$session$SessionRegister$$cell = (IO)UnsafeMemoizable$.MODULE$.unsafeMemoize(AtomicCell.ApplyPartiallyApplied$.MODULE$.of$extension(bl, (Object)this.State().apply(Predef$.MODULE$.Map().empty()), (GenConcurrent)IO$.MODULE$.asyncForIO()), IO$.MODULE$.asyncForIO());
        this.deferredSystemSession = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        this.systemSession = (IO)UnsafeMemoizable$.MODULE$.memoize(CatsUtils$syntax$.MODULE$.logWhenItTakesLonger((IO)this.deferredSystemSession.get(), Enclosing$.MODULE$.apply("js7.common.pekkohttp.web.session.SessionRegister#systemSession")), IO$.MODULE$.asyncForIO());
        this.systemUser = this.systemSession().map((Function1 & Serializable)_$1 -> _$1.map((Function1 & Serializable)_$2 -> _$2.currentUser()));
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    public IO<Either<Problem, S>> systemSession() {
        return this.systemSession;
    }

    public IO<Either<Problem, SimpleUser>> systemUser() {
        return this.systemUser;
    }

    @Override
    public IO<Service.Started> start() {
        return this.startService(this.untilStopRequested().$times$greater(this.onStop()));
    }

    private IO<BoxedUnit> onStop() {
        return this.js7$common$pekkohttp$web$session$SessionRegister$$cell.flatMap((Function1 & Serializable)_$3 -> (IO)_$3.get()).flatMap((Function1 & Serializable)state -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
            SessionRegister.onStop$$anonfun$2$$anonfun$1(state);
            return BoxedUnit.UNIT;
        }));
    }

    public Resource<IO, SessionToken> placeSessionTokenInDirectory(SimpleUser user, Path workDirectory) {
        Path sessionTokenFile = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(workDirectory), "session-token");
        Path headersFile = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(workDirectory), "secret-http-headers");
        return (Resource)package.flatMap$.MODULE$.toFlatMapOps(this.provideSessionTokenFile(user, sessionTokenFile), (FlatMap)Resource$.MODULE$.catsEffectAsyncForResource(IO$.MODULE$.asyncForIO())).flatTap((Function1 & Serializable)sessionToken -> {
            Resource resource = (Resource)package.apply$.MODULE$.catsSyntaxApplyOps(FileUtils$.MODULE$.provideFile(headersFile, IO$.MODULE$.asyncForIO()));
            return (Resource)ApplyOps$.MODULE$.$times$greater$extension((Object)resource, (Object)package$.MODULE$.Resource().eval((Object)IO$.MODULE$.apply((Function0 & Serializable)() -> {
                SessionRegister.placeSessionTokenInDirectory$$anonfun$1$$anonfun$1(headersFile, sessionToken);
                return BoxedUnit.UNIT;
            })), (Apply)Resource$.MODULE$.catsEffectAsyncForResource(IO$.MODULE$.asyncForIO()));
        });
    }

    private Resource<IO, SessionToken> provideSessionTokenFile(SimpleUser user, Path file2) {
        return FileUtils$.MODULE$.provideFile(file2, IO$.MODULE$.asyncForIO()).flatMap((Function1 & Serializable)file -> package$.MODULE$.Resource().eval(this.createSystemSession(user, (Path)file)));
    }

    private IO<SessionToken> createSystemSession(SimpleUser user, Path file) {
        Some some = Some$.MODULE$.apply((Object)js7.base.package$.MODULE$.Js7Version());
        Option<SessionToken> option = this.login$default$3();
        return this.login(user, (Option<Version>)some, option, true).flatMap((Function1 & Serializable)token -> IO$.MODULE$.interruptible((Function0 & Serializable)() -> {
            SessionRegister.createSystemSession$$anonfun$1$$anonfun$1(file, token, user);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.session((SessionToken)token, (Either<Set<UserId>, SimpleUser>)scala.package$.MODULE$.Right().apply((Object)user)).flatMap((Function1 & Serializable)checkedSession -> ((IO)this.deferredSystemSession.complete(checkedSession)).map((Function1 & Serializable)x$1 -> SessionRegister.createSystemSession$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(token, BoxesRunTime.unboxToBoolean((Object)x$1))));
        }));
    }

    public IO<SessionToken> login(SimpleUser user, Option<Version> clientVersion, Option<SessionToken> token, boolean isEternalSession) {
        return this.js7$common$pekkohttp$web$session$SessionRegister$$cell.flatMap((Function1 & Serializable)_$4 -> (IO)_$4.modify((Function1 & Serializable)state2 -> {
            State state3 = (State)package.chaining$.MODULE$.scalaUtilChainingOps(token.fold(() -> SessionRegister.login$$anonfun$1$$anonfun$1$$anonfun$1(state2), (Function1 & Serializable)oldToken -> state2.delete((SessionToken)oldToken, " deleted due to Login")));
            return (Tuple2)ChainingOps$.MODULE$.pipe$extension((Object)state3, (Function1 & Serializable)state -> {
                Option option;
                SessionToken token = SessionToken$.MODULE$.generateFromSecretString(SecretStringGenerator$.MODULE$.newSecretString());
                Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)SessionRegister.v$proxy1$1(state, token)), "!state.tokenToSession.contains(token)"), (Function0<String>)((Function0 & Serializable)SessionRegister::login$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1), FullName$.MODULE$.apply("js7.common.pekkohttp.web.session.SessionRegister.login"), FileName$.MODULE$.apply("SessionRegister.scala"), Line$.MODULE$.apply(114));
                Session session = (Session)this.newSession.apply((Object)SessionInit$.MODULE$.apply(token, user));
                State updated = state.copy((Map)state.tokenToSession().updated((Object)session.sessionToken(), (Object)session));
                Logger LoggerImpl_this = SessionRegister$.js7$common$pekkohttp$web$session$SessionRegister$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info(session.sessionToken() + " for " + user.id() + ": Login" + clientVersion.fold(SessionRegister::login$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2, (Function1 & Serializable)v -> {
                        Version version = v;
                        Version version2 = js7.base.package$.MODULE$.Js7Version();
                        return " (" + v + (String)(!(version != null ? !((Object)version).equals(version2) : version2 != null) ? " \u2714)" : " \u26a0\ufe0f version differs from this server's version " + js7.base.package$.MODULE$.Js7Version() + "!)");
                    }) + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(isEternalSession), (Function0<String>)((Function0 & Serializable)SessionRegister::login$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$4)));
                }
                if (None$.MODULE$.equals(option = clientVersion)) {
                    Logger LoggerImpl_this2 = SessionRegister$.js7$common$pekkohttp$web$session$SessionRegister$$$logger;
                    if (LoggerImpl_this2.underlying().isWarnEnabled()) {
                        LoggerImpl_this2.underlying().warn("Client does not provide its version");
                    }
                } else if (option instanceof Some) {
                    Version v2 = (Version)((Some)option).value();
                    Js7Versions$.MODULE$.checkNonMatchingVersion(v2, (Function0<String>)((Function0 & Serializable)() -> SessionRegister.login$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$5(user)), Js7Versions$.MODULE$.checkNonMatchingVersion$default$3()).left().foreach((Function1)(JProcedure1 & Serializable)problem -> {
                        Logger LoggerImpl_this = SessionRegister$.js7$common$pekkohttp$web$session$SessionRegister$$$logger;
                        if (LoggerImpl_this.underlying().isErrorEnabled()) {
                            LoggerImpl_this.underlying().error(problem.toString());
                            return;
                        }
                    });
                } else {
                    throw new MatchError((Object)option);
                }
                State state2 = (State)Predef$.MODULE$.ArrowAssoc((Object)updated);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state2, (Object)session);
            });
        })).flatMap((Function1 & Serializable)session -> IO$.MODULE$.unlessA(isEternalSession, () -> this.login$$anonfun$2$$anonfun$1(session)).as((Object)session.sessionToken()));
    }

    public Option<SessionToken> login$default$3() {
        return None$.MODULE$;
    }

    public boolean login$default$4() {
        return false;
    }

    public IO<Completed$package$Completed$> logout(SessionToken sessionToken) {
        return this.js7$common$pekkohttp$web$session$SessionRegister$$cell.flatMap((Function1 & Serializable)_$5 -> (IO)_$5.update((Function1 & Serializable)_$6 -> _$6.delete(sessionToken, ": Logout"))).as((Object)Completed$package$Completed$.MODULE$);
    }

    public IO<Either<Problem, S>> session(SessionToken token, Either<Set<UserId>, SimpleUser> idsOrUser) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.js7$common$pekkohttp$web$session$SessionRegister$$cell.flatMap((Function1 & Serializable)_$7 -> (IO)_$7.get()).map((Function1 & Serializable)state -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)state.tokenToSession().get((Object)token), (Object)idsOrUser);
            Option option = (Option)tuple2._1();
            Either either = (Either)tuple2._2();
            if (None$.MODULE$.equals(option)) {
                Serializable users = (Serializable)idsOrUser.fold((Function1 & Serializable)_$8 -> _$8.mkString("|"), (Function1 & Serializable)_$9 -> _$9.id());
                Logger LoggerImpl_this = SessionRegister$.js7$common$pekkohttp$web$session$SessionRegister$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("\ud83d\udd12 InvalidSessionToken: Rejecting unknown {} of {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{token, users}), Object.class));
                }
                return scala.package$.MODULE$.Left().apply((Object)Problems$InvalidSessionTokenProblem$.MODULE$);
            }
            if (option instanceof Some) {
                Set userIds;
                SimpleUser user;
                Session session;
                Session session2 = session = (Session)((Some)option).value();
                if (either instanceof Right && !(user = (SimpleUser)((Right)either).value()).id().isAnonymous()) {
                    UserId userId = user.id();
                    UserId userId2 = session2.currentUser().id();
                    if (userId == null ? userId2 != null : !((Object)userId).equals(userId2)) {
                        return this.tryUpdateLatelyAuthenticatedUser(user, session2);
                    }
                }
                Session session3 = session;
                if (either instanceof Left && !(userIds = (Set)((Left)either).value()).contains((Object)session3.currentUser().id())) {
                    Logger LoggerImpl_this = SessionRegister$.js7$common$pekkohttp$web$session$SessionRegister$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("\ud83d\udd12 InvalidSessionToken: HTTPS distinguished name UserIds " + ("'" + userIds.mkString(", ") + "' do not include Sessions's " + session3.currentUser().id()));
                    }
                    return scala.package$.MODULE$.Left().apply((Object)Problems$InvalidSessionTokenProblem$.MODULE$);
                }
                Session session4 = session;
                return scala.package$.MODULE$.Right().apply((Object)session4);
            }
            throw new MatchError((Object)tuple2);
        }));
        IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.flatTapT$extension(iO, (Function1 & Serializable)session -> this.js7$common$pekkohttp$web$session$SessionRegister$$handleTimeout(session).map((Function1 & Serializable)timedOutAndDeleted -> SessionRegister.session$$anonfun$3$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)timedOutAndDeleted))), IO$.MODULE$.asyncForIO()));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatTapT$extension(iO2, (Function1 & Serializable)session -> IO$.MODULE$.unlessA(session.isEternal(), () -> this.session$$anonfun$4$$anonfun$1(session)).as((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)), IO$.MODULE$.asyncForIO());
    }

    public IO<Object> count() {
        return this.js7$common$pekkohttp$web$session$SessionRegister$$cell.flatMap((Function1 & Serializable)_$10 -> (IO)_$10.get()).map((Function1 & Serializable)_$11 -> _$11.tokenToSession().size());
    }

    private Either<Problem, S> tryUpdateLatelyAuthenticatedUser(SimpleUser newUser, S session) {
        block2: {
            if (session.sessionInit().loginUser().isAnonymous() && session.tryUpdateUser(newUser)) {
                Logger LoggerImpl_this = SessionRegister$.js7$common$pekkohttp$web$session$SessionRegister$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("{} for {} switched to {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{session.sessionToken(), session.sessionInit().loginUser().id(), newUser.id()}), Object.class));
                }
                return scala.package$.MODULE$.Right().apply(session);
            }
            Logger LoggerImpl_this = SessionRegister$.js7$common$pekkohttp$web$session$SessionRegister$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block2;
            LoggerImpl_this.underlying().debug("\ud83d\udd12 InvalidSessionToken: " + session.sessionToken() + ": Rejecting session token " + ("belonging to " + session.currentUser().id() + " but sent by " + newUser.id()));
        }
        return scala.package$.MODULE$.Left().apply((Object)Problems$InvalidSessionTokenProblem$.MODULE$);
    }

    private final SessionRegister$cleanUp$ cleanUp() {
        Object object = this.cleanUp$lzy1;
        if (object instanceof SessionRegister$cleanUp$) {
            return (SessionRegister$cleanUp$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SessionRegister$cleanUp$)this.cleanUp$lzyINIT1();
    }

    private Object cleanUp$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cleanUp$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SessionRegister$cleanUp$ sessionRegister$cleanUp$ = null;
                    try {
                        sessionRegister$cleanUp$ = new SessionRegister$cleanUp$(this);
                        object2 = sessionRegister$cleanUp$ == null ? LazyVals.NullValue$.MODULE$ : sessionRegister$cleanUp$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cleanUp$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return sessionRegister$cleanUp$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public IO<Object> js7$common$pekkohttp$web$session$SessionRegister$$handleTimeout(S session) {
        return session.isAlive().flatMap((Function1 & Serializable)isAlive -> this.handleTimeout$$anonfun$1((Session)session, BoxesRunTime.unboxToBoolean((Object)isAlive)));
    }

    public Either<Problem, BoxedUnit> checkNonMatchingVersion(Option<Version> clientVersion, Version ourVersion) {
        return Checked$.MODULE$.catchNonFatalFlatten(() -> this.checkNonMatchingVersion$$anonfun$1(clientVersion, ourVersion));
    }

    public Version checkNonMatchingVersion$default$2() {
        return js7.base.package$.MODULE$.Js7Version();
    }

    public String toString() {
        return "SessionRegister[" + ((Tag)Predef$.MODULE$.implicitly(this.evidence$1)).tag().shortName() + "]";
    }

    private final SessionRegister$State$ State() {
        return this.State$lzy1;
    }

    private static final void onStop$$anonfun$2$$anonfun$1(State state$1) {
        state$1.logOpenSessions();
    }

    private static final void placeSessionTokenInDirectory$$anonfun$1$$anonfun$1(Path headersFile$2, SessionToken sessionToken$1) {
        Files.createFile(headersFile$2, (FileAttribute[])Arrays$.MODULE$.seqToArray(ServerOperatingSystem$.MODULE$.operatingSystem().secretFileAttributes(), FileAttribute.class));
        FileUtils$syntax$RichPath$.MODULE$.$colon$eq$extension(FileUtils$syntax$.MODULE$.RichPath(headersFile$2), PekkoHttpClient$x$minusjs7$minussession$.MODULE$.name() + ": " + sessionToken$1.secret().string() + "\n");
    }

    private static final void createSystemSession$$anonfun$1$$anonfun$1(Path file$2, SessionToken token$2, SimpleUser user$3) {
        Files.deleteIfExists(file$2);
        Files.createFile(file$2, (FileAttribute[])Arrays$.MODULE$.seqToArray(ServerOperatingSystem$.MODULE$.operatingSystem().secretFileAttributes(), FileAttribute.class));
        FileUtils$syntax$RichPath$.MODULE$.$colon$eq$extension(FileUtils$syntax$.MODULE$.RichPath(file$2), token$2.secret().string());
        Logger LoggerImpl_this = SessionRegister$.js7$common$pekkohttp$web$session$SessionRegister$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("SessionToken for internal {} has been placed in file {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{user$3.id(), file$2}), Object.class));
            return;
        }
    }

    private static final /* synthetic */ SessionToken createSystemSession$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(SessionToken token$5, boolean x$1) {
        boolean bl = x$1;
        return token$5;
    }

    private static final State login$$anonfun$1$$anonfun$1$$anonfun$1(State state$2) {
        return state$2;
    }

    private static final boolean v$proxy1$1(State state$4, SessionToken token$8) {
        return !state$4.tokenToSession().contains((Object)token$8);
    }

    private static final String login$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1() {
        return "Duplicate generated SessionToken";
    }

    private static final String login$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2() {
        return "";
    }

    private static final String login$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$4() {
        return " (eternal)";
    }

    private static final String login$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$5(SimpleUser user$8) {
        return user$8.id().toString();
    }

    private final IO login$$anonfun$2$$anonfun$1(Session session$1) {
        return session$1.touch(this.sessionTimeout).$times$greater(this.cleanUp().scheduleNext());
    }

    private static final /* synthetic */ Either session$$anonfun$3$$anonfun$1(boolean timedOutAndDeleted) {
        if (timedOutAndDeleted) {
            return scala.package$.MODULE$.Left().apply((Object)Problems$InvalidSessionTokenProblem$.MODULE$);
        }
        return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private final IO session$$anonfun$4$$anonfun$1(Session session$2) {
        return session$2.touch(this.sessionTimeout);
    }

    public static final /* synthetic */ IO js7$common$pekkohttp$web$session$SessionRegister$cleanUp$$$_$scheduleNext$$anonfun$1$$anonfun$1(AtomicCell _$12) {
        return (IO)_$12.get();
    }

    public static final /* synthetic */ boolean js7$common$pekkohttp$web$session$SessionRegister$cleanUp$$$_$scheduleNext$$anonfun$1$$anonfun$2(State _$13) {
        return _$13.tokenToSession().values().exists((Function1 & Serializable)o -> !o.isEternal());
    }

    public static final /* synthetic */ IO js7$common$pekkohttp$web$session$SessionRegister$cleanUp$$$_$cleanUp$$anonfun$1(AtomicCell _$14) {
        return (IO)_$14.get();
    }

    public static final IO js7$common$pekkohttp$web$session$SessionRegister$cleanUp$$$_$setFiber$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    public static final /* synthetic */ IO js7$common$pekkohttp$web$session$SessionRegister$cleanUp$$$_$setFiber$$anonfun$2(Fiber _$15) {
        return (IO)_$15.cancel();
    }

    private final /* synthetic */ IO handleTimeout$$anonfun$1(Session session$3, boolean isAlive) {
        return (isAlive ? CatsEffectExtensions$.MODULE$.inline$falseIO() : session$3.touchedBefore().flatMap((Function1 & Serializable)elapsed -> this.js7$common$pekkohttp$web$session$SessionRegister$$cell.flatMap((Function1 & Serializable)_$16 -> (IO)_$16.update((Function1 & Serializable)_$17 -> _$17.delete(session$3.sessionToken(), " timed out (last used " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration((FiniteDuration)elapsed)) + " ago)"))).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return true;
        }))).map((Function1 & Serializable)r -> BoxesRunTime.unboxToBoolean((Object)r));
    }

    private final Problem left$proxy1$1(Version v$1, Version ourVersion$2) {
        return Problem$.MODULE$.pure("Client's version " + v$1 + " does not match " + this.componentName + " version " + ourVersion$2);
    }

    private final Problem checkNonMatchingVersion$$anonfun$1$$anonfun$1(Version v$2, Version ourVersion$3) {
        return this.left$proxy1$1(v$2, ourVersion$3);
    }

    private final Either checkNonMatchingVersion$$anonfun$1(Option clientVersion$5, Version ourVersion$1) {
        Option option = clientVersion$5;
        if (None$.MODULE$.equals(option)) {
            return Checked$.MODULE$.unit();
        }
        if (option instanceof Some) {
            Version v = (Version)((Some)option).value();
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(v.major() == ourVersion$1.major() && v.minor() == ourVersion$1.minor());
            return ScalaUtils$syntax$RichBoolean$.MODULE$.orLeft$extension(RichBoolean_this, () -> this.checkNonMatchingVersion$$anonfun$1$$anonfun$1(v, ourVersion$1));
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ UserId js7$common$pekkohttp$web$session$SessionRegister$State$$_$logOpenSessions$$anonfun$1(Session _$18) {
        return _$18.currentUser().id();
    }

    public static final /* synthetic */ SessionToken js7$common$pekkohttp$web$session$SessionRegister$State$$_$logOpenSessions$$anonfun$2(Session _$19) {
        return _$19.sessionToken();
    }

    public static final /* synthetic */ Vector js7$common$pekkohttp$web$session$SessionRegister$State$$_$logOpenSessions$$anonfun$3(Iterable _$20) {
        return (Vector)_$20.toVector().sortBy((Function1 & Serializable)_$21 -> _$21.number(), (Ordering)Ordering.Long$.MODULE$);
    }

    public static final /* synthetic */ UserId js7$common$pekkohttp$web$session$SessionRegister$State$$_$logOpenSessions$$anonfun$4(Tuple2 _$22) {
        return (UserId)_$22._1();
    }

    public static final /* synthetic */ void js7$common$pekkohttp$web$session$SessionRegister$State$$_$logOpenSessions$$anonfun$5(Tuple2 x$1) {
        UserId userId = (UserId)x$1._1();
        Vector vector = (Vector)x$1._2();
        Logger LoggerImpl_this = SessionRegister$.js7$common$pekkohttp$web$session$SessionRegister$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug(BoxesRunTime.boxToInteger((int)vector.size()).toString() + " open sessions for " + userId + vector.view().mkString(" (", " ", ")"));
            return;
        }
    }

    public final class State
    implements Product,
    Serializable {
        private final Map<SessionToken, S> tokenToSession;
        private final /* synthetic */ SessionRegister $outer;

        public State(SessionRegister $outer, Map<SessionToken, S> tokenToSession) {
            this.tokenToSession = tokenToSession;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            if (((State)object).js7$common$pekkohttp$web$session$SessionRegister$State$$$outer() != this.$outer) return false;
            State state = (State)object;
            Map map = this.tokenToSession();
            Map map2 = state.tokenToSession();
            if (map != null) {
                if (!map.equals(map2)) return false;
                return true;
            }
            if (map2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "tokenToSession";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<SessionToken, S> tokenToSession() {
            return this.tokenToSession;
        }

        public State delete(SessionToken token, String reason) {
            Option option = this.tokenToSession().get((Object)token);
            if (None$.MODULE$.equals(option)) {
                return this;
            }
            if (option instanceof Some) {
                Session session = (Session)((Some)option).value();
                Logger LoggerImpl_this = SessionRegister$.js7$common$pekkohttp$web$session$SessionRegister$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("{} for {}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{token, session.currentUser().id(), reason}), Object.class));
                }
                return this.copy((Map)this.tokenToSession().removed((Object)token));
            }
            throw new MatchError((Object)option);
        }

        public void logOpenSessions() {
            ((Vector)this.tokenToSession().values().groupMap(SessionRegister::js7$common$pekkohttp$web$session$SessionRegister$State$$_$logOpenSessions$$anonfun$1, SessionRegister::js7$common$pekkohttp$web$session$SessionRegister$State$$_$logOpenSessions$$anonfun$2).view().mapValues(SessionRegister::js7$common$pekkohttp$web$session$SessionRegister$State$$_$logOpenSessions$$anonfun$3).toVector().sortBy(SessionRegister::js7$common$pekkohttp$web$session$SessionRegister$State$$_$logOpenSessions$$anonfun$4, UserId$.MODULE$.ordering())).foreach((Function1)((JProcedure1 & Serializable)SessionRegister::js7$common$pekkohttp$web$session$SessionRegister$State$$_$logOpenSessions$$anonfun$5));
        }

        public State copy(Map<SessionToken, S> tokenToSession) {
            return new State(this.$outer, tokenToSession);
        }

        public Map<SessionToken, S> copy$default$1() {
            return this.tokenToSession();
        }

        public Map<SessionToken, S> _1() {
            return this.tokenToSession();
        }

        public final /* synthetic */ SessionRegister js7$common$pekkohttp$web$session$SessionRegister$State$$$outer() {
            return this.$outer;
        }
    }
}

