/*
 * Decompiled with CFR 0.152.
 */
package js7.controller.configuration;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import js7.base.configutils.Configs$;
import js7.base.io.JavaResource$;
import js7.base.io.file.FileUtils$syntax$;
import js7.base.io.file.FileUtils$syntax$RichPath$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.time.JavaTimeConverters$;
import js7.base.time.JavaTimeConverters$AsScalaDuration$;
import js7.base.utils.Tests$;
import js7.cluster.ClusterConf;
import js7.cluster.ClusterConf$;
import js7.common.commandline.CommandLineArguments;
import js7.common.configuration.CommonConfiguration;
import js7.common.configuration.CommonConfiguration$Common$;
import js7.common.configuration.Js7Configuration$;
import js7.common.pekkohttp.web.data.WebServerPort;
import js7.common.pekkohttp.web.data.WebServerPort$;
import js7.common.pekkohttp.web.data.WebServerPort$Https$;
import js7.common.utils.FreeTcpPortFinder$;
import js7.controller.configuration.ControllerConfiguration;
import js7.data.controller.ControllerId;
import js7.data.controller.ControllerId$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class ControllerConfiguration$
implements Mirror.Product,
Serializable {
    private static final String DefaultName;
    private volatile Object DefaultConfig$lzy1;
    public static final ControllerConfiguration$ MODULE$;

    private ControllerConfiguration$() {
    }

    static {
        MODULE$ = new ControllerConfiguration$();
        DefaultName = Tests$.MODULE$.isTest() ? "Controller" : "JS7";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ControllerConfiguration$.class);
    }

    public ControllerConfiguration apply(ControllerId controllerId, Path dataDirectory, Path configDirectory, Seq<WebServerPort> webServerPorts, ZoneId timeZone, Timeout pekkoAskTimeout, ClusterConf clusterConf, String name, Config config) {
        return new ControllerConfiguration(controllerId, dataDirectory, configDirectory, webServerPorts, timeZone, pekkoAskTimeout, clusterConf, name, config);
    }

    public ControllerConfiguration unapply(ControllerConfiguration x$1) {
        return x$1;
    }

    public String DefaultName() {
        return DefaultName;
    }

    public ControllerConfiguration forTest(Path configAndData, Config config, Option<Object> httpPort, Option<Object> httpsPort, String name) {
        Path work;
        Path state;
        Path data = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(configAndData), "data");
        if (!Files.exists(data, new LinkOption[0])) {
            Files.createDirectory(data, new FileAttribute[0]);
        }
        if (!Files.exists(state = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(data), "state"), new LinkOption[0])) {
            Files.createDirectory(state, new FileAttribute[0]);
        }
        if (!Files.exists(work = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(data), "work"), new LinkOption[0])) {
            Files.createDirectory(work, new FileAttribute[0]);
        }
        Path path = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(configAndData), "config");
        Option<ControllerId> option = this.fromDirectories$default$4();
        ControllerConfiguration controllerConfiguration = this.fromDirectories(path, data, config, option, name);
        Option option2 = httpPort.map((Function1 & Serializable)o -> WebServerPort$.MODULE$.localhost(BoxesRunTime.unboxToInt((Object)o)));
        List list = (List)httpsPort.map((Function1 & Serializable)o -> WebServerPort$Https$.MODULE$.apply(new InetSocketAddress("127.0.0.1", BoxesRunTime.unboxToInt((Object)o)))).toList().$plus$plus$colon((IterableOnce)option2);
        ControllerId controllerId = controllerConfiguration.copy$default$1();
        Path path2 = controllerConfiguration.copy$default$2();
        Path path3 = controllerConfiguration.copy$default$3();
        ZoneId zoneId = controllerConfiguration.copy$default$5();
        Timeout timeout = controllerConfiguration.copy$default$6();
        ClusterConf clusterConf = controllerConfiguration.copy$default$7();
        String string = controllerConfiguration.copy$default$8();
        Config config2 = controllerConfiguration.copy$default$9();
        return controllerConfiguration.copy(controllerId, path2, path3, (Seq<WebServerPort>)list, zoneId, timeout, clusterConf, string, config2);
    }

    public Config forTest$default$2() {
        return ConfigFactory.empty();
    }

    public Option<Object> forTest$default$3() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)FreeTcpPortFinder$.MODULE$.findFreeTcpPort()));
    }

    public Option<Object> forTest$default$4() {
        return None$.MODULE$;
    }

    public String forTest$default$5() {
        return this.DefaultName();
    }

    public Config DefaultConfig() {
        Object object = this.DefaultConfig$lzy1;
        if (object instanceof Config) {
            return (Config)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Config)this.DefaultConfig$lzyINIT1();
    }

    private Object DefaultConfig$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.DefaultConfig$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, ControllerConfiguration.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Config config = null;
                    try {
                        config = Configs$.MODULE$.loadResource(JavaResource$.MODULE$.apply("js7/controller/configuration/controller.conf")).withFallback((ConfigMergeable)Js7Configuration$.MODULE$.defaultConfig());
                        object2 = config == null ? LazyVals.NullValue$.MODULE$ : config;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, ControllerConfiguration.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.DefaultConfig$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, ControllerConfiguration.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return config;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, ControllerConfiguration.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ControllerConfiguration fromCommandLine(CommandLineArguments commandLineArguments, Config config) {
        CommonConfiguration.Common common = CommonConfiguration$Common$.MODULE$.fromCommandLineArguments(commandLineArguments);
        ControllerConfiguration conf = this.fromDirectories(common.configDirectory(), common.dataDirectory(), config, (Option<ControllerId>)commandLineArguments.optionAs("--id=", ControllerId$.MODULE$.GenericStringAsString()), this.DefaultName());
        Seq seq = (Seq)common.webServerPorts().$plus$plus(conf.webServerPorts());
        ControllerId controllerId = conf.copy$default$1();
        Path path = conf.copy$default$2();
        Path path2 = conf.copy$default$3();
        ZoneId zoneId = conf.copy$default$5();
        Timeout timeout = conf.copy$default$6();
        ClusterConf clusterConf = conf.copy$default$7();
        String string = conf.copy$default$8();
        Config config2 = conf.copy$default$9();
        return conf.copy(controllerId, path, path2, (Seq<WebServerPort>)seq, zoneId, timeout, clusterConf, string, config2);
    }

    public Config fromCommandLine$default$2() {
        return ConfigFactory.empty();
    }

    private ControllerConfiguration fromDirectories(Path configDirectory, Path dataDirectory, Config extraDefaultConfig, Option<ControllerId> maybeControllerId, String name) {
        Path dataDir = dataDirectory.toAbsolutePath();
        Path configDir = configDirectory.toAbsolutePath();
        Config config = this.resolvedConfig(configDir, dataDir, extraDefaultConfig);
        ControllerId controllerId = (ControllerId)maybeControllerId.getOrElse(() -> ControllerConfiguration$.$anonfun$3(config));
        Either either = Checked$.MODULE$.Ops(ClusterConf$.MODULE$.fromConfig(config));
        return new ControllerConfiguration(controllerId, dataDir, configDir, (Seq<WebServerPort>)package$.MODULE$.Nil(), ZoneId.systemDefault(), Timeout$.MODULE$.durationToTimeout(JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration(config.getDuration("js7.pekko.ask-timeout")))), (ClusterConf)Checked$Ops$.MODULE$.orThrow$extension(either), name, config);
    }

    private Option<ControllerId> fromDirectories$default$4() {
        return None$.MODULE$;
    }

    private Config resolvedConfig(Path configDirectory, Path dataDirectory, Config extraDefaultConfig) {
        Config config = this.configDirectoryToConfig(configDirectory);
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"js7.config-directory");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)configDirectory.toString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"js7.data-directory");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)dataDirectory.toString());
        return ConfigFactory.parseMap((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).withFallback((ConfigMergeable)ConfigFactory.systemProperties()).withFallback((ConfigMergeable)config).withFallback((ConfigMergeable)extraDefaultConfig).withFallback((ConfigMergeable)this.DefaultConfig()).resolve();
    }

    private Config configDirectoryToConfig(Path configDirectory) {
        return Configs$.MODULE$.parseConfigIfExists(FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(configDirectory), "private/private.conf"), true).withFallback((ConfigMergeable)Configs$.MODULE$.parseConfigIfExists(FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(configDirectory), "controller.conf"), false));
    }

    public ControllerConfiguration fromProduct(Product x$0) {
        return new ControllerConfiguration((ControllerId)x$0.productElement(0), (Path)x$0.productElement(1), (Path)x$0.productElement(2), (Seq<WebServerPort>)((Seq)x$0.productElement(3)), (ZoneId)x$0.productElement(4), (Timeout)x$0.productElement(5), (ClusterConf)x$0.productElement(6), (String)x$0.productElement(7), (Config)x$0.productElement(8));
    }

    private static final ControllerId $anonfun$3(Config config$3) {
        return (ControllerId)ControllerId$.MODULE$.apply(config$3.getString("js7.controller.id"));
    }
}

