/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.files;

import com.typesafe.scalalogging.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import js7.base.io.file.FileUtils$;
import js7.base.log.Logger$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$CheckedOption$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.Assertions$;
import js7.base.utils.AutoClosing$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.journal.files.JournalFile;
import js7.journal.files.JournalFile$;
import js7.journal.files.JournalFiles$extensions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Try$;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public final class JournalFiles$
implements Serializable {
    public static final Logger js7$journal$files$JournalFiles$$$logger;
    public static final JournalFiles$extensions$ extensions;
    public static final JournalFiles$ MODULE$;

    private JournalFiles$() {
    }

    static {
        MODULE$ = new JournalFiles$();
        js7$journal$files$JournalFiles$$$logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(JournalFiles$.class));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JournalFiles$.class);
    }

    public Either<Problem, Path> currentFile(Path journalFileBase) {
        Option option = Checked$.MODULE$.CheckedOption(this.listJournalFiles(journalFileBase).lastOption().map((Function1 & Serializable)_$1 -> _$1.file()));
        return Checked$CheckedOption$.MODULE$.toChecked$extension(option, (Function0<Problem>)((Function0 & Serializable)() -> JournalFiles$.currentFile$$anonfun$2(journalFileBase)));
    }

    public Vector<JournalFile> listJournalFiles(Path journalFileBase) {
        return this.listFiles(journalFileBase, (Function1 & Serializable)iterator -> {
            JournalFile.Matcher matcher = new JournalFile.Matcher(journalFileBase.getFileName());
            return (Vector)iterator.flatMap((Function1 & Serializable)file -> matcher.checkedJournalFile((Path)file).toOption()).toVector().sortBy((Function1 & Serializable)_$2 -> _$2.fileEventId(), (Ordering)Ordering.Long$.MODULE$);
        });
    }

    public Vector<Path> listGarbageFiles(Path journalFileBase, long untilFileEventId) {
        Pattern pattern = JournalFile$.MODULE$.garbagePattern(journalFileBase.getFileName());
        return this.listFiles(journalFileBase, (Function1 & Serializable)_$3 -> (Vector)_$3.filter((Function1 & Serializable)file -> {
            Matcher matcher = pattern.matcher(file.getFileName().toString());
            return matcher.matches() && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply(() -> JournalFiles$.listGarbageFiles$$anonfun$1$$anonfun$1$$anonfun$1(matcher, untilFileEventId)).getOrElse(JournalFiles$::listGarbageFiles$$anonfun$1$$anonfun$1$$anonfun$2));
        }).toVector().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
    }

    private <A> Vector<A> listFiles(Path journalFileBase, Function1<Iterator<Path>, Vector<A>> body) {
        Path directory = journalFileBase.getParent();
        if (!Files.exists(directory, new LinkOption[0])) {
            return package$.MODULE$.Vector().empty();
        }
        if (journalFileBase.getFileName() == null) {
            return package$.MODULE$.Vector().empty();
        }
        return (Vector)AutoClosing$.MODULE$.autoClosing(Files.list(directory), (Function1 & Serializable)stream -> (Vector)body.apply((Object)CollectionConverters$.MODULE$.IteratorHasAsScala(stream.iterator()).asScala()));
    }

    public Either<Problem, BoxedUnit> deleteJournalIfMarked(Path fileBase) {
        Left left;
        try {
            Path markerFile = this.deletionMarkerFile(fileBase);
            if (Files.exists(markerFile, new LinkOption[0])) {
                Logger LoggerImpl_this;
                Logger LoggerImpl_this2 = js7$journal$files$JournalFiles$$$logger;
                if (LoggerImpl_this2.underlying().isDebugEnabled()) {
                    LoggerImpl_this2.underlying().debug("Marker file found: {}", (Object)markerFile);
                }
                if ((LoggerImpl_this = js7$journal$files$JournalFiles$$$logger).underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn("DELETE JOURNAL DUE TO JOURNAL RESET IN PREVIOUS RUN");
                }
                this.deleteJournal(fileBase, this.deleteJournal$default$2());
            }
            left = Checked$.MODULE$.unit();
        }
        catch (IOException e) {
            IOException iOException = (IOException)ScalaUtils$syntax$.MODULE$.RichThrowable(e);
            left = package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure(ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(iOException)));
        }
        return left;
    }

    public void deleteJournal(Path fileBase, boolean ignoreFailure) {
        Function1 & Serializable matches = (Function1 & Serializable)string -> JournalFile$.MODULE$.anyJournalFilePattern(fileBase.getFileName()).matcher((CharSequence)string).matches();
        Path markerFile = this.deletionMarkerFile(fileBase);
        if (!Files.exists(markerFile, new LinkOption[0])) {
            FileUtils$.MODULE$.touchFile(markerFile);
        }
        BooleanRef failed = BooleanRef.create((boolean)false);
        this.listFiles(fileBase, (Function1 & Serializable)_$4 -> _$4.filter((Function1 & Serializable)file -> BoxesRunTime.unboxToBoolean((Object)matches.apply((Object)file.getFileName().toString()))).toVector()).foreach((Function1)(JProcedure1 & Serializable)file -> {
            try {
                Logger LoggerImpl_this = js7$journal$files$JournalFiles$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("DELETE JOURNAL FILE {}", file);
                }
                Files.delete(file);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException) {
                    IOException e = (IOException)throwable2;
                    if (ignoreFailure) {
                        Logger LoggerImpl_this = js7$journal$files$JournalFiles$$$logger;
                        if (LoggerImpl_this.underlying().isWarnEnabled()) {
                            Object[] objectArray = new Object[2];
                            objectArray[0] = file;
                            IOException iOException = (IOException)ScalaUtils$syntax$.MODULE$.RichThrowable(e);
                            objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(iOException);
                            LoggerImpl_this.underlying().warn("Delete journal file: {} => {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
                        }
                        failed$1.elem = true;
                    }
                }
                throw throwable;
            }
        });
        if (failed.elem) {
            Logger LoggerImpl_this = js7$journal$files$JournalFiles$$$logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("Journal files will be deleted at next start");
                return;
            }
            return;
        }
        Files.delete(markerFile);
    }

    public boolean deleteJournal$default$2() {
        return false;
    }

    public Path deletionMarkerFile(Path fileBase) {
        return Paths.get(fileBase + "-DELETE!", new String[0]);
    }

    public void updateSymbolicLink(Path fileBase, Path toFile) {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1(toFile, fileBase)), "toFile.toString.startsWith(fileBase.toString)"), FullName$.MODULE$.apply("js7.journal.files.JournalFiles.updateSymbolicLink"), FileName$.MODULE$.apply("JournalFiles.scala"), Line$.MODULE$.apply(119));
        Path symLink = Paths.get(fileBase + "-journal", new String[0]);
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            JournalFiles$.updateSymbolicLink$$anonfun$3(symLink);
            return BoxedUnit.UNIT;
        });
        Try$.MODULE$.apply(() -> JournalFiles$.updateSymbolicLink$$anonfun$4(symLink, toFile));
    }

    private static final String currentFile$$anonfun$2$$anonfun$1(Path journalFileBase$2) {
        return "No journal under '" + journalFileBase$2 + "'";
    }

    private static final Problem currentFile$$anonfun$2(Path journalFileBase$1) {
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> JournalFiles$.currentFile$$anonfun$2$$anonfun$1(journalFileBase$1)), Problem$.MODULE$.apply$default$2());
    }

    private static final boolean listGarbageFiles$$anonfun$1$$anonfun$1$$anonfun$1(Matcher matcher$2, long untilFileEventId$3) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(matcher$2.group(1))) < untilFileEventId$3;
    }

    private static final boolean listGarbageFiles$$anonfun$1$$anonfun$1$$anonfun$2() {
        return false;
    }

    private static final void updateSymbolicLink$$anonfun$1(Path symLink$1) {
        if (Files.exists(symLink$1, LinkOption.NOFOLLOW_LINKS)) {
            Files.delete(symLink$1);
            return;
        }
    }

    public static /* bridge */ /* synthetic */ Object js7$journal$files$JournalFiles$extensions$$$_$updateSymbolicLink$$anonfun$adapted$1(Path symLink$5) {
        JournalFiles$.updateSymbolicLink$$anonfun$1(symLink$5);
        return BoxedUnit.UNIT;
    }

    public static final Path js7$journal$files$JournalFiles$extensions$$$_$updateSymbolicLink$$anonfun$2(Path symLink$2, Path toFile$1) {
        return Files.createSymbolicLink(symLink$2, toFile$1.getFileName(), new FileAttribute[0]);
    }

    private final boolean v$proxy1$1(Path toFile$2, Path fileBase$2) {
        return toFile$2.toString().startsWith(fileBase$2.toString());
    }

    private static final void updateSymbolicLink$$anonfun$3(Path symLink$3) {
        if (Files.exists(symLink$3, LinkOption.NOFOLLOW_LINKS)) {
            Files.delete(symLink$3);
            return;
        }
    }

    private static final Path updateSymbolicLink$$anonfun$4(Path symLink$4, Path toFile$3) {
        return Files.createSymbolicLink(symLink$4, toFile$3.getFileName(), new FileAttribute[0]);
    }
}

