/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.watch;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.unsafe.IORuntime;
import cats.effect.unsafe.Scheduler;
import cats.syntax.package;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import fs2.Stream;
import fs2.Stream$;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.circeutils.CirceUtils$;
import js7.base.circeutils.CirceUtils$RichCirceString$;
import js7.base.data.ByteArray;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$CheckedOption$;
import js7.base.problem.Checked$Ops$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.problem.ProblemCode;
import js7.base.stream.IncreasingNumberSync;
import js7.base.time.JavaTimeConverters$;
import js7.base.time.JavaTimeConverters$AsScalaDuration$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.Timestamp$;
import js7.base.utils.Assertions$;
import js7.base.utils.AutoClosing$;
import js7.base.utils.ByteUnits$;
import js7.base.utils.CloseableIterator;
import js7.base.utils.CloseableIterator$;
import js7.base.utils.Collections$implicits$;
import js7.base.utils.Collections$implicits$RichIterable$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichAny$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.utils.SetOnce;
import js7.base.utils.SetOnce$;
import js7.common.jsonseq.PositionAnd;
import js7.data.Problems$AckFromActiveClusterNodeProblem$;
import js7.data.event.Event;
import js7.data.event.EventId$;
import js7.data.event.JournalHeader$;
import js7.data.event.JournalId;
import js7.data.event.JournalInfo;
import js7.data.event.JournalInfo$;
import js7.data.event.JournalPosition;
import js7.data.event.JournalPosition$;
import js7.data.event.KeyedEvent;
import js7.data.event.Stamped;
import js7.journal.data.JournalLocation;
import js7.journal.files.JournalFiles$extensions$;
import js7.journal.watch.CurrentEventReader;
import js7.journal.watch.EventReader;
import js7.journal.watch.EventWatch;
import js7.journal.watch.FileEventWatch;
import js7.journal.watch.HistoricEventReader;
import js7.journal.watch.JournalEventWatch$;
import js7.journal.watch.JournalEventWatch$HistoricJournalFile$;
import js7.journal.watch.JournalEventWatch$JournalFileIsNotReadyProblem$;
import js7.journal.watch.JournalingObserver;
import js7.journal.watch.RealEventWatch;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SortedMapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.Vector;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Right;
import scala.util.Try$;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public final class JournalEventWatch
implements AutoCloseable,
EventWatch,
RealEventWatch,
FileEventWatch,
JournalingObserver {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JournalEventWatch.class.getDeclaredField("js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1"));
    private IO started;
    private volatile Object js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1;
    private final JournalLocation journalLocation;
    public final Config js7$journal$watch$JournalEventWatch$$config;
    public final IORuntime js7$journal$watch$JournalEventWatch$$ioRuntime;
    private final Scheduler scheduler;
    private final int keepOpenCount;
    private final FiniteDuration releaseEventsDelay;
    private volatile SortedMap<Object, HistoricJournalFile> fileEventIdToHistoric;
    public final SetOnce<JournalId> js7$journal$watch$JournalEventWatch$$journalIdOnce;
    private final Promise<JournalEventWatch> startedPromise;
    private volatile Option<CurrentEventReader> maybeCurrentEventReader;
    private volatile Option<Tuple2<Object, Promise<Option<CurrentEventReader>>>> announcedEventReaderPromise;
    private volatile boolean _isActiveNode;
    public final JournalEventWatch$HistoricJournalFile$ HistoricJournalFile$lzy1;

    public static Config TestConfig() {
        return JournalEventWatch$.MODULE$.TestConfig();
    }

    public static Option<Object> $lessinit$greater$default$3() {
        return JournalEventWatch$.MODULE$.$lessinit$greater$default$3();
    }

    public JournalEventWatch(JournalLocation journalLocation, Config config, Option<Object> announceNextFileEventId, IORuntime ioRuntime) {
        this.journalLocation = journalLocation;
        this.js7$journal$watch$JournalEventWatch$$config = config;
        this.js7$journal$watch$JournalEventWatch$$ioRuntime = ioRuntime;
        this.HistoricJournalFile$lzy1 = new JournalEventWatch$HistoricJournalFile$();
        EventWatch.$init$(this);
        RealEventWatch.$init$(this);
        Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("new JournalEventWatch({}, announceNextFileEventId={})", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{journalLocation, announceNextFileEventId}), Object.class));
        }
        this.scheduler = ioRuntime.scheduler();
        this.keepOpenCount = config.getInt("js7.journal.watch.keep-open");
        this.releaseEventsDelay = JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration(config.getDuration("js7.journal.release-events-delay"))).max(ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(0)));
        Vector vector = (Vector)Collections$implicits$.MODULE$.RichIterable((Iterable)JournalFiles$extensions$.MODULE$.listJournalFiles(journalLocation).map((Function1 & Serializable)o -> new HistoricJournalFile(this, o.fileEventId(), o.file(), this.HistoricJournalFile().$lessinit$greater$default$3())));
        this.fileEventIdToHistoric = (SortedMap)((SortedMapOps)SortedMap$.MODULE$.empty((Ordering)Ordering.Long$.MODULE$)).$plus$plus(Collections$implicits$RichIterable$.MODULE$.toKeyedMap$extension((Iterable)vector, (Function1 & Serializable)_$1 -> _$1.fileEventId()));
        this.fileEventIdToHistoric.values().foreach((Function1)(JProcedure1 & Serializable)historic -> {
            Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug(historic.toString());
                return;
            }
        });
        this.js7$journal$watch$JournalEventWatch$$journalIdOnce = SetOnce$.MODULE$.fromOption(this.fileEventIdToHistoric.lastOption().map((Function1 & Serializable)_$2 -> ((HistoricJournalFile)_$2._2()).file().toFile()).map((Function1 & Serializable)file -> {
            Either either = Checked$.MODULE$.Ops(Checked$.MODULE$.catchNonFatal(() -> JournalEventWatch.$init$$$anonfun$5$$anonfun$1(file)).flatMap((Function1 & Serializable)_$4 -> CirceUtils$RichCirceString$.MODULE$.parseJsonAs$extension(CirceUtils$.MODULE$.RichCirceString((String)_$4), JournalHeader$.MODULE$.jsonCodec())).map((Function1 & Serializable)_$5 -> _$5.journalId()));
            Either either2 = Checked$.MODULE$.Ops(Checked$Ops$.MODULE$.mapProblem$extension(either, (Function1<Problem, Problem>)(Function1 & Serializable)_$6 -> (Problem)package.semigroup$.MODULE$.catsSyntaxSemigroup((Object)Problem$.MODULE$.pure("Invalid journal file '" + file + "': "), Problem$.MODULE$.problemSemigroup()).$bar$plus$bar(_$6)));
            return (JournalId)Checked$Ops$.MODULE$.orThrow$extension(either2);
        }), Tag$.MODULE$.apply(JournalId.class, LightTypeTag$.MODULE$.parse(810931298, "\u0004\u0000\u0001\u0018js7.data.event.JournalId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\u0018js7.data.event.JournalId\u0001\u0001\u0004\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)));
        this.startedPromise = Promise$.MODULE$.apply();
        this.maybeCurrentEventReader = None$.MODULE$;
        this.announcedEventReaderPromise = announceNextFileEventId.map((Function1 & Serializable)_$7 -> JournalEventWatch.$init$$$anonfun$6(BoxesRunTime.unboxToLong((Object)_$7)));
        this._isActiveNode = false;
        Statics.releaseFence();
    }

    public IO started() {
        return this.started;
    }

    @Override
    public void js7$journal$watch$EventWatch$_setter_$started_$eq(IO x$0) {
        this.started = x$0;
    }

    @Override
    public IncreasingNumberSync js7$journal$watch$RealEventWatch$$committedEventIdSync() {
        Object object = this.js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1;
        if (object instanceof IncreasingNumberSync) {
            return (IncreasingNumberSync)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (IncreasingNumberSync)this.js7$journal$watch$RealEventWatch$$committedEventIdSync$lzyINIT1();
    }

    private Object js7$journal$watch$RealEventWatch$$committedEventIdSync$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    IncreasingNumberSync increasingNumberSync = null;
                    try {
                        increasingNumberSync = RealEventWatch.js7$journal$watch$RealEventWatch$$committedEventIdSync$(this);
                        object2 = increasingNumberSync == null ? LazyVals.NullValue$.MODULE$ : increasingNumberSync;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return increasingNumberSync;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public JournalLocation journalLocation() {
        return this.journalLocation;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public void close() {
        this.fileEventIdToHistoric.values().foreach((Function1)(JProcedure1 & Serializable)_$8 -> _$8.close());
        this.maybeCurrentEventReader.foreach((Function1)(JProcedure1 & Serializable)_$9 -> _$9.close());
        this.announcedEventReaderPromise.foreach((Function1 & Serializable)o -> ((Promise)o._2()).trySuccess((Object)None$.MODULE$));
    }

    public Future<JournalEventWatch> whenStarted() {
        return this.startedPromise.future();
    }

    public void onFailover() {
        this._isActiveNode = true;
    }

    @Override
    public boolean isActiveNode() {
        return this._isActiveNode;
    }

    public void isActiveNode_$eq(boolean value) {
        this._isActiveNode = value;
    }

    @Override
    public void onJournalingStarted(Path file, JournalId expectedJournalId, PositionAnd<Object> firstEventPositionAndFileEventId, PositionAnd<Object> flushedLengthAndEventId, boolean isActiveNode) {
        Option<JournalId> option;
        Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("onJournalingStarted " + file.getFileName() + ", " + ("firstEventPositionAndFileEventId=" + firstEventPositionAndFileEventId + ", ") + ("flushedLengthAndEventId=" + flushedLengthAndEventId));
        }
        if (None$.MODULE$.equals(option = this.js7$journal$watch$JournalEventWatch$$journalIdOnce.toOption())) {
            v0 = this.js7$journal$watch$JournalEventWatch$$journalIdOnce.$colon$eq(expectedJournalId);
        } else if (option instanceof Some) {
            JournalId o = (JournalId)((Some)option).value();
            JournalId journalId = expectedJournalId;
            JournalId journalId2 = o;
            Predef$.MODULE$.require(!(journalId != null ? !((Object)journalId).equals(journalId2) : journalId2 != null), () -> JournalEventWatch.onJournalingStarted$$anonfun$1(o, expectedJournalId));
            v0 = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        JournalEventWatch journalEventWatch = this;
        synchronized (journalEventWatch) {
            this._isActiveNode = isActiveNode;
            long after = BoxesRunTime.unboxToLong((Object)flushedLengthAndEventId.value());
            if (after < this.lastEventId()) {
                throw new IllegalArgumentException("Invalid onJournalingStarted(after=" + after + "), must be \u2265 " + this.lastEventId());
            }
            this.maybeCurrentEventReader.foreach((Function1)(JProcedure1 & Serializable)current -> {
                Path path = file;
                Path path2 = current.journalFile();
                if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                    throw scala.sys.package$.MODULE$.error("onJournalingStarted: file == current.journalFile == " + file.getFileName());
                }
                if (current.lastEventId() != BoxesRunTime.unboxToLong(firstEventPositionAndFileEventId.value())) {
                    throw new IllegalArgumentException("onJournalingStarted(" + firstEventPositionAndFileEventId.value() + ") " + ("does not match lastEventId=" + current.lastEventId()));
                }
                this.fileEventIdToHistoric.get((Object)BoxesRunTime.boxToLong((long)current.fileEventId())).foreach((Function1)(JProcedure1 & Serializable)o -> o.closeAfterUse());
                HistoricJournalFile historic = new HistoricJournalFile(this, current.fileEventId(), current.journalFile(), (Option<EventReader>)Some$.MODULE$.apply(current));
                Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("Add {}", (Object)historic);
                }
                Long l = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)current.fileEventId()));
                this.fileEventIdToHistoric = (SortedMap)this.fileEventIdToHistoric.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l, (Object)historic));
            });
            CurrentEventReader currentEventReader = new CurrentEventReader(this.journalLocation(), expectedJournalId, firstEventPositionAndFileEventId, flushedLengthAndEventId, isActiveNode, this.js7$journal$watch$JournalEventWatch$$config, this.js7$journal$watch$JournalEventWatch$$ioRuntime);
            this.maybeCurrentEventReader = Some$.MODULE$.apply((Object)currentEventReader);
            Logger LoggerImpl_this2 = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
            if (LoggerImpl_this2.underlying().isDebugEnabled()) {
                LoggerImpl_this2.underlying().debug("currentEventReader={}", (Object)currentEventReader);
            }
            this.announcedEventReaderPromise.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                long eventId = BoxesRunTime.unboxToLong((Object)tuple2._1());
                Promise promise = (Promise)tuple2._2();
                if (eventId == BoxesRunTime.unboxToLong(firstEventPositionAndFileEventId.value())) {
                    promise.success((Object)Some$.MODULE$.apply((Object)currentEventReader));
                    return;
                }
            });
        }
        this.onFileWritten(flushedLengthAndEventId.position());
        this.onEventsCommitted(BoxesRunTime.unboxToLong((Object)flushedLengthAndEventId.value()));
        this.startedPromise.trySuccess((Object)this);
        this.evictUnusedEventReaders();
    }

    @Override
    public void onJournalingEnded(long fileLength) {
        this.maybeCurrentEventReader.foreach((Function1)(JProcedure1 & Serializable)o -> {
            Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("onJournalingEnded {} fileLength={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{o.journalFile().getFileName(), BoxesRunTime.boxToLong((long)fileLength)}), Object.class));
            }
            Long l = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)o.lastEventId()));
            this.announcedEventReaderPromise = Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l, (Object)Promise$.MODULE$.apply()));
            o.onJournalingEnded(fileLength);
        });
    }

    @Override
    public void releaseEvents(long untilEventId, IORuntime ioRuntime) {
        FiniteDuration delay = EventId$.MODULE$.toTimestamp(untilEventId).$plus(this.releaseEventsDelay).$minus(Timestamp$.MODULE$.now());
        if (ScalaTime$RichFiniteDuration$.MODULE$.isZeroOrBelow$extension(ScalaTime$.MODULE$.RichFiniteDuration(delay))) {
            this.releaseEventsNow(untilEventId);
            return;
        }
        Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("releaseEvents({}), delay {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToLong((long)untilEventId), ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(delay))}), Object.class));
        }
        MonixLikeExtensions$.MODULE$.scheduleOnce(ioRuntime.scheduler(), delay, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.releaseEvents$$anonfun$1(untilEventId);
            return BoxedUnit.UNIT;
        }, FullName$.MODULE$.apply("js7.journal.watch.JournalEventWatch.releaseEvents"));
    }

    private void releaseEventsNow(long untilEventId) {
        Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("releaseEventsNow({})", (Object)BoxesRunTime.boxToLong((long)untilEventId));
        }
        long untilFileEventId = this.eventIdToFileEventId(untilEventId);
        this.deleteJournalFiles(untilFileEventId);
        this.deleteGarbageFiles(untilFileEventId);
    }

    private long eventIdToFileEventId(long eventId) {
        CurrentEventReader current;
        Option<CurrentEventReader> option = this.maybeCurrentEventReader;
        if (option instanceof Some && (current = (CurrentEventReader)((Some)option).value()).fileEventId() <= eventId) {
            return current.fileEventId();
        }
        return BoxesRunTime.unboxToLong((Object)this.historicJournalFileAfter(eventId).fold(JournalEventWatch::eventIdToFileEventId$$anonfun$1, (Function1 & Serializable)_$10 -> _$10.fileEventId()));
    }

    private void deleteJournalFiles(long untilFileEventId) {
        Iterable obsoletes = (Iterable)this.fileEventIdToHistoric.values().filter((Function1 & Serializable)_$11 -> _$11.fileEventId() < untilFileEventId);
        obsoletes.foreach((Function1)(JProcedure1 & Serializable)historic -> {
            block10: {
                Path filename = historic.file().getFileName();
                Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("Delete obsolete journal file '" + filename + "' " + ("(" + Try$.MODULE$.apply(() -> JournalEventWatch.deleteJournalFiles$$anonfun$1$$anonfun$1(historic)).fold((Function1 & Serializable)x2 -> (Serializable)Predef$.MODULE$.identity(x2), (Function1 & Serializable)x2 -> (Serializable)Predef$.MODULE$.identity(x2)) + ")"));
                }
                historic.close();
                try {
                    Files.delete(historic.file());
                    JournalEventWatch journalEventWatch = this;
                    synchronized (journalEventWatch) {
                        this.fileEventIdToHistoric = (SortedMap)this.fileEventIdToHistoric.$minus((Object)BoxesRunTime.boxToLong((long)historic.fileEventId()));
                    }
                }
                catch (IOException e) {
                    if (!Files.exists(historic.file(), new LinkOption[0])) {
                        JournalEventWatch journalEventWatch = this;
                        synchronized (journalEventWatch) {
                            this.fileEventIdToHistoric = (SortedMap)this.fileEventIdToHistoric.$minus((Object)BoxesRunTime.boxToLong((long)historic.fileEventId()));
                            break block10;
                        }
                    }
                    Logger LoggerImpl_this2 = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
                    if (!LoggerImpl_this2.underlying().isWarnEnabled()) break block10;
                    Object[] objectArray = new Object[2];
                    objectArray[0] = filename;
                    IOException iOException = (IOException)ScalaUtils$syntax$.MODULE$.RichThrowable(e);
                    objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(iOException);
                    LoggerImpl_this2.underlying().warn("Cannot delete obsolete journal file '{}': {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
                }
            }
        });
    }

    private void deleteGarbageFiles(long untilFileEventId) {
        JournalFiles$extensions$.MODULE$.listGarbageFiles(this.journalLocation(), untilFileEventId).foreach((Function1)(JProcedure1 & Serializable)file -> {
            block3: {
                Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("Delete garbage journal file '{}'", (Object)file.getFileName());
                }
                try {
                    Files.delete(file);
                }
                catch (IOException e) {
                    Logger LoggerImpl_this2;
                    if (!Files.exists(file, new LinkOption[0]) || !(LoggerImpl_this2 = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger).underlying().isWarnEnabled()) break block3;
                    Object[] objectArray = new Object[2];
                    objectArray[0] = file;
                    IOException iOException = (IOException)ScalaUtils$syntax$.MODULE$.RichThrowable(e);
                    objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(iOException);
                    LoggerImpl_this2.underlying().warn("Cannot delete garbage journal file '{}': {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
                }
            }
        });
    }

    @Override
    public void onFileWritten(long flushedPosition) {
        this.maybeCurrentEventReader.foreach((Function1)(JProcedure1 & Serializable)o -> o.onFileWritten(flushedPosition));
    }

    @Override
    public void onEventsCommitted(PositionAnd<Object> positionAndEventId, int n) {
        Either either = Checked$.MODULE$.Ops(this.checkedCurrentEventReader());
        ((CurrentEventReader)Checked$Ops$.MODULE$.orThrow$extension(either)).onEventsCommitted(positionAndEventId, n);
        this.onEventsCommitted(BoxesRunTime.unboxToLong((Object)positionAndEventId.value()));
    }

    public Option<Stream<IO, Object>> snapshotAfter(long after) {
        return this.rawSnapshotAfter(after).map((Function1 & Serializable)_$12 -> StreamExtensions$.MODULE$.mapParallelBatch(_$12, StreamExtensions$.MODULE$.mapParallelBatch$default$2(_$12), StreamExtensions$.MODULE$.mapParallelBatch$default$3(_$12), StreamExtensions$.MODULE$.mapParallelBatch$default$4(_$12), (Function1 & Serializable)_$13 -> {
            Either either = Checked$.MODULE$.Ops(_$13.parseJsonAs(this.journalLocation().snapshotObjectJsonCodec()));
            return Checked$Ops$.MODULE$.orThrow$extension(either);
        }));
    }

    @Override
    public Option<Stream<IO, ByteArray>> rawSnapshotAfter(long after) {
        CurrentEventReader current;
        Option<CurrentEventReader> option = this.maybeCurrentEventReader;
        if (option instanceof Some && (current = (CurrentEventReader)((Some)option).value()).fileEventId() <= after) {
            return Some$.MODULE$.apply((Object)current.rawSnapshot());
        }
        return this.historicJournalFileAfter(after).map((Function1 & Serializable)historicJournalFile -> {
            block0: {
                Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
                if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
                LoggerImpl_this.underlying().debug("Reading snapshot from {}", historicJournalFile);
            }
            return historicJournalFile.eventReader().rawSnapshot();
        });
    }

    @Override
    public Option<CloseableIterator<Stamped<KeyedEvent<Event>>>> eventsAfter(long after) {
        CurrentEventReader current;
        Option<CurrentEventReader> option = this.maybeCurrentEventReader;
        Option result = option instanceof Some && (current = (CurrentEventReader)((Some)option).value()).fileEventId() <= after ? current.eventsAfter(after) : this.historicEventsAfter(after);
        this.evictUnusedEventReaders();
        return result;
    }

    public String toString() {
        return "JournalEventWatch(" + this.journalLocation().name() + ")";
    }

    private Option<CloseableIterator<Stamped<KeyedEvent<Event>>>> historicEventsAfter(long after) {
        return this.historicJournalFileAfter(after).flatMap((Function1 & Serializable)historicJournalFile -> {
            LongRef last = LongRef.create((long)after);
            return historicJournalFile.eventReader().eventsAfter(after).map((Function1 & Serializable)events -> events.tapEach((JProcedure1 & Serializable)stamped -> {
                last$2.elem = stamped.eventId();
            }).concat(() -> this.historicEventsAfter$$anonfun$1$$anonfun$1$$anonfun$2(last, after)));
        });
    }

    private void evictUnusedEventReaders() {
        ((Vector)((IterableOnceOps)this.fileEventIdToHistoric.values().filter((Function1 & Serializable)_$14 -> _$14.isEvictable())).toVector().sortBy((Function1 & Serializable)_$15 -> _$15.lastUsedAt(), (Ordering)Ordering.Long$.MODULE$)).dropRight(this.keepOpenCount).foreach((Function1)(JProcedure1 & Serializable)_$16 -> _$16.evictEventReader());
    }

    private Option<HistoricJournalFile> historicJournalFileAfter(long after) {
        return this.fileEventIdToHistoric.values().toVector().reverseIterator().find((Function1 & Serializable)_$17 -> _$17.fileEventId() <= after);
    }

    @Override
    public Seq<Object> fileEventIds() {
        Seq seq;
        JournalEventWatch journalEventWatch = this;
        synchronized (journalEventWatch) {
            seq = (Seq)((IterableOps)this.fileEventIdToHistoric.keys().toSeq().sorted((Ordering)Ordering.Long$.MODULE$)).$plus$plus((IterableOnce)this.maybeCurrentEventReader.map((Function1 & Serializable)_$18 -> _$18.fileEventId()));
        }
        return seq;
    }

    @Override
    public Either<Problem, JournalPosition> journalPosition() {
        return this.checkedCurrentEventReader().map((Function1 & Serializable)_$19 -> _$19.journalPosition());
    }

    @Override
    public IO<Either<Problem, Stream<IO, PositionAnd<ByteArray>>>> streamFile(JournalPosition journalPosition, Option<FiniteDuration> timeout, boolean markEOF, boolean onlyAcks) {
        return IO$.MODULE$.defer(() -> this.streamFile$$anonfun$1(onlyAcks, journalPosition, timeout, markEOF));
    }

    private long lastEventId() {
        long l;
        JournalEventWatch journalEventWatch = this;
        synchronized (journalEventWatch) {
            long l2;
            Option<CurrentEventReader> option = this.maybeCurrentEventReader;
            if (option instanceof Some) {
                CurrentEventReader o = (CurrentEventReader)((Some)option).value();
                l2 = o.lastEventId();
            } else if (None$.MODULE$.equals(option)) {
                l2 = BoxesRunTime.unboxToLong((Object)this.fileEventIdToHistoric.keys().maxOption((Ordering)Ordering.Long$.MODULE$).getOrElse(JournalEventWatch::lastEventId$$anonfun$1));
            } else {
                throw new MatchError(option);
            }
            l = l2;
        }
        return l;
    }

    @Override
    public JournalInfo journalInfo() {
        JournalInfo journalInfo;
        JournalEventWatch journalEventWatch = this;
        synchronized (journalEventWatch) {
            journalInfo = JournalInfo$.MODULE$.apply(this.lastEventId(), this.tornEventId(), (Seq<JournalPosition>)((IterableOnceOps)((IterableOps)this.fileEventIdToHistoric.values().view().map((Function1 & Serializable)h -> JournalPosition$.MODULE$.apply(h.fileEventId(), BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply(() -> JournalEventWatch.journalInfo$$anonfun$1$$anonfun$1(h)).getOrElse(JournalEventWatch::journalInfo$$anonfun$1$$anonfun$2))))).$plus$plus((IterableOnce)this.maybeCurrentEventReader.map((Function1 & Serializable)_$24 -> _$24.journalPosition()))).toVector());
        }
        return journalInfo;
    }

    private final JournalEventWatch$HistoricJournalFile$ HistoricJournalFile() {
        return this.HistoricJournalFile$lzy1;
    }

    private Either<Problem, CurrentEventReader> checkedCurrentEventReader() {
        Option option = Checked$.MODULE$.CheckedOption(this.maybeCurrentEventReader);
        return Checked$CheckedOption$.MODULE$.toChecked$extension(option, (Function0<Problem>)((Function0 & Serializable)this::checkedCurrentEventReader$$anonfun$1));
    }

    private static final String $init$$$anonfun$5$$anonfun$1(File file$1) {
        return (String)AutoClosing$.MODULE$.autoClosing(Source$.MODULE$.fromFile(file$1, Codec$.MODULE$.charset2codec(StandardCharsets.UTF_8)), (Function1 & Serializable)_$3 -> (String)_$3.getLines().next());
    }

    private static final /* synthetic */ Tuple2 $init$$$anonfun$6(long _$7) {
        Long l = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)_$7));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l, (Object)Promise$.MODULE$.apply());
    }

    private static final Object onJournalingStarted$$anonfun$1(JournalId o$1, JournalId expectedJournalId$1) {
        return "JournalId " + o$1 + " does not match expected " + expectedJournalId$1;
    }

    private final void releaseEvents$$anonfun$1(long untilEventId$1) {
        this.releaseEventsNow(untilEventId$1);
    }

    private static final long eventIdToFileEventId$$anonfun$1() {
        return EventId$.MODULE$.BeforeFirst();
    }

    private static final String deleteJournalFiles$$anonfun$1$$anonfun$1(HistoricJournalFile historic$1) {
        return ByteUnits$.MODULE$.toKBGB(Files.size(historic$1.file()));
    }

    private static final boolean v$proxy1$1(LongRef last$4, long after$4) {
        return last$4.elem > after$4;
    }

    private static final String historicEventsAfter$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(LongRef last$5, long after$5) {
        return "last=" + last$5.elem + " \u2264 after=" + after$5 + " ?";
    }

    private static final CloseableIterator historicEventsAfter$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2() {
        return CloseableIterator$.MODULE$.empty();
    }

    private final CloseableIterator historicEventsAfter$$anonfun$1$$anonfun$1$$anonfun$2(LongRef last$3, long after$3) {
        if (last$3.elem == after$3) {
            return CloseableIterator$.MODULE$.empty();
        }
        Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("Continue with next HistoricEventReader or CurrentEventReader, last={} after={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToLong((long)last$3.elem), BoxesRunTime.boxToLong((long)after$3)}), Object.class));
        }
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)JournalEventWatch.v$proxy1$1(last$3, after$3)), "last > after"), (Function0<String>)((Function0 & Serializable)() -> JournalEventWatch.historicEventsAfter$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(last$3, after$3)), FullName$.MODULE$.apply("js7.journal.watch.JournalEventWatch.historicEventsAfter"), FileName$.MODULE$.apply("JournalEventWatch.scala"), Line$.MODULE$.apply(288));
        return (CloseableIterator)this.eventsAfter(last$3.elem).getOrElse(JournalEventWatch::historicEventsAfter$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2);
    }

    private final Option $anonfun$3(JournalPosition journalPosition$4) {
        return this.fileEventIdToHistoric.get((Object)BoxesRunTime.boxToLong((long)journalPosition$4.fileEventId())).map((Function1 & Serializable)_$21 -> _$21.eventReader());
    }

    private static final String streamFile$$anonfun$1$$anonfun$2(JournalPosition journalPosition$5) {
        return "Unknown journal file=" + journalPosition$5.fileEventId();
    }

    private static final boolean streamFile$$anonfun$1$$anonfun$3$$anonfun$1(boolean onlyAcks$4) {
        return onlyAcks$4;
    }

    private static final IO streamFile$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1() {
        block0: {
            Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
            if (!LoggerImpl_this.underlying().isWarnEnabled()) break block0;
            LoggerImpl_this.underlying().warn(Problems$AckFromActiveClusterNodeProblem$.MODULE$.toString());
        }
        return IO$.MODULE$.raiseError(Problems$AckFromActiveClusterNodeProblem$.MODULE$.throwable());
    }

    private final Right streamFile$$anonfun$1$$anonfun$3(EventReader eventReader$1, JournalPosition journalPosition$6, Option timeout$3, boolean markEOF$3, boolean onlyAcks$3) {
        Stream stream = (Stream)ScalaUtils$syntax$.MODULE$.RichAny(eventReader$1.streamFile(journalPosition$6.position(), (Option<FiniteDuration>)timeout$3, markEOF$3, onlyAcks$3));
        return package$.MODULE$.Right().apply(ScalaUtils$syntax$RichAny$.MODULE$.pipeIf$extension(stream, (Function0<Object>)((Function0 & Serializable)() -> JournalEventWatch.streamFile$$anonfun$1$$anonfun$3$$anonfun$1(onlyAcks$3)), (Function1 & Serializable)_$22 -> _$22.evalTap((Function1 & Serializable)_$23 -> IO$.MODULE$.whenA(this.isActiveNode(), JournalEventWatch::streamFile$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1))));
    }

    private final IO streamFile$$anonfun$1(boolean onlyAcks$1, JournalPosition journalPosition$1, Option timeout$1, boolean markEOF$1) {
        Option maybeEventReader;
        Option option;
        if (onlyAcks$1 && this._isActiveNode) {
            Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn(Problems$AckFromActiveClusterNodeProblem$.MODULE$.toString());
            }
            return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problems$AckFromActiveClusterNodeProblem$.MODULE$);
        }
        Option<Tuple2<Object, Promise<Option<CurrentEventReader>>>> option2 = this.announcedEventReaderPromise;
        if (option2 instanceof Some) {
            Tuple2 tuple2 = (Tuple2)((Some)option2).value();
            if (journalPosition$1.fileEventId() == BoxesRunTime.unboxToLong((Object)tuple2._1())) {
                Logger LoggerImpl_this;
                Promise promise = (Promise)tuple2._2();
                if (!promise.isCompleted() && (LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger).underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("streamFile({}): waiting for this new journal file", (Object)BoxesRunTime.boxToLong((long)journalPosition$1.fileEventId()));
                }
                return IO$.MODULE$.fromFuture(IO$.MODULE$.pure((Object)promise.future())).map((Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (None$.MODULE$.equals(option)) {
                        return package$.MODULE$.Right().apply((Object)Stream$.MODULE$.empty());
                    }
                    if (option instanceof Some) {
                        CurrentEventReader currentEventReader = (CurrentEventReader)((Some)option).value();
                        return package$.MODULE$.Right().apply((Object)currentEventReader.streamFile(journalPosition$1.position(), timeout$1, markEOF$1, onlyAcks$1));
                    }
                    throw new MatchError((Object)option);
                });
            }
        }
        if (None$.MODULE$.equals(option = (maybeEventReader = this.maybeCurrentEventReader.filter((Function1 & Serializable)_$20 -> _$20.fileEventId() == journalPosition$1.fileEventId()).orElse(() -> this.$anonfun$3(journalPosition$1))))) {
            Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("streamFile(" + journalPosition$1 + "): announcedEventReaderPromise=" + this.announcedEventReaderPromise + " " + ("maybeCurrentEventReader=" + this.maybeCurrentEventReader + " ") + ("fileEventIdToHistoric=" + ((IterableOnceOps)this.fileEventIdToHistoric.keys().toVector().sorted((Ordering)Ordering.Long$.MODULE$)).mkString(",")));
            }
            return IO$.MODULE$.pure((Object)package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> JournalEventWatch.streamFile$$anonfun$1$$anonfun$2(journalPosition$1)), Problem$.MODULE$.apply$default$2())));
        }
        if (option instanceof Some) {
            EventReader eventReader = (EventReader)((Some)option).value();
            return IO$.MODULE$.apply(() -> this.streamFile$$anonfun$1$$anonfun$3(eventReader, journalPosition$1, timeout$1, markEOF$1, onlyAcks$1));
        }
        throw new MatchError((Object)option);
    }

    private static final long lastEventId$$anonfun$1() {
        return EventId$.MODULE$.BeforeFirst();
    }

    private static final long journalInfo$$anonfun$1$$anonfun$1(HistoricJournalFile h$1) {
        return Files.size(h$1.file());
    }

    private static final long journalInfo$$anonfun$1$$anonfun$2() {
        return -1L;
    }

    public static final /* synthetic */ void js7$journal$watch$JournalEventWatch$HistoricJournalFile$$_$closeAfterUse$$anonfun$1(EventReader r) {
        r.closeAfterUse();
    }

    public static final /* synthetic */ void js7$journal$watch$JournalEventWatch$HistoricJournalFile$$_$close$$anonfun$4(EventReader r) {
        r.close();
    }

    public static final String js7$journal$watch$JournalEventWatch$HistoricJournalFile$$_$_$$anonfun$5() {
        return "";
    }

    private final Problem checkedCurrentEventReader$$anonfun$1() {
        return JournalEventWatch$JournalFileIsNotReadyProblem$.MODULE$.apply(this.journalLocation().fileBase());
    }

    public final class HistoricJournalFile {
        private final long fileEventId;
        private final Path file;
        private final AtomicReference<EventReader> _eventReader;
        private final /* synthetic */ JournalEventWatch $outer;

        public HistoricJournalFile(JournalEventWatch $outer, long fileEventId, Path file, Option<EventReader> initialEventReader) {
            this.fileEventId = fileEventId;
            this.file = file;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            EventReader initial$proxy1 = (EventReader)initialEventReader.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            this._eventReader = new AtomicReference<EventReader>(initial$proxy1);
        }

        public long fileEventId() {
            return this.fileEventId;
        }

        public Path file() {
            return this.file;
        }

        public void closeAfterUse() {
            Option$.MODULE$.apply((Object)this._eventReader.get()).foreach((Function1)((JProcedure1 & Serializable)JournalEventWatch::js7$journal$watch$JournalEventWatch$HistoricJournalFile$$_$closeAfterUse$$anonfun$1));
        }

        public void close() {
            Option$.MODULE$.apply((Object)this._eventReader.get()).foreach((Function1)((JProcedure1 & Serializable)JournalEventWatch::js7$journal$watch$JournalEventWatch$HistoricJournalFile$$_$close$$anonfun$4));
        }

        public EventReader eventReader() {
            EventReader eventReader;
            while ((eventReader = this._eventReader.get()) == null) {
                HistoricEventReader r = new HistoricEventReader(this.$outer.journalLocation(), this.$outer.js7$journal$watch$JournalEventWatch$$journalIdOnce.orThrow(), this.fileEventId(), this.file(), this.$outer.js7$journal$watch$JournalEventWatch$$config, this.$outer.js7$journal$watch$JournalEventWatch$$ioRuntime);
                if (this._eventReader.compareAndSet(null, r)) {
                    Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("Using {}", (Object)r);
                    }
                    return r;
                }
                r.close();
            }
            EventReader r = eventReader;
            return r;
        }

        public void evictEventReader() {
            EventReader reader = this._eventReader.get();
            if (reader != null) {
                if (!reader.isInUse() && this._eventReader.compareAndSet(reader, null)) {
                    Logger LoggerImpl_this = JournalEventWatch$.js7$journal$watch$JournalEventWatch$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("Evict {} lastUsedAt={})", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{reader, Timestamp$.MODULE$.ofEpochMilli(reader.lastUsedAt())}), Object.class));
                    }
                    reader.closeAfterUse();
                    return;
                }
                return;
            }
        }

        public long lastUsedAt() {
            EventReader eventReader = this._eventReader.get();
            if (eventReader == null) {
                return 0L;
            }
            EventReader reader = eventReader;
            return reader.lastUsedAt();
        }

        public boolean isEvictable() {
            EventReader reader = this._eventReader.get();
            return reader != null && !reader.isInUse();
        }

        public String toString() {
            String fileSize = (String)Try$.MODULE$.apply(this::$anonfun$4).getOrElse(JournalEventWatch::js7$journal$watch$JournalEventWatch$HistoricJournalFile$$_$_$$anonfun$5);
            return "HistoricJournalFile:" + this.file().getFileName() + fileSize;
        }

        public final /* synthetic */ JournalEventWatch js7$journal$watch$JournalEventWatch$HistoricJournalFile$$$outer() {
            return this.$outer;
        }

        private final String $anonfun$4() {
            return " " + ByteUnits$.MODULE$.toKiBGiB(Files.size(this.file()));
        }
    }

    public static class JournalFileIsNotReadyProblem
    implements Problem,
    Problem.Simple,
    Problem.HasCode,
    Problem.Coded,
    Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JournalFileIsNotReadyProblem.class.getDeclaredField("message$lzy1"));
        private volatile Object message$lzy1;
        private ProblemCode code;
        private final Path file;

        public static JournalFileIsNotReadyProblem apply(Path path) {
            return JournalEventWatch$JournalFileIsNotReadyProblem$.MODULE$.apply(path);
        }

        public static JournalFileIsNotReadyProblem fromProduct(Product product) {
            return JournalEventWatch$JournalFileIsNotReadyProblem$.MODULE$.fromProduct(product);
        }

        public static JournalFileIsNotReadyProblem unapply(JournalFileIsNotReadyProblem journalFileIsNotReadyProblem) {
            return JournalEventWatch$JournalFileIsNotReadyProblem$.MODULE$.unapply(journalFileIsNotReadyProblem);
        }

        public JournalFileIsNotReadyProblem(Path file) {
            this.file = file;
            Problem.Coded.$init$(this);
            Statics.releaseFence();
        }

        @Override
        public final String message() {
            Object object = this.message$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.message$lzyINIT1();
        }

        private Object message$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.message$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = Problem.Simple.message$(this);
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.message$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public ProblemCode code() {
            return this.code;
        }

        @Override
        public void js7$base$problem$Problem$Coded$_setter_$code_$eq(ProblemCode x$0) {
            this.code = x$0;
        }

        public boolean canEqual(Object that) {
            return that instanceof JournalFileIsNotReadyProblem;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "JournalFileIsNotReadyProblem";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "file";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path file() {
            return this.file;
        }

        @Override
        public Map<String, String> arguments() {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"file");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.file().getFileName().toString());
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }

        public JournalFileIsNotReadyProblem copy(Path file) {
            return new JournalFileIsNotReadyProblem(file);
        }

        public Path copy$default$1() {
            return this.file();
        }

        public Path _1() {
            return this.file();
        }
    }
}

