/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.write;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.unsafe.IORuntime;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import io.circe.Encoder;
import io.circe.syntax.package;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import js7.base.circeutils.CirceUtils$;
import js7.base.circeutils.CirceUtils$RichJson$;
import js7.base.data.ByteArray;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.metering.CallMeter;
import js7.base.metering.CallMeterMacros$;
import js7.base.thread.CatsBlocking$;
import js7.base.utils.ByteUnits$;
import js7.data.event.Event;
import js7.data.event.EventId$;
import js7.data.event.JournalHeader;
import js7.data.event.JournalHeader$;
import js7.data.event.JournalSeparators$;
import js7.data.event.JournaledState;
import js7.data.event.KeyedEvent;
import js7.data.event.Stamped;
import js7.data.event.Stamped$;
import js7.journal.write.EventJournalWriter;
import js7.journal.write.FileJsonWriter;
import js7.journal.write.JournalWriter$;
import js7.journal.write.StatisticsCounter;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public abstract class JournalWriter
implements AutoCloseable {
    private final JournaledState.HasEventCodec S;
    private boolean _eventsStarted;
    private long _lastEventId;
    private final FileJsonWriter jsonWriter;

    public JournalWriter(JournaledState.HasEventCodec S, long after, boolean append) {
        this.S = S;
        this._eventsStarted = append;
        this._lastEventId = after;
        if (!append && Files.exists(this.file(), new LinkOption[0])) {
            throw scala.sys.package$.MODULE$.error("JournalWriter: Unexpected journal file: " + this.file());
        }
        if (append && !Files.exists(this.file(), new LinkOption[0])) {
            throw scala.sys.package$.MODULE$.error("JournalWriter: Missing journal file: " + this.file());
        }
        this.jsonWriter = new FileJsonWriter(this.file(), append, this.simulateSync());
    }

    public abstract Path file();

    public abstract Option<FiniteDuration> simulateSync();

    public abstract StatisticsCounter statistics();

    public abstract IORuntime ioRuntime();

    public final FileJsonWriter jsonWriter() {
        return this.jsonWriter;
    }

    @Override
    public void close() {
        this.jsonWriter().close();
    }

    public final void writeHeader(JournalHeader header) {
        JournalHeader journalHeader = (JournalHeader)io.circe.syntax.package$.MODULE$.EncoderOps((Object)header);
        this.jsonWriter().write(CirceUtils$RichJson$.MODULE$.toByteArray$extension(CirceUtils$.MODULE$.RichJson(package.EncoderOps$.MODULE$.asJson$extension((Object)journalHeader, JournalHeader$.MODULE$.jsonCodec()))));
        this.flush(false);
    }

    public void beginEventSection(boolean sync) {
        if (this._eventsStarted) {
            throw new IllegalStateException("EventJournalWriter: duplicate beginEventSection()");
        }
        this.jsonWriter().write(CirceUtils$RichJson$.MODULE$.toByteArray$extension(CirceUtils$.MODULE$.RichJson(JournalSeparators$.MODULE$.EventHeader())));
        this.flush(sync);
        this._eventsStarted = true;
    }

    public void writeEvent(Stamped<KeyedEvent<Event>> stamped) {
        this.writeEvents_((Seq<Stamped<KeyedEvent<Event>>>)package$.MODULE$.Nil().$colon$colon(stamped));
    }

    public void writeEvents_(Seq<Stamped<KeyedEvent<Event>>> stampedEvents) {
        stampedEvents.foreach((Function1)(JProcedure1 & Serializable)stamped -> {
            if (stamped.eventId() <= this._lastEventId) {
                throw new IllegalArgumentException("JournalWriter.writeEvent with EventId " + EventId$.MODULE$.toString(stamped.eventId()) + (" <= lastEventId " + EventId$.MODULE$.toString(this._lastEventId) + ": " + stamped.value()));
            }
            this._lastEventId = stamped.eventId();
        });
        if (scala.sys.package$.MODULE$.runtime().availableProcessors() > 1 && IterableOps.SizeCompareOps$.MODULE$.$greater$eq$extension(stampedEvents.sizeIs(), JournalWriter$.js7$journal$write$JournalWriter$$$JsonParallelizationThreshold)) {
            this.writeJsonInParallel((Seq)stampedEvents, (Encoder)Stamped$.MODULE$.jsonEncoder(this.S.keyedEventJsonCodec()));
            return;
        }
        this.writeJsonSerially((Seq)stampedEvents, (Encoder)Stamped$.MODULE$.jsonEncoder(this.S.keyedEventJsonCodec()));
    }

    private <A> void writeJsonSerially(Seq<A> seq, Encoder<A> evidence$1) {
        seq.foreach((Function1)(JProcedure1 & Serializable)a -> this.jsonWriter().write(this.serialize(a, evidence$1)));
    }

    private <A> void writeJsonInParallel(Seq<A> seq, Encoder<A> evidence$1) {
        LazyRef lazyRef = new LazyRef();
        Stream stream = Stream$.MODULE$.iterable(seq);
        CatsBlocking$.MODULE$.unsafeRunSyncX((IO)StreamExtensions$.MODULE$.mapParallelBatch(stream, StreamExtensions$.MODULE$.mapParallelBatch$default$2(stream), StreamExtensions$.MODULE$.mapParallelBatch$default$3(stream), StreamExtensions$.MODULE$.mapParallelBatch$default$4(stream), (Function1 & Serializable)a -> this.serialize(a, evidence$1)).foreach((Function1 & Serializable)byteArray -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.writeJsonInParallel$$anonfun$2$$anonfun$1((ByteArray)byteArray);
            return BoxedUnit.UNIT;
        })).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain(), this.given_IORuntime$1(lazyRef));
    }

    private <A> ByteArray serialize(A a, Encoder<A> evidence$1) {
        ByteArray byteArray;
        try {
            Object object = io.circe.syntax.package$.MODULE$.EncoderOps(a);
            byteArray = CirceUtils$RichJson$.MODULE$.toByteArray$extension(CirceUtils$.MODULE$.RichJson(package.EncoderOps$.MODULE$.asJson$extension(object, evidence$1)));
        }
        catch (Exception t) {
            throw new EventJournalWriter.SerializationException(t);
        }
        return byteArray;
    }

    public final boolean eventsStarted() {
        return this._eventsStarted;
    }

    public final long lastWrittenEventId() {
        return this._lastEventId;
    }

    public final String fileSizeString() {
        String string;
        try {
            string = ByteUnits$.MODULE$.toMB(Files.size(this.file()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                string = t.toString();
            }
            throw throwable;
        }
        return string;
    }

    public void flush(boolean sync) {
        if (!this.jsonWriter().isFlushed()) {
            this.statistics().beforeFlush();
            CallMeter CallMeter_this = JournalWriter$.js7$journal$write$JournalWriter$$$meterFlush;
            CallMeterMacros$.MODULE$.inline$call$i1(CallMeter_this, (Function0 & Serializable)() -> {
                this.flush$$anonfun$1();
                return BoxedUnit.UNIT;
            });
            this.statistics().afterFlush();
        }
        if (sync && !this.isSynced()) {
            this.statistics().beforeSync();
            CallMeter CallMeter_this = JournalWriter$.js7$journal$write$JournalWriter$$$meterSync;
            CallMeterMacros$.MODULE$.inline$call$i1(CallMeter_this, (Function0 & Serializable)() -> {
                this.flush$$anonfun$2();
                return BoxedUnit.UNIT;
            });
            this.statistics().afterSync();
            return;
        }
    }

    public final boolean isFlushed() {
        return this.jsonWriter().isFlushed();
    }

    public final boolean isSynced() {
        return this.jsonWriter().isSynced();
    }

    public final long fileLength() {
        return this.jsonWriter().fileLength();
    }

    public final long bytesWritten() {
        return this.jsonWriter().bytesWritten();
    }

    private final IORuntime given_IORuntime$lzyINIT1$1(LazyRef given_IORuntime$lzy1$1) {
        IORuntime iORuntime;
        LazyRef lazyRef = given_IORuntime$lzy1$1;
        synchronized (lazyRef) {
            iORuntime = (IORuntime)(given_IORuntime$lzy1$1.initialized() ? given_IORuntime$lzy1$1.value() : given_IORuntime$lzy1$1.initialize((Object)this.ioRuntime()));
        }
        return iORuntime;
    }

    private final IORuntime given_IORuntime$1(LazyRef given_IORuntime$lzy1$2) {
        return (IORuntime)(given_IORuntime$lzy1$2.initialized() ? given_IORuntime$lzy1$2.value() : this.given_IORuntime$lzyINIT1$1(given_IORuntime$lzy1$2));
    }

    private final void writeJsonInParallel$$anonfun$2$$anonfun$1(ByteArray byteArray$1) {
        this.jsonWriter().write(byteArray$1);
    }

    private final void flush$$anonfun$1() {
        this.jsonWriter().flush();
    }

    private final void flush$$anonfun$2() {
        this.jsonWriter().sync();
    }
}

