/*
 * Decompiled with CFR 0.152.
 */
package js7.launcher.forwindows;

import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.io.process.Js7Process;
import js7.base.io.process.Pid;
import js7.base.io.process.Pid$;
import js7.base.io.process.ReturnCode;
import js7.base.io.process.ReturnCode$;
import js7.base.io.process.Stderr$;
import js7.base.io.process.Stdout$;
import js7.base.io.process.StdoutOrStderr;
import js7.base.problem.Problem;
import js7.base.utils.SetOnce;
import js7.base.utils.SetOnce$;
import js7.launcher.forwindows.PipeInputStream;
import js7.launcher.forwindows.PipeOutputStream;
import js7.launcher.forwindows.Redirection;
import js7.launcher.forwindows.ResourceGuard;
import js7.launcher.forwindows.ResourceGuard$;
import js7.launcher.forwindows.WindowsApi$;
import js7.launcher.forwindows.WindowsLogon;
import js7.launcher.forwindows.WindowsProcess$;
import js7.launcher.forwindows.WindowsProcess$LoggedOn$;
import js7.launcher.forwindows.WindowsProcess$StartWindowsProcess$;
import js7.launcher.forwindows.WindowsUserName;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Try$;

public final class WindowsProcess
implements Js7Process {
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(WindowsProcess.class.getDeclaredField("maybeHandle$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(WindowsProcess.class.getDeclaredField("stderr$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(WindowsProcess.class.getDeclaredField("stdout$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(WindowsProcess.class.getDeclaredField("stdin$lzy1"));
    public final Redirection js7$launcher$forwindows$WindowsProcess$$inRedirection;
    private final Redirection outRedirection;
    private final Redirection errRedirection;
    private final LoggedOn loggedOn;
    private final Pid pid;
    private final SetOnce<ReturnCode> returnCodeOnce;
    private final ResourceGuard<WinNT.HANDLE> hProcessGuard;
    private volatile Object stdin$lzy1;
    private volatile Object stdout$lzy1;
    private volatile Object stderr$lzy1;
    private volatile Object maybeHandle$lzy1;

    public static ReturnCode TerminateProcessReturnCode() {
        return WindowsProcess$.MODULE$.TerminateProcessReturnCode();
    }

    public static Either<Problem, String> argsToCommandLine(Seq<String> seq) {
        return WindowsProcess$.MODULE$.argsToCommandLine(seq);
    }

    public static Vector<String> execute(Path path, Seq<String> seq) {
        return WindowsProcess$.MODULE$.execute(path, seq);
    }

    public static String injectableUserName(WindowsUserName windowsUserName) {
        return WindowsProcess$.MODULE$.injectableUserName(windowsUserName);
    }

    public static Path makeFileAppendableForUser(Path path, WindowsUserName windowsUserName) {
        return WindowsProcess$.MODULE$.makeFileAppendableForUser(path, windowsUserName);
    }

    public static Path makeFileExecutableForUser(Path path, WindowsUserName windowsUserName) {
        return WindowsProcess$.MODULE$.makeFileExecutableForUser(path, windowsUserName);
    }

    public static Either<Problem, Js7Process> startWithWindowsLogon(StartWindowsProcess startWindowsProcess, Option<WindowsLogon> option) {
        return WindowsProcess$.MODULE$.startWithWindowsLogon(startWindowsProcess, option);
    }

    public static Option<WindowsLogon> startWithWindowsLogon$default$2() {
        return WindowsProcess$.MODULE$.startWithWindowsLogon$default$2();
    }

    public WindowsProcess(WinBase.PROCESS_INFORMATION processInformation, Redirection inRedirection, Redirection outRedirection, Redirection errRedirection, LoggedOn loggedOn) {
        this.js7$launcher$forwindows$WindowsProcess$$inRedirection = inRedirection;
        this.outRedirection = outRedirection;
        this.errRedirection = errRedirection;
        this.loggedOn = loggedOn;
        this.pid = Pid$.MODULE$.apply(Int$.MODULE$.int2long(processInformation.dwProcessId.intValue()));
        this.returnCodeOnce = SetOnce$.MODULE$.apply(Tag$.MODULE$.apply(ReturnCode.class, LightTypeTag$.MODULE$.parse(-621155426, "\u0004\u0000\u0001\u001ejs7.base.io.process.ReturnCode\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.io.process.ReturnCode\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001bjs7.base.generic.GenericInt\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)));
        this.hProcessGuard = ResourceGuard$.MODULE$.apply(processInformation.hProcess, (JProcedure1 & Serializable)hProcess -> {
            Kernel32Util.closeHandle((WinNT.HANDLE)hProcess);
            inRedirection.closePipe();
            outRedirection.closePipe();
            errRedirection.closePipe();
            loggedOn.close();
        });
    }

    @Override
    public Pid pid() {
        return this.pid;
    }

    @Override
    public boolean isAlive() {
        return this.returnCodeOnce.isEmpty() && !this.waitForProcess(0);
    }

    @Override
    public OutputStream stdin() {
        Object object = this.stdin$lzy1;
        if (object instanceof OutputStream) {
            return (OutputStream)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (OutputStream)this.stdin$lzyINIT1();
    }

    private Object stdin$lzyINIT1() {
        Object object;
        block9: {
            while (true) {
                if ((object = this.stdin$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    PipeOutputStream pipeOutputStream = null;
                    try {
                        WinNT.HANDLE hANDLE = this.js7$launcher$forwindows$WindowsProcess$$inRedirection.pipeHandle();
                        WinNT.HANDLE hANDLE2 = WinBase.INVALID_HANDLE_VALUE;
                        if (!(hANDLE != null ? !hANDLE.equals(hANDLE2) : hANDLE2 != null)) {
                            throw new IllegalStateException("WindowsProcess has no handle for stdin attached");
                        }
                        pipeOutputStream = new PipeOutputStream(this){
                            private final /* synthetic */ WindowsProcess $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                super($outer.js7$launcher$forwindows$WindowsProcess$$inRedirection.pipeHandle());
                            }

                            public void close() {
                                this.$outer.js7$launcher$forwindows$WindowsProcess$$inRedirection.closePipe();
                            }
                        };
                        object2 = pipeOutputStream == null ? LazyVals.NullValue$.MODULE$ : pipeOutputStream;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.stdin$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return pipeOutputStream;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block9;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public InputStream stdout() {
        Object object = this.stdout$lzy1;
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (InputStream)this.stdout$lzyINIT1();
    }

    private Object stdout$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.stdout$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    PipeInputStream pipeInputStream = null;
                    try {
                        pipeInputStream = this.newOutErrInputStream(Stdout$.MODULE$, this.outRedirection);
                        object2 = pipeInputStream == null ? LazyVals.NullValue$.MODULE$ : pipeInputStream;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.stdout$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return pipeInputStream;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public InputStream stderr() {
        Object object = this.stderr$lzy1;
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (InputStream)this.stderr$lzyINIT1();
    }

    private Object stderr$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.stderr$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    PipeInputStream pipeInputStream = null;
                    try {
                        pipeInputStream = this.newOutErrInputStream(Stderr$.MODULE$, this.errRedirection);
                        object2 = pipeInputStream == null ? LazyVals.NullValue$.MODULE$ : pipeInputStream;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.stderr$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return pipeInputStream;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public PipeInputStream newOutErrInputStream(StdoutOrStderr outerr, Redirection redirection) {
        WinNT.HANDLE hANDLE = redirection.pipeHandle();
        WinNT.HANDLE hANDLE2 = WinBase.INVALID_HANDLE_VALUE;
        if (!(hANDLE != null ? !hANDLE.equals(hANDLE2) : hANDLE2 != null)) {
            throw new IllegalStateException("WindowsProcess has no handle for " + outerr + " attached");
        }
        return new PipeInputStream(redirection){
            private final Redirection redirection$2;
            {
                this.redirection$2 = redirection$1;
                super(redirection$1.pipeHandle());
            }

            public void close() {
                this.redirection$2.closePipe();
            }
        };
    }

    @Override
    public void destroy() {
        this.destroyForcibly();
    }

    @Override
    public void destroyForcibly() {
        this.hProcessGuard.use((JProcedure1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return;
            }
            if (option instanceof Some) {
                WinNT.HANDLE hProcess = (WinNT.HANDLE)((Some)option).value();
                WindowsApi$.MODULE$.call("TerminateProcess", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]), (Function0<Object>)((Function0 & Serializable)() -> this.destroyForcibly$$anonfun$1$$anonfun$1(hProcess)));
                return;
            }
            throw new MatchError((Object)option);
        });
    }

    @Override
    public boolean waitFor(FiniteDuration timeout) {
        return this.returnCodeOnce.isDefined() || this.waitForProcess((int)Math.max(0L, Math.min(Integer.MAX_VALUE, timeout.toMillis())));
    }

    @Override
    public ReturnCode waitFor() {
        return (ReturnCode)this.returnCodeOnce.getOrElse(this::waitFor$$anonfun$1);
    }

    @Override
    public Option<ReturnCode> returnCode() {
        Option<ReturnCode> option = this.returnCodeOnce.toOption();
        if (option instanceof Some) {
            ReturnCode rc = (ReturnCode)((Some)option).value();
            return Some$.MODULE$.apply((Object)rc);
        }
        if (None$.MODULE$.equals(option)) {
            this.waitForProcess(0);
            return this.returnCodeOnce.toOption();
        }
        throw new MatchError(option);
    }

    private boolean waitForProcess(int timeout) {
        return BoxesRunTime.unboxToBoolean(this.hProcessGuard.use((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                if (this.returnCodeOnce.isEmpty()) {
                    throw new IllegalStateException("WindowsProcess has been closed before started");
                }
                return true;
            }
            if (option instanceof Some) {
                WinNT.HANDLE hProcess = (WinNT.HANDLE)((Some)option).value();
                boolean terminated = WindowsApi$.MODULE$.waitForSingleObject(hProcess, timeout);
                if (terminated) {
                    this.returnCodeOnce.trySet(ReturnCode$.MODULE$.apply(WindowsProcess$.MODULE$.js7$launcher$forwindows$WindowsProcess$$$getExitCodeProcess(hProcess)));
                    this.hProcessGuard.releaseAfterUse();
                }
                return terminated;
            }
            throw new MatchError((Object)option);
        }));
    }

    @Override
    public Option<ProcessHandle> maybeHandle() {
        Object object = this.maybeHandle$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.maybeHandle$lzyINIT1();
    }

    private Object maybeHandle$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.maybeHandle$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        Optional optional = OptionConverters$.MODULE$.RichOptional(ProcessHandle.of(this.pid().number()));
                        option = OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.maybeHandle$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String toString() {
        return "WindowsProcess(" + this.pid() + ")";
    }

    private final boolean destroyForcibly$$anonfun$1$$anonfun$1$$anonfun$1() {
        return this.waitForProcess(0);
    }

    private static final boolean destroyForcibly$$anonfun$1$$anonfun$1$$anonfun$2() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean destroyForcibly$$anonfun$1$$anonfun$1(WinNT.HANDLE hProcess$1) {
        if (WindowsApi$.MODULE$.kernel32().TerminateProcess(hProcess$1, WindowsProcess$.MODULE$.TerminateProcessReturnCode().number())) return true;
        if (WindowsApi$.MODULE$.kernel32().GetLastError() != 5) return false;
        if (BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply(this::destroyForcibly$$anonfun$1$$anonfun$1$$anonfun$1).getOrElse(WindowsProcess::destroyForcibly$$anonfun$1$$anonfun$1$$anonfun$2))) return true;
        WindowsApi$.MODULE$.kernel32().SetLastError(5);
        if (!false) return false;
        return true;
    }

    private final ReturnCode waitFor$$anonfun$1() {
        this.waitForProcess(-1);
        return this.returnCodeOnce.orThrow();
    }

    public static class LoggedOn
    implements AutoCloseable {
        private final WinNT.HANDLE userToken;
        private final WinNT.HANDLE profileHandle;
        private final AtomicBoolean closed;

        public static LoggedOn logon(Option<WindowsLogon> option) {
            return WindowsProcess$LoggedOn$.MODULE$.logon(option);
        }

        public static WinNT.HANDLE $lessinit$greater$default$2() {
            return WindowsProcess$LoggedOn$.MODULE$.$lessinit$greater$default$2();
        }

        public LoggedOn(WinNT.HANDLE userToken, WinNT.HANDLE profileHandle) {
            this.userToken = userToken;
            this.profileHandle = profileHandle;
            this.closed = new AtomicBoolean();
        }

        public WinNT.HANDLE userToken() {
            return this.userToken;
        }

        public WinNT.HANDLE profileHandle() {
            return this.profileHandle;
        }

        @Override
        public void close() {
            if (!this.closed.getAndSet(true)) {
                WinNT.HANDLE hANDLE = this.profileHandle();
                WinNT.HANDLE hANDLE2 = WinBase.INVALID_HANDLE_VALUE;
                if (hANDLE == null ? hANDLE2 != null : !hANDLE.equals(hANDLE2)) {
                    WindowsApi$.MODULE$.call("UnloadUserProfile", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]), (Function0<Object>)((Function0 & Serializable)this::close$$anonfun$1));
                }
                Kernel32Util.closeHandle((WinNT.HANDLE)this.userToken());
                return;
            }
        }

        private final boolean close$$anonfun$1() {
            return WindowsApi$.MODULE$.myUserenv().UnloadUserProfile(this.userToken(), this.profileHandle());
        }
    }

    public static final class StartWindowsProcess
    implements Product,
    Serializable {
        private final Seq<String> args;
        private final ProcessBuilder.Redirect stdinRedirect;
        private final ProcessBuilder.Redirect stdoutRedirect;
        private final ProcessBuilder.Redirect stderrRedirect;
        private final Map<String, Option<String>> additionalEnv;

        public static StartWindowsProcess apply(Seq<String> seq, ProcessBuilder.Redirect redirect, ProcessBuilder.Redirect redirect2, ProcessBuilder.Redirect redirect3, Map<String, Option<String>> map) {
            return WindowsProcess$StartWindowsProcess$.MODULE$.apply(seq, redirect, redirect2, redirect3, map);
        }

        public static StartWindowsProcess fromProduct(Product product) {
            return WindowsProcess$StartWindowsProcess$.MODULE$.fromProduct(product);
        }

        public static StartWindowsProcess unapply(StartWindowsProcess startWindowsProcess) {
            return WindowsProcess$StartWindowsProcess$.MODULE$.unapply(startWindowsProcess);
        }

        public static Map<String, Option<String>> $lessinit$greater$default$5() {
            return WindowsProcess$StartWindowsProcess$.MODULE$.$lessinit$greater$default$5();
        }

        public StartWindowsProcess(Seq<String> args, ProcessBuilder.Redirect stdinRedirect, ProcessBuilder.Redirect stdoutRedirect, ProcessBuilder.Redirect stderrRedirect, Map<String, Option<String>> additionalEnv) {
            this.args = args;
            this.stdinRedirect = stdinRedirect;
            this.stdoutRedirect = stdoutRedirect;
            this.stderrRedirect = stderrRedirect;
            this.additionalEnv = additionalEnv;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StartWindowsProcess)) return false;
            StartWindowsProcess startWindowsProcess = (StartWindowsProcess)object;
            Seq<String> seq = this.args();
            Seq<String> seq2 = startWindowsProcess.args();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            ProcessBuilder.Redirect redirect = this.stdinRedirect();
            ProcessBuilder.Redirect redirect2 = startWindowsProcess.stdinRedirect();
            if (redirect == null) {
                if (redirect2 != null) {
                    return false;
                }
            } else if (!((Object)redirect).equals(redirect2)) return false;
            ProcessBuilder.Redirect redirect3 = this.stdoutRedirect();
            ProcessBuilder.Redirect redirect4 = startWindowsProcess.stdoutRedirect();
            if (redirect3 == null) {
                if (redirect4 != null) {
                    return false;
                }
            } else if (!((Object)redirect3).equals(redirect4)) return false;
            ProcessBuilder.Redirect redirect5 = this.stderrRedirect();
            ProcessBuilder.Redirect redirect6 = startWindowsProcess.stderrRedirect();
            if (redirect5 == null) {
                if (redirect6 != null) {
                    return false;
                }
            } else if (!((Object)redirect5).equals(redirect6)) return false;
            Map<String, Option<String>> map = this.additionalEnv();
            Map<String, Option<String>> map2 = startWindowsProcess.additionalEnv();
            if (map == null) {
                if (map2 == null) return true;
                return false;
            } else {
                if (!map.equals(map2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StartWindowsProcess;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "StartWindowsProcess";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "args";
                }
                case 1: {
                    return "stdinRedirect";
                }
                case 2: {
                    return "stdoutRedirect";
                }
                case 3: {
                    return "stderrRedirect";
                }
                case 4: {
                    return "additionalEnv";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<String> args() {
            return this.args;
        }

        public ProcessBuilder.Redirect stdinRedirect() {
            return this.stdinRedirect;
        }

        public ProcessBuilder.Redirect stdoutRedirect() {
            return this.stdoutRedirect;
        }

        public ProcessBuilder.Redirect stderrRedirect() {
            return this.stderrRedirect;
        }

        public Map<String, Option<String>> additionalEnv() {
            return this.additionalEnv;
        }

        public StartWindowsProcess copy(Seq<String> args, ProcessBuilder.Redirect stdinRedirect, ProcessBuilder.Redirect stdoutRedirect, ProcessBuilder.Redirect stderrRedirect, Map<String, Option<String>> additionalEnv) {
            return new StartWindowsProcess(args, stdinRedirect, stdoutRedirect, stderrRedirect, additionalEnv);
        }

        public Seq<String> copy$default$1() {
            return this.args();
        }

        public ProcessBuilder.Redirect copy$default$2() {
            return this.stdinRedirect();
        }

        public ProcessBuilder.Redirect copy$default$3() {
            return this.stdoutRedirect();
        }

        public ProcessBuilder.Redirect copy$default$4() {
            return this.stderrRedirect();
        }

        public Map<String, Option<String>> copy$default$5() {
            return this.additionalEnv();
        }

        public Seq<String> _1() {
            return this.args();
        }

        public ProcessBuilder.Redirect _2() {
            return this.stdinRedirect();
        }

        public ProcessBuilder.Redirect _3() {
            return this.stdoutRedirect();
        }

        public ProcessBuilder.Redirect _4() {
            return this.stderrRedirect();
        }

        public Map<String, Option<String>> _5() {
            return this.additionalEnv();
        }
    }
}

