/*
 * Decompiled with CFR 0.152.
 */
package js7.launcher.process;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Outcome;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.UnsafeMemoizable$;
import js7.base.io.process.Js7Process;
import js7.base.io.process.Pid;
import js7.base.io.process.ProcessExtensions$;
import js7.base.io.process.ProcessSignal;
import js7.base.io.process.ProcessSignal$SIGKILL$;
import js7.base.io.process.ReturnCode;
import js7.base.io.process.Stderr$;
import js7.base.io.process.Stdout$;
import js7.base.io.process.StdoutOrStderr;
import js7.base.log.Logger$;
import js7.base.log.Logger$syntax$;
import js7.base.problem.Problem;
import js7.base.system.OperatingSystem$;
import js7.base.thread.IOExecutor$env$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.Allocated;
import js7.base.utils.BlockingLock;
import js7.base.utils.BlockingLock$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.data.job.CommandLine;
import js7.data.job.JobKey;
import js7.data.order.OrderId;
import js7.launcher.StdObservers;
import js7.launcher.process.PipedProcess$;
import js7.launcher.process.ProcessConfiguration;
import js7.launcher.processkiller.SubagentProcessKiller;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class PipedProcess {
    private final ProcessConfiguration conf;
    private final Js7Process process;
    private final StdObservers stdObservers;
    private final OrderId orderId;
    private final JobKey jobKey;
    private final Allocated<IO, SubagentProcessKiller> processKillerAlloc;
    private final String label;
    private final Logger logger;
    private final SubagentProcessKiller processKiller;
    private final Deferred<IO, BoxedUnit> sigkilled;
    private Option<ProcessSignal> _isKilling;
    private final BlockingLock _isKillingLock;
    private final Deadline runningSince;
    private final IO<ReturnCode> awaitProcessTermination;
    private final IO<ReturnCode> watchProcessAndStdouterr;

    public static IO<Either<Problem, PipedProcess>> start(CommandLine commandLine, ProcessConfiguration processConfiguration, StdObservers stdObservers, OrderId orderId, JobKey jobKey) {
        return PipedProcess$.MODULE$.start(commandLine, processConfiguration, stdObservers, orderId, jobKey);
    }

    public PipedProcess(ProcessConfiguration conf, Js7Process process, StdObservers stdObservers, OrderId orderId, JobKey jobKey, Allocated<IO, SubagentProcessKiller> processKillerAlloc, String label) {
        this.conf = conf;
        this.process = process;
        this.stdObservers = stdObservers;
        this.orderId = orderId;
        this.jobKey = jobKey;
        this.processKillerAlloc = processKillerAlloc;
        this.label = label;
        this.logger = Logger$.MODULE$.withPrefix(label, ClassTag$.MODULE$.apply(PipedProcess.class));
        this.processKiller = processKillerAlloc.allocatedThing();
        this.sigkilled = cats.effect.package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        this._isKilling = package.option$.MODULE$.none();
        this._isKillingLock = new BlockingLock(BlockingLock$.MODULE$.$lessinit$greater$default$1());
        this.runningSince = Deadline$.MODULE$.now();
        this.awaitProcessTermination = (IO)UnsafeMemoizable$.MODULE$.memoize(((IO)process.maybeHandle().fold(PipedProcess::$init$$$anonfun$1, (Function1 & Serializable)_$1 -> ProcessExtensions$.MODULE$.onExitIO((ProcessHandle)_$1))).$times$greater(IO$.MODULE$.defer(() -> this.$init$$$anonfun$3(process)).flatTap((Function1 & Serializable)rc -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$init$$$anonfun$4$$anonfun$1((ReturnCode)rc);
            return BoxedUnit.UNIT;
        }))), IO$.MODULE$.asyncForIO());
        this.watchProcessAndStdouterr = (IO)UnsafeMemoizable$.MODULE$.memoize(CatsEffectExtensions$.MODULE$.raceBoth(IO$.MODULE$, this.awaitProcessTermination(), CatsEffectExtensions$.MODULE$.raceBoth(IO$.MODULE$, ((IO)this.sigkilled.get()).andWait((Duration)PipedProcess$.js7$launcher$process$PipedProcess$$$killStdoutAndStderrDelay), this.pumpStdoutAndStderrToSink()).flatMap((Function1 & Serializable)x$1 -> {
            Option option;
            Either either = x$1;
            if (either instanceof Left && !(option = package$.MODULE$.Left().unapply((Left)either)).isEmpty()) {
                Tuple2 tuple2 = (Tuple2)option.get();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = tuple2._1();
                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                    Fiber stdouterrFiber = (Fiber)tuple2._2();
                    return IO$.MODULE$.defer(() -> this.$init$$$anonfun$5$$anonfun$1(stdouterrFiber, orderId, jobKey)).as((Object)BoxesRunTime.boxToBoolean((boolean)false));
                }
            }
            if (either instanceof Right) {
                Tuple2 tuple2 = (Tuple2)((Right)either).value();
                Fiber sigkilledFiber = (Fiber)tuple2._1();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = tuple2._2();
                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                    return ((IO)sigkilledFiber.cancel()).as((Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
            }
            throw new MatchError((Object)either);
        })).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Tuple2 tuple2 = (Tuple2)((Left)either).value();
                ReturnCode returnCode = (ReturnCode)tuple2._1();
                Fiber stdouterrFiber = (Fiber)tuple2._2();
                return IO$.MODULE$.defer(() -> this.$init$$$anonfun$6$$anonfun$1(returnCode, conf, orderId, stdouterrFiber)).as((Object)returnCode);
            }
            if (either instanceof Right) {
                Fiber terminationFiber = (Fiber)((Tuple2)((Right)either).value())._1();
                return (IO)CatsEffectExtensions$.MODULE$.joinStd(terminationFiber, IO$.MODULE$.asyncForIO());
            }
            throw new MatchError((Object)either);
        }), IO$.MODULE$.asyncForIO());
    }

    public ProcessConfiguration conf() {
        return this.conf;
    }

    public Js7Process process() {
        return this.process;
    }

    public Pid pid() {
        return this.process().pid();
    }

    public FiniteDuration duration() {
        return ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(this.runningSince));
    }

    public IO<ReturnCode> awaitProcessTermination() {
        return this.awaitProcessTermination;
    }

    public IO<ReturnCode> watchProcessAndStdouterr() {
        return this.watchProcessAndStdouterr;
    }

    public IO<BoxedUnit> release() {
        return this.processKillerAlloc.release();
    }

    private IO<BoxedUnit> pumpStdoutAndStderrToSink() {
        return Logger$syntax$.MODULE$.traceIO(this.logger, "pumpStdoutAndStderrToSink", Logger$syntax$.MODULE$.traceIO$default$3(this.logger), IO$.MODULE$.both(this.pumpOutErrToSink(Stdout$.MODULE$, this.process().stdout()), this.pumpOutErrToSink(Stderr$.MODULE$, this.process().stderr())).void());
    }

    private IO<BoxedUnit> pumpOutErrToSink(StdoutOrStderr outErr, InputStream in) {
        return this.stdObservers.pumpInputStreamToSink(outErr, in, this.conf().encoding()).handleErrorWith((Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof IOException) {
                IOException t = (IOException)throwable;
                if (OperatingSystem$.MODULE$.isWindows() && this._isKilling.isDefined()) {
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        this.pumpOutErrToSink$$anonfun$1$$anonfun$1(outErr, t);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            Throwable t = throwable;
            return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.pumpOutErrToSink$$anonfun$1$$anonfun$2(outErr, t);
                return BoxedUnit.UNIT;
            });
        });
    }

    public IO<BoxedUnit> sendProcessSignal(ProcessSignal signal) {
        return IO$.MODULE$.defer(() -> this.sendProcessSignal$$anonfun$1(signal));
    }

    private IO<BoxedUnit> kill(boolean force) {
        if (!force) {
            return this.processKiller.sigtermMainProcessAndSaveDescendant(this.process());
        }
        return this.processKiller.sigkillWithDescendants(this.process());
    }

    public boolean isAlive() {
        return this.process().isAlive();
    }

    public String toString() {
        return this.label;
    }

    private static final IO $init$$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private static final ReturnCode $init$$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1(Js7Process process$4) {
        return process$4.waitFor();
    }

    private final ReturnCode $init$$$anonfun$3$$anonfun$2$$anonfun$1(Js7Process process$3) {
        return (ReturnCode)Logger$syntax$.MODULE$.traceCallWithResult(this.logger, "waitFor " + process$3, () -> PipedProcess.$init$$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1(process$3));
    }

    private final IO $init$$$anonfun$3$$anonfun$2(Js7Process process$2) {
        return IOExecutor$env$.MODULE$.interruptibleVirtualThread(() -> this.$init$$$anonfun$3$$anonfun$2$$anonfun$1(process$2));
    }

    private final IO $init$$$anonfun$3(Js7Process process$1) {
        return (IO)process$1.returnCode().map((Function1 & Serializable)value -> IO$.MODULE$.pure(value)).getOrElse(() -> this.$init$$$anonfun$3$$anonfun$2(process$1));
    }

    private final void $init$$$anonfun$4$$anonfun$1(ReturnCode rc$1) {
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("Process {} terminated with {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.pid(), rc$1}), Object.class));
            return;
        }
    }

    private final IO $init$$$anonfun$5$$anonfun$1(Fiber stdouterrFiber$1, OrderId orderId$1, JobKey jobKey$1) {
        block0: {
            Logger LoggerImpl_this = this.logger;
            if (!LoggerImpl_this.underlying().isWarnEnabled()) break block0;
            LoggerImpl_this.underlying().warn("Ignoring stdout and stderr after SIGKILL (maybe a child process is still running)");
        }
        return CatsEffectExtensions$.MODULE$.startAndForget(PipedProcess$.MODULE$.js7$launcher$process$PipedProcess$$$joinStdouterr((Fiber<IO, Throwable, BoxedUnit>)stdouterrFiber$1, orderId$1, jobKey$1, PipedProcess$.js7$launcher$process$PipedProcess$$$stdoutAndStderrAbandonAfter));
    }

    private final void $init$$$anonfun$6$$anonfun$1$$anonfun$1(ReturnCode returnCode$2) {
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info("terminated with {}, awaiting stdout or stderr (maybe a child process is still running)", (Object)returnCode$2);
            return;
        }
    }

    private static final String $init$$$anonfun$6$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(boolean ended$1, String what$2, FiniteDuration elapsed$1) {
        if (ended$1) {
            return "\ud83d\udd35 " + what$2 + " ended after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(elapsed$1));
        }
        return "\ud83d\udfe3 " + what$2 + " are still ignored after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(elapsed$1));
    }

    private final IO $init$$$anonfun$6$$anonfun$1(ReturnCode returnCode$1, ProcessConfiguration conf$1, OrderId orderId$3, Fiber stdouterrFiber$2) {
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("terminated with {}", (Object)returnCode$1);
        }
        String what = orderId$3 + " stdout or stderr";
        return (IO)IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$init$$$anonfun$6$$anonfun$1$$anonfun$1(returnCode$1);
            return BoxedUnit.UNIT;
        }).delayBy((Duration)conf$1.worryAboutStdoutAfterTermination()).background().surround(CatsUtils$syntax$.MODULE$.logWhenItTakesLonger((IO)CatsEffectExtensions$.MODULE$.joinStd(stdouterrFiber$2, IO$.MODULE$.asyncForIO()), PipedProcess$.js7$launcher$process$PipedProcess$$$StdouterrWorry, (Function4 & Serializable)(x$1, x$2, x$3, x$4) -> {
            Tuple4 tuple4 = Tuple4$.MODULE$.apply(x$1, x$2, x$3, x$4);
            Option option = (Option)tuple4._1();
            FiniteDuration finiteDuration = (FiniteDuration)tuple4._2();
            String string = (String)tuple4._4();
            if (None$.MODULE$.equals(option)) {
                FiniteDuration elapsed = finiteDuration;
                String sym = string;
                return IO$.MODULE$.pure((Object)(sym + " Still waiting for " + what + " for " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(elapsed))));
            }
            if (option instanceof Some) {
                Outcome outcome = (Outcome)((Some)option).value();
                if (outcome instanceof Outcome.Succeeded) {
                    IO iO;
                    cats.effect.package$.MODULE$.Outcome();
                    Outcome.Succeeded succeeded = Outcome.Succeeded$.MODULE$.unapply((Outcome.Succeeded)outcome);
                    IO ended2 = iO = (IO)succeeded._1();
                    FiniteDuration elapsed = finiteDuration;
                    return ended2.flatMap((Function1 & Serializable)ended -> IO$.MODULE$.apply(() -> PipedProcess.$init$$$anonfun$6$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)ended), what, elapsed)));
                }
                if (outcome instanceof Outcome.Canceled) {
                    cats.effect.package$.MODULE$.Outcome();
                    if (Outcome.Canceled$.MODULE$.unapply((Outcome.Canceled)outcome)) {
                        FiniteDuration elapsed = finiteDuration;
                        String sym = string;
                        return IO$.MODULE$.pure((Object)(sym + " " + what + " canceled after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(elapsed))));
                    }
                }
                if (outcome instanceof Outcome.Errored) {
                    Throwable throwable;
                    cats.effect.package$.MODULE$.Outcome();
                    Outcome.Errored errored = Outcome.Errored$.MODULE$.unapply((Outcome.Errored)outcome);
                    Throwable t = throwable = (Throwable)errored._1();
                    FiniteDuration elapsed = finiteDuration;
                    String sym = string;
                    Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                    return IO$.MODULE$.pure((Object)(sym + " " + what + " failed after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(elapsed)) + " with " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable2)));
                }
            }
            throw new MatchError((Object)tuple4);
        }), (MonadCancel)IO$.MODULE$.asyncForIO());
    }

    private final void pumpOutErrToSink$$anonfun$1$$anonfun$1(StdoutOrStderr outErr$2, IOException t$1) {
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isWarnEnabled()) {
            IOException iOException = (IOException)ScalaUtils$syntax$.MODULE$.RichThrowable(t$1);
            LoggerImpl_this.underlying().warn("While killing the process, " + outErr$2 + " became unreadable: " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(iOException), (Throwable)t$1);
            return;
        }
    }

    private final void pumpOutErrToSink$$anonfun$1$$anonfun$2(StdoutOrStderr outErr$3, Throwable t$2) {
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isWarnEnabled()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = outErr$3;
            Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t$2);
            objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable);
            LoggerImpl_this.underlying().warn("{}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
            return;
        }
    }

    private final void sendProcessSignal$$anonfun$1$$anonfun$1(ProcessSignal signal$2) {
        if (!this._isKilling.contains((Object)ProcessSignal$SIGKILL$.MODULE$)) {
            this._isKilling = Some$.MODULE$.apply((Object)signal$2);
            return;
        }
    }

    private final IO sendProcessSignal$$anonfun$1$$anonfun$2() {
        return ((IO)this.sigkilled.complete((Object)BoxedUnit.UNIT)).void();
    }

    private final IO sendProcessSignal$$anonfun$1(ProcessSignal signal$1) {
        ProcessSignal processSignal = signal$1;
        ProcessSignal$SIGKILL$ processSignal$SIGKILL$ = ProcessSignal$SIGKILL$.MODULE$;
        boolean force = !(processSignal != null ? !processSignal.equals(processSignal$SIGKILL$) : processSignal$SIGKILL$ != null);
        this._isKillingLock.lock((Function0 & Serializable)() -> {
            this.sendProcessSignal$$anonfun$1$$anonfun$1(signal$1);
            return BoxedUnit.UNIT;
        });
        return this.kill(force).guarantee(IO$.MODULE$.whenA(force, this::sendProcessSignal$$anonfun$1$$anonfun$2));
    }
}

