/*
 * Decompiled with CFR 0.152.
 */
package js7.tests.addOrders;

import cats.effect.IO;
import cats.effect.IO$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.Timestamp;
import js7.data.event.Event;
import js7.data.event.KeyedEvent;
import js7.data.event.KeyedEvent$;
import js7.data.event.Stamped;
import js7.data.order.OrderEvent;
import js7.data.order.OrderEvent$OrderCancelled$;
import js7.data.order.OrderEvent$OrderDeleted$;
import js7.data.order.OrderEvent$OrderForked$;
import js7.data.order.OrderEvent$OrderStarted$;
import js7.data.order.OrderId;
import js7.tests.addOrders.Statistics;
import js7.tests.addOrders.Statistics$;
import js7.tests.addOrders.StatisticsBuilder$obs$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public final class StatisticsBuilder {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(StatisticsBuilder.class.getDeclaredField("obs$lzy1"));
    private final Set<OrderId> isOurOrder;
    public final Function1<Statistics, IO<Object>> js7$tests$addOrders$StatisticsBuilder$$tryEmit;
    private final Deadline since;
    private final Map<OrderId, Timestamp> orderIdToStarted;
    private final Map<OrderId, Timestamp> orderIdToProcessingStarted;
    private final Map<OrderId, Seq<OrderId>> orderToChildren;
    private int eventCount;
    private int orderAddedCount;
    private int _deletedOrderCount;
    private int failedOrderCount;
    private int completedForkedOrderCount;
    private FiniteDuration totalOrderDuration;
    private FiniteDuration maximumOrderDuration;
    private int processedCount;
    private FiniteDuration totalProcessDuration;
    private FiniteDuration maximumProcessDuration;
    private long stdWritten;
    private volatile Object obs$lzy1;

    public StatisticsBuilder(Set<OrderId> isOurOrder, Function1<Statistics, IO<Object>> tryEmit) {
        this.isOurOrder = isOurOrder;
        this.js7$tests$addOrders$StatisticsBuilder$$tryEmit = tryEmit;
        this.since = Deadline$.MODULE$.now();
        this.orderIdToStarted = (Map)Map$.MODULE$.empty();
        this.orderIdToProcessingStarted = (Map)Map$.MODULE$.empty();
        this.orderToChildren = (Map)Map$.MODULE$.empty();
        this.eventCount = 0;
        this.orderAddedCount = 0;
        this._deletedOrderCount = 0;
        this.failedOrderCount = 0;
        this.completedForkedOrderCount = 0;
        this.totalOrderDuration = ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(0));
        this.maximumOrderDuration = ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(0));
        this.processedCount = 0;
        this.totalProcessDuration = ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(0));
        this.maximumProcessDuration = ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(0));
        this.stdWritten = 0L;
    }

    public int deletedOrderCount() {
        return this._deletedOrderCount;
    }

    public int lastOrderCount() {
        return this.orderAddedCount - this._deletedOrderCount;
    }

    public final StatisticsBuilder$obs$ obs() {
        Object object = this.obs$lzy1;
        if (object instanceof StatisticsBuilder$obs$) {
            return (StatisticsBuilder$obs$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (StatisticsBuilder$obs$)this.obs$lzyINIT1();
    }

    private Object obs$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.obs$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    StatisticsBuilder$obs$ statisticsBuilder$obs$ = null;
                    try {
                        statisticsBuilder$obs$ = new StatisticsBuilder$obs$(this);
                        object2 = statisticsBuilder$obs$ == null ? LazyVals.NullValue$.MODULE$ : statisticsBuilder$obs$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.obs$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return statisticsBuilder$obs$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public IO<BoxedUnit> count(Stamped<KeyedEvent<Event>> stampedEvent) {
        return IO$.MODULE$.defer(() -> this.count$$anonfun$1(stampedEvent));
    }

    public Statistics toStatistics() {
        return Statistics$.MODULE$.apply(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(this.since)), this.lastOrderCount(), this.eventCount, this._deletedOrderCount, this.failedOrderCount, this.totalOrderDuration, this.maximumOrderDuration, this.completedForkedOrderCount, this.processedCount, this.totalProcessDuration, this.maximumProcessDuration, this.stdWritten);
    }

    private final IO count$$anonfun$1(Stamped stampedEvent$1) {
        ++this.eventCount;
        KeyedEvent keyedEvent = (KeyedEvent)stampedEvent$1.value();
        Tuple2 tuple2 = KeyedEvent$.MODULE$.unapply(keyedEvent);
        Object object = tuple2._1();
        if (object instanceof OrderId) {
            OrderId orderId = (OrderId)object;
            Event event = (Event)tuple2._2();
            if (this.isOurOrder.apply((Object)orderId.root())) {
                Event event2 = event;
                if (event2 instanceof OrderEvent.OrderStdWritten) {
                    OrderEvent.OrderStdWritten event3 = (OrderEvent.OrderStdWritten)event2;
                    Object object2 = Predef$.MODULE$.byteArrayOps(event3.chunk().getBytes(StandardCharsets.UTF_8));
                    this.stdWritten += (long)ArrayOps$.MODULE$.size$extension(object2);
                    return IO$.MODULE$.unit();
                }
                if (event2 instanceof OrderEvent.OrderAddedX) {
                    ++this.orderAddedCount;
                    return this.obs().tryPublish();
                }
                if (OrderEvent$OrderDeleted$.MODULE$.equals(event2)) {
                    ++this._deletedOrderCount;
                    return this.obs().tryPublish();
                }
                if (event2 == OrderEvent$OrderStarted$.MODULE$) {
                    this.orderIdToStarted.update((Object)orderId, (Object)stampedEvent$1.timestamp());
                    return IO$.MODULE$.unit();
                }
                if (event2 instanceof OrderEvent.OrderTerminated) {
                    this.orderIdToStarted.remove((Object)orderId).foreach((Function1)(JProcedure1 & Serializable)start -> {
                        FiniteDuration duration = stampedEvent$1.timestamp().$minus((Timestamp)start);
                        this.totalOrderDuration = this.totalOrderDuration.$plus(duration);
                        this.maximumOrderDuration = this.maximumOrderDuration.max(duration);
                    });
                    return IO$.MODULE$.unit();
                }
                if (event2 instanceof OrderEvent.OrderProcessingStarted) {
                    this.orderIdToProcessingStarted.update((Object)orderId, (Object)stampedEvent$1.timestamp());
                    return IO$.MODULE$.unit();
                }
                if (event2 instanceof OrderEvent.OrderProcessed) {
                    this.orderIdToProcessingStarted.remove((Object)orderId).foreach((Function1)(JProcedure1 & Serializable)start -> {
                        ++this.processedCount;
                        FiniteDuration duration = stampedEvent$1.timestamp().$minus((Timestamp)start);
                        this.totalProcessDuration = this.totalProcessDuration.$plus(duration);
                        this.maximumProcessDuration = this.maximumProcessDuration.max(duration);
                    });
                    return IO$.MODULE$.unit();
                }
                if (event2 instanceof OrderEvent.OrderForked) {
                    Vector<OrderEvent.OrderForked.Child> vector;
                    OrderEvent.OrderForked orderForked = OrderEvent$OrderForked$.MODULE$.unapply((OrderEvent.OrderForked)event2);
                    Vector<OrderEvent.OrderForked.Child> children2 = vector = orderForked._1();
                    this.orderToChildren.update((Object)orderId, children2.map((Function1 & Serializable)_$2 -> _$2.orderId()));
                    return IO$.MODULE$.unit();
                }
                if (event2 instanceof OrderEvent.OrderJoined) {
                    this.orderToChildren.remove((Object)orderId).foreach((Function1)(JProcedure1 & Serializable)children -> this.completedForkedOrderCount += children.size());
                    return this.obs().tryPublish();
                }
                if (event2 == OrderEvent$OrderCancelled$.MODULE$ || event2 instanceof OrderEvent.OrderFailed || event2 instanceof OrderEvent.OrderFailedInFork) {
                    ++this.failedOrderCount;
                    return IO$.MODULE$.unit();
                }
                return IO$.MODULE$.unit();
            }
        }
        return IO$.MODULE$.unit();
    }
}

