/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.unsafe.IORuntimeConfig$;
import java.io.Serializable;
import scala.Predef$;
import scala.Product;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class IORuntimeConfig
implements Product,
Serializable {
    private final int cancelationCheckThreshold;
    private final int autoYieldThreshold;
    private final boolean enhancedExceptions;
    private final int traceBufferSize;
    private final Duration shutdownHookTimeout;
    private final boolean reportUnhandledFiberErrors;
    private final FiniteDuration cpuStarvationCheckInterval;
    private final Duration cpuStarvationCheckInitialDelay;
    private final double cpuStarvationCheckThreshold;
    private final int traceBufferLogSize;

    public static FiniteDuration DefaultCpuStarvationCheckInitialDelay() {
        return IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckInitialDelay();
    }

    public static FiniteDuration DefaultCpuStarvationCheckInterval() {
        return IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckInterval();
    }

    public static double DefaultCpuStarvationCheckThreshold() {
        return IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckThreshold();
    }

    public static boolean DefaultEnhancedExceptions() {
        return IORuntimeConfig$.MODULE$.DefaultEnhancedExceptions();
    }

    public static boolean DefaultReportUnhandledFiberErrors() {
        return IORuntimeConfig$.MODULE$.DefaultReportUnhandledFiberErrors();
    }

    public static Duration.Infinite DefaultShutdownHookTimeout() {
        return IORuntimeConfig$.MODULE$.DefaultShutdownHookTimeout();
    }

    public static int DefaultTraceBufferSize() {
        return IORuntimeConfig$.MODULE$.DefaultTraceBufferSize();
    }

    public static IORuntimeConfig apply() {
        return IORuntimeConfig$.MODULE$.apply();
    }

    public static IORuntimeConfig apply(int n, int n2) {
        return IORuntimeConfig$.MODULE$.apply(n, n2);
    }

    public static IORuntimeConfig apply(int n, int n2, boolean bl, int n3) {
        return IORuntimeConfig$.MODULE$.apply(n, n2, bl, n3);
    }

    public static IORuntimeConfig apply(int n, int n2, boolean bl, int n3, Duration duration) {
        return IORuntimeConfig$.MODULE$.apply(n, n2, bl, n3, duration);
    }

    public static IORuntimeConfig apply(int n, int n2, boolean bl, int n3, Duration duration, boolean bl2, FiniteDuration finiteDuration, Duration duration2, double d) {
        return IORuntimeConfig$.MODULE$.apply(n, n2, bl, n3, duration, bl2, finiteDuration, duration2, d);
    }

    public static IORuntimeConfig apply(int n, int n2, boolean bl, int n3, Duration duration, boolean bl2, FiniteDuration finiteDuration, FiniteDuration finiteDuration2, double d) {
        return IORuntimeConfig$.MODULE$.apply(n, n2, bl, n3, duration, bl2, finiteDuration, finiteDuration2, d);
    }

    public static IORuntimeConfig fromProduct(Product product) {
        return IORuntimeConfig$.MODULE$.fromProduct(product);
    }

    public static IORuntimeConfig unapply(IORuntimeConfig iORuntimeConfig) {
        return IORuntimeConfig$.MODULE$.unapply(iORuntimeConfig);
    }

    public IORuntimeConfig(int cancelationCheckThreshold, int autoYieldThreshold, boolean enhancedExceptions, int traceBufferSize, Duration shutdownHookTimeout, boolean reportUnhandledFiberErrors, FiniteDuration cpuStarvationCheckInterval, Duration cpuStarvationCheckInitialDelay, double cpuStarvationCheckThreshold) {
        this.cancelationCheckThreshold = cancelationCheckThreshold;
        this.autoYieldThreshold = autoYieldThreshold;
        this.enhancedExceptions = enhancedExceptions;
        this.traceBufferSize = traceBufferSize;
        this.shutdownHookTimeout = shutdownHookTimeout;
        this.reportUnhandledFiberErrors = reportUnhandledFiberErrors;
        this.cpuStarvationCheckInterval = cpuStarvationCheckInterval;
        this.cpuStarvationCheckInitialDelay = cpuStarvationCheckInitialDelay;
        this.cpuStarvationCheckThreshold = cpuStarvationCheckThreshold;
        Predef$.MODULE$.require(autoYieldThreshold > 1, () -> IORuntimeConfig.$init$$$anonfun$1(autoYieldThreshold));
        Predef$.MODULE$.require(cancelationCheckThreshold > 0, () -> IORuntimeConfig.$init$$$anonfun$2(cancelationCheckThreshold));
        Predef$.MODULE$.require(autoYieldThreshold % cancelationCheckThreshold == 0, () -> IORuntimeConfig.$init$$$anonfun$3(cancelationCheckThreshold, autoYieldThreshold));
        Predef$.MODULE$.require(cpuStarvationCheckThreshold > 0.0, () -> IORuntimeConfig.$init$$$anonfun$4(cpuStarvationCheckThreshold));
        this.traceBufferLogSize = (int)Math.round(Math.log(traceBufferSize) / Math.log(2.0));
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.cancelationCheckThreshold());
        n = Statics.mix((int)n, (int)this.autoYieldThreshold());
        n = Statics.mix((int)n, (int)(this.enhancedExceptions() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)this.traceBufferSize());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.shutdownHookTimeout()));
        n = Statics.mix((int)n, (int)(this.reportUnhandledFiberErrors() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cpuStarvationCheckInterval()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cpuStarvationCheckInitialDelay()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.cpuStarvationCheckThreshold()));
        return Statics.finalizeHash((int)n, (int)9);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof IORuntimeConfig)) return false;
        IORuntimeConfig iORuntimeConfig = (IORuntimeConfig)object;
        if (this.cancelationCheckThreshold() != iORuntimeConfig.cancelationCheckThreshold()) return false;
        if (this.autoYieldThreshold() != iORuntimeConfig.autoYieldThreshold()) return false;
        if (this.enhancedExceptions() != iORuntimeConfig.enhancedExceptions()) return false;
        if (this.traceBufferSize() != iORuntimeConfig.traceBufferSize()) return false;
        if (this.reportUnhandledFiberErrors() != iORuntimeConfig.reportUnhandledFiberErrors()) return false;
        if (this.cpuStarvationCheckThreshold() != iORuntimeConfig.cpuStarvationCheckThreshold()) return false;
        Duration duration = this.shutdownHookTimeout();
        Duration duration2 = iORuntimeConfig.shutdownHookTimeout();
        if (duration == null) {
            if (duration2 != null) {
                return false;
            }
        } else if (!duration.equals(duration2)) return false;
        FiniteDuration finiteDuration = this.cpuStarvationCheckInterval();
        FiniteDuration finiteDuration2 = iORuntimeConfig.cpuStarvationCheckInterval();
        if (finiteDuration == null) {
            if (finiteDuration2 != null) {
                return false;
            }
        } else if (!finiteDuration.equals(finiteDuration2)) return false;
        Duration duration3 = this.cpuStarvationCheckInitialDelay();
        Duration duration4 = iORuntimeConfig.cpuStarvationCheckInitialDelay();
        if (duration3 == null) {
            if (duration4 == null) return true;
            return false;
        } else {
            if (!duration3.equals(duration4)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof IORuntimeConfig;
    }

    public int productArity() {
        return 9;
    }

    public String productPrefix() {
        return "IORuntimeConfig";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this._3());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this._4());
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return BoxesRunTime.boxToBoolean((boolean)this._6());
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
            case 8: {
                return BoxesRunTime.boxToDouble((double)this._9());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "cancelationCheckThreshold";
            }
            case 1: {
                return "autoYieldThreshold";
            }
            case 2: {
                return "enhancedExceptions";
            }
            case 3: {
                return "traceBufferSize";
            }
            case 4: {
                return "shutdownHookTimeout";
            }
            case 5: {
                return "reportUnhandledFiberErrors";
            }
            case 6: {
                return "cpuStarvationCheckInterval";
            }
            case 7: {
                return "cpuStarvationCheckInitialDelay";
            }
            case 8: {
                return "cpuStarvationCheckThreshold";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public int cancelationCheckThreshold() {
        return this.cancelationCheckThreshold;
    }

    public int autoYieldThreshold() {
        return this.autoYieldThreshold;
    }

    public boolean enhancedExceptions() {
        return this.enhancedExceptions;
    }

    public int traceBufferSize() {
        return this.traceBufferSize;
    }

    public Duration shutdownHookTimeout() {
        return this.shutdownHookTimeout;
    }

    public boolean reportUnhandledFiberErrors() {
        return this.reportUnhandledFiberErrors;
    }

    public FiniteDuration cpuStarvationCheckInterval() {
        return this.cpuStarvationCheckInterval;
    }

    public Duration cpuStarvationCheckInitialDelay() {
        return this.cpuStarvationCheckInitialDelay;
    }

    public double cpuStarvationCheckThreshold() {
        return this.cpuStarvationCheckThreshold;
    }

    public IORuntimeConfig(int cancelationCheckThreshold, int autoYieldThreshold) {
        this(cancelationCheckThreshold, autoYieldThreshold, IORuntimeConfig$.MODULE$.DefaultEnhancedExceptions(), IORuntimeConfig$.MODULE$.DefaultTraceBufferSize(), (Duration)IORuntimeConfig$.MODULE$.DefaultShutdownHookTimeout(), IORuntimeConfig$.MODULE$.DefaultReportUnhandledFiberErrors(), IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckInterval(), (Duration)IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckInitialDelay(), IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckThreshold());
    }

    public IORuntimeConfig copy(int cancelationCheckThreshold, int autoYieldThreshold, boolean enhancedExceptions, int traceBufferSize, Duration shutdownHookTimeout, boolean reportUnhandledFiberErrors, FiniteDuration cpuStarvationCheckInterval, Duration cpuStarvationCheckInitialDelay, double cpuStarvationCheckThreshold) {
        return new IORuntimeConfig(cancelationCheckThreshold, autoYieldThreshold, enhancedExceptions, traceBufferSize, shutdownHookTimeout, reportUnhandledFiberErrors, cpuStarvationCheckInterval, cpuStarvationCheckInitialDelay, cpuStarvationCheckThreshold);
    }

    public int copy$default$1() {
        return this.cancelationCheckThreshold();
    }

    public int copy$default$2() {
        return this.autoYieldThreshold();
    }

    public boolean copy$default$3() {
        return this.enhancedExceptions();
    }

    public int copy$default$4() {
        return this.traceBufferSize();
    }

    public Duration copy$default$5() {
        return this.shutdownHookTimeout();
    }

    public boolean copy$default$6() {
        return this.reportUnhandledFiberErrors();
    }

    public FiniteDuration copy$default$7() {
        return this.cpuStarvationCheckInterval();
    }

    public Duration copy$default$8() {
        return this.cpuStarvationCheckInitialDelay();
    }

    public double copy$default$9() {
        return this.cpuStarvationCheckThreshold();
    }

    public IORuntimeConfig copy(int cancelationCheckThreshold, int autoYieldThreshold, boolean enhancedExceptions, int traceBufferSize, Duration shutdownHookTimeout) {
        return new IORuntimeConfig(cancelationCheckThreshold, autoYieldThreshold, enhancedExceptions, traceBufferSize, shutdownHookTimeout, IORuntimeConfig$.MODULE$.DefaultReportUnhandledFiberErrors(), IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckInterval(), (Duration)IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckInitialDelay(), IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckThreshold());
    }

    public IORuntimeConfig(int cancelationCheckThreshold, int autoYieldThreshold, boolean enhancedExceptions, int traceBufferSize) {
        this(cancelationCheckThreshold, autoYieldThreshold, enhancedExceptions, traceBufferSize, (Duration)IORuntimeConfig$.MODULE$.DefaultShutdownHookTimeout(), IORuntimeConfig$.MODULE$.DefaultReportUnhandledFiberErrors(), IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckInterval(), (Duration)IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckInitialDelay(), IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckThreshold());
    }

    public IORuntimeConfig(int cancelationCheckThreshold, int autoYieldThreshold, boolean enhancedExceptions, int traceBufferSize, Duration shutdownHookTimeout) {
        this(cancelationCheckThreshold, autoYieldThreshold, enhancedExceptions, traceBufferSize, shutdownHookTimeout, IORuntimeConfig$.MODULE$.DefaultReportUnhandledFiberErrors(), IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckInterval(), (Duration)IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckInitialDelay(), IORuntimeConfig$.MODULE$.DefaultCpuStarvationCheckThreshold());
    }

    public IORuntimeConfig copy(int cancelationCheckThreshold, int autoYieldThreshold, boolean enhancedExceptions, int traceBufferSize) {
        return new IORuntimeConfig(cancelationCheckThreshold, autoYieldThreshold, enhancedExceptions, traceBufferSize, this.shutdownHookTimeout(), this.reportUnhandledFiberErrors(), this.cpuStarvationCheckInterval(), this.cpuStarvationCheckInitialDelay(), this.cpuStarvationCheckThreshold());
    }

    public IORuntimeConfig copy(int cancelationCheckThreshold, int autoYieldThreshold) {
        return new IORuntimeConfig(cancelationCheckThreshold, autoYieldThreshold, this.enhancedExceptions(), this.traceBufferSize(), this.shutdownHookTimeout(), this.reportUnhandledFiberErrors(), this.cpuStarvationCheckInterval(), this.cpuStarvationCheckInitialDelay(), this.cpuStarvationCheckThreshold());
    }

    public int traceBufferLogSize() {
        return this.traceBufferLogSize;
    }

    public int _1() {
        return this.cancelationCheckThreshold();
    }

    public int _2() {
        return this.autoYieldThreshold();
    }

    public boolean _3() {
        return this.enhancedExceptions();
    }

    public int _4() {
        return this.traceBufferSize();
    }

    public Duration _5() {
        return this.shutdownHookTimeout();
    }

    public boolean _6() {
        return this.reportUnhandledFiberErrors();
    }

    public FiniteDuration _7() {
        return this.cpuStarvationCheckInterval();
    }

    public Duration _8() {
        return this.cpuStarvationCheckInitialDelay();
    }

    public double _9() {
        return this.cpuStarvationCheckThreshold();
    }

    private static final Object $init$$$anonfun$1(int autoYieldThreshold$1) {
        return new StringBuilder(33).append("Auto yield threshold ").append(autoYieldThreshold$1).append(" must be > 1").toString();
    }

    private static final Object $init$$$anonfun$2(int cancelationCheckThreshold$1) {
        return new StringBuilder(40).append("Cancelation check threshold ").append(cancelationCheckThreshold$1).append(" must be > 0").toString();
    }

    private static final Object $init$$$anonfun$3(int cancelationCheckThreshold$2, int autoYieldThreshold$2) {
        return new StringBuilder(72).append("Auto yield threshold ").append(autoYieldThreshold$2).append(" must be a multiple of cancelation check threshold ").append(cancelationCheckThreshold$2).toString();
    }

    private static final Object $init$$$anonfun$4(double cpuStarvationCheckThreshold$1) {
        return new StringBuilder(43).append("CPU starvation check threshold ").append(cpuStarvationCheckThreshold$1).append(" must be > 0").toString();
    }
}

