/*
 * Decompiled with CFR 0.152.
 */
package js7.base.crypt.generic;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Foldable;
import cats.Traverse;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Resource;
import cats.instances.package;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import cats.syntax.ParallelSequenceOps1$;
import cats.syntax.package;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import fs2.Chunk;
import fs2.Compiler;
import fs2.Compiler$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.crypt.GenericSignature;
import js7.base.crypt.SignatureVerifier;
import js7.base.crypt.SignerId;
import js7.base.crypt.generic.DirectoryWatchingSignatureVerifier$;
import js7.base.crypt.generic.DirectoryWatchingSignatureVerifier$ConfigStringExpectedProblem$;
import js7.base.crypt.generic.DirectoryWatchingSignatureVerifier$State$;
import js7.base.crypt.generic.GenericSignatureVerifier;
import js7.base.data.ByteArray;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.io.file.FileUtils$syntax$;
import js7.base.io.file.FileUtils$syntax$RichPath$;
import js7.base.io.file.watch.DirectoryState;
import js7.base.io.file.watch.DirectoryStateJvm$;
import js7.base.io.file.watch.DirectoryWatch$;
import js7.base.io.file.watch.DirectoryWatchSettings;
import js7.base.log.CanBindCorrelId$;
import js7.base.log.CorrelId$;
import js7.base.log.Logger$syntax$;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$Lazy$;
import js7.base.service.Service;
import js7.base.service.Service$;
import js7.base.service.StoppableByRequest;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.utils.Labeled;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEither$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import sourcecode.Name$;

public final class DirectoryWatchingSignatureVerifier
implements SignatureVerifier,
Service,
StoppableByRequest,
Service.StoppableByCancel {
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private boolean stoppableByCancel;
    private final Map<SignatureVerifier.Companion, Path> companionToDirectory;
    private final DirectoryWatchSettings settings;
    private final Function0<BoxedUnit> onUpdated;
    private volatile State state;

    public static Either<Problem, DirectoryWatchingSignatureVerifier> checked(Seq<Labeled<ByteArray>> seq, String string) {
        return DirectoryWatchingSignatureVerifier$.MODULE$.checked(seq, string);
    }

    public static Either<Problem, Resource<IO, DirectoryWatchingSignatureVerifier>> checkedResource(Config config, Function0<BoxedUnit> function0) {
        return DirectoryWatchingSignatureVerifier$.MODULE$.checkedResource(config, function0);
    }

    public static String filenameExtension() {
        return DirectoryWatchingSignatureVerifier$.MODULE$.filenameExtension();
    }

    public static Either<Problem, GenericSignature> genericSignatureToSignature(GenericSignature genericSignature) {
        return DirectoryWatchingSignatureVerifier$.MODULE$.genericSignatureToSignature(genericSignature);
    }

    public static DirectoryWatchingSignatureVerifier ignoreInvalid(Seq<Labeled<ByteArray>> seq, String string) {
        return DirectoryWatchingSignatureVerifier$.MODULE$.ignoreInvalid((Seq)seq, string);
    }

    public static Either<Problem, Prepared> prepare(Config config) {
        return DirectoryWatchingSignatureVerifier$.MODULE$.prepare(config);
    }

    public static String recommendedKeyDirectoryName() {
        return DirectoryWatchingSignatureVerifier$.MODULE$.recommendedKeyDirectoryName();
    }

    public static String typeName() {
        return DirectoryWatchingSignatureVerifier$.MODULE$.typeName();
    }

    public static String checked$default$2() {
        return DirectoryWatchingSignatureVerifier$.MODULE$.checked$default$2();
    }

    public DirectoryWatchingSignatureVerifier(Map<SignatureVerifier.Companion, Path> companionToDirectory, DirectoryWatchSettings settings, Function0<BoxedUnit> onUpdated) {
        this.companionToDirectory = companionToDirectory;
        this.settings = settings;
        this.onUpdated = onUpdated;
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        Service.StoppableByCancel.$init$(this);
        this.state = DirectoryWatchingSignatureVerifier$State$.MODULE$.apply((Map<SignatureVerifier.Companion, Either<Problem, SignatureVerifier>>)Predef$.MODULE$.Map().empty());
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    @Override
    public void js7$base$service$Service$StoppableByCancel$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public DirectoryWatchingSignatureVerifier$ companion() {
        return DirectoryWatchingSignatureVerifier$.MODULE$;
    }

    @Override
    public Seq<String> publicKeys() {
        throw new NotImplementedError("DirectoryWatchingSignatureVerifier#publicKeys");
    }

    @Override
    public String publicKeyOrigin() {
        return "(DirectoryWatchingSignatureVerifier)";
    }

    @Override
    public IO<Service.Started> start() {
        return ((IO)package.traverse$.MODULE$.toTraverseOps((Object)this.companionToDirectory.toVector(), (Traverse)package.vector$.MODULE$.catsStdInstancesForVector()).traverse((Function1 & Serializable)x$1 -> {
            SignatureVerifier.Companion companion = (SignatureVerifier.Companion)x$1._1();
            Path path = (Path)x$1._2();
            return this.js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$readDirectory(path).map((Function1 & Serializable)_$1 -> {
                Either either = ScalaUtils$syntax$.MODULE$.RichEither(_$1);
                return (DirectoryState)ScalaUtils$syntax$RichEither$.MODULE$.orThrow$extension(either);
            }).map((Function1 & Serializable)directoryState -> {
                SignatureVerifier.Companion companion = (SignatureVerifier.Companion)Predef$.MODULE$.ArrowAssoc((Object)companion);
                Path path = (Path)Predef$.MODULE$.ArrowAssoc((Object)path);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)companion, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path, directoryState));
            });
        }, (Applicative)IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)companionToDir -> IO$.MODULE$.defer(() -> this.start$$anonfun$2$$anonfun$1(companionToDir)));
    }

    private IO<BoxedUnit> watchDirectory(SignatureVerifier.Companion companion, Path directory, DirectoryState directoryState) {
        return (IO)StreamExtensions$.MODULE$.collectAndFlushOnSilence(DirectoryWatch$.MODULE$.stream(directory, directoryState, this.settings, (Function1<Path, Object>)(Function1 & Serializable)file -> this.isRelevantFile((Path)file)), this.settings.directorySilence(), IO$.MODULE$.asyncForIO()).evalTap((Function1 & Serializable)events -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
            DirectoryWatchingSignatureVerifier.watchDirectory$$anonfun$2$$anonfun$1(companion, events);
            return BoxedUnit.UNIT;
        })).foreach((Function1 & Serializable)_$4 -> this.rereadDirectory(directory)).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain();
    }

    private IO<BoxedUnit> rereadDirectory(Path directory) {
        return Logger$syntax$.MODULE$.debugIO(DirectoryWatchingSignatureVerifier$.js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$$logger, IO$.MODULE$.defer(() -> this.rereadDirectory$$anonfun$1(directory)), Name$.MODULE$.apply("rereadDirectory"));
    }

    public Either<Problem, SignatureVerifier> js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$toVerifier(SignatureVerifier.Companion companion, Path directory, DirectoryState directoryState) {
        Vector files = directoryState.files().toVector();
        Either checked = Checked$.MODULE$.catchNonFatal(() -> DirectoryWatchingSignatureVerifier.$anonfun$1(companion, files, directory));
        Either either = checked;
        if (either instanceof Left) {
            Problem problem = (Problem)((Left)either).value();
            Logger LoggerImpl_this = DirectoryWatchingSignatureVerifier$.js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$$logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error("{} signature keys are not readable: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{companion.typeName(), problem}), Object.class));
            }
        } else if (either instanceof Right) {
            Logger LoggerImpl_this;
            SignatureVerifier verifier = (SignatureVerifier)((Right)either).value();
            Logger LoggerImpl_this2 = DirectoryWatchingSignatureVerifier$.js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$$logger;
            if (LoggerImpl_this2.underlying().isInfoEnabled()) {
                LoggerImpl_this2.underlying().info("Trusting signature keys:");
            }
            verifier.publicKeysToStrings().foreach((Function1)(JProcedure1 & Serializable)o -> {
                Logger LoggerImpl_this = DirectoryWatchingSignatureVerifier$.js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("  {}", o);
                    return;
                }
            });
            if (files.isEmpty() && (LoggerImpl_this = DirectoryWatchingSignatureVerifier$.js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$$logger).underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("  No public key files for signature verifier '{}' in directory '{}'", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{companion.typeName(), directory}), Object.class));
            }
        } else {
            throw new MatchError(either);
        }
        return checked;
    }

    public IO<Either<Problem, DirectoryState>> js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$readDirectory(Path directory) {
        return IO$.MODULE$.interruptible(() -> this.readDirectory$$anonfun$1(directory));
    }

    private boolean isRelevantFile(Path file) {
        return !file.getFileName().startsWith(".");
    }

    public Either<Problem, Seq<SignerId>> verify(ByteArray document, GenericSignature signature) {
        return this.state.genericVerifier().verify(document, signature);
    }

    @Override
    public Seq<String> publicKeysToStrings() {
        return package$.MODULE$.Nil().$colon$colon((Object)"DirectoryWatchingSignatureVerifier#publicKeysToStrings");
    }

    public String toString() {
        return "DirectoryWatchingSignatureVerifier(" + ((IterableOnceOps)this.companionToDirectory.keys().map((Function1 & Serializable)_$6 -> _$6.typeName())).mkString(" ") + ")";
    }

    private static final IO start$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(SignatureVerifier.Companion companion$4, Throwable t$1, Function1 retry$1) {
        block0: {
            Logger LoggerImpl_this = DirectoryWatchingSignatureVerifier$.js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$$logger;
            if (!LoggerImpl_this.underlying().isErrorEnabled()) break block0;
            Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t$1);
            Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(t$1);
            LoggerImpl_this.underlying().error(companion$4.typeName() + ": " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable), ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable2));
        }
        return ((IO)retry$1.apply((Object)BoxedUnit.UNIT)).delayBy((Duration)ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(10)));
    }

    private final IO start$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(SignatureVerifier.Companion companion$2, Path directory$2, DirectoryState directoryState$1) {
        return (IO)MonixLikeExtensions$.MODULE$.onErrorRestartLoop(this.watchDirectory(companion$2, directory$2, directoryState$1), BoxedUnit.UNIT, (Function3 & Serializable)(t, _$2, retry) -> IO$.MODULE$.defer(() -> DirectoryWatchingSignatureVerifier.start$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(companion$2, t, retry)), (ApplicativeError)IO$.MODULE$.asyncForIO());
    }

    private final IO start$$anonfun$2$$anonfun$1(Vector companionToDir$1) {
        this.state = DirectoryWatchingSignatureVerifier$State$.MODULE$.apply((Map<SignatureVerifier.Companion, Either<Problem, SignatureVerifier>>)((IterableOnceOps)companionToDir$1.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                SignatureVerifier.Companion companion = (SignatureVerifier.Companion)tuple2._1();
                if (tuple22 != null) {
                    Path directory = (Path)tuple22._1();
                    DirectoryState directoryState = (DirectoryState)tuple22._2();
                    SignatureVerifier.Companion companion2 = (SignatureVerifier.Companion)Predef$.MODULE$.ArrowAssoc((Object)companion);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)companion2, this.js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$toVerifier(companion, directory, directoryState));
                }
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Vector vector = (Vector)package.parallel$.MODULE$.catsSyntaxParallelSequence1(companionToDir$1.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                SignatureVerifier.Companion companion = (SignatureVerifier.Companion)tuple2._1();
                if (tuple22 != null) {
                    Path directory = (Path)tuple22._1();
                    DirectoryState directoryState = (DirectoryState)tuple22._2();
                    return CorrelId$.MODULE$.bindNew(() -> this.start$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(companion, directory, directoryState), CanBindCorrelId$.MODULE$.io());
                }
            }
            throw new MatchError((Object)tuple2);
        }), (Traverse)package.vector$.MODULE$.catsStdInstancesForVector());
        return this.startService(((IO)ParallelSequenceOps1$.MODULE$.parSequence$extension((Object)vector, (Traverse)package.vector$.MODULE$.catsStdInstancesForVector(), IO$.MODULE$.parallelForIO())).map((Function1)(JProcedure1 & Serializable)_$3 -> package.foldable$.MODULE$.toFoldableOps(_$3, (Foldable)package.vector$.MODULE$.catsStdInstancesForVector()).combineAll((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit())));
    }

    private static final void watchDirectory$$anonfun$2$$anonfun$1(SignatureVerifier.Companion companion$6, Chunk events$1) {
        Logger LoggerImpl_this = DirectoryWatchingSignatureVerifier$.js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$$logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info("Rereading signature keys of {} type due to {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{companion$6.typeName(), events$1.asSeq().mkString(", ")}), Object.class));
            return;
        }
    }

    public static final /* synthetic */ Tuple2 js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$anon$1$$_$applyOrElse$$anonfun$2(SignatureVerifier.Companion companion$9, Either _$5) {
        SignatureVerifier.Companion companion = (SignatureVerifier.Companion)Predef$.MODULE$.ArrowAssoc((Object)companion$9);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)companion, (Object)_$5);
    }

    private final IO rereadDirectory$$anonfun$1(Path directory$4) {
        return ((IO)package.traverse$.MODULE$.toTraverseOps((Object)((IterableOnceOps)this.companionToDirectory.collect((PartialFunction)new Serializable(directory$4, this){
            private final Path directory$5;
            private final /* synthetic */ DirectoryWatchingSignatureVerifier $outer;
            {
                this.directory$5 = directory$11;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tuple2 x2) {
                Tuple2 tuple2 = x2;
                if (tuple2 != null) {
                    SignatureVerifier.Companion companion = (SignatureVerifier.Companion)tuple2._1();
                    Path path = this.directory$5;
                    Object object = tuple2._2();
                    if (!(path != null ? !((Object)path).equals(object) : object != null)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x2, Function1 function1) {
                Tuple2 tuple2 = x2;
                if (tuple2 != null) {
                    SignatureVerifier.Companion companion = (SignatureVerifier.Companion)tuple2._1();
                    Path path = this.directory$5;
                    Object object = tuple2._2();
                    if (!(path != null ? !((Object)path).equals(object) : object != null)) {
                        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.$outer.js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$readDirectory(this.directory$5));
                        return ((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)directoryState -> IO$.MODULE$.apply(() -> this.applyOrElse$$anonfun$1$$anonfun$1(companion, directoryState)), IO$.MODULE$.asyncForIO())).map(arg_0 -> DirectoryWatchingSignatureVerifier.js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$anon$1$$_$applyOrElse$$anonfun$2(companion, arg_0));
                    }
                }
                return function1.apply((Object)x2);
            }

            private final Either applyOrElse$$anonfun$1$$anonfun$1(SignatureVerifier.Companion companion$8, DirectoryState directoryState$2) {
                return this.$outer.js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$toVerifier(companion$8, this.directory$5, directoryState$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(js7.base.crypt.SignatureVerifier$Companion js7.base.io.file.watch.DirectoryState ), js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$anon$1$$_$applyOrElse$$anonfun$2(js7.base.crypt.SignatureVerifier$Companion scala.util.Either ), applyOrElse$$anonfun$1$$anonfun$1(js7.base.crypt.SignatureVerifier$Companion js7.base.io.file.watch.DirectoryState )}, serializedLambda);
            }
        })).toVector(), (Traverse)package.vector$.MODULE$.catsStdInstancesForVector()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IO$.MODULE$.asyncForIO())).map((Function1)(JProcedure1 & Serializable)updated -> {
            this.state = DirectoryWatchingSignatureVerifier$State$.MODULE$.apply((Map<SignatureVerifier.Companion, Either<Problem, SignatureVerifier>>)((Map)this.state.companionToVerifier().$plus$plus((IterableOnce)updated)));
            try {
                this.onUpdated.apply$mcV$sp();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    Logger LoggerImpl_this = DirectoryWatchingSignatureVerifier$.js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$$logger;
                    if (LoggerImpl_this.underlying().isErrorEnabled()) {
                        Throwable throwable4 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                        Throwable throwable5 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                        LoggerImpl_this.underlying().error("onUpdated => " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable4), ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable5));
                    }
                }
                throw throwable;
            }
        });
    }

    private static final SignatureVerifier $anonfun$1(SignatureVerifier.Companion companion$10, Vector files$1, Path directory$6) {
        return companion$10.ignoreInvalid((Seq<Labeled<ByteArray>>)((Seq)files$1.map((Function1 & Serializable)file -> FileUtils$syntax$RichPath$.MODULE$.labeledByteArray$extension(FileUtils$syntax$.MODULE$.RichPath(directory$6.resolve((Path)file))))), directory$6.toString());
    }

    private final DirectoryState readDirectory$$anonfun$1$$anonfun$1(Path directory$9) {
        return DirectoryStateJvm$.MODULE$.readDirectory(directory$9, (Function1<Path, Object>)(Function1 & Serializable)file -> this.isRelevantFile((Path)file));
    }

    private final Either readDirectory$$anonfun$1(Path directory$8) {
        return Checked$.MODULE$.catchNonFatal(() -> this.readDirectory$$anonfun$1$$anonfun$1(directory$8));
    }

    public static class ConfigStringExpectedProblem
    extends Problem.Lazy
    implements Product,
    Serializable {
        private final String configKey;

        public static ConfigStringExpectedProblem apply(String string) {
            return DirectoryWatchingSignatureVerifier$ConfigStringExpectedProblem$.MODULE$.apply(string);
        }

        public static ConfigStringExpectedProblem fromProduct(Product product) {
            return DirectoryWatchingSignatureVerifier$ConfigStringExpectedProblem$.MODULE$.fromProduct(product);
        }

        public static ConfigStringExpectedProblem unapply(ConfigStringExpectedProblem configStringExpectedProblem) {
            return DirectoryWatchingSignatureVerifier$ConfigStringExpectedProblem$.MODULE$.unapply(configStringExpectedProblem);
        }

        public ConfigStringExpectedProblem(String configKey) {
            this.configKey = configKey;
            super(DirectoryWatchingSignatureVerifier$.MODULE$.js7$base$crypt$generic$DirectoryWatchingSignatureVerifier$$$ConfigStringExpectedProblem$superArg$1(configKey), Problem$Lazy$.MODULE$.$lessinit$greater$default$2());
        }

        public boolean canEqual(Object that) {
            return that instanceof ConfigStringExpectedProblem;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ConfigStringExpectedProblem";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "configKey";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String configKey() {
            return this.configKey;
        }

        public ConfigStringExpectedProblem copy(String configKey) {
            return new ConfigStringExpectedProblem(configKey);
        }

        public String copy$default$1() {
            return this.configKey();
        }

        public String _1() {
            return this.configKey();
        }
    }

    public static final class Prepared {
        private final Map<SignatureVerifier.Companion, Path> companionToDirectory;
        private final DirectoryWatchSettings settings;

        public Prepared(Map<SignatureVerifier.Companion, Path> companionToDirectory, DirectoryWatchSettings settings) {
            this.companionToDirectory = companionToDirectory;
            this.settings = settings;
        }

        public Resource<IO, DirectoryWatchingSignatureVerifier> toResource(Function0<BoxedUnit> onUpdated) {
            return Service$.MODULE$.resource(IO$.MODULE$.apply(() -> this.toResource$$anonfun$1(onUpdated)));
        }

        private final DirectoryWatchingSignatureVerifier toResource$$anonfun$1(Function0 onUpdated$2) {
            return new DirectoryWatchingSignatureVerifier(this.companionToDirectory, this.settings, (Function0<BoxedUnit>)onUpdated$2);
        }
    }

    public static final class State
    implements Product,
    Serializable {
        private final Map companionToVerifier;
        private final GenericSignatureVerifier genericVerifier;

        public static State apply(Map<SignatureVerifier.Companion, Either<Problem, SignatureVerifier>> map) {
            return DirectoryWatchingSignatureVerifier$State$.MODULE$.apply(map);
        }

        public static State fromProduct(Product product) {
            return DirectoryWatchingSignatureVerifier$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return DirectoryWatchingSignatureVerifier$State$.MODULE$.unapply(state);
        }

        public State(Map<SignatureVerifier.Companion, Either<Problem, SignatureVerifier>> companionToVerifier) {
            this.companionToVerifier = companionToVerifier;
            this.genericVerifier = new GenericSignatureVerifier((Iterable<SignatureVerifier>)((IterableOnceOps)companionToVerifier.values().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Either x2) {
                    Either either = x2;
                    if (either instanceof Right) {
                        SignatureVerifier o = (SignatureVerifier)((Right)either).value();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Either x2, Function1 function1) {
                    Either either = x2;
                    if (either instanceof Right) {
                        SignatureVerifier o = (SignatureVerifier)((Right)either).value();
                        return o;
                    }
                    return function1.apply((Object)x2);
                }
            })).toVector());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            Map<SignatureVerifier.Companion, Either<Problem, SignatureVerifier>> map = this.companionToVerifier();
            Map<SignatureVerifier.Companion, Either<Problem, SignatureVerifier>> map2 = state.companionToVerifier();
            if (map != null) {
                if (!map.equals(map2)) return false;
                return true;
            }
            if (map2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "companionToVerifier";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<SignatureVerifier.Companion, Either<Problem, SignatureVerifier>> companionToVerifier() {
            return this.companionToVerifier;
        }

        public GenericSignatureVerifier genericVerifier() {
            return this.genericVerifier;
        }

        public State copy(Map<SignatureVerifier.Companion, Either<Problem, SignatureVerifier>> companionToVerifier) {
            return new State(companionToVerifier);
        }

        public Map<SignatureVerifier.Companion, Either<Problem, SignatureVerifier>> copy$default$1() {
            return this.companionToVerifier();
        }

        public Map<SignatureVerifier.Companion, Either<Problem, SignatureVerifier>> _1() {
            return this.companionToVerifier();
        }
    }
}

