/*
 * Decompiled with CFR 0.152.
 */
package js7.base.io.https;

import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import js7.base.crypt.x509.X509Cert$;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.data.ByteSequence$ops$;
import js7.base.generic.SecretString;
import js7.base.io.https.CompositeX509TrustManager$;
import js7.base.io.https.KeyStoreRef;
import js7.base.io.https.OneAliasX509ExtendedX509KeyManager;
import js7.base.io.https.OneAliasX509KeyManager;
import js7.base.io.https.StoreRef;
import js7.base.io.https.TrustStoreRef;
import js7.base.log.Logger$;
import js7.base.utils.AutoClosing$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public final class Https$
implements Serializable {
    public static final Logger js7$base$io$https$Https$$$logger;
    private static final ByteArray PemHeader;
    private static final String algorithm;
    public static final Https$ MODULE$;

    private Https$() {
    }

    static {
        block0: {
            MODULE$ = new Https$();
            js7$base$io$https$Https$$$logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(Https$.class));
            PemHeader = ByteArray$.MODULE$.apply("-----BEGIN CERTIFICATE-----");
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
            Logger LoggerImpl_this = js7$base$io$https$Https$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("algorithm={}", (Object)algorithm);
        }
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Https$.class);
    }

    public SSLContext loadSSLContext(Option<KeyStoreRef> keyStoreRef, Seq<TrustStoreRef> trustStoreRefs) {
        KeyManager[] keyManagers = (KeyManager[])keyStoreRef.fold(Https$::$anonfun$1, (Function1 & Serializable)ref -> MODULE$.keyStoreRefToKeyManagers((KeyStoreRef)ref));
        Seq<X509TrustManager> trustManagers = this.trustStoreRefToKeyManagers(trustStoreRefs);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, new TrustManager[]{CompositeX509TrustManager$.MODULE$.apply(trustManagers)}, null);
        return sslContext;
    }

    public Option<KeyStoreRef> loadSSLContext$default$1() {
        return None$.MODULE$;
    }

    public Seq<TrustStoreRef> loadSSLContext$default$2() {
        return package$.MODULE$.Nil();
    }

    private KeyManager[] keyStoreRefToKeyManagers(KeyStoreRef ref) {
        KeyStore keyStore = this.loadKeyStore(ref, "private");
        ref.alias().foreach((Function1)(JProcedure1 & Serializable)a -> {
            if (!keyStore.containsAlias((String)a)) {
                throw new IllegalArgumentException("Unknown alias=" + a + " for " + ref + " - known aliases: " + CollectionConverters$.MODULE$.EnumerationHasAsScala(keyStore.aliases()).asScala().mkString(", "));
            }
        });
        KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
        ref.keyPassword().provideCharArray((JProcedure1 & Serializable)_$1 -> factory.init(keyStore, (char[])_$1));
        KeyManager[] keyManagers = factory.getKeyManagers();
        return (KeyManager[])ref.alias().fold(() -> Https$.keyStoreRefToKeyManagers$$anonfun$3(keyManagers), (Function1 & Serializable)a -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])keyManagers);
            return (KeyManager[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> {
                KeyManager keyManager = x$1;
                if (keyManager instanceof X509ExtendedKeyManager) {
                    X509ExtendedKeyManager km = (X509ExtendedKeyManager)keyManager;
                    return new OneAliasX509ExtendedX509KeyManager(km, (String)a);
                }
                if (keyManager instanceof X509KeyManager) {
                    X509KeyManager km = (X509KeyManager)keyManager;
                    return new OneAliasX509KeyManager(km, (String)a){
                        private final X509KeyManager keyManager;
                        private final String alias;
                        {
                            this.keyManager = km$1;
                            this.alias = a$2;
                        }

                        public X509KeyManager keyManager() {
                            return this.keyManager;
                        }

                        public String alias() {
                            return this.alias;
                        }
                    };
                }
                KeyManager o = keyManager;
                return o;
            }, ClassTag$.MODULE$.apply(KeyManager.class));
        });
    }

    private Seq<X509TrustManager> trustStoreRefToKeyManagers(Seq<TrustStoreRef> trustStoreRefs) {
        return (Seq)((IterableOps)((IterableOps)trustStoreRefs.flatMap((Function1 & Serializable)trustStoreRef -> {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
            factory.init(MODULE$.loadKeyStore((StoreRef)trustStoreRef, "trust"));
            return Predef$.MODULE$.wrapRefArray((Object[])factory.getTrustManagers());
        })).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(TrustManager x2) {
                TrustManager trustManager = x2;
                if (trustManager instanceof X509TrustManager) {
                    X509TrustManager o = (X509TrustManager)trustManager;
                    return true;
                }
                TrustManager o = trustManager;
                return true;
            }

            public final Object applyOrElse(TrustManager x2, Function1 function1) {
                block1: {
                    TrustManager trustManager = x2;
                    if (trustManager instanceof X509TrustManager) {
                        X509TrustManager o = (X509TrustManager)trustManager;
                        return Some$.MODULE$.apply((Object)o);
                    }
                    TrustManager o = trustManager;
                    Logger LoggerImpl_this = Https$.js7$base$io$https$Https$$$logger;
                    if (!LoggerImpl_this.underlying().isDebugEnabled()) break block1;
                    LoggerImpl_this.underlying().debug("Ignoring unknown TrustManager: {} {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{o.getClass().getName(), o}), Object.class));
                }
                return None$.MODULE$;
            }
        })).flatten(Predef$.MODULE$.$conforms());
    }

    private KeyStore loadKeyStore(StoreRef storeRef, String kind) {
        return (KeyStore)AutoClosing$.MODULE$.autoClosing(storeRef.url().openStream(), (Function1 & Serializable)_$2 -> MODULE$.loadKeyStoreFromInputStream((InputStream)_$2, storeRef.storePassword(), storeRef.url().toString(), kind));
    }

    public KeyStore loadKeyStoreFromInputStream(InputStream in, SecretString password, String sourcePath, String kind) {
        KeyStore keyStore;
        int sizeLimit = 10000000;
        try {
            ByteArray content = (ByteArray)ByteArray$.MODULE$.fromInputStreamLimited(in, sizeLimit).getOrElse(() -> Https$.$anonfun$3(sizeLimit, sourcePath));
            keyStore = ByteSequence$ops$.MODULE$.toAllByteSequenceOps(content, ByteArray$.MODULE$.implicitByteSequence()).startsWith(PemHeader) ? this.pemToKeyStore(content.toInputStream(), this.sourcePathToName(sourcePath)) : this.pkcs12ToKeyStore(content.toInputStream(), password);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                throw new RuntimeException("Cannot load keystore '" + sourcePath + "': " + t, t);
            }
            throw throwable;
        }
        KeyStore keyStore2 = keyStore;
        this.log(keyStore2, sourcePath, kind);
        return keyStore2;
    }

    private KeyStore pkcs12ToKeyStore(InputStream in, SecretString password) {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        password.provideCharArray((JProcedure1 & Serializable)_$3 -> keyStore.load(in, (char[])_$3));
        return keyStore;
    }

    private String certificateToString(Certificate cert) {
        Certificate certificate = cert;
        if (certificate instanceof X509Certificate) {
            X509Certificate cert2 = (X509Certificate)certificate;
            return X509Cert$.MODULE$.apply(cert2).toLongString();
        }
        Certificate o = certificate;
        return o.getType();
    }

    public String sourcePathToName(String sourcePath) {
        int n = sourcePath.replace('\\', '/').lastIndexOf(47);
        if (-1 == n) {
            return sourcePath;
        }
        int i = n;
        return StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(sourcePath), i + 1);
    }

    private KeyStore pemToKeyStore(InputStream in, String name) {
        Buffer certs = (Buffer)Buffer$.MODULE$.empty();
        boolean eof = false;
        while (!eof) {
            certs.$plus$eq((Object)CertificateFactory.getInstance("X.509").generateCertificate(in));
            in.mark(1);
            eof = in.read() < 0;
            if (eof) continue;
            in.reset();
        }
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        ((IterableOps)certs.zipWithIndex()).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Certificate cert = (Certificate)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Certificate cert = (Certificate)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                keyStore.setCertificateEntry(name + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(certs.length() > 1), (Function0<String>)((Function0 & Serializable)() -> Https$.pemToKeyStore$$anonfun$2$$anonfun$1(i))), cert);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return keyStore;
    }

    private void log(KeyStore keyStore, String sourcePath, String kind) {
        Iterator iterator = CollectionConverters$.MODULE$.EnumerationHasAsScala(keyStore.aliases()).asScala().flatMap((Function1 & Serializable)a -> Option$.MODULE$.apply((Object)keyStore.getCertificate((String)a)).map((Function1 & Serializable)_$4 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(a);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$4);
        }));
        if (iterator.isEmpty()) {
            Logger LoggerImpl_this = js7$base$io$https$Https$$$logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("Loaded empty {} keystore {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{kind, sourcePath}), Object.class));
                return;
            }
            return;
        }
        Logger LoggerImpl_this = js7$base$io$https$Https$$$logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info("Loaded " + kind + " keystore " + sourcePath + iterator.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String alias = (String)tuple2._1();
                    Certificate cert = (Certificate)tuple2._2();
                    return "\n  " + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(keyStore.isKeyEntry(alias)), (Function0<String>)((Function0 & Serializable)Https$::log$$anonfun$1$$anonfun$1)) + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(keyStore.isCertificateEntry(alias)), (Function0<String>)((Function0 & Serializable)Https$::log$$anonfun$1$$anonfun$2)) + MODULE$.certificateToString(cert) + " alias=" + alias + " (hashCode=" + cert.hashCode() + ")";
                }
                throw new MatchError((Object)tuple2);
            }).mkString(""));
            return;
        }
    }

    private static final KeyManager[] $anonfun$1() {
        return (KeyManager[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(KeyManager.class));
    }

    private static final KeyManager[] keyStoreRefToKeyManagers$$anonfun$3(KeyManager[] keyManagers$1) {
        return keyManagers$1;
    }

    private static final ByteArray $anonfun$3(int sizeLimit$1, String sourcePath$1) {
        throw new RuntimeException("Certificate store must not have more than " + sizeLimit$1 + " bytes: " + sourcePath$1);
    }

    private static final String pemToKeyStore$$anonfun$2$$anonfun$1(int i$1) {
        return "#" + (i$1 + 1);
    }

    private static final String log$$anonfun$1$$anonfun$1() {
        return "Private key ";
    }

    private static final String log$$anonfun$1$$anonfun$2() {
        return "Trusted ";
    }
}

