/*
 * Decompiled with CFR 0.152.
 */
package js7.common.pekkohttp;

import java.io.Serializable;
import js7.base.generic.GenericString;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.common.pekkohttp.CirceJsonSupport$;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller$;
import org.apache.pekko.http.scaladsl.marshalling.Marshalling;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCode$;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.BigDecimal$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class StandardMarshallers$
implements Serializable {
    private static final ByteString Nl;
    private static final Marshaller StringMarshaller;
    private static final Unmarshaller finiteDurationParamMarshaller;
    private static final Unmarshaller durationParamMarshaller;
    private static final Marshaller problemToEntityMarshaller;
    private static final Marshaller problemToResponseMarshaller;
    private static final Marshaller unitToResponseMarshaller;
    public static final StandardMarshallers$ MODULE$;

    private StandardMarshallers$() {
    }

    static {
        MODULE$ = new StandardMarshallers$();
        Nl = ByteString$.MODULE$.apply("\n");
        StringMarshaller = Marshaller$.MODULE$.withOpenCharset(MediaTypes$.MODULE$.text$divplain(), (Function2 & Serializable)(string, charset) -> HttpEntity$.MODULE$.apply((ContentType)MediaTypes$.MODULE$.text$divplain().withCharset(charset), ByteString$.MODULE$.fromString(string, charset.nioCharset())));
        finiteDurationParamMarshaller = Unmarshaller$.MODULE$.strict((Function1 & Serializable)string -> this.stringToFiniteDuration((String)string));
        durationParamMarshaller = Unmarshaller$.MODULE$.strict((Function1 & Serializable)x$1 -> {
            String string = x$1;
            if ("infinite".equals(string)) {
                return Duration$.MODULE$.Inf();
            }
            String o = string;
            return this.stringToFiniteDuration(o);
        });
        problemToEntityMarshaller = Marshaller$.MODULE$.oneOf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Marshaller[]{MODULE$.stringMarshaller(MediaTypes$.MODULE$.text$divplain(), (Function1 & Serializable)_$2 -> _$2.toString()), CirceJsonSupport$.MODULE$.jsonMarshaller(Problem$.MODULE$.typedJsonEncoder())}));
        problemToResponseMarshaller = Marshaller$.MODULE$.apply((Function1 & Serializable)ec -> (Function1 & Serializable)problem -> this.problemToEntityMarshaller().apply(problem, ec).map((Function1 & Serializable)_$3 -> _$3.map((Function1 & Serializable)_$4 -> _$4.map((Function1 & Serializable)_$5 -> HttpResponse$.MODULE$.apply(StatusCode$.MODULE$.int2StatusCode(problem.httpStatusCode()), (Seq)package$.MODULE$.Nil(), (ResponseEntity)_$5, HttpResponse$.MODULE$.apply$default$4()))), ec));
        unitToResponseMarshaller = Marshaller$.MODULE$.apply((Function1 & Serializable)_$6 -> (Function1 & Serializable)_$7 -> Future$.MODULE$.successful((Object)new .colon.colon((Object)Marshalling.Opaque$.MODULE$.apply((Function0 & Serializable)() -> HttpResponse$.MODULE$.apply((StatusCode)StatusCodes$.MODULE$.OK(), HttpResponse$.MODULE$.apply$default$2(), HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4())), (List)Nil$.MODULE$)));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StandardMarshallers$.class);
    }

    public Marshaller<String, RequestEntity> StringMarshaller() {
        return StringMarshaller;
    }

    public Unmarshaller<String, FiniteDuration> finiteDurationParamMarshaller() {
        return finiteDurationParamMarshaller;
    }

    public <A extends GenericString> Unmarshaller<String, A> genericStringParamMarshaller(GenericString.Companion<A> A) {
        return Unmarshaller$.MODULE$.strict((Function1 & Serializable)_$1 -> A.apply((String)_$1));
    }

    public Unmarshaller<String, Duration> durationParamMarshaller() {
        return durationParamMarshaller;
    }

    private FiniteDuration stringToFiniteDuration(String string) {
        return new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(package$.MODULE$.BigDecimal().apply(string).$times(BigDecimal$.MODULE$.int2bigDecimal(1000)).toLong())).millis();
    }

    public Marshaller<Problem, RequestEntity> problemToEntityMarshaller() {
        return problemToEntityMarshaller;
    }

    public Marshaller<Problem, HttpResponse> problemToResponseMarshaller() {
        return problemToResponseMarshaller;
    }

    public ToResponseMarshallable problemToResponseMarshallable(Problem problem) {
        StatusCode statusCode = (StatusCode)Predef$.MODULE$.ArrowAssoc((Object)StatusCode$.MODULE$.int2StatusCode(problem.httpStatusCode()));
        return ToResponseMarshallable$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)statusCode, (Object)problem), Marshaller$.MODULE$.fromStatusCodeAndValue(Predef$.MODULE$.$conforms(), this.problemToEntityMarshaller()));
    }

    public <A> Marshaller<A, RequestEntity> stringMarshaller(MediaType.WithOpenCharset mediaType, Function1<A, String> toString) {
        return Marshaller$.MODULE$.withOpenCharset(mediaType, (Function2 & Serializable)(a, charset) -> {
            ByteString byteString = ByteString$.MODULE$.apply((String)toString.apply(a), charset.nioCharset());
            if (!byteString.endsWith((Iterable)Nl)) {
                byteString = byteString.$plus$plus(Nl);
            }
            return HttpEntity.Strict$.MODULE$.apply((ContentType)ContentType$.MODULE$.apply(mediaType, charset), byteString);
        });
    }

    public <A> Marshaller<Either<Problem, A>, HttpResponse> checkedToResponseMarshaller(Marshaller<A, HttpResponse> evidence$1) {
        return Marshaller$.MODULE$.apply((Function1 & Serializable)ec -> (Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Object a = ((Right)either).value();
                return ((Marshaller)Predef$.MODULE$.implicitly((Object)evidence$1)).apply(a, ec);
            }
            if (either instanceof Left) {
                Problem problem = (Problem)((Left)either).value();
                return MODULE$.problemToResponseMarshaller().apply((Object)problem, ec);
            }
            throw new MatchError((Object)either);
        });
    }

    public Marshaller<BoxedUnit, HttpResponse> unitToResponseMarshaller() {
        return unitToResponseMarshaller;
    }
}

