/*
 * Decompiled with CFR 0.152.
 */
package js7.common.pekkohttp;

import com.typesafe.config.Config;
import io.circe.parser.package$;
import java.io.Serializable;
import java.util.Locale;
import js7.base.auth.SessionToken$;
import js7.base.log.CanBindCorrelId$;
import js7.base.log.CorrelId;
import js7.base.log.CorrelId$;
import js7.base.log.LogLevel;
import js7.base.log.LogLevel$;
import js7.base.log.Slf4jUtils$syntax$;
import js7.base.log.Slf4jUtils$syntax$LevelLogger$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.Stopwatch$;
import js7.base.utils.ByteUnits$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichAny$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichString$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.common.http.PekkoHttpClient$x$minusjs7$minuscorrelation$minusid$;
import js7.common.http.PekkoHttpClient$x$minusjs7$minusrequest$minusid$;
import js7.common.http.PekkoHttpClient$x$minusjs7$minussession$;
import js7.common.pekkohttp.ExceptionHandling;
import js7.common.pekkohttp.WebLogDirectives$;
import js7.common.pekkohttp.web.auth.CSRF$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.impl.util.JavaMapping;
import org.apache.pekko.http.impl.util.JavaMapping$;
import org.apache.pekko.http.scaladsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.AttributeKeys$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.headers.Referer;
import org.apache.pekko.http.scaladsl.model.headers.User;
import org.apache.pekko.http.scaladsl.server.ConjunctionMagnet$;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directives$;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.util.ApplyConverter$;
import org.apache.pekko.http.scaladsl.server.util.TupleOps;
import org.apache.pekko.stream.scaladsl.FlowOpsMat;
import org.apache.pekko.stream.scaladsl.Source;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Future;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichChar$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public interface WebLogDirectives
extends ExceptionHandling {
    public static AttributeKey<CorrelId> CorrelIdAttributeKey() {
        return WebLogDirectives$.MODULE$.CorrelIdAttributeKey();
    }

    public static Config TestConfig() {
        return WebLogDirectives$.MODULE$.TestConfig();
    }

    public static void $init$(WebLogDirectives $this) {
    }

    @Override
    public Config config();

    public ActorSystem actorSystem();

    public static LogLevel js7$common$pekkohttp$WebLogDirectives$$logLevel$(WebLogDirectives $this) {
        return $this.js7$common$pekkohttp$WebLogDirectives$$logLevel();
    }

    default public LogLevel js7$common$pekkohttp$WebLogDirectives$$logLevel() {
        return LogLevel$.MODULE$.apply(this.config().getString("js7.web.server.log.level"));
    }

    public static LogLevel js7$common$pekkohttp$WebLogDirectives$$errorLogLevel$(WebLogDirectives $this) {
        return $this.js7$common$pekkohttp$WebLogDirectives$$errorLogLevel();
    }

    default public LogLevel js7$common$pekkohttp$WebLogDirectives$$errorLogLevel() {
        return LogLevel$.MODULE$.apply(this.config().getString("js7.web.server.log.error-level"));
    }

    public static LogLevel js7$common$pekkohttp$WebLogDirectives$$internalServerErrorLevel$(WebLogDirectives $this) {
        return $this.js7$common$pekkohttp$WebLogDirectives$$internalServerErrorLevel();
    }

    default public LogLevel js7$common$pekkohttp$WebLogDirectives$$internalServerErrorLevel() {
        return LogLevel$.MODULE$.apply(this.config().getString("js7.web.server.log.500-level"));
    }

    public static boolean js7$common$pekkohttp$WebLogDirectives$$logRequest$(WebLogDirectives $this) {
        return $this.js7$common$pekkohttp$WebLogDirectives$$logRequest();
    }

    default public boolean js7$common$pekkohttp$WebLogDirectives$$logRequest() {
        return this.actorSystem().settings().config().getBoolean("js7.web.server.log.request");
    }

    public static boolean js7$common$pekkohttp$WebLogDirectives$$logResponse$(WebLogDirectives $this) {
        return $this.js7$common$pekkohttp$WebLogDirectives$$logResponse();
    }

    default public boolean js7$common$pekkohttp$WebLogDirectives$$logResponse() {
        return this.actorSystem().settings().config().getBoolean("js7.web.server.log.response");
    }

    public static Directive mainRoute$(WebLogDirectives $this) {
        return $this.mainRoute();
    }

    default public Directive<BoxedUnit> mainRoute() {
        return (Directive)((Directive)((Directive)this.meterRequest().$amp(ConjunctionMagnet$.MODULE$.fromDirective((Directive)Directives$.MODULE$.decodeRequest().$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directives$.MODULE$.encodeResponse(), TupleOps.Join$.MODULE$.join0P())), TupleOps.Join$.MODULE$.join0P()))).$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.webLog(), TupleOps.Join$.MODULE$.join0P()))).$amp(ConjunctionMagnet$.MODULE$.fromDirective(CSRF$.MODULE$.forbidCSRF(), TupleOps.Join$.MODULE$.join0P()));
    }

    private Directive<BoxedUnit> meterRequest() {
        return Directives$.MODULE$.mapInnerRoute((Function1 & Serializable)inner -> {
            LongRef t = LongRef.create((long)0L);
            return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.mapRequest((Function1 & Serializable)request -> {
                t$1.elem = System.nanoTime();
                return request;
            })).apply(() -> WebLogDirectives.meterRequest$$anonfun$1$$anonfun$2(t, inner));
        });
    }

    public static Directive webLog$(WebLogDirectives $this) {
        return $this.webLog();
    }

    default public Directive<BoxedUnit> webLog() {
        return Directives$.MODULE$.mapInnerRoute((Function1 & Serializable)inner -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractRequest(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)request -> {
            CorrelId correlId = this.getCorrelId((HttpRequest)request);
            return this.setCorrelIdAttribute(correlId, (Function1<RequestContext, Future<RouteResult>>)((Function1)Directive$.MODULE$.addByNameNullaryApply(this.webLogOnly((HttpRequest)request, correlId)).apply(() -> this.webLog$$anonfun$1$$anonfun$1$$anonfun$1(inner))));
        }));
    }

    private CorrelId getCorrelId(HttpRequest request) {
        if (!CorrelId$.MODULE$.isEnabled()) {
            return CorrelId$.MODULE$.empty();
        }
        return (CorrelId)request.headers().find((Function1 & Serializable)_$1 -> _$1.is(PekkoHttpClient$x$minusjs7$minuscorrelation$minusid$.MODULE$.lowercaseName())).flatMap((Function1 & Serializable)h -> CorrelId$.MODULE$.checked(h.value()).toOption()).getOrElse(WebLogDirectives::getCorrelId$$anonfun$3);
    }

    private Function1<RequestContext, Future<RouteResult>> setCorrelIdAttribute(CorrelId correlId, Function1<RequestContext, Future<RouteResult>> route) {
        if (!CorrelId$.MODULE$.isEnabled()) {
            return route;
        }
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.mapRequest((Function1 & Serializable)_$2 -> (HttpRequest)_$2.addAttribute(WebLogDirectives$.MODULE$.CorrelIdAttributeKey(), (Object)correlId))).apply(() -> WebLogDirectives.setCorrelIdAttribute$$anonfun$2(route));
    }

    private Directive<BoxedUnit> webLogOnly(HttpRequest request, CorrelId correlId) {
        if (!this.js7$common$pekkohttp$WebLogDirectives$$logRequest() && !this.js7$common$pekkohttp$WebLogDirectives$$logResponse()) {
            return Directives$.MODULE$.pass();
        }
        if (this.js7$common$pekkohttp$WebLogDirectives$$logRequest() || WebLogDirectives$.js7$common$pekkohttp$WebLogDirectives$$$webLogger.underlying().isTraceEnabled()) {
            this.log(request, (Option<HttpResponse>)None$.MODULE$, correlId, this.js7$common$pekkohttp$WebLogDirectives$$logRequest() ? this.js7$common$pekkohttp$WebLogDirectives$$logLevel() : LogLevel$.Trace, 0L, this.log$default$6());
        }
        if (this.js7$common$pekkohttp$WebLogDirectives$$logResponse()) {
            long start = System.nanoTime();
            return Directives$.MODULE$.mapResponse((Function1 & Serializable)response -> {
                this.log(request, (Option<HttpResponse>)Some$.MODULE$.apply(response), correlId, this.statusToLogLevel(response.status()), System.nanoTime() - start, this.log$default$6());
                return this.meterTime(request, (HttpResponse)response, correlId, start);
            });
        }
        return Directives$.MODULE$.pass();
    }

    private HttpResponse meterTime(HttpRequest request, HttpResponse response, CorrelId correlId, long start) {
        Deadline since = Deadline$.MODULE$.now();
        LongRef chunkCount = LongRef.create((long)0L);
        LongRef byteCount = LongRef.create((long)0L);
        ResponseEntity responseEntity = response.entity();
        if (responseEntity instanceof HttpEntity.Chunked) {
            HttpEntity.Chunked entity = (HttpEntity.Chunked)responseEntity;
            Source source = (Source)((FlowOpsMat)entity.chunks().wireTap((Function1)(JProcedure1 & Serializable)part -> {
                ++chunkCount$1.elem;
                byteCount$1.elem += (long)part.data().size();
            })).watchTermination((Function2 & Serializable)(mat, future) -> {
                future.onComplete((Function1)(JProcedure1 & Serializable)tried -> this.log(request, (Option<HttpResponse>)Some$.MODULE$.apply((Object)response), correlId, this.js7$common$pekkohttp$WebLogDirectives$$logLevel(), System.nanoTime() - start, BoxesRunTime.boxToLong((long)chunkCount$3.elem).toString() + " chunks, " + Stopwatch$.MODULE$.bytesPerSecondString(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since)), byteCount$3.elem) + tried.fold((Function1 & Serializable)t -> {
                    Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                    return " " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable);
                }, (Function1 & Serializable)_$3 -> "")), this.ioRuntime().compute());
                return mat;
            });
            ContentType contentType = entity.copy$default$1();
            return response.withEntity((RequestEntity)entity.copy(contentType, source));
        }
        return response;
    }

    private void log(HttpRequest request, Option<HttpResponse> response, CorrelId correlId, LogLevel logLevel, long nanos, String streamSuffix) {
        correlId.bind((Function0 & Serializable)() -> {
            this.log$$anonfun$1(request, response, nanos, streamSuffix, logLevel);
            return BoxedUnit.UNIT;
        }, CanBindCorrelId$.MODULE$.forUnit());
    }

    private String log$default$6() {
        return "";
    }

    private LogLevel statusToLogLevel(StatusCode statusCode) {
        StatusCode statusCode2 = statusCode;
        StatusCode status = statusCode2;
        if (status.intValue() < 400) {
            return this.js7$common$pekkohttp$WebLogDirectives$$logLevel();
        }
        StatusCode status2 = statusCode2;
        if (status2.intValue() == 500) {
            return this.js7$common$pekkohttp$WebLogDirectives$$internalServerErrorLevel();
        }
        return this.js7$common$pekkohttp$WebLogDirectives$$errorLogLevel();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String requestResponseToLine(HttpRequest request, Option<HttpResponse> maybeResponse, long nanos, String streamSuffix) {
        BoxedUnit boxedUnit;
        StringBuilder sb = new StringBuilder(512);
        Option<HttpResponse> option = maybeResponse;
        if (option instanceof Some) {
            HttpResponse response = (HttpResponse)((Some)option).value();
            v0 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(streamSuffix)) ? sb.append("<-|") : sb.append(response.status().intValue());
        } else {
            v0 = sb.append("-->");
        }
        sb.append(' ');
        sb.append((String)request.headers().collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(HttpHeader x2) {
                Option option;
                HttpHeader httpHeader = x2;
                if (httpHeader != null && !(option = PekkoHttpClient$x$minusjs7$minussession$.MODULE$.unapply(httpHeader)).isEmpty()) {
                    String string;
                    String secret = string = (String)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(HttpHeader x2, Function1 function1) {
                Option option;
                HttpHeader httpHeader = x2;
                if (httpHeader != null && !(option = PekkoHttpClient$x$minusjs7$minussession$.MODULE$.unapply(httpHeader)).isEmpty()) {
                    String string;
                    String secret = string = (String)option.get();
                    return SessionToken$.MODULE$.stringToShort(secret);
                }
                return function1.apply((Object)x2);
            }
        }).getOrElse(WebLogDirectives::requestResponseToLine$$anonfun$1));
        sb.append(' ');
        sb.append((String)request.headers().collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(HttpHeader x2) {
                Option option;
                HttpHeader httpHeader = x2;
                if (httpHeader != null && !(option = PekkoHttpClient$x$minusjs7$minusrequest$minusid$.MODULE$.unapply(httpHeader)).isEmpty()) {
                    String string;
                    String id = string = (String)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(HttpHeader x2, Function1 function1) {
                Option option;
                HttpHeader httpHeader = x2;
                if (httpHeader != null && !(option = PekkoHttpClient$x$minusjs7$minusrequest$minusid$.MODULE$.unapply(httpHeader)).isEmpty()) {
                    String string;
                    String id = string = (String)option.get();
                    return id;
                }
                return function1.apply((Object)x2);
            }
        }).getOrElse(WebLogDirectives::requestResponseToLine$$anonfun$2));
        sb.append(' ');
        sb.append((String)request.attribute((org.apache.pekko.http.javadsl.model.AttributeKey)AttributeKeys$.MODULE$.remoteAddress(), (JavaMapping)JavaMapping$.MODULE$.attributeKey()).flatMap((Function1 & Serializable)_$4 -> _$4.toIP()).fold(WebLogDirectives::requestResponseToLine$$anonfun$4, (Function1 & Serializable)_$5 -> _$5.ip().getHostAddress()));
        sb.append(' ');
        String string = (String)ScalaUtils$syntax$.MODULE$.RichAny(request.method().value());
        sb.append((String)ScalaUtils$syntax$RichAny$.MODULE$.pipeIf$extension(string, (Function0<Object>)((Function0 & Serializable)() -> WebLogDirectives.requestResponseToLine$$anonfun$6(streamSuffix)), (Function1 & Serializable)_$6 -> _$6.toLowerCase(Locale.ROOT)));
        sb.append(' ');
        sb.append((Object)request.uri());
        Option<HttpResponse> option2 = maybeResponse;
        if (None$.MODULE$.equals(option2)) {
            WebLogDirectives.appendHeader$1(request, sb, ClassTag$.MODULE$.apply(Referer.class));
            WebLogDirectives.appendHeader$1(request, sb, ClassTag$.MODULE$.apply(User.minusAgent.class));
            boxedUnit = BoxedUnit.UNIT;
            return sb.toString();
        }
        if (!(option2 instanceof Some)) throw new MatchError(option2);
        HttpResponse response = (HttpResponse)((Some)option2).value();
        if (response.status().isFailure()) {
            ResponseEntity responseEntity = response.entity();
            if (responseEntity instanceof HttpEntity.Strict) {
                HttpEntity.Strict strict = (HttpEntity.Strict)responseEntity;
                ContentType contentType = strict.contentType();
                ContentType.WithCharset withCharset = ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029();
                ContentType contentType2 = contentType;
                if (!(withCharset != null ? !withCharset.equals(contentType2) : contentType2 != null)) {
                    String truncated;
                    HttpEntity.Strict entity = strict;
                    String string2 = entity.data().utf8String();
                    boxedUnit = WebLogDirectives$.MODULE$.js7$common$pekkohttp$WebLogDirectives$$$appendQuotedString(sb, truncated + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean((truncated = StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(ScalaUtils$syntax$RichString$.MODULE$.dropLastWhile$extension(ScalaUtils$syntax$.MODULE$.RichString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(string2), 1001)), (Function1<Object, Object>)(Function1 & Serializable)_$7 -> WebLogDirectives.$anonfun$3(BoxesRunTime.unboxToChar((Object)_$7)))), (Function1 & Serializable)c -> WebLogDirectives.$anonfun$4(BoxesRunTime.unboxToChar((Object)c)))).length() < string2.length()), (Function0<String>)((Function0 & Serializable)WebLogDirectives::requestResponseToLine$$anonfun$8)));
                    return sb.toString();
                }
                ContentType.WithFixedCharset withFixedCharset = ContentTypes$.MODULE$.application$divjson();
                ContentType contentType3 = contentType;
                if (!(withFixedCharset != null ? !withFixedCharset.equals(contentType3) : contentType3 != null)) {
                    HttpEntity.Strict entity = strict;
                    Either either = package$.MODULE$.parse(entity.data().utf8String()).flatMap((Function1 & Serializable)_$8 -> _$8.as(Problem$.MODULE$.jsonDecoder()));
                    if (either instanceof Left) {
                        boxedUnit = WebLogDirectives$.MODULE$.js7$common$pekkohttp$WebLogDirectives$$$appendQuotedString(sb, response.status().reason());
                        return sb.toString();
                    }
                    if (!(either instanceof Right)) throw new MatchError((Object)either);
                    Problem problem = (Problem)((Right)either).value();
                    boxedUnit = WebLogDirectives$.MODULE$.js7$common$pekkohttp$WebLogDirectives$$$appendQuotedString(sb, problem.toString());
                    return sb.toString();
                }
            }
            boxedUnit = WebLogDirectives$.MODULE$.js7$common$pekkohttp$WebLogDirectives$$$appendQuotedString(sb, response.status().reason());
            return sb.toString();
        }
        ResponseEntity responseEntity = response.entity();
        if (responseEntity instanceof HttpEntity.Strict) {
            HttpEntity.Strict entity = (HttpEntity.Strict)responseEntity;
            sb.append(' ');
            sb.append(ByteUnits$.MODULE$.toKBGB(Int$.MODULE$.int2long(entity.data().length())));
            sb.append(' ');
            boxedUnit = sb.append(ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(nanos)).nanoseconds())));
            return sb.toString();
        }
        if (streamSuffix.isEmpty()) {
            sb.append(" STREAM... ");
            boxedUnit = sb.append(ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(nanos)).nanoseconds())));
            return sb.toString();
        }
        sb.append(' ');
        boxedUnit = sb.append(streamSuffix);
        return sb.toString();
    }

    private static Function1 meterRequest$$anonfun$1$$anonfun$2$$anonfun$2(Function1 inner$2) {
        return inner$2;
    }

    private static Function1 meterRequest$$anonfun$1$$anonfun$2(LongRef t$2, Function1 inner$1) {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.mapRouteResult((Function1 & Serializable)result -> {
            WebLogDirectives$.js7$common$pekkohttp$WebLogDirectives$$$requestCallMeter.addNanos(System.nanoTime() - t$3.elem);
            return result;
        })).apply(() -> WebLogDirectives.meterRequest$$anonfun$1$$anonfun$2$$anonfun$2(inner$1));
    }

    private Function1 webLog$$anonfun$1$$anonfun$1$$anonfun$1(Function1 inner$4) {
        return this.seal((Function1<RequestContext, Future<RouteResult>>)inner$4);
    }

    private static CorrelId getCorrelId$$anonfun$3() {
        return CorrelId$.MODULE$.generate();
    }

    private static Function1 setCorrelIdAttribute$$anonfun$2(Function1 route$1) {
        return route$1;
    }

    private String message$proxy1$1(HttpRequest request$5, Option response$4, long nanos$2, String streamSuffix$2) {
        return this.requestResponseToLine(request$5, (Option<HttpResponse>)response$4, nanos$2, streamSuffix$2);
    }

    private String log$$anonfun$1$$anonfun$1(HttpRequest request$7, Option response$5, long nanos$3, String streamSuffix$4) {
        return this.message$proxy1$1(request$7, response$5, nanos$3, streamSuffix$4);
    }

    private void log$$anonfun$1(HttpRequest request$4, Option response$3, long nanos$1, String streamSuffix$1, LogLevel logLevel$1) {
        Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(WebLogDirectives$.js7$common$pekkohttp$WebLogDirectives$$$webLogger.underlying()), logLevel$1, (Function0<String>)((Function0 & Serializable)() -> this.log$$anonfun$1$$anonfun$1(request$4, response$3, nanos$1, streamSuffix$1)));
    }

    private static void appendHeader$1(HttpRequest request$6, StringBuilder sb$1, ClassTag evidence$1) {
        Option option = request$6.header(evidence$1);
        if (None$.MODULE$.equals(option)) {
            sb$1.append(" -");
            return;
        }
        if (option instanceof Some) {
            HttpHeader h = (HttpHeader)((Some)option).value();
            WebLogDirectives$.MODULE$.js7$common$pekkohttp$WebLogDirectives$$$appendQuotedString(sb$1, h.value());
            return;
        }
        throw new MatchError((Object)option);
    }

    private static String requestResponseToLine$$anonfun$1() {
        return "-";
    }

    private static String requestResponseToLine$$anonfun$2() {
        return "#";
    }

    private static String requestResponseToLine$$anonfun$4() {
        return "-";
    }

    private static boolean requestResponseToLine$$anonfun$6(String streamSuffix$3) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(streamSuffix$3));
    }

    private static /* synthetic */ boolean $anonfun$3(char _$7) {
        return _$7 == '\n';
    }

    private static /* synthetic */ char $anonfun$4(char c) {
        if (RichChar$.MODULE$.isControl$extension(Predef$.MODULE$.charWrapper(c))) {
            return '\u00b7';
        }
        return c;
    }

    private static String requestResponseToLine$$anonfun$8() {
        return "...";
    }
}

