/*
 * Decompiled with CFR 0.152.
 */
package js7.common.pekkohttp.web;

import cats.ApplicativeError;
import cats.Foldable;
import cats.UnorderedFoldable$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import cats.syntax.ParallelTraversableOps1$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import fs2.Compiler;
import fs2.Compiler$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.io.file.watch.DirectoryEvent;
import js7.base.io.file.watch.DirectoryState;
import js7.base.io.file.watch.DirectoryStateJvm$;
import js7.base.io.file.watch.DirectoryWatch$;
import js7.base.io.file.watch.DirectoryWatchSettings;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.common.pekkohttp.web.HttpsDirectoryWatch$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class HttpsDirectoryWatch
implements Service,
StoppableByRequest,
Service.StoppableByRequest {
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private final DirectoryWatchSettings settings;
    private final Seq<Path> files;
    private final IO<BoxedUnit> onHttpsKeyOrCertChanged;

    public static Resource<IO, HttpsDirectoryWatch> resource(DirectoryWatchSettings directoryWatchSettings, Seq<Path> seq, IO<BoxedUnit> iO) {
        return HttpsDirectoryWatch$.MODULE$.resource(directoryWatchSettings, seq, iO);
    }

    public HttpsDirectoryWatch(DirectoryWatchSettings settings, Seq<Path> files, IO<BoxedUnit> onHttpsKeyOrCertChanged) {
        this.settings = settings;
        this.files = files;
        this.onHttpsKeyOrCertChanged = onHttpsKeyOrCertChanged;
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    @Override
    public IO<Service.Started> start() {
        return this.watchDirectories().start().flatMap((Function1 & Serializable)watching -> this.startService((IO)watching.joinWithUnit((MonadCancel)IO$.MODULE$.asyncForIO(), (.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    private IO<BoxedUnit> watchDirectories() {
        Seq seq = (Seq)package.all$.MODULE$.catsSyntaxParallelTraverse1(this.directoryToFilenames(), UnorderedFoldable$.MODULE$.catsTraverseForSeq());
        return ((IO)ParallelTraversableOps1$.MODULE$.parTraverse$extension((Object)seq, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path dir = (Path)tuple2._1();
                Set files = (Set)tuple2._2();
                return this.observeDirectory(dir, (Set<Path>)files);
            }
            throw new MatchError((Object)tuple2);
        }, UnorderedFoldable$.MODULE$.catsTraverseForSeq(), IO$.MODULE$.parallelForIO())).map((Function1)(JProcedure1 & Serializable)_$1 -> package.all$.MODULE$.toFoldableOps(_$1, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForSeq()).combineAll((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()));
    }

    private Seq<Tuple2<Path, Set<Path>>> directoryToFilenames() {
        return ((IterableOps)((IterableOps)this.files.map((Function1 & Serializable)path -> {
            Path path2 = (Path)Predef$.MODULE$.ArrowAssoc((Object)path.getParent());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path2, (Object)path.getFileName());
        })).filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path directory = (Path)tuple2._1();
                Path filename = (Path)tuple2._2();
                return directory != null && filename != null;
            }
            throw new MatchError((Object)tuple2);
        })).groupMap((Function1 & Serializable)_$2 -> (Path)_$2._1(), (Function1 & Serializable)_$3 -> (Path)_$3._2()).view().mapValues((Function1 & Serializable)_$4 -> _$4.toSet()).toVector();
    }

    private IO<BoxedUnit> observeDirectory(Path directory, Set<Path> files) {
        return MonixLikeExtensions$.MODULE$.onErrorTap(IO$.MODULE$.defer(() -> this.observeDirectory$$anonfun$1(directory, files)), (PartialFunction<Throwable, IO<BoxedUnit>>)new Serializable(){

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                return true;
            }

            public final Object applyOrElse(Throwable x2, Function1 function1) {
                Throwable throwable = x2;
                return IO$.MODULE$.apply(() -> HttpsDirectoryWatch.js7$common$pekkohttp$web$HttpsDirectoryWatch$$anon$1$$_$applyOrElse$$anonfun$adapted$1(x2));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{js7$common$pekkohttp$web$HttpsDirectoryWatch$$anon$1$$_$applyOrElse$$anonfun$adapted$1(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    private final IO observeDirectory$$anonfun$1(Path directory$1, Set files$1) {
        DirectoryState directoryState = DirectoryStateJvm$.MODULE$.readDirectory(directory$1, (Function1<Path, Object>)files$1);
        return (IO)StreamExtensions$.MODULE$.tapEachChunk(MonixLikeExtensions$.MODULE$.takeUntilEval(DirectoryWatch$.MODULE$.stream(directory$1, directoryState, this.settings, (Function1<Path, Object>)files$1), this.untilStopRequested(), (ApplicativeError)IO$.MODULE$.asyncForIO()).debounce(this.settings.directorySilence(), (GenTemporal)IO$.MODULE$.asyncForIO()), (JProcedure1 & Serializable)events -> {
            Logger LoggerImpl_this = HttpsDirectoryWatch$.js7$common$pekkohttp$web$HttpsDirectoryWatch$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("HTTPS keys or certificates change signaled: {}", (Object)((IterableOnceOps)events.toArraySeq(ClassTag$.MODULE$.apply(DirectoryEvent.class)).distinct()).mkString(", "));
                return;
            }
        }, IO$.MODULE$.asyncForIO()).evalTap((Function1 & Serializable)_$5 -> this.onHttpsKeyOrCertChanged).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain();
    }

    private static final void applyOrElse$$anonfun$1(Throwable x$1) {
        Logger LoggerImpl_this = HttpsDirectoryWatch$.js7$common$pekkohttp$web$HttpsDirectoryWatch$$$logger;
        if (LoggerImpl_this.underlying().isErrorEnabled()) {
            Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(x$1);
            LoggerImpl_this.underlying().error(ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable), x$1);
            return;
        }
    }

    public static /* bridge */ /* synthetic */ Object js7$common$pekkohttp$web$HttpsDirectoryWatch$$anon$1$$_$applyOrElse$$anonfun$adapted$1(Throwable x$2) {
        HttpsDirectoryWatch.applyOrElse$$anonfun$1(x$2);
        return BoxedUnit.UNIT;
    }
}

